/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.P4RuntimeDriverUtils;
import org.onosproject.net.DeviceId;
import org.onosproject.net.behaviour.TableStatisticsDiscovery;
import org.onosproject.net.flow.DefaultTableStatisticsEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.IndexTableId;
import org.onosproject.net.flow.TableId;
import org.onosproject.net.flow.TableStatisticsEntry;
import org.onosproject.net.pi.model.PiPipelineInterpreter;
import org.onosproject.net.pi.model.PiPipelineModel;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.model.PiTableModel;

public class P4RuntimeTableStatisticsDiscovery
extends AbstractP4RuntimeHandlerBehaviour
implements TableStatisticsDiscovery {
    public List<TableStatisticsEntry> getTableStatistics() {
        if (!this.setupBehaviour("getTableStatistics()")) {
            return Collections.emptyList();
        }
        FlowRuleService flowService = (FlowRuleService)this.handler().get(FlowRuleService.class);
        PiPipelineInterpreter interpreter = P4RuntimeDriverUtils.getInterpreter(this.handler());
        PiPipelineModel model = this.pipeconf.pipelineModel();
        ArrayList rules = Lists.newArrayList((Iterable)flowService.getFlowEntries(this.deviceId));
        Map<PiTableId, Integer> piTableFlowCount = this.piFlowRuleCounting(model, interpreter, rules);
        Map<PiTableId, Long> piTableMatchCount = this.piMatchedCounting(model, interpreter, rules);
        List<TableStatisticsEntry> tableStatsList = this.generatePiFlowTableStatistics(piTableFlowCount, piTableMatchCount, model, this.deviceId);
        return tableStatsList;
    }

    private Map<PiTableId, Integer> piFlowRuleCounting(PiPipelineModel model, PiPipelineInterpreter interpreter, List<FlowEntry> rules) {
        HashMap<PiTableId, Integer> piTableFlowCount = new HashMap<PiTableId, Integer>();
        for (PiTableModel tableModel : model.tables()) {
            piTableFlowCount.put(tableModel.id(), 0);
        }
        for (FlowEntry f : rules) {
            PiTableId piTableId;
            if (f.state() != FlowEntry.FlowEntryState.ADDED || (piTableId = this.getPiTableId(f, interpreter)) == null) continue;
            piTableFlowCount.put(piTableId, (Integer)piTableFlowCount.get(piTableId) + 1);
        }
        return piTableFlowCount;
    }

    private Map<PiTableId, Long> piMatchedCounting(PiPipelineModel model, PiPipelineInterpreter interpreter, List<FlowEntry> rules) {
        HashMap<PiTableId, Long> piTableMatchCount = new HashMap<PiTableId, Long>();
        for (PiTableModel tableModel : model.tables()) {
            piTableMatchCount.put(tableModel.id(), 0L);
        }
        for (FlowEntry f : rules) {
            PiTableId piTableId;
            if (f.state() != FlowEntry.FlowEntryState.ADDED || (piTableId = this.getPiTableId(f, interpreter)) == null) continue;
            piTableMatchCount.put(piTableId, (Long)piTableMatchCount.get(piTableId) + f.packets());
        }
        return piTableMatchCount;
    }

    private PiTableId getPiTableId(FlowEntry flowEntry, PiPipelineInterpreter interpreter) {
        return flowEntry.table().type() == TableId.Type.PIPELINE_INDEPENDENT ? (PiTableId)flowEntry.table() : (PiTableId)interpreter.mapFlowRuleTableId(((Integer)((IndexTableId)flowEntry.table()).id()).intValue()).orElse(null);
    }

    private List<TableStatisticsEntry> generatePiFlowTableStatistics(Map<PiTableId, Integer> piTableFlowCount, Map<PiTableId, Long> piTableMatchCount, PiPipelineModel model, DeviceId deviceId) {
        Iterator<Map.Entry<PiTableId, Integer>> it = piTableFlowCount.entrySet().iterator();
        ArrayList<TableStatisticsEntry> tableStatsList = new ArrayList<TableStatisticsEntry>();
        while (it.hasNext()) {
            Map.Entry<PiTableId, Integer> pair = it.next();
            TableStatisticsEntry tableStat = DefaultTableStatisticsEntry.builder().withDeviceId(deviceId).withTableId((TableId)pair.getKey()).withActiveFlowEntries((long)piTableFlowCount.get(pair.getKey()).intValue()).withPacketsMatchedCount(piTableMatchCount.get(pair.getKey()).longValue()).withMaxSize(((PiTableModel)model.table(pair.getKey()).get()).maxSize()).build();
            tableStatsList.add(tableStat);
            it.remove();
        }
        return tableStatsList;
    }
}

