/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime.mirror;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.store.service.WallClockTimestamp;

public class TimedEntry<E extends PiEntity> {
    private final long timestamp;
    private final E entity;

    TimedEntry(long timestamp, E entity) {
        this.timestamp = timestamp;
        this.entity = entity;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public E entry() {
        return this.entity;
    }

    public long lifeSec() {
        long now = new WallClockTimestamp().unixTimestamp();
        return (now - this.timestamp) / 1000L;
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.entity);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimedEntry other = (TimedEntry)obj;
        return Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.entity, other.entity);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", this.timestamp).add("entity", this.entity).toString();
    }
}

