/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import java.nio.ByteBuffer;
import java.util.stream.Collectors;
import org.onlab.packet.EthType;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.P4RuntimeDriverUtils;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.packet.OutboundPacket;
import org.onosproject.net.packet.PacketProgrammable;
import org.onosproject.net.pi.model.PiPipelineInterpreter;
import org.onosproject.p4runtime.api.P4RuntimeClient;

public class P4RuntimePacketProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements PacketProgrammable {
    public void emit(OutboundPacket packet) {
        if (!this.setupBehaviour("emit()")) {
            return;
        }
        PiPipelineInterpreter interpreter = P4RuntimeDriverUtils.getInterpreter(this.handler());
        if (interpreter == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.logPacketOut(packet);
        }
        try {
            interpreter.mapOutboundPacket(packet).forEach(op -> ((P4RuntimeClient)this.client).packetOut(this.p4DeviceId.longValue(), op, this.pipeconf));
        }
        catch (PiPipelineInterpreter.PiInterpreterException e) {
            this.log.error("Unable to translate outbound packet for {} with pipeconf {}: {}", new Object[]{this.deviceId, this.pipeconf.id(), e.getMessage()});
        }
    }

    private void logPacketOut(OutboundPacket packet) {
        EthType.EtherType etherType = this.getEtherType(packet.data());
        String outPorts = packet.treatment().immediate().stream().filter(i -> i.type().equals((Object)Instruction.Type.OUTPUT)).map(i -> Long.toString(((Instructions.OutputInstruction)i).port().toLong())).collect(Collectors.joining(","));
        String desc = outPorts.isBlank() ? "treatment=" + packet.treatment().toString() : "egress_ports=" + outPorts;
        this.log.trace("Sending PACKET-OUT >>> device={} {} eth_type={}", new Object[]{packet.sendThrough(), desc, etherType.ethType().toString()});
    }

    private EthType.EtherType getEtherType(ByteBuffer data) {
        short shortEthType = data.getShort(12);
        data.rewind();
        return EthType.EtherType.lookup((short)shortEthType);
    }
}

