/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeMeterMirror;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultBand;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterCellId;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterProgrammable;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.pi.model.PiMeterId;
import org.onosproject.net.pi.model.PiMeterModel;
import org.onosproject.net.pi.model.PiPipelineModel;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiMeterCellConfig;
import org.onosproject.net.pi.runtime.PiMeterCellHandle;
import org.onosproject.net.pi.service.PiMeterTranslator;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslationException;
import org.onosproject.p4runtime.api.P4RuntimeClient;

public class P4RuntimeMeterProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements MeterProgrammable {
    private static final int METER_LOCK_EXPIRE_TIME_IN_MIN = 10;
    private static final LoadingCache<PiMeterCellHandle, Lock> ENTRY_LOCKS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PiMeterCellHandle, Lock>(){

        public Lock load(PiMeterCellHandle handle) {
            return new ReentrantLock();
        }
    });
    private PiMeterTranslator translator;
    private P4RuntimeMeterMirror meterMirror;
    private PiPipelineModel pipelineModel;

    @Override
    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.translator = this.translationService.meterTranslator();
        this.meterMirror = (P4RuntimeMeterMirror)this.handler().get(P4RuntimeMeterMirror.class);
        this.pipelineModel = this.pipeconf.pipelineModel();
        return true;
    }

    public CompletableFuture<Boolean> performMeterOperation(MeterOperation meterOp) {
        if (!this.setupBehaviour("performMeterOperation()")) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(this.processMeterOp(meterOp));
    }

    private boolean processMeterOp(MeterOperation meterOp) {
        PiMeterCellConfig piMeterCellConfig;
        if (meterOp.type() != MeterOperation.Type.MODIFY) {
            this.log.warn("P4Runtime meter operations must be MODIFY!");
            return false;
        }
        try {
            piMeterCellConfig = (PiMeterCellConfig)this.translator.translate((PiTranslatable)meterOp.meter(), this.pipeconf);
        }
        catch (PiTranslationException e) {
            this.log.warn("Unable translate meter, aborting meter operation {}: {}", (Object)meterOp.type(), (Object)e.getMessage());
            this.log.debug("exception", (Throwable)e);
            return false;
        }
        PiMeterCellHandle handle = PiMeterCellHandle.of((DeviceId)this.deviceId, (PiMeterCellConfig)piMeterCellConfig);
        ((Lock)ENTRY_LOCKS.getUnchecked((Object)handle)).lock();
        boolean result = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf).modify((PiEntity)piMeterCellConfig).submitSync().isSuccess();
        if (result) {
            this.meterMirror.put(handle, piMeterCellConfig);
        }
        ((Lock)ENTRY_LOCKS.getUnchecked((Object)handle)).unlock();
        return result;
    }

    public CompletableFuture<Collection<Meter>> getMeters() {
        if (!this.setupBehaviour("getMeters()")) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        HashSet<PiMeterId> meterIds = new HashSet<PiMeterId>();
        for (PiMeterModel mode : this.pipelineModel.meters()) {
            meterIds.add(mode.id());
        }
        Collection piMeterCellConfigs = ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), this.pipeconf).meterCells(meterIds).submitSync().all(PiMeterCellConfig.class);
        Collection meters = piMeterCellConfigs.stream().map(p -> {
            DefaultMeter meter = (DefaultMeter)DefaultMeter.builder().withBands((Collection)p.meterBands().stream().map(b -> DefaultBand.builder().withRate(b.rate()).burstSize(b.burst()).ofType(Band.Type.NONE).build()).collect(Collectors.toList())).withCellId((MeterCellId)p.cellId()).build();
            meter.setState(MeterState.ADDED);
            return meter;
        }).collect(Collectors.toList());
        return CompletableFuture.completedFuture(meters);
    }
}

