/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeDefaultEntryMirror;
import org.onosproject.net.behaviour.PiPipelineProgrammable;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.model.PiPipelineModel;
import org.onosproject.net.pi.runtime.PiTableEntry;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeReadClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractP4RuntimePipelineProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements PiPipelineProgrammable {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public abstract ByteBuffer createDeviceDataBuffer(PiPipeconf var1);

    public CompletableFuture<Boolean> setPipeconf(PiPipeconf pipeconf) {
        if (!this.setupBehaviour("setPipeconf()")) {
            return CompletableFuture.completedFuture(false);
        }
        ByteBuffer deviceDataBuffer = this.createDeviceDataBuffer(pipeconf);
        if (deviceDataBuffer == null) {
            return CompletableFuture.completedFuture(false);
        }
        CompletableFuture pipeconfSet = ((P4RuntimeClient)this.client).setPipelineConfig(this.p4DeviceId.longValue(), pipeconf, deviceDataBuffer);
        return this.getDefaultEntries(pipeconfSet, pipeconf);
    }

    public CompletableFuture<Boolean> isPipeconfSet(PiPipeconf pipeconf) {
        if (!this.setupBehaviour("isPipeconfSet()")) {
            return CompletableFuture.completedFuture(false);
        }
        return ((P4RuntimeClient)this.client).isPipelineConfigSet(this.p4DeviceId.longValue(), pipeconf);
    }

    public abstract Optional<PiPipeconf> getDefaultPipeconf();

    private CompletableFuture<Boolean> getDefaultEntries(CompletableFuture<Boolean> pipeconfSet, PiPipeconf pipeconf) {
        if (!this.driverBoolProperty("supportDefaultTableEntry", true)) {
            return pipeconfSet;
        }
        return pipeconfSet.thenApply(setSuccess -> {
            if (!setSuccess.booleanValue()) {
                return setSuccess;
            }
            P4RuntimeDefaultEntryMirror mirror = (P4RuntimeDefaultEntryMirror)this.handler().get(P4RuntimeDefaultEntryMirror.class);
            PiPipelineModel pipelineModel = pipeconf.pipelineModel();
            P4RuntimeReadClient.ReadRequest request = ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), pipeconf);
            pipelineModel.tables().stream().filter(t -> !t.isConstantTable()).forEach(t -> {
                if (!t.constDefaultAction().isPresent()) {
                    request.defaultTableEntry(t.id());
                }
            });
            P4RuntimeReadClient.ReadResponse response = request.submitSync();
            mirror.sync(this.deviceId, response.all(PiTableEntry.class));
            return true;
        });
    }
}

