/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeMeterMirror;
import org.onosproject.drivers.p4runtime.mirror.TimedEntry;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.DefaultMeter;
import org.onosproject.net.meter.DefaultMeterFeatures;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFeatures;
import org.onosproject.net.meter.MeterOperation;
import org.onosproject.net.meter.MeterProgrammable;
import org.onosproject.net.meter.MeterScope;
import org.onosproject.net.meter.MeterState;
import org.onosproject.net.pi.model.PiMeterId;
import org.onosproject.net.pi.model.PiMeterModel;
import org.onosproject.net.pi.model.PiPipelineModel;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMeterCellConfig;
import org.onosproject.net.pi.runtime.PiMeterCellHandle;
import org.onosproject.net.pi.runtime.PiMeterCellId;
import org.onosproject.net.pi.service.PiMeterTranslator;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslatedEntity;
import org.onosproject.net.pi.service.PiTranslationException;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeWriteClient;

public class P4RuntimeMeterProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements MeterProgrammable {
    private static final Striped<Lock> WRITE_LOCKS = Striped.lock((int)30);
    private PiMeterTranslator translator;
    private P4RuntimeMeterMirror meterMirror;
    private PiPipelineModel pipelineModel;

    @Override
    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.translator = this.translationService.meterTranslator();
        this.meterMirror = (P4RuntimeMeterMirror)this.handler().get(P4RuntimeMeterMirror.class);
        this.pipelineModel = this.pipeconf.pipelineModel();
        return true;
    }

    public CompletableFuture<Boolean> performMeterOperation(MeterOperation meterOp) {
        if (!this.setupBehaviour("performMeterOperation()")) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(this.processMeterOp(meterOp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processMeterOp(MeterOperation meterOp) {
        PiMeterCellHandle handle = PiMeterCellHandle.of((DeviceId)this.deviceId, (PiMeterCellId)((PiMeterCellId)meterOp.meter().meterCellId()));
        boolean result = true;
        ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).lock();
        try {
            PiMeterCellConfig piMeterCellConfig;
            switch (meterOp.type()) {
                case ADD: 
                case MODIFY: {
                    try {
                        piMeterCellConfig = (PiMeterCellConfig)this.translator.translate((PiTranslatable)meterOp.meter(), this.pipeconf);
                    }
                    catch (PiTranslationException e) {
                        this.log.warn("Unable translate meter, aborting meter operation {}: {}", (Object)meterOp.type(), (Object)e.getMessage());
                        this.log.debug("exception", (Throwable)e);
                        boolean bl = false;
                        ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).unlock();
                        return bl;
                    }
                    this.translator.learn((PiHandle)handle, new PiTranslatedEntity((PiTranslatable)meterOp.meter(), (PiEntity)piMeterCellConfig, (PiHandle)handle));
                    break;
                }
                case REMOVE: {
                    PiMeterCellId piMeterCellId = (PiMeterCellId)meterOp.meter().meterCellId();
                    piMeterCellConfig = PiMeterCellConfig.reset((PiMeterCellId)piMeterCellId);
                    this.translator.forget((PiHandle)handle);
                    break;
                }
                default: {
                    this.log.warn("Meter Operation type {} not supported", (Object)meterOp.type());
                    boolean bl = false;
                    return bl;
                }
            }
            P4RuntimeWriteClient.WriteRequest request = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf);
            this.appendEntryToWriteRequestOrSkip(request, handle, piMeterCellConfig);
            if (!request.pendingUpdates().isEmpty() && (result = request.submitSync().isSuccess())) {
                this.meterMirror.applyWriteRequest(request);
            }
        }
        finally {
            ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).unlock();
        }
        return result;
    }

    public CompletableFuture<Collection<Meter>> getMeters() {
        if (!this.setupBehaviour("getMeters()")) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        HashSet<PiMeterId> meterIds = new HashSet<PiMeterId>();
        for (PiMeterModel mode : this.pipelineModel.meters()) {
            meterIds.add(mode.id());
        }
        Collection piMeterCellConfigs = ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), this.pipeconf).meterCells(meterIds).submitSync().all(PiMeterCellConfig.class);
        this.meterMirror.sync(this.deviceId, piMeterCellConfigs);
        if (piMeterCellConfigs.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArrayList inconsistentOrDefaultCells = Lists.newArrayList();
        ArrayList meters = Lists.newArrayList();
        for (PiMeterCellConfig config : piMeterCellConfigs) {
            PiMeterCellHandle handle;
            DefaultMeter meter = (DefaultMeter)this.forgeMeter(config, handle = PiMeterCellHandle.of((DeviceId)this.deviceId, (PiMeterCellConfig)config));
            if (meter == null) {
                inconsistentOrDefaultCells.add(config.cellId());
                continue;
            }
            meters.add(meter);
        }
        if (!inconsistentOrDefaultCells.isEmpty()) {
            P4RuntimeWriteClient.WriteRequest request = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf);
            for (PiMeterCellId cellId : inconsistentOrDefaultCells) {
                PiMeterCellHandle handle = PiMeterCellHandle.of((DeviceId)this.deviceId, (PiMeterCellId)cellId);
                this.appendEntryToWriteRequestOrSkip(request, handle, PiMeterCellConfig.reset((PiMeterCellId)cellId));
            }
            request.submit().whenComplete((response, ex) -> {
                if (ex != null) {
                    this.log.error("Exception resetting inconsistent meter entries", ex);
                } else {
                    this.log.debug("Successfully removed {} out of {} inconsistent meter entries", (Object)response.success().size(), (Object)response.all().size());
                }
                response.success().forEach(entity -> this.meterMirror.remove((PiMeterCellHandle)entity.handle()));
            });
        }
        return CompletableFuture.completedFuture(meters);
    }

    public CompletableFuture<Collection<MeterFeatures>> getMeterFeatures() {
        if (!this.setupBehaviour("getMeterFeatures()")) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        HashSet meterFeatures = new HashSet();
        this.pipeconf.pipelineModel().meters().forEach(m -> meterFeatures.add(new P4RuntimeMeterFeaturesBuilder((PiMeterModel)m, this.deviceId).build()));
        return CompletableFuture.completedFuture(meterFeatures);
    }

    private Meter forgeMeter(PiMeterCellConfig config, PiMeterCellHandle handle) {
        Optional translatedEntity = this.translator.lookup((PiHandle)handle);
        TimedEntry timedEntry = this.meterMirror.get(handle);
        if (translatedEntity.isEmpty()) {
            if (!config.isDefaultConfig()) {
                this.log.warn("Meter Cell Config obtained from device {} is different from one in in translation store: device={}, store=Default", (Object)this.deviceId, (Object)config);
            } else {
                this.log.debug("Configs for {} obtained from device: {} and from the store are default, skipping the forge section", (Object)config.cellId(), (Object)this.deviceId);
            }
            return null;
        }
        if (!this.isSimilar((PiMeterCellConfig)((PiTranslatedEntity)translatedEntity.get()).translated(), config)) {
            this.log.warn("Meter Cell Config obtained from device {} is different from one in in translation store: device={}, store={}", new Object[]{this.deviceId, config, ((PiTranslatedEntity)translatedEntity.get()).translated()});
            return null;
        }
        if (timedEntry == null) {
            this.log.warn("Meter entry handle not found in device mirror: {}", (Object)handle);
            return null;
        }
        Meter original = (Meter)((PiTranslatedEntity)translatedEntity.get()).original();
        DefaultMeter meter = (DefaultMeter)DefaultMeter.builder().withBands(original.bands()).withCellId(original.meterCellId()).forDevice(this.deviceId).build();
        meter.setState(MeterState.ADDED);
        return meter;
    }

    private boolean appendEntryToWriteRequestOrSkip(P4RuntimeWriteClient.WriteRequest writeRequest, PiMeterCellHandle handle, PiMeterCellConfig configToModify) {
        TimedEntry configOnDevice = this.meterMirror.get(handle);
        if (configOnDevice != null && ((PiMeterCellConfig)configOnDevice.entry()).equals((Object)configToModify)) {
            this.log.debug("Ignoring re-apply of existing entry: {}", (Object)configToModify);
            return true;
        }
        writeRequest.entity((PiEntity)configToModify, P4RuntimeWriteClient.UpdateType.MODIFY);
        return false;
    }

    protected boolean isSimilar(PiMeterCellConfig onosMeter, PiMeterCellConfig deviceMeter) {
        return onosMeter.equals((Object)deviceMeter);
    }

    public static class P4RuntimeMeterFeaturesBuilder {
        private final PiMeterModel piMeterModel;
        private DeviceId deviceId;
        private static final long PI_METER_START_INDEX = 0L;
        private static final short PI_METER_MAX_BAND = 2;
        private static final short PI_METER_MAX_COLOR = 3;

        public P4RuntimeMeterFeaturesBuilder(PiMeterModel piMeterModel, DeviceId deviceId) {
            this.piMeterModel = (PiMeterModel)Preconditions.checkNotNull((Object)piMeterModel);
            this.deviceId = deviceId;
        }

        public MeterFeatures build() {
            MeterFeatures.Builder builder = DefaultMeterFeatures.builder().forDevice(this.deviceId).withScope(MeterScope.of((String)((String)this.piMeterModel.id().id()))).withMaxBands((short)2).withMaxColors((short)3);
            if (this.piMeterModel.size() > 0L) {
                builder.withStartIndex(0L).withEndIndex(this.piMeterModel.size() - 1L);
            }
            HashSet bands = Sets.newHashSet();
            bands.add(Band.Type.MARK_YELLOW);
            bands.add(Band.Type.MARK_RED);
            builder.withBandTypes((Set)bands);
            HashSet units = Sets.newHashSet();
            if (this.piMeterModel.unit() == PiMeterModel.Unit.BYTES) {
                units.add(Meter.Unit.BYTES_PER_SEC);
            } else if (this.piMeterModel.unit() == PiMeterModel.Unit.PACKETS) {
                units.add(Meter.Unit.PKTS_PER_SEC);
            }
            return builder.withUnits((Set)units).hasBurst(true).hasStats(false).build();
        }

        public MeterFeatures noMeterFeatures(DeviceId deviceId) {
            return DefaultMeterFeatures.noMeterFeatures((DeviceId)deviceId);
        }
    }
}

