/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.base.Preconditions;
import org.onosproject.drivers.p4runtime.P4RuntimeDriverUtils;
import org.onosproject.grpc.utils.AbstractGrpcHandlerBehaviour;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.service.PiPipeconfService;
import org.onosproject.net.pi.service.PiTranslationService;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeController;

public abstract class AbstractP4RuntimeHandlerBehaviour
extends AbstractGrpcHandlerBehaviour<P4RuntimeClient, P4RuntimeController> {
    protected Long p4DeviceId;
    protected PiPipeconf pipeconf;
    PiTranslationService translationService;

    public AbstractP4RuntimeHandlerBehaviour() {
        super(P4RuntimeController.class);
    }

    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.p4DeviceId = P4RuntimeDriverUtils.extractP4DeviceId(this.mgmtUriFromNetcfg());
        if (this.p4DeviceId == null) {
            this.log.warn("Unable to obtain P4Runtime-internal device_id from config of {}, cannot perform {}", (Object)this.deviceId, (Object)opName);
            return false;
        }
        PiPipeconfService pipeconfService = (PiPipeconfService)this.handler().get(PiPipeconfService.class);
        this.pipeconf = pipeconfService.getPipeconf(this.deviceId).orElse(null);
        if (this.pipeconf == null) {
            this.log.warn("Missing pipeconf for {}, cannot perform {}", (Object)this.deviceId, (Object)opName);
            return false;
        }
        this.translationService = (PiTranslationService)this.handler().get(PiTranslationService.class);
        return true;
    }

    boolean driverBoolProperty(String propName, boolean defaultVal) {
        Preconditions.checkNotNull((Object)propName);
        if (this.handler().driver().getProperty(propName) == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(this.handler().driver().getProperty(propName));
    }
}

