/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeActionProfileGroupMirror;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeActionProfileMemberMirror;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeMirror;
import org.onosproject.drivers.p4runtime.mirror.TimedEntry;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProgrammable;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.pi.model.PiActionProfileId;
import org.onosproject.net.pi.model.PiActionProfileModel;
import org.onosproject.net.pi.runtime.PiActionProfileGroup;
import org.onosproject.net.pi.runtime.PiActionProfileGroupHandle;
import org.onosproject.net.pi.runtime.PiActionProfileMember;
import org.onosproject.net.pi.runtime.PiActionProfileMemberHandle;
import org.onosproject.net.pi.runtime.PiActionProfileMemberId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.service.PiGroupTranslator;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslatedEntity;
import org.onosproject.net.pi.service.PiTranslationException;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeReadClient;
import org.onosproject.p4runtime.api.P4RuntimeWriteClient;

public class P4RuntimeActionGroupProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements GroupProgrammable {
    private static final String READ_ACTION_GROUPS_FROM_MIRROR = "actionGroupReadFromMirror";
    private static final boolean DEFAULT_READ_ACTION_GROUPS_FROM_MIRROR = false;
    private static final Striped<Lock> WRITE_LOCKS = Striped.lock((int)30);
    protected GroupStore groupStore;
    private P4RuntimeActionProfileGroupMirror groupMirror;
    private P4RuntimeActionProfileMemberMirror memberMirror;
    private PiGroupTranslator groupTranslator;

    @Override
    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.groupMirror = (P4RuntimeActionProfileGroupMirror)this.handler().get(P4RuntimeActionProfileGroupMirror.class);
        this.memberMirror = (P4RuntimeActionProfileMemberMirror)this.handler().get(P4RuntimeActionProfileMemberMirror.class);
        this.groupStore = (GroupStore)this.handler().get(GroupStore.class);
        this.groupTranslator = this.translationService.groupTranslator();
        return true;
    }

    public void performGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        if (!this.setupBehaviour("performGroupOperation()")) {
            return;
        }
        groupOps.operations().forEach(op -> {
            Group groupOnStore = this.groupStore.getGroup(deviceId, op.groupId());
            if (groupOnStore == null) {
                this.log.warn("Unable to find group {} in store, aborting {} operation [{}]", new Object[]{op.groupId(), op.opType(), op});
                return;
            }
            DefaultGroupDescription groupDesc = new DefaultGroupDescription(deviceId, groupOnStore.type(), groupOnStore.buckets(), groupOnStore.appCookie(), (Integer)groupOnStore.id().id(), groupOnStore.appId());
            DefaultGroup groupToApply = new DefaultGroup(op.groupId(), (GroupDescription)groupDesc);
            this.processPdGroup((Group)groupToApply, op.opType());
        });
    }

    public Collection<Group> getGroups() {
        if (!this.setupBehaviour("getGroups()")) {
            return Collections.emptyList();
        }
        if (this.driverBoolProperty(READ_ACTION_GROUPS_FROM_MIRROR, false)) {
            return this.getGroupsFromMirror();
        }
        P4RuntimeReadClient.ReadRequest request = ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), this.pipeconf);
        this.pipeconf.pipelineModel().actionProfiles().stream().map(PiActionProfileModel::id).forEach(id -> request.actionProfileGroups(id).actionProfileMembers(id));
        P4RuntimeReadClient.ReadResponse response = request.submitSync();
        if (!response.isSuccess()) {
            return Collections.emptyList();
        }
        Collection groupsOnDevice = response.all(PiActionProfileGroup.class);
        Map<PiActionProfileMemberHandle, PiActionProfileMember> membersOnDevice = response.all(PiActionProfileMember.class).stream().collect(Collectors.toMap(m -> m.handle(this.deviceId), m -> m));
        this.groupMirror.sync(this.deviceId, groupsOnDevice);
        this.memberMirror.sync(this.deviceId, membersOnDevice.values());
        ArrayList result = Lists.newArrayList();
        ArrayList groupsToRemove = Lists.newArrayList();
        HashSet memberHandlesToKeep = Sets.newHashSet();
        for (PiActionProfileGroup piGroup : groupsOnDevice) {
            Group pdGroup = this.checkAndForgeGroupEntry(piGroup, membersOnDevice);
            if (pdGroup == null) {
                groupsToRemove.add(piGroup);
                continue;
            }
            result.add(pdGroup);
            piGroup.members().stream().map(m -> PiActionProfileMemberHandle.of((DeviceId)this.deviceId, (PiActionProfileId)piGroup.actionProfile(), (PiActionProfileMemberId)m.id())).forEach(memberHandlesToKeep::add);
        }
        Sets.SetView memberHandlesToRemove = Sets.difference(membersOnDevice.keySet(), (Set)memberHandlesToKeep);
        Set groupHandlesToRemove = groupsToRemove.stream().map(g -> g.handle(this.deviceId)).collect(Collectors.toSet());
        if (groupHandlesToRemove.size() + memberHandlesToRemove.size() > 0) {
            this.log.warn("Cleaning up {} action profile groups and {} members on {}...", new Object[]{groupHandlesToRemove.size(), memberHandlesToRemove.size(), this.deviceId});
            ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf).delete(groupHandlesToRemove).delete((Iterable)memberHandlesToRemove).submit().whenComplete((r, ex) -> {
                if (ex != null) {
                    this.log.error("Exception removing inconsistent group/members", ex);
                } else {
                    this.log.debug("Completed removal of inconsistent groups/members ({} of {} updates succeeded)", (Object)r.success().size(), (Object)r.all().size());
                    this.groupMirror.applyWriteResponse((P4RuntimeWriteClient.WriteResponse)r);
                    this.memberMirror.applyWriteResponse((P4RuntimeWriteClient.WriteResponse)r);
                }
            });
        }
        return result;
    }

    private Collection<Group> getGroupsFromMirror() {
        Map<PiActionProfileMemberHandle, PiActionProfileMember> members = this.memberMirror.getAll(this.deviceId).stream().map(TimedEntry::entry).collect(Collectors.toMap(e -> e.handle(this.deviceId), e -> e));
        return this.groupMirror.getAll(this.deviceId).stream().map(TimedEntry::entry).map(g -> this.checkAndForgeGroupEntry((PiActionProfileGroup)g, members)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Group checkAndForgeGroupEntry(PiActionProfileGroup piGroupOnDevice, Map<PiActionProfileMemberHandle, PiActionProfileMember> membersOnDevice) {
        PiActionProfileGroupHandle handle = PiActionProfileGroupHandle.of((DeviceId)this.deviceId, (PiActionProfileGroup)piGroupOnDevice);
        Optional translatedEntity = this.groupTranslator.lookup((PiHandle)handle);
        TimedEntry mirrorEntry = this.groupMirror.get(handle);
        if (!translatedEntity.isPresent()) {
            this.log.warn("Group not found in translation store: {}", (Object)handle);
            return null;
        }
        PiActionProfileGroup piGroupFromStore = (PiActionProfileGroup)((PiTranslatedEntity)translatedEntity.get()).translated();
        if (!piGroupFromStore.equals((Object)piGroupOnDevice)) {
            this.log.warn("Group on device {} is different from the one in translation store: {} [device={}, store={}]", new Object[]{this.deviceId, handle, piGroupOnDevice, piGroupFromStore});
            return null;
        }
        if (!this.validateGroupMembers(piGroupFromStore, membersOnDevice)) {
            this.log.warn("Group on device {} refers to members that are different than those found in translation store: {}", (Object)this.deviceId, (Object)handle);
            return null;
        }
        if (mirrorEntry == null) {
            this.log.warn("Group handle not found in device mirror: {}", (Object)handle);
            return null;
        }
        return this.addedGroup((Group)((PiTranslatedEntity)translatedEntity.get()).original(), mirrorEntry.lifeSec());
    }

    private boolean validateGroupMembers(PiActionProfileGroup piGroupFromStore, Map<PiActionProfileMemberHandle, PiActionProfileMember> membersOnDevice) {
        Collection<PiActionProfileMember> groupMembers = this.extractAllMemberInstancesOrNull(piGroupFromStore);
        if (groupMembers == null) {
            return false;
        }
        return groupMembers.stream().allMatch(memberFromStore -> memberFromStore.equals(membersOnDevice.get(memberFromStore.handle(this.deviceId))));
    }

    private Group addedGroup(Group original, long life) {
        DefaultGroup forgedGroup = new DefaultGroup(original.id(), (GroupDescription)original);
        forgedGroup.setState(Group.GroupState.ADDED);
        forgedGroup.setLife(life);
        return forgedGroup;
    }

    private void processPdGroup(Group pdGroup, GroupOperation.Type opType) {
        PiActionProfileGroup piGroup;
        try {
            piGroup = (PiActionProfileGroup)this.groupTranslator.translate((PiTranslatable)pdGroup, this.pipeconf);
        }
        catch (PiTranslationException e) {
            this.log.warn("Unable to translate group, aborting {} operation: {} [{}]", new Object[]{opType, e.getMessage(), pdGroup});
            return;
        }
        Operation operation = opType.equals((Object)GroupOperation.Type.DELETE) ? Operation.REMOVE : Operation.APPLY;
        PiActionProfileGroupHandle handle = piGroup.handle(this.deviceId);
        if (operation.equals((Object)Operation.APPLY)) {
            this.groupTranslator.learn((PiHandle)handle, new PiTranslatedEntity((PiTranslatable)pdGroup, (PiEntity)piGroup, (PiHandle)handle));
        } else {
            this.groupTranslator.forget((PiHandle)handle);
        }
        this.asyncWritePiGroup(piGroup, handle, operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncWritePiGroup(PiActionProfileGroup group, PiActionProfileGroupHandle groupHandle, Operation operation) {
        Collection<PiActionProfileMember> members = this.extractAllMemberInstancesOrNull(group);
        if (members == null) {
            return;
        }
        P4RuntimeWriteClient.WriteRequest request = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf);
        ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).lock();
        try {
            if (operation == Operation.APPLY) {
                members.forEach(m -> this.appendEntityToWriteRequestOrSkip(request, (PiHandle)m.handle(this.deviceId), (PiEntity)m, this.memberMirror, operation));
                this.appendEntityToWriteRequestOrSkip(request, groupHandle, group, this.groupMirror, operation);
            } else {
                this.appendEntityToWriteRequestOrSkip(request, groupHandle, group, this.groupMirror, operation);
                members.forEach(m -> this.appendEntityToWriteRequestOrSkip(request, (PiHandle)m.handle(this.deviceId), (PiEntity)m, this.memberMirror, operation));
            }
            if (request.pendingUpdates().isEmpty()) {
                return;
            }
            this.groupMirror.applyWriteRequest(request);
            this.memberMirror.applyWriteRequest(request);
            request.submit().whenComplete((r, ex) -> {
                if (ex != null) {
                    this.log.error("Exception writing PI group to " + this.deviceId, ex);
                } else {
                    this.log.debug("Completed write of PI group to {} ({} of {} updates succeeded)", new Object[]{this.deviceId, r.success().size(), r.all().size()});
                }
            });
        }
        finally {
            ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).unlock();
        }
    }

    private <H extends PiHandle, E extends PiEntity> void appendEntityToWriteRequestOrSkip(P4RuntimeWriteClient.WriteRequest writeRequest, H handle, E entityToApply, P4RuntimeMirror<H, E> mirror, Operation operation) {
        TimedEntry<E> entityOnDevice = mirror.get(handle);
        switch (operation) {
            case APPLY: {
                if (entityOnDevice == null) {
                    writeRequest.insert(entityToApply);
                    break;
                }
                if (entityToApply.equals(entityOnDevice.entry())) {
                    return;
                }
                writeRequest.modify(entityToApply);
                break;
            }
            case REMOVE: {
                if (entityOnDevice == null) {
                    return;
                }
                writeRequest.delete(handle);
                break;
            }
            default: {
                this.log.error("Unrecognized operation {}", (Object)operation);
            }
        }
    }

    private Collection<PiActionProfileMember> extractAllMemberInstancesOrNull(PiActionProfileGroup group) {
        Collection instances = group.members().stream().map(PiActionProfileGroup.WeightedMember::instance).filter(Objects::nonNull).collect(Collectors.toList());
        if (instances.size() != group.members().size()) {
            this.log.error("PiActionProfileGroup has {} member references, but only {} instances were found", (Object)group.members().size(), (Object)instances.size());
            return null;
        }
        return instances;
    }

    static enum Operation {
        APPLY,
        REMOVE;

    }
}

