/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.onosproject.cluster.ClusterService;
import org.onosproject.drivers.p4runtime.P4RuntimeDriverUtils;
import org.onosproject.grpc.utils.AbstractGrpcHandshaker;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.device.DeviceAgentListener;
import org.onosproject.net.device.DeviceHandshaker;
import org.onosproject.net.pi.model.PiPipeconf;
import org.onosproject.net.pi.service.PiPipeconfService;
import org.onosproject.net.pi.service.PiPipeconfWatchdogService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeController;

public class P4RuntimeHandshaker
extends AbstractGrpcHandshaker<P4RuntimeClient, P4RuntimeController>
implements DeviceHandshaker {
    private static final int MAX_CLUSTER_SIZE = 20;
    private Long p4DeviceId;

    public P4RuntimeHandshaker() {
        super(P4RuntimeController.class);
    }

    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.p4DeviceId = P4RuntimeDriverUtils.extractP4DeviceId(this.mgmtUriFromNetcfg());
        if (this.p4DeviceId == null) {
            this.log.warn("Unable to obtain the P4Runtime-internal device_id from config of {}, cannot perform {}", (Object)this.deviceId, (Object)opName);
            return false;
        }
        return true;
    }

    public boolean isAvailable() {
        if (!(this.setupBehaviour("isAvailable()") && ((P4RuntimeClient)this.client).isServerReachable() && ((P4RuntimeClient)this.client).isSessionOpen(this.p4DeviceId.longValue()))) {
            return false;
        }
        return PiPipeconfWatchdogService.PipelineStatus.READY.equals((Object)((PiPipeconfWatchdogService)this.handler().get(PiPipeconfWatchdogService.class)).getStatus(this.data().deviceId()));
    }

    public CompletableFuture<Boolean> probeAvailability() {
        if (!(this.setupBehaviour("probeAvailability()") && ((P4RuntimeClient)this.client).isServerReachable() && ((P4RuntimeClient)this.client).isSessionOpen(this.p4DeviceId.longValue()))) {
            return CompletableFuture.completedFuture(false);
        }
        PiPipeconfService piPipeconfService = (PiPipeconfService)this.handler().get(PiPipeconfService.class);
        Optional optionalPiPipeconf = piPipeconfService.getPipeconf(this.deviceId);
        if (optionalPiPipeconf.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        if (!PiPipeconfWatchdogService.PipelineStatus.READY.equals((Object)((PiPipeconfWatchdogService)this.handler().get(PiPipeconfWatchdogService.class)).getStatus(this.data().deviceId()))) {
            return CompletableFuture.completedFuture(false);
        }
        return ((P4RuntimeClient)this.client).isPipelineConfigSet(this.p4DeviceId.longValue(), (PiPipeconf)optionalPiPipeconf.get());
    }

    public void roleChanged(MastershipRole newRole) {
        if (!this.setupBehaviour("roleChanged()")) {
            return;
        }
        if (!newRole.equals((Object)MastershipRole.NONE)) {
            throw new UnsupportedOperationException("Use preference-based way for setting MASTER or STANDBY roles");
        }
        this.log.info("Notified role NONE, closing session...");
        ((P4RuntimeClient)this.client).closeSession(this.p4DeviceId.longValue());
    }

    public void roleChanged(int preference, long term) {
        if (!this.setupBehaviour("roleChanged()")) {
            return;
        }
        int clusterSize = ((ClusterService)this.handler().get(ClusterService.class)).getNodes().size();
        if (clusterSize > 20) {
            throw new IllegalStateException("Cluster too big! Maz size supported is 20");
        }
        BigInteger electionId = BigInteger.valueOf(term).multiply(BigInteger.valueOf(20L)).subtract(BigInteger.valueOf(preference));
        ((P4RuntimeClient)this.client).setMastership(this.p4DeviceId.longValue(), preference == 0, electionId);
    }

    public MastershipRole getRole() {
        if (!(this.setupBehaviour("getRole()") && ((P4RuntimeClient)this.client).isServerReachable() && ((P4RuntimeClient)this.client).isSessionOpen(this.p4DeviceId.longValue()))) {
            return MastershipRole.NONE;
        }
        return ((P4RuntimeClient)this.client).isMaster(this.p4DeviceId.longValue()) ? MastershipRole.MASTER : MastershipRole.STANDBY;
    }

    public void addDeviceAgentListener(ProviderId providerId, DeviceAgentListener listener) {
        ((P4RuntimeController)this.handler().get(P4RuntimeController.class)).addDeviceAgentListener(this.data().deviceId(), providerId, listener);
    }

    public void removeDeviceAgentListener(ProviderId providerId) {
        ((P4RuntimeController)this.handler().get(P4RuntimeController.class)).removeDeviceAgentListener(this.data().deviceId(), providerId);
    }
}

