/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Striped;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimePreEntryMirror;
import org.onosproject.drivers.p4runtime.mirror.TimedEntry;
import org.onosproject.net.DeviceId;
import org.onosproject.net.group.DefaultGroup;
import org.onosproject.net.group.Group;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupOperation;
import org.onosproject.net.group.GroupOperations;
import org.onosproject.net.group.GroupProgrammable;
import org.onosproject.net.group.GroupStore;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiPreEntry;
import org.onosproject.net.pi.runtime.PiPreEntryHandle;
import org.onosproject.net.pi.service.PiReplicationGroupTranslator;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslatedEntity;
import org.onosproject.net.pi.service.PiTranslationException;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeWriteClient;

public class P4RuntimeReplicationGroupProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements GroupProgrammable {
    private static final Striped<Lock> STRIPED_LOCKS = Striped.lock((int)30);
    private GroupStore groupStore;
    private P4RuntimePreEntryMirror mirror;
    private PiReplicationGroupTranslator translator;

    @Override
    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.mirror = (P4RuntimePreEntryMirror)this.handler().get(P4RuntimePreEntryMirror.class);
        this.groupStore = (GroupStore)this.handler().get(GroupStore.class);
        this.translator = this.translationService.replicationGroupTranslator();
        return true;
    }

    public void performGroupOperation(DeviceId deviceId, GroupOperations groupOps) {
        if (!this.setupBehaviour("performGroupOperation()")) {
            return;
        }
        groupOps.operations().forEach(op -> {
            Group group = this.groupStore.getGroup(deviceId, op.groupId());
            if (group == null) {
                this.log.warn("Unable to find group {} in store, aborting {} operation [{}]", new Object[]{op.groupId(), op.opType(), op});
                return;
            }
            this.processGroupOp(group, op.opType());
        });
    }

    public Collection<Group> getGroups() {
        if (!this.setupBehaviour("getGroups()")) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.getGroupsFromMirror());
    }

    private Collection<Group> getGroupsFromMirror() {
        return this.mirror.getAll(this.deviceId).stream().map(TimedEntry::entry).map(this::forgeGroupEntry).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processGroupOp(Group pdGroup, GroupOperation.Type opType) {
        PiPreEntry preEntry;
        try {
            preEntry = (PiPreEntry)this.translator.translate((PiTranslatable)pdGroup, this.pipeconf);
        }
        catch (PiTranslationException e) {
            this.log.warn("Unable to translate replication group, aborting {} operation: {} [{}]", new Object[]{opType, e.getMessage(), pdGroup});
            return;
        }
        PiPreEntryHandle handle = (PiPreEntryHandle)preEntry.handle(this.deviceId);
        PiPreEntry entryOnDevice = this.mirror.get(handle) == null ? null : (PiPreEntry)this.mirror.get(handle).entry();
        Lock lock = (Lock)STRIPED_LOCKS.get((Object)handle);
        lock.lock();
        try {
            this.processPreEntry(handle, preEntry, entryOnDevice, pdGroup, opType);
        }
        finally {
            lock.unlock();
        }
    }

    private void processPreEntry(PiPreEntryHandle handle, PiPreEntry entryToApply, PiPreEntry entryOnDevice, Group pdGroup, GroupOperation.Type opType) {
        switch (opType) {
            case ADD: {
                this.robustInsert(handle, entryToApply, pdGroup);
                return;
            }
            case MODIFY: {
                this.robustModify(handle, entryToApply, pdGroup);
                return;
            }
            case DELETE: {
                this.preEntryWrite(handle, entryToApply, pdGroup, P4RuntimeWriteClient.UpdateType.DELETE);
                return;
            }
        }
        this.log.error("Unknown group operation type {}, cannot process multicast group", (Object)opType);
    }

    private boolean writeEntryOnDevice(PiPreEntry entry, P4RuntimeWriteClient.UpdateType opType) {
        return ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf).entity((PiEntity)entry, opType).submitSync().isSuccess();
    }

    private boolean preEntryWrite(PiPreEntryHandle handle, PiPreEntry preEntry, Group pdGroup, P4RuntimeWriteClient.UpdateType opType) {
        switch (opType) {
            case DELETE: {
                if (this.writeEntryOnDevice(preEntry, P4RuntimeWriteClient.UpdateType.DELETE)) {
                    this.mirror.remove(handle);
                    this.translator.forget((PiHandle)handle);
                    return true;
                }
                return false;
            }
            case INSERT: 
            case MODIFY: {
                if (this.writeEntryOnDevice(preEntry, opType)) {
                    this.mirror.put(handle, preEntry);
                    this.translator.learn((PiHandle)handle, new PiTranslatedEntity((PiTranslatable)pdGroup, (PiEntity)preEntry, (PiHandle)handle));
                    return true;
                }
                return false;
            }
        }
        this.log.warn("Unknown operation type {}, cannot apply group", (Object)opType);
        return false;
    }

    private void robustInsert(PiPreEntryHandle handle, PiPreEntry preEntry, Group pdGroup) {
        if (this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.INSERT)) {
            return;
        }
        this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.DELETE);
        this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.INSERT);
    }

    private void robustModify(PiPreEntryHandle handle, PiPreEntry preEntry, Group pdGroup) {
        if (this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.MODIFY)) {
            return;
        }
        this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.DELETE);
        this.preEntryWrite(handle, preEntry, pdGroup, P4RuntimeWriteClient.UpdateType.INSERT);
    }

    private Group forgeGroupEntry(PiPreEntry preEntry) {
        PiPreEntryHandle handle = (PiPreEntryHandle)preEntry.handle(this.deviceId);
        Optional translatedEntity = this.translator.lookup((PiHandle)handle);
        TimedEntry timedEntry = this.mirror.get(handle);
        if (!translatedEntity.isPresent()) {
            this.log.warn("PRE entry handle not found in translation store: {}", (Object)handle);
            return null;
        }
        if (timedEntry == null) {
            this.log.warn("PRE entry handle not found in device mirror: {}", (Object)handle);
            return null;
        }
        return this.addedGroup((Group)((PiTranslatedEntity)translatedEntity.get()).original(), timedEntry.lifeSec());
    }

    private Group addedGroup(Group original, long life) {
        DefaultGroup forgedGroup = new DefaultGroup(original.id(), (GroupDescription)original);
        forgedGroup.setState(Group.GroupState.ADDED);
        forgedGroup.setLife(life);
        return forgedGroup;
    }
}

