/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime.mirror;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.onlab.util.KryoNamespace;
import org.onlab.util.SharedExecutors;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeMirror;
import org.onosproject.drivers.p4runtime.mirror.TimedEntry;
import org.onosproject.event.EventListener;
import org.onosproject.net.Annotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.service.PiPipeconfWatchdogEvent;
import org.onosproject.net.pi.service.PiPipeconfWatchdogListener;
import org.onosproject.net.pi.service.PiPipeconfWatchdogService;
import org.onosproject.p4runtime.api.P4RuntimeWriteClient;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractDistributedP4RuntimeMirror<H extends PiHandle, E extends PiEntity>
implements P4RuntimeMirror<H, E> {
    private static final String MAP_NAME_TEMPLATE = "onos-p4runtime-mirror-%s-map";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY)
    protected PiPipeconfWatchdogService pipeconfWatchdogService;
    private EventuallyConsistentMap<PiHandle, TimedEntry<E>> mirrorMap;
    private EventuallyConsistentMap<PiHandle, Annotations> annotationsMap;
    private final PiEntityType entityType;
    private final boolean flushOnPipelineUnknown;
    private final PiPipeconfWatchdogListener pipeconfListener = new InternalPipeconfWatchdogListener();

    AbstractDistributedP4RuntimeMirror(PiEntityType entityType) {
        this.entityType = entityType;
        this.flushOnPipelineUnknown = false;
    }

    AbstractDistributedP4RuntimeMirror(PiEntityType entityType, boolean flushOnPipelineUnknown) {
        this.entityType = entityType;
        this.flushOnPipelineUnknown = flushOnPipelineUnknown;
    }

    protected abstract String mapSimpleName();

    @Activate
    public void activate() {
        String fullMapName = String.format(MAP_NAME_TEMPLATE, this.mapSimpleName());
        KryoNamespace serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{TimedEntry.class}).build();
        this.mirrorMap = this.storageService.eventuallyConsistentMapBuilder().withName(fullMapName).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.annotationsMap = this.storageService.eventuallyConsistentMapBuilder().withName(fullMapName + "-annotations").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.pipeconfWatchdogService.addListener((EventListener)this.pipeconfListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.pipeconfWatchdogService.removeListener((EventListener)this.pipeconfListener);
        this.mirrorMap.destroy();
        this.mirrorMap = null;
        this.log.info("Stopped");
    }

    @Override
    public Collection<TimedEntry<E>> getAll(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId);
        return this.mirrorMap.entrySet().stream().filter(entry -> ((PiHandle)entry.getKey()).deviceId().equals((Object)deviceId)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public TimedEntry<E> get(H handle) {
        Preconditions.checkNotNull(handle);
        return (TimedEntry)this.mirrorMap.get(handle);
    }

    @Override
    public void put(H handle, E entry) {
        Preconditions.checkNotNull(handle);
        Preconditions.checkNotNull(entry);
        PiPipeconfWatchdogService.PipelineStatus status = this.pipeconfWatchdogService.getStatus(handle.deviceId());
        if (this.flushOnPipelineUnknown && !status.equals((Object)PiPipeconfWatchdogService.PipelineStatus.READY)) {
            this.log.info("Ignoring {} mirror update because pipeline status of {} is {}: {}", new Object[]{this.entityType, handle.deviceId(), status, entry});
            return;
        }
        long now = new WallClockTimestamp().unixTimestamp();
        TimedEntry<E> timedEntry = new TimedEntry<E>(now, entry);
        this.mirrorMap.put(handle, timedEntry);
    }

    @Override
    public void remove(H handle) {
        Preconditions.checkNotNull(handle);
        this.mirrorMap.remove(handle);
        this.annotationsMap.remove(handle);
    }

    @Override
    public void putAnnotations(H handle, Annotations annotations) {
        Preconditions.checkNotNull(handle);
        Preconditions.checkNotNull((Object)annotations);
        this.annotationsMap.put(handle, (Object)annotations);
    }

    @Override
    public Annotations annotations(H handle) {
        Preconditions.checkNotNull(handle);
        return (Annotations)this.annotationsMap.get(handle);
    }

    @Override
    public void sync(DeviceId deviceId, Collection<E> entities) {
        Preconditions.checkNotNull((Object)deviceId);
        Map<PiHandle, PiEntity> deviceState = entities.stream().collect(Collectors.toMap(e -> e.handle(deviceId), e -> e));
        Map localState = this.deviceHandleMap(deviceId);
        AtomicInteger removeCount = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        AtomicInteger addCount = new AtomicInteger(0);
        deviceState.keySet().stream().filter(deviceHandle -> !localState.containsKey(deviceHandle)).forEach(deviceHandle -> {
            PiEntity entryToAdd = (PiEntity)deviceState.get(deviceHandle);
            this.log.debug("Adding mirror entry for {}: {}", (Object)deviceId, (Object)entryToAdd);
            this.put(deviceHandle, entryToAdd);
            addCount.incrementAndGet();
        });
        localState.keySet().forEach(localHandle -> {
            PiEntity localEntry = (PiEntity)localState.get(localHandle);
            PiEntity deviceEntry = (PiEntity)deviceState.get(localHandle);
            if (deviceEntry == null) {
                this.log.debug("Removing mirror entry for {}: {}", (Object)deviceId, (Object)localEntry);
                this.remove(localHandle);
                removeCount.incrementAndGet();
            } else if (!deviceEntry.equals(localEntry)) {
                this.log.debug("Updating mirror entry for {}: {}-->{}", new Object[]{deviceId, localEntry, deviceEntry});
                this.put(localHandle, deviceEntry);
                updateCount.incrementAndGet();
            }
        });
        if (removeCount.get() + updateCount.get() + addCount.get() > 0) {
            this.log.info("Synchronized {} mirror for {}: {} removed, {} updated, {} added", new Object[]{this.entityType, deviceId, removeCount, updateCount, addCount});
        }
    }

    private Set<PiHandle> getHandlesForDevice(DeviceId deviceId) {
        return this.mirrorMap.keySet().stream().filter(h -> h.deviceId().equals((Object)deviceId)).collect(Collectors.toSet());
    }

    private Map<PiHandle, E> deviceHandleMap(DeviceId deviceId) {
        HashMap deviceMap = Maps.newHashMap();
        this.mirrorMap.entrySet().stream().filter(e -> ((PiHandle)e.getKey()).deviceId().equals((Object)deviceId)).forEach(e -> deviceMap.put((PiHandle)e.getKey(), ((TimedEntry)e.getValue()).entry()));
        return deviceMap;
    }

    private void removeAll(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId);
        Set<PiHandle> handles = this.getHandlesForDevice(deviceId);
        handles.forEach(this::remove);
    }

    @Override
    public void applyWriteRequest(P4RuntimeWriteClient.WriteRequest request) {
        this.applyUpdates(request.pendingUpdates());
    }

    @Override
    public void applyWriteResponse(P4RuntimeWriteClient.WriteResponse response) {
        this.applyUpdates(response.success());
    }

    private void applyUpdates(Collection<? extends P4RuntimeWriteClient.EntityUpdateRequest> updates) {
        updates.stream().filter(r -> r.entityType().equals((Object)this.entityType)).forEach(r -> {
            switch (r.updateType()) {
                case INSERT: 
                case MODIFY: {
                    this.put(r.handle(), r.entity());
                    break;
                }
                case DELETE: {
                    this.remove(r.handle());
                    break;
                }
                default: {
                    this.log.error("Unknown update type {}", (Object)r.updateType());
                }
            }
        });
    }

    public class InternalPipeconfWatchdogListener
    implements PiPipeconfWatchdogListener {
        public void event(PiPipeconfWatchdogEvent event) {
            AbstractDistributedP4RuntimeMirror.this.log.debug("Flushing mirror for {}, pipeline status is {}", event.subject(), (Object)event.type());
            SharedExecutors.getPoolThreadExecutor().execute(() -> AbstractDistributedP4RuntimeMirror.this.removeAll((DeviceId)event.subject()));
        }

        public boolean isRelevant(PiPipeconfWatchdogEvent event) {
            return AbstractDistributedP4RuntimeMirror.this.flushOnPipelineUnknown && ((PiPipeconfWatchdogEvent.Type)event.type()).equals((Object)PiPipeconfWatchdogEvent.Type.PIPELINE_UNKNOWN);
        }
    }
}

