/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.p4runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Striped;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.onosproject.drivers.p4runtime.AbstractP4RuntimeHandlerBehaviour;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeDefaultEntryMirror;
import org.onosproject.drivers.p4runtime.mirror.P4RuntimeTableMirror;
import org.onosproject.drivers.p4runtime.mirror.TimedEntry;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultFlowEntry;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleProgrammable;
import org.onosproject.net.pi.model.PiCounterType;
import org.onosproject.net.pi.model.PiPipelineModel;
import org.onosproject.net.pi.model.PiTableId;
import org.onosproject.net.pi.model.PiTableModel;
import org.onosproject.net.pi.runtime.PiCounterCell;
import org.onosproject.net.pi.runtime.PiCounterCellData;
import org.onosproject.net.pi.runtime.PiCounterCellHandle;
import org.onosproject.net.pi.runtime.PiCounterCellId;
import org.onosproject.net.pi.runtime.PiEntity;
import org.onosproject.net.pi.runtime.PiEntityType;
import org.onosproject.net.pi.runtime.PiHandle;
import org.onosproject.net.pi.runtime.PiMatchKey;
import org.onosproject.net.pi.runtime.PiTableEntry;
import org.onosproject.net.pi.runtime.PiTableEntryHandle;
import org.onosproject.net.pi.service.PiFlowRuleTranslator;
import org.onosproject.net.pi.service.PiTranslatable;
import org.onosproject.net.pi.service.PiTranslatedEntity;
import org.onosproject.net.pi.service.PiTranslationException;
import org.onosproject.p4runtime.api.P4RuntimeClient;
import org.onosproject.p4runtime.api.P4RuntimeReadClient;
import org.onosproject.p4runtime.api.P4RuntimeWriteClient;

public class P4RuntimeFlowRuleProgrammable
extends AbstractP4RuntimeHandlerBehaviour
implements FlowRuleProgrammable {
    private static final Striped<Lock> WRITE_LOCKS = Striped.lock((int)30);
    private PiPipelineModel pipelineModel;
    private P4RuntimeTableMirror tableMirror;
    private PiFlowRuleTranslator translator;
    private P4RuntimeDefaultEntryMirror defaultEntryMirror;

    @Override
    protected boolean setupBehaviour(String opName) {
        if (!super.setupBehaviour(opName)) {
            return false;
        }
        this.pipelineModel = this.pipeconf.pipelineModel();
        this.tableMirror = (P4RuntimeTableMirror)this.handler().get(P4RuntimeTableMirror.class);
        this.translator = this.translationService.flowRuleTranslator();
        this.defaultEntryMirror = (P4RuntimeDefaultEntryMirror)this.handler().get(P4RuntimeDefaultEntryMirror.class);
        return true;
    }

    public Collection<FlowEntry> getFlowEntries() {
        if (!this.setupBehaviour("getFlowEntries()")) {
            return Collections.emptyList();
        }
        if (this.driverBoolProperty("tableReadFromMirror", false)) {
            return this.getFlowEntriesFromMirror();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ArrayList inconsistentEntries = Lists.newArrayList();
        Collection<PiTableEntry> deviceEntries = this.getAllTableEntriesFromDevice();
        if (deviceEntries == null) {
            return Collections.emptyList();
        }
        this.tableMirror.sync(this.deviceId, deviceEntries);
        if (deviceEntries.isEmpty()) {
            return Collections.emptyList();
        }
        Map<PiTableEntryHandle, PiCounterCellData> counterCellMap = this.readEntryCounters(deviceEntries);
        for (PiTableEntry entry : deviceEntries) {
            PiTableEntryHandle handle;
            FlowEntry flowEntry = this.forgeFlowEntry(entry, handle = entry.handle(this.deviceId), counterCellMap.get(handle));
            if (flowEntry == null) {
                if (this.isOriginalDefaultEntry(entry)) continue;
                inconsistentEntries.add(entry);
                continue;
            }
            result.add((Object)flowEntry);
        }
        ArrayList inconsistentDefaultEntries = Lists.newArrayList();
        List<PiTableEntry> tempDefaultEntries = inconsistentEntries.stream().filter(PiTableEntry::isDefaultAction).collect(Collectors.toList());
        inconsistentEntries.removeAll(tempDefaultEntries);
        tempDefaultEntries.forEach(piTableEntry -> {
            PiTableEntry resetEntry = PiTableEntry.builder().forTable(piTableEntry.table()).build();
            inconsistentDefaultEntries.add(resetEntry);
        });
        if (!inconsistentEntries.isEmpty() || !inconsistentDefaultEntries.isEmpty()) {
            P4RuntimeWriteClient.WriteRequest writeRequest = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf);
            if (!inconsistentEntries.isEmpty()) {
                this.log.warn("Found {} inconsistent table entries on {}, removing them...", (Object)inconsistentEntries.size(), (Object)this.deviceId);
                writeRequest = writeRequest.entities((Iterable)inconsistentEntries, P4RuntimeWriteClient.UpdateType.DELETE);
            }
            if (!inconsistentDefaultEntries.isEmpty()) {
                this.log.warn("Found {} inconsistent default table entries on {}, resetting them...", (Object)inconsistentDefaultEntries.size(), (Object)this.deviceId);
                writeRequest = writeRequest.entities((Iterable)inconsistentDefaultEntries, P4RuntimeWriteClient.UpdateType.MODIFY);
            }
            writeRequest.submit().whenComplete((response, ex) -> {
                if (ex != null) {
                    this.log.error("Exception removing inconsistent table entries", ex);
                } else {
                    this.log.debug("Successfully removed {} out of {} inconsistent entries", (Object)response.success().size(), (Object)response.all().size());
                }
                response.success().forEach(entity -> this.tableMirror.remove((PiTableEntryHandle)entity.handle()));
            });
        }
        return result.build();
    }

    private Collection<PiTableEntry> getAllTableEntriesFromDevice() {
        P4RuntimeReadClient.ReadRequest request = ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), this.pipeconf);
        boolean supportDefaultTableEntry = this.driverBoolProperty("supportDefaultTableEntry", true);
        boolean tableWildcardReads = this.driverBoolProperty("tableWildcardReads", false);
        if (!tableWildcardReads) {
            this.pipelineModel.tables().stream().filter(t -> !t.isConstantTable()).forEach(t -> {
                request.tableEntries(t.id());
                if (supportDefaultTableEntry && t.constDefaultAction().isEmpty()) {
                    request.defaultTableEntry(t.id());
                }
            });
        } else {
            request.allTableEntries();
            if (supportDefaultTableEntry) {
                request.allDefaultTableEntries();
            }
        }
        P4RuntimeReadClient.ReadResponse response = request.submitSync();
        if (!response.isSuccess()) {
            return null;
        }
        Stream<Object> piTableEntries = response.all(PiTableEntry.class).stream().distinct();
        if (tableWildcardReads) {
            piTableEntries = piTableEntries.filter(te -> {
                Optional piTableModel = this.pipelineModel.table(te.table());
                return !piTableModel.isEmpty() && !((PiTableModel)piTableModel.get()).isConstantTable() && (!supportDefaultTableEntry || !((PiTableModel)piTableModel.get()).constDefaultAction().isPresent());
            });
        }
        return piTableEntries.collect(Collectors.toList());
    }

    public Collection<FlowRule> applyFlowRules(Collection<FlowRule> rules) {
        return this.processFlowRules(rules, Operation.APPLY);
    }

    public Collection<FlowRule> removeFlowRules(Collection<FlowRule> rules) {
        return this.processFlowRules(rules, Operation.REMOVE);
    }

    private FlowEntry forgeFlowEntry(PiTableEntry entry, PiTableEntryHandle handle, PiCounterCellData cellData) {
        Optional translatedEntity = this.translator.lookup((PiHandle)handle);
        TimedEntry timedEntry = this.tableMirror.get(handle);
        if (translatedEntity.isEmpty()) {
            if (!this.isOriginalDefaultEntry(entry)) {
                this.log.warn("Table entry handle not found in translation store: {}", (Object)handle);
            }
            return null;
        }
        if (!((PiTableEntry)((PiTranslatedEntity)translatedEntity.get()).translated()).equals((Object)entry)) {
            this.log.warn("Table entry obtained from device {} is different from one in in translation store: device={}, store={}", new Object[]{this.deviceId, entry, ((PiTranslatedEntity)translatedEntity.get()).translated()});
            return null;
        }
        if (timedEntry == null) {
            this.log.warn("Table entry handle not found in device mirror: {}", (Object)handle);
            return null;
        }
        if (cellData != null) {
            return new DefaultFlowEntry((FlowRule)((PiTranslatedEntity)translatedEntity.get()).original(), FlowEntry.FlowEntryState.ADDED, timedEntry.lifeSec(), cellData.packets(), cellData.bytes());
        }
        return new DefaultFlowEntry((FlowRule)((PiTranslatedEntity)translatedEntity.get()).original(), FlowEntry.FlowEntryState.ADDED, timedEntry.lifeSec(), 0L, 0L);
    }

    private Collection<FlowEntry> getFlowEntriesFromMirror() {
        return this.tableMirror.getAll(this.deviceId).stream().map(timedEntry -> this.forgeFlowEntry((PiTableEntry)timedEntry.entry(), ((PiTableEntry)timedEntry.entry()).handle(this.deviceId), null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<FlowRule> processFlowRules(Collection<FlowRule> rules, Operation driverOperation) {
        CompletableFuture futureResponse;
        if (!this.setupBehaviour("processFlowRules()") || rules.isEmpty()) {
            return Collections.emptyList();
        }
        P4RuntimeWriteClient.WriteRequest request = ((P4RuntimeClient)this.client).write(this.p4DeviceId.longValue(), this.pipeconf);
        HashMap handleToRuleMap = Maps.newHashMap();
        ArrayList skippedRules = Lists.newArrayList();
        ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).lock();
        try {
            for (FlowRule rule : rules) {
                PiTableEntry entry;
                try {
                    entry = (PiTableEntry)this.translator.translate((PiTranslatable)rule, this.pipeconf);
                }
                catch (PiTranslationException e) {
                    this.log.warn("Unable to translate flow rule for pipeconf '{}': {} [{}]", new Object[]{this.pipeconf.id(), e.getMessage(), rule});
                    continue;
                }
                PiTableEntryHandle handle = entry.handle(this.deviceId);
                handleToRuleMap.put(handle, rule);
                if (driverOperation.equals((Object)Operation.APPLY)) {
                    this.translator.learn((PiHandle)handle, new PiTranslatedEntity((PiTranslatable)rule, (PiEntity)entry, (PiHandle)handle));
                } else {
                    this.translator.forget((PiHandle)handle);
                }
                if (!this.appendEntryToWriteRequestOrSkip(request, handle, entry, driverOperation)) continue;
                skippedRules.add(rule);
            }
            if (request.pendingUpdates().isEmpty()) {
                Collection<FlowRule> collection = rules;
                return collection;
            }
            this.tableMirror.applyWriteRequest(request);
            futureResponse = request.submit();
        }
        finally {
            ((Lock)WRITE_LOCKS.get((Object)this.deviceId)).unlock();
        }
        P4RuntimeWriteClient.WriteResponse response = (P4RuntimeWriteClient.WriteResponse)Futures.getUnchecked((Future)futureResponse);
        List<FlowRule> appliedRules = this.getAppliedFlowRules(response, handleToRuleMap, driverOperation);
        return ImmutableList.builder().addAll((Iterable)skippedRules).addAll(appliedRules).build();
    }

    private List<FlowRule> getAppliedFlowRules(P4RuntimeWriteClient.WriteResponse response, Map<PiHandle, FlowRule> handleToFlowRuleMap, Operation driverOperation) {
        return response.success().stream().filter(r -> r.entityType().equals((Object)PiEntityType.TABLE_ENTRY)).filter(r -> this.isUpdateTypeRelevant(r.updateType(), driverOperation)).map(r -> {
            FlowRule rule = (FlowRule)handleToFlowRuleMap.get(r.handle());
            if (rule == null) {
                this.log.warn("Server returned unrecognized table entry handle in write response: {}", (Object)r.handle());
            }
            return rule;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isUpdateTypeRelevant(P4RuntimeWriteClient.UpdateType p4UpdateType, Operation driverOperation) {
        switch (p4UpdateType) {
            case INSERT: 
            case MODIFY: {
                if (driverOperation.equals((Object)Operation.APPLY)) break;
                return false;
            }
            case DELETE: {
                if (driverOperation.equals((Object)Operation.REMOVE)) break;
                return false;
            }
            default: {
                this.log.error("Unknown update type {}", (Object)p4UpdateType);
                return false;
            }
        }
        return true;
    }

    private boolean appendEntryToWriteRequestOrSkip(P4RuntimeWriteClient.WriteRequest writeRequest, PiTableEntryHandle handle, PiTableEntry piEntryToApply, Operation driverOperation) {
        P4RuntimeWriteClient.UpdateType updateType;
        TimedEntry piEntryOnDevice = this.tableMirror.get(handle);
        boolean supportDefaultEntry = this.driverBoolProperty("supportDefaultTableEntry", true);
        boolean deleteBeforeUpdate = this.driverBoolProperty("tableDeleteBeforeUpdate", false);
        if (driverOperation == Operation.APPLY) {
            if (piEntryOnDevice == null) {
                updateType = !piEntryToApply.isDefaultAction() || !supportDefaultEntry ? P4RuntimeWriteClient.UpdateType.INSERT : P4RuntimeWriteClient.UpdateType.MODIFY;
            } else {
                if (piEntryToApply.action().equals(((PiTableEntry)piEntryOnDevice.entry()).action())) {
                    this.log.debug("Ignoring re-apply of existing entry: {}", (Object)piEntryToApply);
                    return true;
                }
                if (deleteBeforeUpdate && !piEntryToApply.isDefaultAction()) {
                    writeRequest.delete((PiHandle)handle);
                    updateType = P4RuntimeWriteClient.UpdateType.INSERT;
                } else {
                    updateType = P4RuntimeWriteClient.UpdateType.MODIFY;
                }
            }
        } else {
            if (piEntryToApply.isDefaultAction()) {
                PiTableEntry originalDefaultEntry = this.getOriginalDefaultEntry(piEntryToApply.table());
                if (originalDefaultEntry == null) {
                    return false;
                }
                return this.appendEntryToWriteRequestOrSkip(writeRequest, originalDefaultEntry.handle(this.deviceId), originalDefaultEntry, Operation.APPLY);
            }
            if (piEntryOnDevice == null) {
                this.log.debug("Ignoring delete of missing entry: {}", (Object)piEntryToApply);
                return true;
            }
            updateType = P4RuntimeWriteClient.UpdateType.DELETE;
        }
        writeRequest.entity((PiEntity)piEntryToApply, updateType);
        return false;
    }

    private PiTableEntry getOriginalDefaultEntry(PiTableId tableId) {
        PiTableEntryHandle handle = PiTableEntry.builder().forTable(tableId).withMatchKey(PiMatchKey.EMPTY).build().handle(this.deviceId);
        TimedEntry originalDefaultEntry = this.defaultEntryMirror.get(handle);
        if (originalDefaultEntry != null) {
            return (PiTableEntry)originalDefaultEntry.entry();
        }
        return null;
    }

    private boolean isOriginalDefaultEntry(PiTableEntry entry) {
        if (!entry.isDefaultAction()) {
            return false;
        }
        PiTableEntry originalDefaultEntry = this.getOriginalDefaultEntry(entry.table());
        if (originalDefaultEntry == null) {
            return false;
        }
        if (originalDefaultEntry.action() == null) {
            return entry.action() == null;
        }
        return originalDefaultEntry.action().equals(entry.action());
    }

    private Map<PiTableEntryHandle, PiCounterCellData> readEntryCounters(Collection<PiTableEntry> tableEntries) {
        if (!this.driverBoolProperty("supportTableCounters", true) || tableEntries.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.driverBoolProperty("tableReadCountersWithTableEntries", true)) {
            return tableEntries.stream().filter(t -> t.counter() != null).collect(Collectors.toMap(t -> t.handle(this.deviceId), PiTableEntry::counter));
        }
        Set cellHandles = tableEntries.stream().filter(e -> !e.isDefaultAction()).filter(e -> this.tableHasCounter(e.table())).map(PiCounterCellId::ofDirect).map(id -> PiCounterCellHandle.of((DeviceId)this.deviceId, (PiCounterCellId)id)).collect(Collectors.toSet());
        return ((P4RuntimeClient)this.client).read(this.p4DeviceId.longValue(), this.pipeconf).handles(cellHandles).submitSync().all(PiCounterCell.class).stream().filter(c -> c.cellId().counterType().equals((Object)PiCounterType.DIRECT)).collect(Collectors.toMap(c -> c.cellId().tableEntry().handle(this.deviceId), PiCounterCell::data));
    }

    private boolean tableHasCounter(PiTableId tableId) {
        return this.pipelineModel.table(tableId).isPresent() && !((PiTableModel)this.pipelineModel.table(tableId).get()).counters().isEmpty();
    }

    static enum Operation {
        APPLY,
        REMOVE;

    }
}

