/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.onlab.packet.IpAddress;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.CltSignalType;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.device.OchPortDescription;
import org.onosproject.net.device.OduCltPortDescription;
import org.onosproject.net.device.PortDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlConfigParser {
    public static final Logger log = LoggerFactory.getLogger(XmlConfigParser.class);

    private XmlConfigParser() {
    }

    public static HierarchicalConfiguration loadXml(InputStream xmlStream) {
        XMLConfiguration cfg = new XMLConfiguration();
        try {
            cfg.load(xmlStream);
            return cfg;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Cannot load xml from Stream", e);
        }
    }

    public static List<ControllerInfo> parseStreamControllers(HierarchicalConfiguration cfg) {
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        List fields = cfg.configurationsAt("data.capable-switch.logical-switches.switch.controllers.controller");
        for (HierarchicalConfiguration sub : fields) {
            controllers.add(new ControllerInfo(IpAddress.valueOf((String)sub.getString("ip-address")), Integer.parseInt(sub.getString("port")), sub.getString("protocol")));
        }
        return controllers;
    }

    public static List<PortDescription> parseFujitsuT100Ports(HierarchicalConfiguration cfg) {
        AtomicInteger counter = new AtomicInteger(1);
        ArrayList portDescriptions = Lists.newArrayList();
        List subtrees = cfg.configurationsAt("data.interfaces.interface");
        for (HierarchicalConfiguration portConfig : subtrees) {
            if (!portConfig.getString("name").contains("LCN") && !portConfig.getString("name").contains("LMP") && portConfig.getString("type").equals("ianaift:ethernetCsmacd")) {
                portDescriptions.add(XmlConfigParser.parseT100OduPort(portConfig, counter.getAndIncrement()));
                continue;
            }
            if (!portConfig.getString("type").equals("ianaift:otnOtu")) continue;
            portDescriptions.add(XmlConfigParser.parseT100OchPort(portConfig, counter.getAndIncrement()));
        }
        return portDescriptions;
    }

    private static OchPortDescription parseT100OchPort(HierarchicalConfiguration cfg, long count) {
        PortNumber portNumber = PortNumber.portNumber((long)count);
        SubnodeConfiguration otuConfig = cfg.configurationAt("otu");
        boolean enabled = otuConfig.getString("administrative-state").equals("up");
        OduSignalType signalType = otuConfig.getString("rate").equals("OTU4") ? OduSignalType.ODU4 : null;
        boolean isTunable = true;
        OchSignal lambda = new OchSignal(GridType.DWDM, ChannelSpacing.CHL_50GHZ, 0, 4);
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", cfg.getString("name")).build();
        return new OchPortDescription(portNumber, enabled, signalType, isTunable, lambda, new SparseAnnotations[]{annotations});
    }

    private static OduCltPortDescription parseT100OduPort(HierarchicalConfiguration cfg, long count) {
        PortNumber portNumber = PortNumber.portNumber((long)count);
        SubnodeConfiguration ethernetConfig = cfg.configurationAt("ethernet");
        boolean enabled = ethernetConfig.getString("administrative-state").equals("up");
        CltSignalType signalType = ethernetConfig.getString("rate").equals("100000000") ? CltSignalType.CLT_100GBE : null;
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", cfg.getString("name")).build();
        return new OduCltPortDescription(portNumber, enabled, signalType, new SparseAnnotations[]{annotations});
    }

    protected static String parseSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch.logical-switches.switch");
        return field.getProperty("id").toString();
    }

    public static String parseCapableSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch");
        return field.getProperty("id").toString();
    }

    public static String createControllersConfig(HierarchicalConfiguration cfg, HierarchicalConfiguration actualCfg, String target, String netconfOperation, String controllerOperation, List<ControllerInfo> controllers) {
        cfg.setProperty("edit-config.target", (Object)target);
        cfg.setProperty("edit-config.default-operation", (Object)netconfOperation);
        cfg.setProperty("edit-config.config.capable-switch.id", (Object)XmlConfigParser.parseCapableSwitchId(actualCfg));
        cfg.setProperty("edit-config.config.capable-switch.logical-switches.switch.id", (Object)XmlConfigParser.parseSwitchId(actualCfg));
        ArrayList<ConfigurationNode> newControllers = new ArrayList<ConfigurationNode>();
        for (ControllerInfo ci : controllers) {
            XMLConfiguration controller = new XMLConfiguration();
            controller.setRoot(new HierarchicalConfiguration.Node("controller"));
            String id = ci.type() + ":" + ci.ip() + ":" + ci.port();
            controller.setProperty("id", (Object)id);
            controller.setProperty("ip-address", (Object)ci.ip());
            controller.setProperty("port", (Object)ci.port());
            controller.setProperty("protocol", (Object)ci.type());
            newControllers.add(controller.getRootNode());
        }
        cfg.addNodes("edit-config.config.capable-switch.logical-switches.switch.controllers", newControllers);
        XMLConfiguration editcfg = (XMLConfiguration)cfg;
        StringWriter stringWriter = new StringWriter();
        try {
            editcfg.save((Writer)stringWriter);
        }
        catch (ConfigurationException e) {
            log.error("createControllersConfig()", (Throwable)e);
        }
        String s = stringWriter.toString().replaceAll("<controller>", "<controller nc:operation=\"" + controllerOperation + "\">");
        s = s.replace("<target>" + target + "</target>", "<target><" + target + "/></target>");
        return s;
    }

    public static List<HierarchicalConfiguration> parseWaveServerCienaPorts(HierarchicalConfiguration cfg) {
        return cfg.configurationsAt("ws-ports.port-interface");
    }

    public static PortDescription parseWaveServerCienaOchPorts(long portNumber, long oduPortSpeed, HierarchicalConfiguration config, SparseAnnotations annotations) {
        ArrayList tunableType = Lists.newArrayList((Object[])new String[]{"Performance-Optimized", "Accelerated"});
        String transmitterPath = "ptp-config.transmitter-state";
        String tunablePath = "ptp-config.adv-config.tx-tuning-mode";
        String gridTypePath = "ptp-config.adv-config.wl-spacing";
        String frequencyPath = "ptp-config.adv-config.frequency";
        boolean isEnabled = config.getString("ptp-config.transmitter-state").equals("enabled");
        boolean isTunable = tunableType.contains(config.getString("ptp-config.adv-config.tx-tuning-mode"));
        int speed100GbpsinMbps = 100000;
        OduSignalType oduSignalType = oduPortSpeed == 100000L ? OduSignalType.ODU4 : null;
        GridType gridType = config.getString("ptp-config.adv-config.wl-spacing").equals("FlexGrid") ? GridType.FLEX : null;
        ChannelSpacing chSpacing = gridType == GridType.FLEX ? ChannelSpacing.CHL_6P25GHZ : null;
        int baseFrequency = 193100;
        int spacingMult = (int)(XmlConfigParser.toGbps(Integer.parseInt(config.getString("ptp-config.adv-config.frequency")) - 193100) / XmlConfigParser.toGbpsFromHz(chSpacing.frequency().asHz()));
        return new OchPortDescription(PortNumber.portNumber((long)portNumber), isEnabled, oduSignalType, isTunable, new OchSignal(gridType, chSpacing, spacingMult, 1), new SparseAnnotations[]{annotations});
    }

    private static long toGbps(long speed) {
        return speed * 1000L;
    }

    private static long toGbpsFromHz(long speed) {
        return speed / 1000L;
    }

    public static boolean configSuccess(HierarchicalConfiguration reply) {
        return reply != null && reply.containsKey("ok");
    }
}

