/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.drivers.utilities.YangElement;
import org.onosproject.drivers.utilities.YangXmlUtils;
import org.onosproject.net.behaviour.ControllerInfo;

public class YangXmlUtilsTest {
    public static final String OF_CONFIG_XML_PATH = "/of-config/of-config.xml";
    private YangXmlUtilsAdap utils;
    private XMLConfiguration testCreateConfig;

    @Before
    public void setUp() throws Exception {
        Assert.assertTrue((String)"No resource for test", (YangXmlUtilsTest.class.getResourceAsStream(OF_CONFIG_XML_PATH) != null ? 1 : 0) != 0);
        this.utils = new YangXmlUtilsAdap();
        this.testCreateConfig = new XMLConfiguration();
    }

    @Test
    public void testGetXmlUtilsInstance() throws ConfigurationException {
        YangXmlUtils instance1 = YangXmlUtils.getInstance();
        YangXmlUtils instance2 = YangXmlUtils.getInstance();
        Assert.assertEquals((String)"Duplicate instance", (Object)instance1, (Object)instance2);
    }

    @Test
    public void testGetXmlConfigurationFromMap() throws ConfigurationException {
        HashMap<String, String> pathAndValues = new HashMap<String, String>();
        pathAndValues.put("capable-switch.id", "openvswitch");
        pathAndValues.put("switch.id", "ofc-bridge");
        pathAndValues.put("controller.id", "tcp:1.1.1.1:1");
        pathAndValues.put("controller.ip-address", "1.1.1.1");
        XMLConfiguration cfg = this.utils.getXmlConfiguration(OF_CONFIG_XML_PATH, pathAndValues);
        this.testCreateConfig.load(this.getClass().getResourceAsStream("/testCreateSingleYangConfig.xml"));
        Assert.assertNotEquals((String)"Null testConfiguration", (Object)new XMLConfiguration(), (Object)this.testCreateConfig);
        Assert.assertEquals((String)"Wrong configuaration", (Object)IteratorUtils.toList((Iterator)this.testCreateConfig.getKeys()), (Object)IteratorUtils.toList((Iterator)cfg.getKeys()));
        Assert.assertEquals((String)"Wrong string configuaration", (Object)this.utils.getString(this.testCreateConfig), (Object)this.utils.getString(cfg));
    }

    @Test
    public void getXmlConfigurationFromYangElements() throws ConfigurationException {
        Assert.assertNotEquals((String)"Null testConfiguration", (Object)new XMLConfiguration(), (Object)this.testCreateConfig);
        this.testCreateConfig.load(this.getClass().getResourceAsStream("/testYangConfig.xml"));
        ArrayList<YangElement> elements = new ArrayList<YangElement>();
        elements.add(new YangElement("capable-switch", (Map)ImmutableMap.of((Object)"id", (Object)"openvswitch")));
        elements.add(new YangElement("switch", (Map)ImmutableMap.of((Object)"id", (Object)"ofc-bridge")));
        ImmutableList controllers = ImmutableList.of((Object)new ControllerInfo(IpAddress.valueOf((String)"1.1.1.1"), 1, "tcp"), (Object)new ControllerInfo(IpAddress.valueOf((String)"2.2.2.2"), 2, "tcp"));
        controllers.stream().forEach(cInfo -> elements.add(new YangElement("controller", (Map)ImmutableMap.of((Object)"id", (Object)cInfo.target(), (Object)"ip-address", (Object)cInfo.ip().toString()))));
        XMLConfiguration cfg = new XMLConfiguration((HierarchicalConfiguration)YangXmlUtils.getInstance().getXmlConfiguration(OF_CONFIG_XML_PATH, elements));
        Assert.assertEquals((String)"Wrong configuaration", (Object)IteratorUtils.toList((Iterator)this.testCreateConfig.getKeys()), (Object)IteratorUtils.toList((Iterator)cfg.getKeys()));
        Assert.assertEquals((String)"Wrong string configuaration", (Object)this.utils.getString(this.testCreateConfig), (Object)this.utils.getString(cfg));
    }

    @Test
    public void testReadLastXmlConfiguration() throws ConfigurationException {
        this.testCreateConfig.load(this.getClass().getResourceAsStream("/testYangConfig.xml"));
        List elements = this.utils.readXmlConfiguration((HierarchicalConfiguration)this.testCreateConfig, "controller");
        ImmutableList expected = ImmutableList.of((Object)new YangElement("controller", (Map)ImmutableMap.of((Object)"id", (Object)"tcp:1.1.1.1:1", (Object)"ip-address", (Object)"1.1.1.1")), (Object)new YangElement("controller", (Map)ImmutableMap.of((Object)"id", (Object)"tcp:2.2.2.2:2", (Object)"ip-address", (Object)"2.2.2.2")));
        Assert.assertEquals((String)"Wrong elements collected", (Object)expected, (Object)elements);
    }

    @Test
    public void testReadNestedXmlConfiguration() throws ConfigurationException {
        this.testCreateConfig.load(this.getClass().getResourceAsStream("/testYangConfig.xml"));
        List elements = this.utils.readXmlConfiguration((HierarchicalConfiguration)this.testCreateConfig, "controllers");
        ImmutableList expected = ImmutableList.of((Object)new YangElement("controllers", (Map)ImmutableMap.of((Object)"controller.id", (Object)"tcp:1.1.1.1:1", (Object)"controller.ip-address", (Object)"1.1.1.1")), (Object)new YangElement("controllers", (Map)ImmutableMap.of((Object)"controller.id", (Object)"tcp:2.2.2.2:2", (Object)"controller.ip-address", (Object)"2.2.2.2")));
        Assert.assertEquals((String)"Wrong elements collected", (Object)expected, (Object)elements);
    }

    private class YangXmlUtilsAdap
    extends YangXmlUtils {
        private YangXmlUtilsAdap() {
        }

        protected InputStream getCfgInputStream(String file) {
            return YangXmlUtilsAdap.class.getResourceAsStream(file);
        }
    }
}

