/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.drivers.utilities.XmlConfigParser;
import org.onosproject.net.behaviour.ControllerInfo;

public class XmlConfigParserTest {
    @Test
    public void basics() throws IOException {
        InputStream stream = this.getClass().getResourceAsStream("/testConfig.xml");
        List controllers = XmlConfigParser.parseStreamControllers((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)stream));
        Assert.assertTrue((boolean)((ControllerInfo)controllers.get(0)).equals((Object)new ControllerInfo(IpAddress.valueOf((String)"10.128.12.1"), 6653, "tcp")));
        Assert.assertTrue((boolean)((ControllerInfo)controllers.get(1)).equals((Object)new ControllerInfo(IpAddress.valueOf((String)"10.128.12.2"), 6654, "tcp")));
    }

    @Test
    public void switchId() {
        InputStream stream = this.getClass().getResourceAsStream("/testConfig.xml");
        String switchId = XmlConfigParser.parseSwitchId((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)stream));
        Assert.assertTrue((boolean)switchId.equals("ofc-bridge"));
    }

    @Test
    public void capableSwitchId() {
        InputStream stream = this.getClass().getResourceAsStream("/testConfig.xml");
        String capableSwitchId = XmlConfigParser.parseCapableSwitchId((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)stream));
        Assert.assertTrue((boolean)capableSwitchId.equals("openvswitch"));
    }

    @Test
    public void controllersConfig() {
        InputStream streamOrig = this.getClass().getResourceAsStream("/testConfig.xml");
        InputStream streamCfg = XmlConfigParser.class.getResourceAsStream("/controllers.xml");
        String config = XmlConfigParser.createControllersConfig((HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)streamCfg), (HierarchicalConfiguration)XmlConfigParser.loadXml((InputStream)streamOrig), (String)"running", (String)"merge", (String)"create", new ArrayList<ControllerInfo>(Arrays.asList(new ControllerInfo(IpAddress.valueOf((String)"192.168.1.1"), 5000, "tcp"))));
        Assert.assertTrue((boolean)config.contains("192.168.1.1"));
        Assert.assertTrue((boolean)config.contains("tcp"));
        Assert.assertTrue((boolean)config.contains("5000"));
    }
}

