/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.utilities;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.onlab.packet.IpAddress;
import org.onosproject.net.behaviour.ControllerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlConfigParser {
    public static final Logger log = LoggerFactory.getLogger(XmlConfigParser.class);
    private static final String DISALLOW_DTD_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String DISALLOW_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    private XmlConfigParser() {
    }

    private static HierarchicalConfiguration loadXmlCommonPart(XMLConfiguration cfg, InputStream xmlStream) throws ParserConfigurationException, ConfigurationException {
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        XmlConfigParser.disableFeature(dbfactory, DISALLOW_DTD_FEATURE);
        XmlConfigParser.disableFeature(dbfactory, DISALLOW_EXTERNAL_DTD);
        dbfactory.setXIncludeAware(false);
        dbfactory.setExpandEntityReferences(false);
        cfg.setDocumentBuilder(dbfactory.newDocumentBuilder());
        cfg.load(xmlStream);
        return cfg;
    }

    public static HierarchicalConfiguration loadXml(InputStream xmlStream) {
        try {
            XMLConfiguration cfg = new XMLConfiguration();
            return XmlConfigParser.loadXmlCommonPart(cfg, xmlStream);
        }
        catch (ParserConfigurationException | ConfigurationException e) {
            throw new IllegalArgumentException("Cannot load xml from Stream", e);
        }
    }

    public static HierarchicalConfiguration loadXml(InputStream xmlStream, boolean withDelim) {
        try {
            XMLConfiguration cfg = new XMLConfiguration();
            if (!withDelim) {
                cfg.setDelimiterParsingDisabled(true);
            }
            return XmlConfigParser.loadXmlCommonPart(cfg, xmlStream);
        }
        catch (ParserConfigurationException | ConfigurationException e) {
            throw new IllegalArgumentException("Cannot load xml from Stream", e);
        }
    }

    public static HierarchicalConfiguration loadXmlString(String xmlStr) {
        return XmlConfigParser.loadXml(new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8)));
    }

    public static HierarchicalConfiguration loadXmlString(String xmlStr, boolean withDelim) {
        return XmlConfigParser.loadXml(new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8)), withDelim);
    }

    public static List<ControllerInfo> parseStreamControllers(HierarchicalConfiguration cfg) {
        ArrayList<ControllerInfo> controllers = new ArrayList<ControllerInfo>();
        List fields = cfg.configurationsAt("data.capable-switch.logical-switches.switch.controllers.controller");
        for (HierarchicalConfiguration sub : fields) {
            controllers.add(new ControllerInfo(IpAddress.valueOf((String)sub.getString("ip-address")), Integer.parseInt(sub.getString("port")), sub.getString("protocol")));
        }
        return controllers;
    }

    protected static String parseSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch.logical-switches.switch");
        return field.getProperty("id").toString();
    }

    public static String parseCapableSwitchId(HierarchicalConfiguration cfg) {
        SubnodeConfiguration field = cfg.configurationAt("data.capable-switch");
        return field.getProperty("id").toString();
    }

    public static String createControllersConfig(HierarchicalConfiguration cfg, HierarchicalConfiguration actualCfg, String target, String netconfOperation, String controllerOperation, List<ControllerInfo> controllers) {
        cfg.setProperty("edit-config.target", (Object)target);
        cfg.setProperty("edit-config.default-operation", (Object)netconfOperation);
        cfg.setProperty("edit-config.config.capable-switch.id", (Object)XmlConfigParser.parseCapableSwitchId(actualCfg));
        cfg.setProperty("edit-config.config.capable-switch.logical-switches.switch.id", (Object)XmlConfigParser.parseSwitchId(actualCfg));
        ArrayList<ConfigurationNode> newControllers = new ArrayList<ConfigurationNode>();
        for (ControllerInfo ci : controllers) {
            XMLConfiguration controller = new XMLConfiguration();
            controller.setRoot(new HierarchicalConfiguration.Node("controller"));
            String id = ci.type() + ":" + ci.ip() + ":" + ci.port();
            controller.setProperty("id", (Object)id);
            controller.setProperty("ip-address", (Object)ci.ip());
            controller.setProperty("port", (Object)ci.port());
            controller.setProperty("protocol", (Object)ci.type());
            newControllers.add(controller.getRootNode());
        }
        cfg.addNodes("edit-config.config.capable-switch.logical-switches.switch.controllers", newControllers);
        XMLConfiguration editcfg = (XMLConfiguration)cfg;
        StringWriter stringWriter = new StringWriter();
        try {
            editcfg.save((Writer)stringWriter);
        }
        catch (ConfigurationException e) {
            log.error("createControllersConfig()", (Throwable)e);
        }
        String s = stringWriter.toString().replaceAll("<controller>", "<controller nc:operation=\"" + controllerOperation + "\">");
        s = s.replace("<target>" + target + "</target>", "<target><" + target + "/></target>");
        return s;
    }

    public static boolean configSuccess(HierarchicalConfiguration reply) {
        return reply != null && reply.containsKey("ok");
    }

    private static void disableFeature(DocumentBuilderFactory dbfactory, String feature) {
        try {
            dbfactory.setFeature(feature, true);
        }
        catch (ParserConfigurationException e) {
            log.info("ParserConfigurationException was thrown. The feature '" + feature + "' is probably not supported by your XML processor.");
        }
    }
}

