/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.TestServiceDirectory;
import org.onlab.packet.ChassisId;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.core.CoreService;
import org.onosproject.core.CoreServiceAdapter;
import org.onosproject.core.Version;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.FlowRuleServiceAdapter;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentServiceAdapter;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.statistic.StatisticServiceAdapter;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyServiceAdapter;
import org.onosproject.ui.impl.TopologyViewWebSocket;

public class TopologyViewWebSocketTest {
    private static final ProviderId PID = new ProviderId("of", "foo.bar");
    private static final ChassisId CHID = new ChassisId(123L);
    private static final MacAddress MAC = MacAddress.valueOf((String)"00:00:00:00:00:19");
    private static final DeviceId DID = DeviceId.deviceId((String)"of:foo");
    private static final Set<IpAddress> IPS = ImmutableSet.of((Object)IpAddress.valueOf((String)"1.2.3.4"));
    private TestWebSocket ws;
    private TestServiceDirectory sd;

    @Before
    public void setUp() {
        this.sd = new TestServiceDirectory();
        this.sd.add(DeviceService.class, (Object)new TestDeviceService());
        this.sd.add(ClusterService.class, (Object)new ClusterServiceAdapter());
        this.sd.add(LinkService.class, (Object)new LinkServiceAdapter());
        this.sd.add(HostService.class, (Object)new TestHostService());
        this.sd.add(MastershipService.class, (Object)new MastershipServiceAdapter());
        this.sd.add(IntentService.class, (Object)new IntentServiceAdapter());
        this.sd.add(FlowRuleService.class, (Object)new TestFlowService());
        this.sd.add(StatisticService.class, (Object)new StatisticServiceAdapter());
        this.sd.add(TopologyService.class, (Object)new TopologyServiceAdapter());
        this.sd.add(CoreService.class, (Object)new TestCoreService());
        this.ws = new TestWebSocket((ServiceDirectory)this.sd);
    }

    @Test
    public void requestDetailsDevice() {
        String request = "{\"event\":\"requestDetails\", \"sid\":0, \"payload\":{\"id\":\"of:000001\",\"class\":\"device\"}}";
        this.ws.onMessage(request);
        Assert.assertEquals((String)"incorrect id", (Object)"of:000001", (Object)this.ws.reply.path("payload").path("id").asText());
        Assert.assertEquals((String)"incorrect mfr", (Object)"foo", (Object)this.ws.reply.path("payload").path("props").path("Vendor").asText());
    }

    @Test
    public void requestDetailsHost() {
        String request = "{\"event\":\"requestDetails\", \"sid\":0, \"payload\":{\"id\":\"00:00:00:00:00:19/-1\",\"class\":\"host\"}}";
        this.ws.onMessage(request);
        Assert.assertEquals((String)"incorrect id", (Object)"00:00:00:00:00:19/-1", (Object)this.ws.reply.path("payload").path("id").asText());
        Assert.assertEquals((String)"incorrect ip address", (Object)"1.2.3.4", (Object)this.ws.reply.path("payload").path("props").path("IP").asText());
    }

    private class TestHostService
    extends HostServiceAdapter {
        private TestHostService() {
        }

        public Host getHost(HostId hostId) {
            return new DefaultHost(PID, hostId, MAC, VlanId.NONE, new HostLocation(DID, PortNumber.P0, 123L), IPS, new Annotations[0]);
        }
    }

    private class TestFlowService
    extends FlowRuleServiceAdapter {
        private TestFlowService() {
        }

        public Iterable<FlowEntry> getFlowEntries(DeviceId deviceId) {
            return new ArrayList<FlowEntry>();
        }
    }

    private class TestDeviceService
    extends DeviceServiceAdapter {
        private TestDeviceService() {
        }

        public Device getDevice(DeviceId deviceId) {
            return new DefaultDevice(PID, deviceId, Device.Type.SWITCH, "foo", "hw", "sw", "sn", CHID, new Annotations[0]);
        }

        public List<Port> getPorts(DeviceId deviceId) {
            return new ArrayList<Port>();
        }
    }

    private class TestCoreService
    extends CoreServiceAdapter {
        private TestCoreService() {
        }

        public Version version() {
            return Version.version((String)"1.2.3");
        }
    }

    private class TestWebSocket
    extends TopologyViewWebSocket {
        private ObjectNode reply;

        public TestWebSocket(ServiceDirectory directory) {
            super(directory);
        }

        protected synchronized void sendMessage(ObjectNode data) {
            this.reply = data;
        }
    }
}

