/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.onlab.rest.BaseResource;
import org.onosproject.net.Device;
import org.onosproject.net.device.DeviceService;
import org.onosproject.ui.impl.DeviceTableRow;
import org.onosproject.ui.impl.RowComparator;
import org.onosproject.ui.impl.TableRow;

@Path(value="device")
public class DeviceGuiResource
extends BaseResource {
    private static final String DEVICES = "devices";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @GET
    @Produces(value={"application/json"})
    public Response getDevices(@DefaultValue(value="id") @QueryParam(value="sortCol") String colId, @DefaultValue(value="asc") @QueryParam(value="sortDir") String dir) {
        DeviceService service = (DeviceService)this.get(DeviceService.class);
        TableRow[] rows = this.generateTableRows(service);
        RowComparator rc = new RowComparator(colId, RowComparator.direction((String)dir));
        Arrays.sort(rows, rc);
        ArrayNode devices = this.generateArrayNode(rows);
        ObjectNode rootNode = MAPPER.createObjectNode();
        rootNode.set(DEVICES, (JsonNode)devices);
        return Response.ok((Object)rootNode.toString()).build();
    }

    private ArrayNode generateArrayNode(TableRow[] rows) {
        ArrayNode devices = MAPPER.createArrayNode();
        for (TableRow r : rows) {
            devices.add((JsonNode)r.toJsonNode());
        }
        return devices;
    }

    private TableRow[] generateTableRows(DeviceService service) {
        ArrayList<DeviceTableRow> list = new ArrayList<DeviceTableRow>();
        for (Device dev : service.getDevices()) {
            list.add(new DeviceTableRow(service, dev));
        }
        return list.toArray(new TableRow[list.size()]);
    }
}

