/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import org.onosproject.net.Device;
import org.onosproject.net.device.DeviceService;
import org.onosproject.ui.impl.AbstractTableRow;

public class DeviceTableRow
extends AbstractTableRow {
    private static final String ID = "id";
    private static final String AVAILABLE = "available";
    private static final String AVAILABLE_IID = "_iconid_available";
    private static final String TYPE_IID = "_iconid_type";
    private static final String DEV_ICON_PREFIX = "devIcon_";
    private static final String ROLE = "role";
    private static final String MFR = "mfr";
    private static final String HW = "hw";
    private static final String SW = "sw";
    private static final String SERIAL = "serial";
    private static final String PROTOCOL = "protocol";
    private static final String CHASSISID = "chassisid";
    private static final String[] COL_IDS = new String[]{"id", "available", "_iconid_available", "_iconid_type", "role", "mfr", "hw", "sw", "serial", "protocol", "chassisid"};
    private static final String ICON_ID_ONLINE = "deviceOnline";
    private static final String ICON_ID_OFFLINE = "deviceOffline";

    public DeviceTableRow(DeviceService service, Device d) {
        boolean available = service.isAvailable(d.id());
        String iconId = available ? ICON_ID_ONLINE : ICON_ID_OFFLINE;
        this.add(ID, d.id().toString());
        this.add(AVAILABLE, Boolean.toString(available));
        this.add(AVAILABLE_IID, iconId);
        this.add(TYPE_IID, this.getTypeIconId(d));
        this.add(ROLE, service.getRole(d.id()).toString());
        this.add(MFR, d.manufacturer());
        this.add(HW, d.hwVersion());
        this.add(SW, d.swVersion());
        this.add(SERIAL, d.serialNumber());
        this.add(PROTOCOL, d.annotations().value(PROTOCOL));
        this.add(CHASSISID, d.chassisId().toString());
    }

    private String getTypeIconId(Device d) {
        return DEV_ICON_PREFIX + d.type().toString();
    }

    protected String[] columnIds() {
        return COL_IDS;
    }
}

