/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiView;
import org.onosproject.ui.impl.AbstractInjectionResource;

@Path(value="/")
public class MainNavResource
extends AbstractInjectionResource {
    private static final String NAV_HTML = "nav.html";
    private static final String INJECT_VIEW_ITEMS_START = "<!-- {INJECTED-VIEW-NAV-START} -->";
    private static final String INJECT_VIEW_ITEMS_END = "<!-- {INJECTED-VIEW-NAV-END} -->";
    private static final String NAV_FORMAT = "<a ng-click=\"navCtrl.hideNav()\" href=\"#/%s\">%s</a>\n";

    @GET
    @Produces(value={"text/html"})
    public Response getNavigation() throws IOException {
        UiExtensionService service = (UiExtensionService)this.get(UiExtensionService.class);
        InputStream navTemplate = this.getClass().getClassLoader().getResourceAsStream(NAV_HTML);
        String js = new String(ByteStreams.toByteArray((InputStream)navTemplate));
        int p1s = this.split(js, 0, INJECT_VIEW_ITEMS_START);
        int p1e = this.split(js, 0, INJECT_VIEW_ITEMS_END);
        int p2s = this.split(js, p1e, null);
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(js, 0, p1s), (Object)this.includeNavItems(service), (Object)this.stream(js, p1e, p2s)));
        return Response.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).build();
    }

    private InputStream includeNavItems(UiExtensionService service) {
        StringBuilder sb = new StringBuilder("\n");
        for (UiExtension extension : service.getExtensions()) {
            for (UiView view : extension.views()) {
                sb.append(String.format(NAV_FORMAT, view.id(), view.label()));
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

