/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.impl.TopologyViewMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Deprecated
public abstract class TopologyViewMessages {
    protected static final Logger log = LoggerFactory.getLogger(TopologyViewMessages.class);
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core", true);
    private static final String COMPACT = "%s/%s-%s/%s";
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final String GB_UNIT = "GB";
    private static final String MB_UNIT = "MB";
    private static final String KB_UNIT = "KB";
    private static final String B_UNIT = "B";
    protected final ServiceDirectory directory;
    protected final ClusterService clusterService;
    protected final DeviceService deviceService;
    protected final LinkService linkService;
    protected final HostService hostService;
    protected final MastershipService mastershipService;
    protected final IntentService intentService;
    protected final FlowRuleService flowService;
    protected final StatisticService statService;
    protected final TopologyService topologyService;
    protected final ObjectMapper mapper = new ObjectMapper();
    private final String version;
    private static Map<String, ObjectNode> metaUi = new ConcurrentHashMap();

    static Map<String, ObjectNode> getMetaUi() {
        return Collections.unmodifiableMap(metaUi);
    }

    protected TopologyViewMessages(ServiceDirectory directory) {
        this.directory = (ServiceDirectory)Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.intentService = (IntentService)directory.get(IntentService.class);
        this.flowService = (FlowRuleService)directory.get(FlowRuleService.class);
        this.statService = (StatisticService)directory.get(StatisticService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        String ver = ((CoreService)directory.get(CoreService.class)).version().toString();
        this.version = ver.replace(".SNAPSHOT", "*").replaceFirst("~.*$", "");
    }

    protected ObjectNode payload(ObjectNode event) {
        return (ObjectNode)event.path("payload");
    }

    protected long number(ObjectNode node, String name) {
        return node.path(name).asLong();
    }

    protected String string(ObjectNode node, String name) {
        return node.path(name).asText();
    }

    protected String string(ObjectNode node, String name, String defaultValue) {
        return node.path(name).asText(defaultValue);
    }

    private String ip(Set<IpAddress> ipAddresses) {
        Iterator<IpAddress> it = ipAddresses.iterator();
        return it.hasNext() ? it.next().toString() : "unknown";
    }

    private JsonNode props(Annotations annotations) {
        ObjectNode props = this.mapper.createObjectNode();
        if (annotations != null) {
            for (String key : annotations.keys()) {
                props.put(key, annotations.value(key));
            }
        }
        return props;
    }

    protected ObjectNode info(long id, String message) {
        return this.message("info", id, message);
    }

    protected ObjectNode warning(long id, String message) {
        return this.message("warning", id, message);
    }

    protected ObjectNode error(long id, String message) {
        return this.message("error", id, message);
    }

    private ObjectNode message(String severity, long id, String message) {
        return this.envelope("message", id, this.mapper.createObjectNode().put("severity", severity).put("message", message));
    }

    protected ObjectNode envelope(String type, long sid, ObjectNode payload) {
        ObjectNode event = this.mapper.createObjectNode();
        event.put("event", type);
        if (sid > 0L) {
            event.put("sid", sid);
        }
        event.set("payload", (JsonNode)payload);
        return event;
    }

    protected Set<Host> getHosts(ArrayNode array) {
        HashSet<Host> hosts = new HashSet<Host>();
        if (array != null) {
            for (JsonNode node : array) {
                try {
                    this.addHost(hosts, HostId.hostId((String)node.asText()));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Skipping ID {}", (Object)node.asText());
                }
            }
        }
        return hosts;
    }

    private void addHost(Set<Host> hosts, HostId hostId) {
        Host host = this.hostService.getHost(hostId);
        if (host != null) {
            hosts.add(host);
        }
    }

    protected Set<Device> getDevices(ArrayNode array) {
        HashSet<Device> devices = new HashSet<Device>();
        if (array != null) {
            for (JsonNode node : array) {
                try {
                    this.addDevice(devices, DeviceId.deviceId((String)node.asText()));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Skipping ID {}", (Object)node.asText());
                }
            }
        }
        return devices;
    }

    private void addDevice(Set<Device> devices, DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null) {
            devices.add(device);
        }
    }

    protected void addHover(Set<Host> hosts, Set<Device> devices, String hover) {
        try {
            this.addHost(hosts, HostId.hostId((String)hover));
        }
        catch (IllegalArgumentException e) {
            try {
                this.addDevice(devices, DeviceId.deviceId((String)hover));
            }
            catch (IllegalArgumentException ne) {
                log.debug("Skipping ID {}", (Object)hover);
            }
        }
    }

    protected ObjectNode instanceMessage(ClusterEvent event, String messageType) {
        ControllerNode node = (ControllerNode)event.subject();
        int switchCount = this.mastershipService.getDevicesOf(node.id()).size();
        ObjectNode payload = this.mapper.createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("online", this.clusterService.getState(node.id()) == ControllerNode.State.ACTIVE).put("uiAttached", ((ControllerNode)event.subject()).equals(this.clusterService.getLocalNode())).put("switches", switchCount);
        ArrayNode labels = this.mapper.createArrayNode();
        labels.add(node.id().toString());
        labels.add(node.ip().toString());
        payload.set("labels", (JsonNode)labels);
        this.addMetaUi(node.id().toString(), payload);
        String type = messageType != null ? messageType : (event.type() == ClusterEvent.Type.INSTANCE_ADDED ? "addInstance" : (event.type() == ClusterEvent.Type.INSTANCE_REMOVED ? "removeInstance" : "addInstance"));
        return this.envelope(type, 0L, payload);
    }

    protected ObjectNode deviceMessage(DeviceEvent event) {
        Device device = (Device)event.subject();
        ObjectNode payload = this.mapper.createObjectNode().put("id", device.id().toString()).put("type", device.type().toString().toLowerCase()).put("online", this.deviceService.isAvailable(device.id())).put("master", this.master(device.id()));
        String name = device.annotations().value("name");
        ArrayNode labels = this.mapper.createArrayNode();
        labels.add("");
        labels.add(Strings.isNullOrEmpty((String)name) ? device.id().toString() : name);
        labels.add(device.id().toString());
        payload.set("labels", (JsonNode)labels);
        payload.set("props", this.props(device.annotations()));
        this.addGeoLocation((Annotated)device, payload);
        this.addMetaUi(device.id().toString(), payload);
        String type = event.type() == DeviceEvent.Type.DEVICE_ADDED ? "addDevice" : (event.type() == DeviceEvent.Type.DEVICE_REMOVED ? "removeDevice" : "updateDevice");
        return this.envelope(type, 0L, payload);
    }

    protected ObjectNode linkMessage(LinkEvent event) {
        Link link = (Link)event.subject();
        ObjectNode payload = this.mapper.createObjectNode().put("id", TopologyViewMessages.compactLinkString((Link)link)).put("type", link.type().toString().toLowerCase()).put("online", link.state() == Link.State.ACTIVE).put("linkWidth", 1.2).put("src", link.src().deviceId().toString()).put("srcPort", link.src().port().toString()).put("dst", link.dst().deviceId().toString()).put("dstPort", link.dst().port().toString());
        String type = event.type() == LinkEvent.Type.LINK_ADDED ? "addLink" : (event.type() == LinkEvent.Type.LINK_REMOVED ? "removeLink" : "updateLink");
        return this.envelope(type, 0L, payload);
    }

    protected ObjectNode hostMessage(HostEvent event) {
        Host host = (Host)event.subject();
        String hostType = host.annotations().value("type");
        ObjectNode payload = this.mapper.createObjectNode().put("id", host.id().toString()).put("type", Strings.isNullOrEmpty((String)hostType) ? "endstation" : hostType).put("ingress", TopologyViewMessages.compactLinkString((Link)this.edgeLink(host, true))).put("egress", TopologyViewMessages.compactLinkString((Link)this.edgeLink(host, false)));
        payload.set("cp", (JsonNode)this.hostConnect(this.mapper, host.location()));
        payload.set("labels", (JsonNode)this.labels(this.mapper, new String[]{this.ip(host.ipAddresses()), host.mac().toString()}));
        payload.set("props", this.props(host.annotations()));
        this.addGeoLocation((Annotated)host, payload);
        this.addMetaUi(host.id().toString(), payload);
        String type = event.type() == HostEvent.Type.HOST_ADDED ? "addHost" : (event.type() == HostEvent.Type.HOST_REMOVED ? "removeHost" : "updateHost");
        return this.envelope(type, 0L, payload);
    }

    private ObjectNode hostConnect(ObjectMapper mapper, HostLocation location) {
        return mapper.createObjectNode().put("device", location.deviceId().toString()).put("port", location.port().toLong());
    }

    private ArrayNode labels(ObjectMapper mapper, String ... labels) {
        ArrayNode json = mapper.createArrayNode();
        for (String label : labels) {
            json.add(label);
        }
        return json;
    }

    private String master(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        return master != null ? master.toString() : "";
    }

    private EdgeLink edgeLink(Host host, boolean ingress) {
        return new DefaultEdgeLink(PID, new ConnectPoint((ElementId)host.id(), PortNumber.portNumber((long)0L)), host.location(), ingress, new Annotations[0]);
    }

    private void addMetaUi(String id, ObjectNode payload) {
        ObjectNode meta = (ObjectNode)metaUi.get(id);
        if (meta != null) {
            payload.set("metaUi", (JsonNode)meta);
        }
    }

    private void addGeoLocation(Annotated annotated, ObjectNode payload) {
        Annotations annotations = annotated.annotations();
        if (annotations == null) {
            return;
        }
        String slat = annotations.value("latitude");
        String slng = annotations.value("longitude");
        try {
            if (slat != null && slng != null && !slat.isEmpty() && !slng.isEmpty()) {
                double lat = Double.parseDouble(slat);
                double lng = Double.parseDouble(slng);
                ObjectNode loc = this.mapper.createObjectNode().put("type", "latlng").put("lat", lat).put("lng", lng);
                payload.set("location", (JsonNode)loc);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid geo data latitude={}; longiture={}", (Object)slat, (Object)slng);
        }
    }

    protected void updateMetaUi(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        metaUi.put(this.string(payload, "id"), (ObjectNode)payload.path("memento"));
    }

    protected ObjectNode summmaryMessage(long sid) {
        Topology topology = this.topologyService.currentTopology();
        return this.envelope("showSummary", sid, this.json("ONOS Summary", "node", new Prop[]{new Prop(this, "Devices", this.format((Number)topology.deviceCount())), new Prop(this, "Links", this.format((Number)topology.linkCount())), new Prop(this, "Hosts", this.format((Number)this.hostService.getHostCount())), new Prop(this, "Topology SCCs", this.format((Number)topology.clusterCount())), new Separator(this), new Prop(this, "Intents", this.format((Number)this.intentService.getIntentCount())), new Prop(this, "Flows", this.format((Number)this.flowService.getFlowRuleCount())), new Prop(this, "Version", this.version)}));
    }

    protected ObjectNode deviceDetails(DeviceId deviceId, long sid) {
        Device device = this.deviceService.getDevice(deviceId);
        Annotations annot = device.annotations();
        String name = annot.value("name");
        int portCount = this.deviceService.getPorts(deviceId).size();
        int flowCount = this.getFlowCount(deviceId);
        return this.envelope("showDetails", sid, this.json(Strings.isNullOrEmpty((String)name) ? deviceId.toString() : name, device.type().toString().toLowerCase(), new Prop[]{new Prop(this, "URI", deviceId.toString()), new Prop(this, "Vendor", device.manufacturer()), new Prop(this, "H/W Version", device.hwVersion()), new Prop(this, "S/W Version", device.swVersion()), new Prop(this, "Serial Number", device.serialNumber()), new Prop(this, "Protocol", annot.value("protocol")), new Separator(this), new Prop(this, "Master", this.master(deviceId)), new Prop(this, "Latitude", annot.value("latitude")), new Prop(this, "Longitude", annot.value("longitude")), new Separator(this), new Prop(this, "Ports", Integer.toString(portCount)), new Prop(this, "Flows", Integer.toString(flowCount))}));
    }

    protected int getFlowCount(DeviceId deviceId) {
        int count = 0;
        Iterator it = this.flowService.getFlowEntries(deviceId).iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    protected Map<Link, Integer> getFlowCounts(DeviceId deviceId) {
        ArrayList entries = new ArrayList();
        HashSet<DefaultEdgeLink> links = new HashSet<DefaultEdgeLink>(this.linkService.getDeviceEgressLinks(deviceId));
        Set hosts = this.hostService.getConnectedHosts(deviceId);
        Iterator it = this.flowService.getFlowEntries(deviceId).iterator();
        while (it.hasNext()) {
            entries.add(it.next());
        }
        if (hosts != null) {
            for (Host host : hosts) {
                links.add(new DefaultEdgeLink(host.providerId(), new ConnectPoint((ElementId)host.id(), PortNumber.P0), host.location(), false, new Annotations[0]));
            }
        }
        HashMap<Link, Integer> counts = new HashMap<Link, Integer>();
        for (Link link : links) {
            counts.put(link, this.getEgressFlows(link, entries));
        }
        return counts;
    }

    private Integer getEgressFlows(Link link, List<FlowEntry> entries) {
        int count = 0;
        PortNumber out = link.src().port();
        for (FlowEntry entry : entries) {
            TrafficTreatment treatment = entry.treatment();
            for (Instruction instruction : treatment.instructions()) {
                if (instruction.type() != Instruction.Type.OUTPUT || !((Instructions.OutputInstruction)instruction).port().equals((Object)out)) continue;
                ++count;
            }
        }
        return count;
    }

    protected ObjectNode hostDetails(HostId hostId, long sid) {
        Host host = this.hostService.getHost(hostId);
        Annotations annot = host.annotations();
        String type = annot.value("type");
        String name = annot.value("name");
        String vlan = host.vlan().toString();
        return this.envelope("showDetails", sid, this.json(Strings.isNullOrEmpty((String)name) ? hostId.toString() : name, Strings.isNullOrEmpty((String)type) ? "endstation" : type, new Prop[]{new Prop(this, "MAC", host.mac().toString()), new Prop(this, "IP", host.ipAddresses().toString().replaceAll("[\\[\\]]", "")), new Prop(this, "VLAN", vlan.equals("-1") ? "none" : vlan), new Separator(this), new Prop(this, "Latitude", annot.value("latitude")), new Prop(this, "Longitude", annot.value("longitude"))}));
    }

    protected ObjectNode trafficSummaryMessage(long sid) {
        ObjectNode payload = this.mapper.createObjectNode();
        ArrayNode paths = this.mapper.createArrayNode();
        payload.set("paths", (JsonNode)paths);
        ObjectNode pathNodeN = this.mapper.createObjectNode();
        ArrayNode linksNodeN = this.mapper.createArrayNode();
        ArrayNode labelsN = this.mapper.createArrayNode();
        pathNodeN.put("class", "plain").put("traffic", false);
        pathNodeN.set("links", (JsonNode)linksNodeN);
        pathNodeN.set("labels", (JsonNode)labelsN);
        paths.add((JsonNode)pathNodeN);
        ObjectNode pathNodeT = this.mapper.createObjectNode();
        ArrayNode linksNodeT = this.mapper.createArrayNode();
        ArrayNode labelsT = this.mapper.createArrayNode();
        pathNodeT.put("class", "secondary").put("traffic", true);
        pathNodeT.set("links", (JsonNode)linksNodeT);
        pathNodeT.set("labels", (JsonNode)labelsT);
        paths.add((JsonNode)pathNodeT);
        for (BiLink link : this.consolidateLinks(this.linkService.getLinks())) {
            boolean bi;
            boolean bl = bi = link.two != null;
            if (!this.isInfrastructureEgress(link.one) && (!bi || !this.isInfrastructureEgress(link.two))) continue;
            link.addLoad(this.statService.load(link.one));
            link.addLoad(bi ? this.statService.load(link.two) : null);
            if (link.hasTraffic) {
                linksNodeT.add(TopologyViewMessages.compactLinkString((Link)link.one));
                labelsT.add(this.formatBytes(link.bytes));
                continue;
            }
            linksNodeN.add(TopologyViewMessages.compactLinkString((Link)link.one));
            labelsN.add("");
        }
        return this.envelope("showTraffic", sid, payload);
    }

    private Collection<BiLink> consolidateLinks(Iterable<Link> links) {
        HashMap biLinks = new HashMap();
        for (Link link : links) {
            this.addLink(biLinks, link);
        }
        return biLinks.values();
    }

    protected ObjectNode flowSummaryMessage(long sid, Set<Device> devices) {
        ObjectNode payload = this.mapper.createObjectNode();
        ArrayNode paths = this.mapper.createArrayNode();
        payload.set("paths", (JsonNode)paths);
        for (Device device : devices) {
            Map counts = this.getFlowCounts(device.id());
            for (Link link : counts.keySet()) {
                this.addLinkFlows(link, paths, (Integer)counts.get(link));
            }
        }
        return this.envelope("showTraffic", sid, payload);
    }

    private void addLinkFlows(Link link, ArrayNode paths, Integer count) {
        ObjectNode pathNode = this.mapper.createObjectNode();
        ArrayNode linksNode = this.mapper.createArrayNode();
        ArrayNode labels = this.mapper.createArrayNode();
        boolean noFlows = count == null || count == 0;
        pathNode.put("class", noFlows ? "secondary" : "primary");
        pathNode.put("traffic", false);
        pathNode.set("links", (JsonNode)linksNode.add(TopologyViewMessages.compactLinkString((Link)link)));
        pathNode.set("labels", (JsonNode)labels.add(noFlows ? "" : count.toString() + (count == 1 ? " flow" : " flows")));
        paths.add((JsonNode)pathNode);
    }

    protected ObjectNode trafficMessage(long sid, TrafficClass ... trafficClasses) {
        ObjectNode payload = this.mapper.createObjectNode();
        ArrayNode paths = this.mapper.createArrayNode();
        payload.set("paths", (JsonNode)paths);
        Map biLinks = this.classifyLinkTraffic(trafficClasses);
        HashMap<String, ObjectNode> pathNodes = new HashMap<String, ObjectNode>();
        for (BiLink biLink : biLinks.values()) {
            boolean hasTraffic = biLink.hasTraffic;
            String tc = (biLink.classes + (hasTraffic ? " animated" : "")).trim();
            ObjectNode pathNode = (ObjectNode)pathNodes.get(tc);
            if (pathNode == null) {
                pathNode = this.mapper.createObjectNode().put("class", tc).put("traffic", hasTraffic);
                pathNode.set("links", (JsonNode)this.mapper.createArrayNode());
                pathNode.set("labels", (JsonNode)this.mapper.createArrayNode());
                pathNodes.put(tc, pathNode);
                paths.add((JsonNode)pathNode);
            }
            ((ArrayNode)pathNode.path("links")).add(TopologyViewMessages.compactLinkString((Link)biLink.one));
            ((ArrayNode)pathNode.path("labels")).add(hasTraffic ? this.formatBytes(biLink.bytes) : "");
        }
        return this.envelope("showTraffic", sid, payload);
    }

    private Map<LinkKey, BiLink> classifyLinkTraffic(TrafficClass ... trafficClasses) {
        HashMap<LinkKey, BiLink> biLinks = new HashMap<LinkKey, BiLink>();
        for (TrafficClass trafficClass : trafficClasses) {
            for (Intent intent : trafficClass.intents) {
                boolean isOptical = intent instanceof OpticalConnectivityIntent;
                List installables = this.intentService.getInstallableIntents(intent.key());
                if (installables == null) continue;
                for (Intent installable : installables) {
                    String type;
                    String string = type = isOptical ? trafficClass.type + " optical" : trafficClass.type;
                    if (installable instanceof PathIntent) {
                        this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((PathIntent)installable).path().links());
                        continue;
                    }
                    if (installable instanceof LinkCollectionIntent) {
                        this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((LinkCollectionIntent)installable).links());
                        continue;
                    }
                    if (!(installable instanceof OpticalPathIntent)) continue;
                    this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((OpticalPathIntent)installable).path().links());
                }
            }
        }
        return biLinks;
    }

    private void classifyLinks(String type, Map<LinkKey, BiLink> biLinks, boolean showTraffic, Iterable<Link> links) {
        if (links != null) {
            for (Link link : links) {
                BiLink biLink = this.addLink(biLinks, link);
                if (!this.isInfrastructureEgress(link)) continue;
                if (showTraffic) {
                    biLink.addLoad(this.statService.load(link));
                }
                biLink.addClass(type);
            }
        }
    }

    private BiLink addLink(Map<LinkKey, BiLink> biLinks, Link link) {
        LinkKey key = this.canonicalLinkKey(link);
        BiLink biLink = biLinks.get(key);
        if (biLink != null) {
            biLink.setOther(link);
        } else {
            biLink = new BiLink(this, key, link);
            biLinks.put(key, biLink);
        }
        return biLink;
    }

    protected void addPathTraffic(ArrayNode paths, String type, String trafficType, Iterable<Link> links) {
        ObjectNode pathNode = this.mapper.createObjectNode();
        ArrayNode linksNode = this.mapper.createArrayNode();
        if (links != null) {
            ArrayNode labels = this.mapper.createArrayNode();
            boolean hasTraffic = false;
            for (Link link : links) {
                if (!this.isInfrastructureEgress(link)) continue;
                linksNode.add(TopologyViewMessages.compactLinkString((Link)link));
                Load load = this.statService.load(link);
                String label = "";
                if (load.rate() > 0L) {
                    hasTraffic = true;
                    label = this.formatBytes(load.latest());
                }
                labels.add(label);
            }
            pathNode.put("class", hasTraffic ? type + " " + trafficType : type);
            pathNode.put("traffic", hasTraffic);
            pathNode.set("links", (JsonNode)linksNode);
            pathNode.set("labels", (JsonNode)labels);
            paths.add((JsonNode)pathNode);
        }
    }

    private String formatBytes(long bytes) {
        String unit;
        double value;
        if ((double)bytes > 1.073741824E9) {
            value = (double)bytes / 1.073741824E9;
            unit = "GB";
        } else if ((double)bytes > 1048576.0) {
            value = (double)bytes / 1048576.0;
            unit = "MB";
        } else if ((double)bytes > 1024.0) {
            value = (double)bytes / 1024.0;
            unit = "KB";
        } else {
            value = bytes;
            unit = "B";
        }
        DecimalFormat format = new DecimalFormat("#,###.##");
        return format.format(value) + " " + unit;
    }

    private String format(Number number) {
        DecimalFormat format = new DecimalFormat("#,###");
        return format.format(number);
    }

    private boolean isInfrastructureEgress(Link link) {
        return link.src().elementId() instanceof DeviceId;
    }

    private static String compactLinkString(Link link) {
        return String.format("%s/%s-%s/%s", link.src().elementId(), link.src().port(), link.dst().elementId(), link.dst().port());
    }

    private ObjectNode json(String id, String type, Prop ... props) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode().put("id", id).put("type", type);
        ObjectNode pnode = mapper.createObjectNode();
        ArrayNode porder = mapper.createArrayNode();
        for (Prop p : props) {
            porder.add(p.key);
            pnode.put(p.key, p.value);
        }
        result.set("propOrder", (JsonNode)porder);
        result.set("props", (JsonNode)pnode);
        return result;
    }

    private LinkKey canonicalLinkKey(Link link) {
        String dn;
        String sn = link.src().elementId().toString();
        return sn.compareTo(dn = link.dst().elementId().toString()) < 0 ? LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()) : LinkKey.linkKey((ConnectPoint)link.dst(), (ConnectPoint)link.src());
    }
}

