/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jetty.websocket.WebSocket;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Accumulator;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipAdminService;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.ui.impl.TopologyViewIntentFilter;
import org.onosproject.ui.impl.TopologyViewMessages;
import org.onosproject.ui.impl.TopologyViewWebSocket;

@Deprecated
public class TopologyViewWebSocket
extends TopologyViewMessages
implements WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final long MAX_AGE_MS = 15000L;
    private static final byte PING = 9;
    private static final byte PONG = 10;
    private static final byte[] PING_DATA = new byte[]{-34, -83};
    private static final String APP_ID = "org.onosproject.gui";
    private static final long TRAFFIC_FREQUENCY = 5000L;
    private static final long SUMMARY_FREQUENCY = 30000L;
    private static final Comparator<? super ControllerNode> NODE_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    private final Timer timer = new Timer("topology-view");
    private static final int MAX_EVENTS = 1000;
    private static final int MAX_BATCH_MS = 5000;
    private static final int MAX_IDLE_MS = 1000;
    private final ApplicationId appId;
    private WebSocket.Connection connection;
    private WebSocket.FrameConnection control;
    private final ClusterEventListener clusterListener = new InternalClusterListener(this, null);
    private final MastershipListener mastershipListener = new InternalMastershipListener(this, null);
    private final DeviceListener deviceListener = new InternalDeviceListener(this, null);
    private final LinkListener linkListener = new InternalLinkListener(this, null);
    private final HostListener hostListener = new InternalHostListener(this, null);
    private final IntentListener intentListener = new InternalIntentListener(this, null);
    private final FlowRuleListener flowListener = new InternalFlowListener(this, null);
    private final Accumulator<Event> eventAccummulator = new InternalEventAccummulator(this);
    private TimerTask trafficTask;
    private ObjectNode trafficEvent;
    private TimerTask summaryTask;
    private ObjectNode summaryEvent;
    private long lastActive = System.currentTimeMillis();
    private boolean listenersRemoved = false;
    private TopologyViewIntentFilter intentFilter = new TopologyViewIntentFilter(this.intentService, this.deviceService, this.hostService, this.linkService);
    private Set<Host> selectedHosts;
    private Set<Device> selectedDevices;
    private List<Intent> selectedIntents;
    private int currentIntentIndex = -1;

    public TopologyViewWebSocket(ServiceDirectory directory) {
        super(directory);
        this.appId = ((CoreService)directory.get(CoreService.class)).registerApplication(APP_ID);
    }

    synchronized void close() {
        this.removeListeners();
        if (this.connection.isOpen()) {
            this.connection.close();
        }
    }

    synchronized boolean isIdle() {
        boolean idle;
        boolean bl = idle = System.currentTimeMillis() - this.lastActive > 15000L;
        if (idle || this.connection != null && !this.connection.isOpen()) {
            return true;
        }
        if (this.connection != null) {
            try {
                this.control.sendControl((byte)9, PING_DATA, 0, PING_DATA.length);
            }
            catch (IOException e) {
                log.warn("Unable to send ping message due to: ", (Throwable)e);
            }
        }
        return false;
    }

    public void onOpen(WebSocket.Connection connection) {
        log.info("GUI client connected");
        this.connection = connection;
        this.control = (WebSocket.FrameConnection)connection;
        this.addListeners();
        this.sendAllInstances(null);
        this.sendAllDevices();
        this.sendAllLinks();
        this.sendAllHosts();
    }

    public synchronized void onClose(int closeCode, String message) {
        this.removeListeners();
        this.timer.cancel();
        log.info("GUI client disconnected");
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        this.lastActive = System.currentTimeMillis();
        return true;
    }

    public void onMessage(String data) {
        this.lastActive = System.currentTimeMillis();
        try {
            this.processMessage((ObjectNode)this.mapper.reader().readTree(data));
        }
        catch (Exception e) {
            log.warn("Unable to parse GUI request {} due to {}", (Object)data, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    private void processMessage(ObjectNode event) {
        String type = this.string(event, "event", "unknown");
        if (type.equals("requestDetails")) {
            this.requestDetails(event);
        } else if (type.equals("updateMeta")) {
            this.updateMetaUi(event);
        } else if (type.equals("addHostIntent")) {
            this.createHostIntent(event);
        } else if (type.equals("addMultiSourceIntent")) {
            this.createMultiSourceIntent(event);
        } else if (type.equals("requestRelatedIntents")) {
            this.stopTrafficMonitoring();
            this.requestRelatedIntents(event);
        } else if (type.equals("requestNextRelatedIntent")) {
            this.stopTrafficMonitoring();
            this.requestAnotherRelatedIntent(event, 1);
        } else if (type.equals("requestPrevRelatedIntent")) {
            this.stopTrafficMonitoring();
            this.requestAnotherRelatedIntent(event, -1);
        } else if (type.equals("requestSelectedIntentTraffic")) {
            this.requestSelectedIntentTraffic(event);
            this.startTrafficMonitoring(event);
        } else if (type.equals("requestAllTraffic")) {
            this.requestAllTraffic(event);
            this.startTrafficMonitoring(event);
        } else if (type.equals("requestDeviceLinkFlows")) {
            this.requestDeviceLinkFlows(event);
            this.startTrafficMonitoring(event);
        } else if (type.equals("cancelTraffic")) {
            this.cancelTraffic(event);
        } else if (type.equals("requestSummary")) {
            this.requestSummary(event);
            this.startSummaryMonitoring(event);
        } else if (type.equals("cancelSummary")) {
            this.stopSummaryMonitoring();
        } else if (type.equals("equalizeMasters")) {
            this.equalizeMasters(event);
        }
    }

    protected synchronized void sendMessage(ObjectNode data) {
        try {
            if (this.connection.isOpen()) {
                this.connection.sendMessage(data.toString());
            }
        }
        catch (IOException e) {
            log.warn("Unable to send message {} to GUI due to {}", (Object)data, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    private void sendAllInstances(String messageType) {
        ArrayList nodes = new ArrayList(this.clusterService.getNodes());
        Collections.sort(nodes, NODE_COMPARATOR);
        for (ControllerNode node : nodes) {
            this.sendMessage(this.instanceMessage(new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node), messageType));
        }
    }

    private void sendAllDevices() {
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() != Device.Type.ROADM) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() == Device.Type.ROADM) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
    }

    private void sendAllLinks() {
        for (Link link : this.linkService.getLinks()) {
            if (link.type() != Link.Type.OPTICAL) continue;
            this.sendMessage(this.linkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
        for (Link link : this.linkService.getLinks()) {
            if (link.type() == Link.Type.OPTICAL) continue;
            this.sendMessage(this.linkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
    }

    private void sendAllHosts() {
        for (Host host : this.hostService.getHosts()) {
            this.sendMessage(this.hostMessage(new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        }
    }

    private void requestDetails(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        String type = this.string(payload, "class", "unknown");
        long sid = this.number(event, "sid");
        if (type.equals("device")) {
            this.sendMessage(this.deviceDetails(DeviceId.deviceId((String)this.string(payload, "id")), sid));
        } else if (type.equals("host")) {
            this.sendMessage(this.hostDetails(HostId.hostId((String)this.string(payload, "id")), sid));
        }
    }

    private void createHostIntent(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        long id = this.number(event, "sid");
        HostId one = HostId.hostId((String)this.string(payload, "one"));
        HostId two = HostId.hostId((String)this.string(payload, "two"));
        HostToHostIntent intent = new HostToHostIntent(this.appId, one, two, DefaultTrafficSelector.emptySelector(), DefaultTrafficTreatment.emptyTreatment());
        this.intentService.submit((Intent)intent);
        this.startMonitoringIntent(event, (Intent)intent);
    }

    private void createMultiSourceIntent(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        long id = this.number(event, "sid");
        Set src = this.getHostIds((ArrayNode)payload.path("src"));
        HostId dst = HostId.hostId((String)this.string(payload, "dst"));
        Host dstHost = this.hostService.getHost(dst);
        Set ingressPoints = this.getHostLocations(src);
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthDst(dstHost.mac()).build();
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        MultiPointToSinglePointIntent intent = new MultiPointToSinglePointIntent(this.appId, selector, treatment, ingressPoints, (ConnectPoint)dstHost.location());
        this.intentService.submit((Intent)intent);
        this.startMonitoringIntent(event, (Intent)intent);
    }

    private synchronized void startMonitoringIntent(ObjectNode event, Intent intent) {
        this.selectedHosts = new HashSet();
        this.selectedDevices = new HashSet();
        this.selectedIntents = new ArrayList();
        this.selectedIntents.add(intent);
        this.currentIntentIndex = -1;
        this.requestAnotherRelatedIntent(event, 1);
        this.requestSelectedIntentTraffic(event);
    }

    private Set<ConnectPoint> getHostLocations(Set<HostId> hostIds) {
        HashSet<ConnectPoint> points = new HashSet<ConnectPoint>();
        for (HostId hostId : hostIds) {
            points.add((ConnectPoint)this.getHostLocation(hostId));
        }
        return points;
    }

    private HostLocation getHostLocation(HostId hostId) {
        return this.hostService.getHost(hostId).location();
    }

    private Set<HostId> getHostIds(ArrayNode ids) {
        HashSet<HostId> hostIds = new HashSet<HostId>();
        for (JsonNode id : ids) {
            hostIds.add(HostId.hostId((String)id.asText()));
        }
        return hostIds;
    }

    private synchronized long startTrafficMonitoring(ObjectNode event) {
        this.stopTrafficMonitoring();
        this.trafficEvent = event;
        this.trafficTask = new TrafficMonitor(this, null);
        this.timer.schedule(this.trafficTask, 5000L, 5000L);
        return this.number(event, "sid");
    }

    private synchronized void stopTrafficMonitoring() {
        if (this.trafficTask != null) {
            this.trafficTask.cancel();
            this.trafficTask = null;
            this.trafficEvent = null;
        }
    }

    private synchronized void requestAllTraffic(ObjectNode event) {
        long sid = this.startTrafficMonitoring(event);
        this.sendMessage(this.trafficSummaryMessage(sid));
    }

    private void requestDeviceLinkFlows(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        long sid = this.startTrafficMonitoring(event);
        ArrayNode ids = (ArrayNode)payload.path("ids");
        HashSet hosts = new HashSet();
        Set devices = this.getDevices(ids);
        String hover = this.string(payload, "hover");
        if (!Strings.isNullOrEmpty((String)hover)) {
            this.addHover(hosts, devices, hover);
        }
        this.sendMessage(this.flowSummaryMessage(sid, devices));
    }

    private synchronized void requestRelatedIntents(ObjectNode event) {
        ObjectNode payload = this.payload(event);
        if (!payload.has("ids")) {
            return;
        }
        long sid = this.number(event, "sid");
        this.stopTrafficMonitoring();
        ArrayNode ids = (ArrayNode)payload.path("ids");
        this.selectedHosts = this.getHosts(ids);
        this.selectedDevices = this.getDevices(ids);
        this.selectedIntents = this.intentFilter.findPathIntents(this.selectedHosts, this.selectedDevices, this.intentService.getIntents());
        this.currentIntentIndex = -1;
        if (this.haveSelectedIntents()) {
            this.sendMessage(this.trafficMessage(sid, new TopologyViewMessages.TrafficClass[]{new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "primary", (Iterable)this.selectedIntents)}));
        }
    }

    private boolean haveSelectedIntents() {
        return this.selectedIntents != null && !this.selectedIntents.isEmpty();
    }

    private void processHoverExtendedSelection(long sid, String hover) {
        HashSet hoverSelHosts = new HashSet(this.selectedHosts);
        HashSet hoverSelDevices = new HashSet(this.selectedDevices);
        this.addHover(hoverSelHosts, hoverSelDevices, hover);
        ArrayList primary = this.selectedIntents == null ? new ArrayList() : this.intentFilter.findPathIntents(hoverSelHosts, hoverSelDevices, (Iterable)this.selectedIntents);
        HashSet secondary = new HashSet(this.selectedIntents);
        secondary.removeAll(primary);
        this.sendMessage(this.trafficMessage(sid, new TopologyViewMessages.TrafficClass[]{new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "primary", primary), new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "secondary", secondary)}));
    }

    private void requestAnotherRelatedIntent(ObjectNode event, int offset) {
        if (this.haveSelectedIntents()) {
            this.currentIntentIndex += offset;
            if (this.currentIntentIndex < 0) {
                this.currentIntentIndex = this.selectedIntents.size() - 1;
            } else if (this.currentIntentIndex >= this.selectedIntents.size()) {
                this.currentIntentIndex = 0;
            }
            this.sendSelectedIntent(event);
        }
    }

    private void sendSelectedIntent(ObjectNode event) {
        Intent selectedIntent = (Intent)this.selectedIntents.get(this.currentIntentIndex);
        log.info("Requested next intent {}", (Object)selectedIntent.id());
        HashSet<Intent> primary = new HashSet<Intent>();
        primary.add(selectedIntent);
        HashSet secondary = new HashSet(this.selectedIntents);
        secondary.remove(selectedIntent);
        this.sendMessage(this.trafficMessage(this.number(event, "sid"), new TopologyViewMessages.TrafficClass[]{new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "primary", primary), new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "secondary", secondary)}));
    }

    private void requestSelectedIntentTraffic(ObjectNode event) {
        if (this.haveSelectedIntents()) {
            if (this.currentIntentIndex < 0) {
                this.currentIntentIndex = 0;
            }
            Intent selectedIntent = (Intent)this.selectedIntents.get(this.currentIntentIndex);
            log.info("Requested traffic for selected {}", (Object)selectedIntent.id());
            HashSet<Intent> primary = new HashSet<Intent>();
            primary.add(selectedIntent);
            this.sendMessage(this.trafficMessage(this.number(event, "sid"), new TopologyViewMessages.TrafficClass[]{new TopologyViewMessages.TrafficClass((TopologyViewMessages)this, "primary", primary, true)}));
        }
    }

    private void cancelTraffic(ObjectNode event) {
        this.selectedIntents = null;
        this.sendMessage(this.trafficMessage(this.number(event, "sid"), new TopologyViewMessages.TrafficClass[0]));
        this.stopTrafficMonitoring();
    }

    private synchronized long startSummaryMonitoring(ObjectNode event) {
        this.stopSummaryMonitoring();
        this.summaryEvent = event;
        this.summaryTask = new SummaryMonitor(this, null);
        this.timer.schedule(this.summaryTask, 30000L, 30000L);
        return this.number(event, "sid");
    }

    private synchronized void stopSummaryMonitoring() {
        if (this.summaryEvent != null) {
            this.summaryTask.cancel();
            this.summaryTask = null;
            this.summaryEvent = null;
        }
    }

    private synchronized void requestSummary(ObjectNode event) {
        this.sendMessage(this.summmaryMessage(this.number(event, "sid")));
    }

    private void equalizeMasters(ObjectNode event) {
        ((MastershipAdminService)this.directory.get(MastershipAdminService.class)).balanceRoles();
    }

    private void addListeners() {
        this.clusterService.addListener(this.clusterListener);
        this.mastershipService.addListener(this.mastershipListener);
        this.deviceService.addListener(this.deviceListener);
        this.linkService.addListener(this.linkListener);
        this.hostService.addListener(this.hostListener);
        this.intentService.addListener(this.intentListener);
        this.flowService.addListener(this.flowListener);
    }

    private synchronized void removeListeners() {
        if (!this.listenersRemoved) {
            this.listenersRemoved = true;
            this.clusterService.removeListener(this.clusterListener);
            this.mastershipService.removeListener(this.mastershipListener);
            this.deviceService.removeListener(this.deviceListener);
            this.linkService.removeListener(this.linkListener);
            this.hostService.removeListener(this.hostListener);
            this.intentService.removeListener(this.intentListener);
            this.flowService.removeListener(this.flowListener);
        }
    }

    static /* synthetic */ void access$900(TopologyViewWebSocket x0, String x1) {
        x0.sendAllInstances(x1);
    }

    static /* synthetic */ Accumulator access$1000(TopologyViewWebSocket x0) {
        return x0.eventAccummulator;
    }

    static /* synthetic */ ObjectNode access$1100(TopologyViewWebSocket x0) {
        return x0.trafficEvent;
    }

    static /* synthetic */ void access$1200(TopologyViewWebSocket x0, ObjectNode x1) {
        x0.requestSelectedIntentTraffic(x1);
    }

    static /* synthetic */ void access$1300(TopologyViewWebSocket x0, ObjectNode x1) {
        x0.requestAllTraffic(x1);
    }

    static /* synthetic */ void access$1400(TopologyViewWebSocket x0, ObjectNode x1) {
        x0.requestDeviceLinkFlows(x1);
    }

    static /* synthetic */ ObjectNode access$1500(TopologyViewWebSocket x0) {
        return x0.summaryEvent;
    }

    static /* synthetic */ void access$1600(TopologyViewWebSocket x0, ObjectNode x1) {
        x0.requestSummary(x1);
    }
}

