/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class UiExtensionManager
implements UiExtensionService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<UiExtension> extensions = Lists.newArrayList();
    private final Map<String, UiExtension> views = Maps.newHashMap();
    private final UiExtension core = UiExtensionManager.createCoreExtension();

    private static UiExtension createCoreExtension() {
        ImmutableList coreViews = ImmutableList.of((Object)new UiView("topo", "Topology View"), (Object)new UiView("device", "Devices"), (Object)new UiView("sample", "Sample"));
        UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)new TopologyViewMessageHandler());
        return new UiExtension((List)coreViews, messageHandlerFactory, "core", UiExtensionManager.class.getClassLoader());
    }

    @Activate
    public void activate() {
        this.register(this.core);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.unregister(this.core);
        this.log.info("Stopped");
    }

    public synchronized void register(UiExtension extension) {
        if (!this.extensions.contains(extension)) {
            this.extensions.add(extension);
            for (UiView view : extension.views()) {
                this.views.put(view.id(), extension);
            }
        }
    }

    public synchronized void unregister(UiExtension extension) {
        this.extensions.remove(extension);
        extension.views().stream().map(UiView::id).collect(Collectors.toSet()).forEach(this.views::remove);
    }

    public synchronized List<UiExtension> getExtensions() {
        return ImmutableList.copyOf((Collection)this.extensions);
    }

    public synchronized UiExtension getViewExtension(String viewId) {
        return (UiExtension)this.views.get(viewId);
    }
}

