/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.util.Accumulator;
import org.onlab.util.Tools;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterEventListener;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.mastership.MastershipListener;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.flow.FlowRuleListener;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.impl.TopologyViewIntentFilter;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.TopologyViewMessageHandlerBase;

public class TopologyViewMessageHandler
extends TopologyViewMessageHandlerBase {
    private static final String REQ_DETAILS = "requestDetails";
    private static final String UPDATE_META = "updateMeta";
    private static final String ADD_HOST_INTENT = "addHostIntent";
    private static final String ADD_MULTI_SRC_INTENT = "addMultiSourceIntent";
    private static final String REQ_RELATED_INTENTS = "requestRelatedIntents";
    private static final String REQ_NEXT_INTENT = "requestNextRelatedIntent";
    private static final String REQ_PREV_INTENT = "requestPrevRelatedIntent";
    private static final String REQ_SEL_INTENT_TRAFFIC = "requestSelectedIntentTraffic";
    private static final String REQ_ALL_FLOW_TRAFFIC = "requestAllFlowTraffic";
    private static final String REQ_ALL_PORT_TRAFFIC = "requestAllPortTraffic";
    private static final String REQ_DEV_LINK_FLOWS = "requestDeviceLinkFlows";
    private static final String CANCEL_TRAFFIC = "cancelTraffic";
    private static final String REQ_SUMMARY = "requestSummary";
    private static final String CANCEL_SUMMARY = "cancelSummary";
    private static final String EQ_MASTERS = "equalizeMasters";
    private static final String SPRITE_LIST_REQ = "spriteListRequest";
    private static final String SPRITE_DATA_REQ = "spriteDataRequest";
    private static final String TOPO_START = "topoStart";
    private static final String TOPO_HEARTBEAT = "topoHeartbeat";
    private static final String TOPO_STOP = "topoStop";
    private static final String APP_ID = "org.onosproject.gui";
    private static final long TRAFFIC_FREQUENCY = 5000L;
    private static final long SUMMARY_FREQUENCY = 30000L;
    private static final Comparator<? super ControllerNode> NODE_COMPARATOR = (o1, o2) -> o1.id().toString().compareTo(o2.id().toString());
    private final Timer timer = new Timer("onos-topology-view");
    private static final int MAX_EVENTS = 1000;
    private static final int MAX_BATCH_MS = 5000;
    private static final int MAX_IDLE_MS = 1000;
    private ApplicationId appId;
    private final ClusterEventListener clusterListener = new InternalClusterListener(this, null);
    private final MastershipListener mastershipListener = new InternalMastershipListener(this, null);
    private final DeviceListener deviceListener = new InternalDeviceListener(this, null);
    private final LinkListener linkListener = new InternalLinkListener(this, null);
    private final HostListener hostListener = new InternalHostListener(this, null);
    private final IntentListener intentListener = new InternalIntentListener(this, null);
    private final FlowRuleListener flowListener = new InternalFlowListener(this, null);
    private final Accumulator<Event> eventAccummulator = new InternalEventAccummulator(this);
    private final ExecutorService msgSender = Executors.newSingleThreadExecutor(Tools.groupedThreads((String)"onos/gui", (String)"msg-sender"));
    private TimerTask trafficTask = null;
    private TrafficEvent trafficEvent = null;
    private TimerTask summaryTask = null;
    private boolean summaryRunning = false;
    private boolean listenersRemoved = false;
    private TopologyViewIntentFilter intentFilter;
    private Set<Host> selectedHosts;
    private Set<Device> selectedDevices;
    private List<Intent> selectedIntents;
    private int currentIntentIndex = -1;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.intentFilter = new TopologyViewIntentFilter(this.intentService, this.deviceService, this.hostService, this.linkService);
        this.appId = ((CoreService)directory.get(CoreService.class)).registerApplication(APP_ID);
    }

    public void destroy() {
        this.cancelAllRequests();
        this.removeListeners();
        super.destroy();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new TopoStart(this, null), (Object)new TopoHeartbeat(this, null), (Object)new TopoStop(this, null), (Object)new ReqSummary(this, null), (Object)new CancelSummary(this, null), (Object)new SpriteListReq(this, null), (Object[])new RequestHandler[]{new SpriteDataReq(this, null), new RequestDetails(this, null), new UpdateMeta(this, null), new EqMasters(this, null), new AddHostIntent(this, null), new AddMultiSourceIntent(this, null), new ReqRelatedIntents(this, null), new ReqNextIntent(this, null), new ReqPrevIntent(this, null), new ReqSelectedIntentTraffic(this, null), new ReqAllFlowTraffic(this, null), new ReqAllPortTraffic(this, null), new ReqDevLinkFlows(this, null), new CancelTraffic(this, null)});
    }

    protected synchronized void sendMessage(ObjectNode data) {
        UiConnection connection = this.connection();
        if (connection != null) {
            connection.sendMessage(data);
        }
    }

    private synchronized void requestSummary(long sid) {
        this.sendMessage(this.summmaryMessage(sid));
    }

    private void cancelAllRequests() {
        this.stopSummaryMonitoring();
        this.stopTrafficMonitoring();
    }

    private void sendAllInstances(String messageType) {
        ArrayList nodes = new ArrayList(this.clusterService.getNodes());
        Collections.sort(nodes, NODE_COMPARATOR);
        for (ControllerNode node : nodes) {
            this.sendMessage(this.instanceMessage(new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node), messageType));
        }
    }

    private void sendAllDevices() {
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() != Device.Type.ROADM) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
        for (Device device : this.deviceService.getDevices()) {
            if (device.type() == Device.Type.ROADM) continue;
            this.sendMessage(this.deviceMessage(new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device)));
        }
    }

    private void sendAllLinks() {
        for (Link link : this.linkService.getLinks()) {
            if (link.type() != Link.Type.OPTICAL) continue;
            this.sendMessage(this.linkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
        for (Link link : this.linkService.getLinks()) {
            if (link.type() == Link.Type.OPTICAL) continue;
            this.sendMessage(this.linkMessage(new LinkEvent(LinkEvent.Type.LINK_ADDED, link)));
        }
    }

    private void sendAllHosts() {
        for (Host host : this.hostService.getHosts()) {
            this.sendMessage(this.hostMessage(new HostEvent(HostEvent.Type.HOST_ADDED, host)));
        }
    }

    private synchronized void startMonitoringIntent(Intent intent) {
        this.selectedHosts = new HashSet();
        this.selectedDevices = new HashSet();
        this.selectedIntents = new ArrayList();
        this.selectedIntents.add(intent);
        this.currentIntentIndex = -1;
        this.requestAnotherRelatedIntent(1);
        this.requestSelectedIntentTraffic();
    }

    private Set<ConnectPoint> getHostLocations(Set<HostId> hostIds) {
        HashSet<ConnectPoint> points = new HashSet<ConnectPoint>();
        for (HostId hostId : hostIds) {
            points.add((ConnectPoint)this.getHostLocation(hostId));
        }
        return points;
    }

    private HostLocation getHostLocation(HostId hostId) {
        return this.hostService.getHost(hostId).location();
    }

    private Set<HostId> getHostIds(ArrayNode ids) {
        HashSet<HostId> hostIds = new HashSet<HostId>();
        for (JsonNode id : ids) {
            hostIds.add(HostId.hostId((String)id.asText()));
        }
        return hostIds;
    }

    private synchronized void startTrafficMonitoring() {
        this.stopTrafficMonitoring();
        this.trafficTask = new TrafficMonitor(this, null);
        this.timer.schedule(this.trafficTask, 5000L, 5000L);
    }

    private synchronized void stopTrafficMonitoring() {
        if (this.trafficTask != null) {
            this.trafficTask.cancel();
            this.trafficTask = null;
        }
    }

    private synchronized void requestAllFlowTraffic() {
        this.startTrafficMonitoring();
        this.sendMessage(this.trafficSummaryMessage(TopologyViewMessageHandlerBase.StatsType.FLOW));
    }

    private synchronized void requestAllPortTraffic() {
        this.startTrafficMonitoring();
        this.sendMessage(this.trafficSummaryMessage(TopologyViewMessageHandlerBase.StatsType.PORT));
    }

    private void requestDeviceLinkFlows(ObjectNode payload) {
        this.startTrafficMonitoring();
        ArrayNode ids = (ArrayNode)payload.path("ids");
        HashSet hosts = new HashSet();
        Set devices = this.getDevices(ids);
        String hover = JsonUtils.string((ObjectNode)payload, (String)"hover");
        if (!Strings.isNullOrEmpty((String)hover)) {
            this.addHover(hosts, devices, hover);
        }
        this.sendMessage(this.flowSummaryMessage(devices));
    }

    private boolean haveSelectedIntents() {
        return this.selectedIntents != null && !this.selectedIntents.isEmpty();
    }

    private void processHoverExtendedSelection(long sid, String hover) {
        HashSet hoverSelHosts = new HashSet(this.selectedHosts);
        HashSet hoverSelDevices = new HashSet(this.selectedDevices);
        this.addHover(hoverSelHosts, hoverSelDevices, hover);
        ArrayList primary = this.selectedIntents == null ? new ArrayList() : this.intentFilter.findPathIntents(hoverSelHosts, hoverSelDevices, (Iterable)this.selectedIntents);
        HashSet secondary = new HashSet(this.selectedIntents);
        secondary.removeAll(primary);
        this.sendMessage(this.trafficMessage(new TopologyViewMessageHandlerBase.TrafficClass[]{new TopologyViewMessageHandlerBase.TrafficClass("primary", primary), new TopologyViewMessageHandlerBase.TrafficClass("secondary", secondary)}));
    }

    private void requestAnotherRelatedIntent(int offset) {
        if (this.haveSelectedIntents()) {
            this.currentIntentIndex += offset;
            if (this.currentIntentIndex < 0) {
                this.currentIntentIndex = this.selectedIntents.size() - 1;
            } else if (this.currentIntentIndex >= this.selectedIntents.size()) {
                this.currentIntentIndex = 0;
            }
            this.sendSelectedIntent();
        }
    }

    private void sendSelectedIntent() {
        Intent selectedIntent = (Intent)this.selectedIntents.get(this.currentIntentIndex);
        log.info("Requested next intent {}", (Object)selectedIntent.id());
        HashSet<Intent> primary = new HashSet<Intent>();
        primary.add(selectedIntent);
        HashSet secondary = new HashSet(this.selectedIntents);
        secondary.remove(selectedIntent);
        this.sendMessage(this.trafficMessage(new TopologyViewMessageHandlerBase.TrafficClass[]{new TopologyViewMessageHandlerBase.TrafficClass("primary", primary), new TopologyViewMessageHandlerBase.TrafficClass("secondary", secondary)}));
    }

    private void requestSelectedIntentTraffic() {
        if (this.haveSelectedIntents()) {
            if (this.currentIntentIndex < 0) {
                this.currentIntentIndex = 0;
            }
            Intent selectedIntent = (Intent)this.selectedIntents.get(this.currentIntentIndex);
            log.info("Requested traffic for selected {}", (Object)selectedIntent.id());
            HashSet<Intent> primary = new HashSet<Intent>();
            primary.add(selectedIntent);
            this.sendMessage(this.trafficMessage(new TopologyViewMessageHandlerBase.TrafficClass[]{new TopologyViewMessageHandlerBase.TrafficClass("primary", primary, true)}));
        }
    }

    private synchronized void startSummaryMonitoring() {
        this.stopSummaryMonitoring();
        this.summaryTask = new SummaryMonitor(this, null);
        this.timer.schedule(this.summaryTask, 30000L, 30000L);
        this.summaryRunning = true;
    }

    private synchronized void stopSummaryMonitoring() {
        if (this.summaryTask != null) {
            this.summaryTask.cancel();
            this.summaryTask = null;
        }
        this.summaryRunning = false;
    }

    private synchronized void addListeners() {
        this.listenersRemoved = false;
        this.clusterService.addListener(this.clusterListener);
        this.mastershipService.addListener(this.mastershipListener);
        this.deviceService.addListener(this.deviceListener);
        this.linkService.addListener(this.linkListener);
        this.hostService.addListener(this.hostListener);
        this.intentService.addListener(this.intentListener);
        this.flowService.addListener(this.flowListener);
    }

    private synchronized void removeListeners() {
        if (!this.listenersRemoved) {
            this.listenersRemoved = true;
            this.clusterService.removeListener(this.clusterListener);
            this.mastershipService.removeListener(this.mastershipListener);
            this.deviceService.removeListener(this.deviceListener);
            this.linkService.removeListener(this.linkListener);
            this.hostService.removeListener(this.hostListener);
            this.intentService.removeListener(this.intentListener);
            this.flowService.removeListener(this.flowListener);
        }
    }

    static /* synthetic */ void access$2700(TopologyViewMessageHandler x0) {
        x0.addListeners();
    }

    static /* synthetic */ void access$2800(TopologyViewMessageHandler x0, String x1) {
        x0.sendAllInstances(x1);
    }

    static /* synthetic */ void access$2900(TopologyViewMessageHandler x0) {
        x0.sendAllDevices();
    }

    static /* synthetic */ void access$3000(TopologyViewMessageHandler x0) {
        x0.sendAllLinks();
    }

    static /* synthetic */ void access$3100(TopologyViewMessageHandler x0) {
        x0.sendAllHosts();
    }

    static /* synthetic */ void access$3200(TopologyViewMessageHandler x0) {
        x0.stopSummaryMonitoring();
    }

    static /* synthetic */ void access$3300(TopologyViewMessageHandler x0) {
        x0.stopTrafficMonitoring();
    }

    static /* synthetic */ void access$3400(TopologyViewMessageHandler x0, long x1) {
        x0.requestSummary(x1);
    }

    static /* synthetic */ void access$3500(TopologyViewMessageHandler x0) {
        x0.startSummaryMonitoring();
    }

    static /* synthetic */ ObjectNode access$3600(TopologyViewMessageHandler x0) {
        return x0.objectNode();
    }

    static /* synthetic */ ArrayNode access$3700(TopologyViewMessageHandler x0) {
        return x0.arrayNode();
    }

    static /* synthetic */ ObjectNode access$3800(TopologyViewMessageHandler x0) {
        return x0.objectNode();
    }

    static /* synthetic */ ApplicationId access$3900(TopologyViewMessageHandler x0) {
        return x0.appId;
    }

    static /* synthetic */ void access$4000(TopologyViewMessageHandler x0, Intent x1) {
        x0.startMonitoringIntent(x1);
    }

    static /* synthetic */ Set access$4100(TopologyViewMessageHandler x0, ArrayNode x1) {
        return x0.getHostIds(x1);
    }

    static /* synthetic */ Set access$4200(TopologyViewMessageHandler x0, Set x1) {
        return x0.getHostLocations(x1);
    }

    static /* synthetic */ Set access$4302(TopologyViewMessageHandler x0, Set x1) {
        x0.selectedHosts = x1;
        return x0.selectedHosts;
    }

    static /* synthetic */ Set access$4402(TopologyViewMessageHandler x0, Set x1) {
        x0.selectedDevices = x1;
        return x0.selectedDevices;
    }

    static /* synthetic */ List access$4502(TopologyViewMessageHandler x0, List x1) {
        x0.selectedIntents = x1;
        return x0.selectedIntents;
    }

    static /* synthetic */ Set access$4300(TopologyViewMessageHandler x0) {
        return x0.selectedHosts;
    }

    static /* synthetic */ Set access$4400(TopologyViewMessageHandler x0) {
        return x0.selectedDevices;
    }

    static /* synthetic */ TopologyViewIntentFilter access$4600(TopologyViewMessageHandler x0) {
        return x0.intentFilter;
    }

    static /* synthetic */ int access$4702(TopologyViewMessageHandler x0, int x1) {
        x0.currentIntentIndex = x1;
        return x0.currentIntentIndex;
    }

    static /* synthetic */ boolean access$4800(TopologyViewMessageHandler x0) {
        return x0.haveSelectedIntents();
    }

    static /* synthetic */ List access$4500(TopologyViewMessageHandler x0) {
        return x0.selectedIntents;
    }

    static /* synthetic */ void access$4900(TopologyViewMessageHandler x0, int x1) {
        x0.requestAnotherRelatedIntent(x1);
    }

    static /* synthetic */ TrafficEvent access$5002(TopologyViewMessageHandler x0, TrafficEvent x1) {
        x0.trafficEvent = x1;
        return x0.trafficEvent;
    }

    static /* synthetic */ void access$5100(TopologyViewMessageHandler x0) {
        x0.requestSelectedIntentTraffic();
    }

    static /* synthetic */ void access$5200(TopologyViewMessageHandler x0) {
        x0.startTrafficMonitoring();
    }

    static /* synthetic */ void access$5300(TopologyViewMessageHandler x0) {
        x0.requestAllFlowTraffic();
    }

    static /* synthetic */ void access$5400(TopologyViewMessageHandler x0) {
        x0.requestAllPortTraffic();
    }

    static /* synthetic */ void access$5500(TopologyViewMessageHandler x0, ObjectNode x1) {
        x0.requestDeviceLinkFlows(x1);
    }

    static /* synthetic */ ExecutorService access$5800(TopologyViewMessageHandler x0) {
        return x0.msgSender;
    }

    static /* synthetic */ Accumulator access$5900(TopologyViewMessageHandler x0) {
        return x0.eventAccummulator;
    }

    static /* synthetic */ TimerTask access$6000(TopologyViewMessageHandler x0) {
        return x0.trafficTask;
    }

    static /* synthetic */ TrafficEvent access$5000(TopologyViewMessageHandler x0) {
        return x0.trafficEvent;
    }

    static /* synthetic */ boolean access$6300(TopologyViewMessageHandler x0) {
        return x0.summaryRunning;
    }
}

