/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.core.CoreService;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.incubator.net.tunnel.OpticalTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowEntry;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.OpticalPathIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.statistic.Load;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.impl.TopologyViewMessageHandlerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Deprecated
public abstract class TopologyViewMessageHandlerBase
extends UiMessageHandler {
    protected static final Logger log = LoggerFactory.getLogger(TopologyViewMessageHandlerBase.class);
    private static final ProviderId PID = new ProviderId("core", "org.onosproject.core", true);
    private static final String COMPACT = "%s/%s-%s/%s";
    private static final double KILO = 1024.0;
    private static final double MEGA = 1048576.0;
    private static final double GIGA = 1.073741824E9;
    private static final String GBITS_UNIT = "Gb";
    private static final String MBITS_UNIT = "Mb";
    private static final String KBITS_UNIT = "Kb";
    private static final String BITS_UNIT = "b";
    private static final String GBYTES_UNIT = "GB";
    private static final String MBYTES_UNIT = "MB";
    private static final String KBYTES_UNIT = "KB";
    private static final String BYTES_UNIT = "B";
    private static final double BPS_THRESHOLD = 4096.0;
    protected ServiceDirectory directory;
    protected ClusterService clusterService;
    protected DeviceService deviceService;
    protected LinkService linkService;
    protected HostService hostService;
    protected MastershipService mastershipService;
    protected IntentService intentService;
    protected FlowRuleService flowService;
    protected StatisticService flowStatsService;
    protected PortStatisticsService portStatsService;
    protected TopologyService topologyService;
    protected TunnelService tunnelService;
    private String version;
    private static Map<String, ObjectNode> metaUi = new ConcurrentHashMap();

    static Map<String, ObjectNode> getMetaUi() {
        return Collections.unmodifiableMap(metaUi);
    }

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.directory = (ServiceDirectory)Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.intentService = (IntentService)directory.get(IntentService.class);
        this.flowService = (FlowRuleService)directory.get(FlowRuleService.class);
        this.flowStatsService = (StatisticService)directory.get(StatisticService.class);
        this.portStatsService = (PortStatisticsService)directory.get(PortStatisticsService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        this.tunnelService = (TunnelService)directory.get(TunnelService.class);
        String ver = ((CoreService)directory.get(CoreService.class)).version().toString();
        this.version = ver.replace(".SNAPSHOT", "*").replaceFirst("~.*$", "");
    }

    private String ip(Set<IpAddress> ipAddresses) {
        Iterator<IpAddress> it = ipAddresses.iterator();
        return it.hasNext() ? it.next().toString() : "unknown";
    }

    private JsonNode props(Annotations annotations) {
        ObjectNode props = this.objectNode();
        if (annotations != null) {
            for (String key : annotations.keys()) {
                props.put(key, annotations.value(key));
            }
        }
        return props;
    }

    protected ObjectNode info(long id, String message) {
        return this.message("info", id, message);
    }

    protected ObjectNode warning(long id, String message) {
        return this.message("warning", id, message);
    }

    protected ObjectNode error(long id, String message) {
        return this.message("error", id, message);
    }

    private ObjectNode message(String severity, long id, String message) {
        ObjectNode payload = this.objectNode().put("severity", severity).put("message", message);
        return JsonUtils.envelope((String)"message", (long)id, (ObjectNode)payload);
    }

    protected Set<Host> getHosts(ArrayNode array) {
        HashSet<Host> hosts = new HashSet<Host>();
        if (array != null) {
            for (JsonNode node : array) {
                try {
                    this.addHost(hosts, HostId.hostId((String)node.asText()));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Skipping ID {}", (Object)node.asText());
                }
            }
        }
        return hosts;
    }

    private void addHost(Set<Host> hosts, HostId hostId) {
        Host host = this.hostService.getHost(hostId);
        if (host != null) {
            hosts.add(host);
        }
    }

    protected Set<Device> getDevices(ArrayNode array) {
        HashSet<Device> devices = new HashSet<Device>();
        if (array != null) {
            for (JsonNode node : array) {
                try {
                    this.addDevice(devices, DeviceId.deviceId((String)node.asText()));
                }
                catch (IllegalArgumentException e) {
                    log.debug("Skipping ID {}", (Object)node.asText());
                }
            }
        }
        return devices;
    }

    private void addDevice(Set<Device> devices, DeviceId deviceId) {
        Device device = this.deviceService.getDevice(deviceId);
        if (device != null) {
            devices.add(device);
        }
    }

    protected void addHover(Set<Host> hosts, Set<Device> devices, String hover) {
        try {
            this.addHost(hosts, HostId.hostId((String)hover));
        }
        catch (IllegalArgumentException e) {
            try {
                this.addDevice(devices, DeviceId.deviceId((String)hover));
            }
            catch (IllegalArgumentException ne) {
                log.debug("Skipping ID {}", (Object)hover);
            }
        }
    }

    protected ObjectNode instanceMessage(ClusterEvent event, String messageType) {
        ControllerNode node = (ControllerNode)event.subject();
        int switchCount = this.mastershipService.getDevicesOf(node.id()).size();
        ObjectNode payload = this.objectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("online", this.clusterService.getState(node.id()) == ControllerNode.State.ACTIVE).put("uiAttached", node.equals(this.clusterService.getLocalNode())).put("switches", switchCount);
        ArrayNode labels = this.arrayNode();
        labels.add(node.id().toString());
        labels.add(node.ip().toString());
        payload.set("labels", (JsonNode)labels);
        this.addMetaUi(node.id().toString(), payload);
        String type = messageType != null ? messageType : (event.type() == ClusterEvent.Type.INSTANCE_ADDED ? "addInstance" : (event.type() == ClusterEvent.Type.INSTANCE_REMOVED ? "removeInstance" : "addInstance"));
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode deviceMessage(DeviceEvent event) {
        Device device = (Device)event.subject();
        ObjectNode payload = this.objectNode().put("id", device.id().toString()).put("type", device.type().toString().toLowerCase()).put("online", this.deviceService.isAvailable(device.id())).put("master", this.master(device.id()));
        String name = device.annotations().value("name");
        ArrayNode labels = this.arrayNode();
        labels.add("");
        labels.add(Strings.isNullOrEmpty((String)name) ? device.id().toString() : name);
        labels.add(device.id().toString());
        payload.set("labels", (JsonNode)labels);
        payload.set("props", this.props(device.annotations()));
        this.addGeoLocation((Annotated)device, payload);
        this.addMetaUi(device.id().toString(), payload);
        String type = event.type() == DeviceEvent.Type.DEVICE_ADDED ? "addDevice" : (event.type() == DeviceEvent.Type.DEVICE_REMOVED ? "removeDevice" : "updateDevice");
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode linkMessage(LinkEvent event) {
        Link link = (Link)event.subject();
        ObjectNode payload = this.objectNode().put("id", TopologyViewMessageHandlerBase.compactLinkString((Link)link)).put("type", link.type().toString().toLowerCase()).put("online", link.state() == Link.State.ACTIVE).put("linkWidth", 1.2).put("src", link.src().deviceId().toString()).put("srcPort", link.src().port().toString()).put("dst", link.dst().deviceId().toString()).put("dstPort", link.dst().port().toString());
        String type = event.type() == LinkEvent.Type.LINK_ADDED ? "addLink" : (event.type() == LinkEvent.Type.LINK_REMOVED ? "removeLink" : "updateLink");
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    protected ObjectNode hostMessage(HostEvent event) {
        Host host = (Host)event.subject();
        String hostType = host.annotations().value("type");
        ObjectNode payload = this.objectNode().put("id", host.id().toString()).put("type", Strings.isNullOrEmpty((String)hostType) ? "endstation" : hostType).put("ingress", TopologyViewMessageHandlerBase.compactLinkString((Link)this.edgeLink(host, true))).put("egress", TopologyViewMessageHandlerBase.compactLinkString((Link)this.edgeLink(host, false)));
        payload.set("cp", (JsonNode)this.hostConnect(host.location()));
        payload.set("labels", (JsonNode)this.labels(new String[]{this.ip(host.ipAddresses()), host.mac().toString()}));
        payload.set("props", this.props(host.annotations()));
        this.addGeoLocation((Annotated)host, payload);
        this.addMetaUi(host.id().toString(), payload);
        String type = event.type() == HostEvent.Type.HOST_ADDED ? "addHost" : (event.type() == HostEvent.Type.HOST_REMOVED ? "removeHost" : "updateHost");
        return JsonUtils.envelope((String)type, (long)0L, (ObjectNode)payload);
    }

    private ObjectNode hostConnect(HostLocation location) {
        return this.objectNode().put("device", location.deviceId().toString()).put("port", location.port().toLong());
    }

    private ArrayNode labels(String ... labels) {
        ArrayNode json = this.arrayNode();
        for (String label : labels) {
            json.add(label);
        }
        return json;
    }

    private String master(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        return master != null ? master.toString() : "";
    }

    private EdgeLink edgeLink(Host host, boolean ingress) {
        return new DefaultEdgeLink(PID, new ConnectPoint((ElementId)host.id(), PortNumber.portNumber((long)0L)), host.location(), ingress, new Annotations[0]);
    }

    private void addMetaUi(String id, ObjectNode payload) {
        ObjectNode meta = (ObjectNode)metaUi.get(id);
        if (meta != null) {
            payload.set("metaUi", (JsonNode)meta);
        }
    }

    private void addGeoLocation(Annotated annotated, ObjectNode payload) {
        Annotations annotations = annotated.annotations();
        if (annotations == null) {
            return;
        }
        String slat = annotations.value("latitude");
        String slng = annotations.value("longitude");
        try {
            if (slat != null && slng != null && !slat.isEmpty() && !slng.isEmpty()) {
                double lat = Double.parseDouble(slat);
                double lng = Double.parseDouble(slng);
                ObjectNode loc = this.objectNode().put("type", "latlng").put("lat", lat).put("lng", lng);
                payload.set("location", (JsonNode)loc);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid geo data latitude={}; longiture={}", (Object)slat, (Object)slng);
        }
    }

    protected void updateMetaUi(ObjectNode payload) {
        metaUi.put(JsonUtils.string((ObjectNode)payload, (String)"id"), JsonUtils.node((ObjectNode)payload, (String)"memento"));
    }

    protected ObjectNode summmaryMessage(long sid) {
        Topology topology = this.topologyService.currentTopology();
        return JsonUtils.envelope((String)"showSummary", (long)sid, (ObjectNode)this.json("ONOS Summary", "node", new Prop[]{new Prop("Devices", this.format((Number)topology.deviceCount())), new Prop("Links", this.format((Number)topology.linkCount())), new Prop("Hosts", this.format((Number)this.hostService.getHostCount())), new Prop("Topology SCCs", this.format((Number)topology.clusterCount())), new Separator(), new Prop("Intents", this.format((Number)this.intentService.getIntentCount())), new Prop("Tunnels", this.format((Number)this.tunnelService.tunnelCount())), new Prop("Flows", this.format((Number)this.flowService.getFlowRuleCount())), new Prop("Version", this.version)}));
    }

    protected ObjectNode deviceDetails(DeviceId deviceId, long sid) {
        Device device = this.deviceService.getDevice(deviceId);
        Annotations annot = device.annotations();
        String name = annot.value("name");
        int portCount = this.deviceService.getPorts(deviceId).size();
        int flowCount = this.getFlowCount(deviceId);
        int tunnelCount = this.getTunnelCount(deviceId);
        return JsonUtils.envelope((String)"showDetails", (long)sid, (ObjectNode)this.json(Strings.isNullOrEmpty((String)name) ? deviceId.toString() : name, device.type().toString().toLowerCase(), new Prop[]{new Prop("URI", deviceId.toString()), new Prop("Vendor", device.manufacturer()), new Prop("H/W Version", device.hwVersion()), new Prop("S/W Version", device.swVersion()), new Prop("Serial Number", device.serialNumber()), new Prop("Protocol", annot.value("protocol")), new Separator(), new Prop("Master", this.master(deviceId)), new Prop("Latitude", annot.value("latitude")), new Prop("Longitude", annot.value("longitude")), new Separator(), new Prop("Ports", Integer.toString(portCount)), new Prop("Flows", Integer.toString(flowCount)), new Prop("Tunnels", Integer.toString(tunnelCount))}));
    }

    protected int getFlowCount(DeviceId deviceId) {
        int count = 0;
        Iterator it = this.flowService.getFlowEntries(deviceId).iterator();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }

    protected int getTunnelCount(DeviceId deviceId) {
        int count = 0;
        Collection tunnels = this.tunnelService.queryAllTunnels();
        for (Tunnel tunnel : tunnels) {
            OpticalTunnelEndPoint src = (OpticalTunnelEndPoint)tunnel.src();
            OpticalTunnelEndPoint dst = (OpticalTunnelEndPoint)tunnel.dst();
            DeviceId srcDevice = (DeviceId)src.elementId().get();
            DeviceId dstDevice = (DeviceId)dst.elementId().get();
            if (!srcDevice.toString().equals(deviceId.toString()) && !dstDevice.toString().equals(deviceId.toString())) continue;
            ++count;
        }
        return count;
    }

    protected Map<Link, Integer> getFlowCounts(DeviceId deviceId) {
        ArrayList entries = new ArrayList();
        HashSet<DefaultEdgeLink> links = new HashSet<DefaultEdgeLink>(this.linkService.getDeviceEgressLinks(deviceId));
        Set hosts = this.hostService.getConnectedHosts(deviceId);
        Iterator it = this.flowService.getFlowEntries(deviceId).iterator();
        while (it.hasNext()) {
            entries.add(it.next());
        }
        if (hosts != null) {
            for (Host host : hosts) {
                links.add(new DefaultEdgeLink(host.providerId(), new ConnectPoint((ElementId)host.id(), PortNumber.P0), host.location(), false, new Annotations[0]));
            }
        }
        HashMap<Link, Integer> counts = new HashMap<Link, Integer>();
        for (Link link : links) {
            counts.put(link, this.getEgressFlows(link, entries));
        }
        return counts;
    }

    private Integer getEgressFlows(Link link, List<FlowEntry> entries) {
        int count = 0;
        PortNumber out = link.src().port();
        for (FlowEntry entry : entries) {
            TrafficTreatment treatment = entry.treatment();
            for (Instruction instruction : treatment.allInstructions()) {
                if (instruction.type() != Instruction.Type.OUTPUT || !((Instructions.OutputInstruction)instruction).port().equals((Object)out)) continue;
                ++count;
            }
        }
        return count;
    }

    protected ObjectNode hostDetails(HostId hostId, long sid) {
        Host host = this.hostService.getHost(hostId);
        Annotations annot = host.annotations();
        String type = annot.value("type");
        String name = annot.value("name");
        String vlan = host.vlan().toString();
        return JsonUtils.envelope((String)"showDetails", (long)sid, (ObjectNode)this.json(Strings.isNullOrEmpty((String)name) ? hostId.toString() : name, Strings.isNullOrEmpty((String)type) ? "endstation" : type, new Prop[]{new Prop("MAC", host.mac().toString()), new Prop("IP", host.ipAddresses().toString().replaceAll("[\\[\\]]", "")), new Prop("VLAN", vlan.equals("-1") ? "none" : vlan), new Separator(), new Prop("Latitude", annot.value("latitude")), new Prop("Longitude", annot.value("longitude"))}));
    }

    protected ObjectNode trafficSummaryMessage(StatsType type) {
        ObjectNode payload = this.objectNode();
        ArrayNode paths = this.arrayNode();
        payload.set("paths", (JsonNode)paths);
        ObjectNode pathNodeN = this.objectNode();
        ArrayNode linksNodeN = this.arrayNode();
        ArrayNode labelsN = this.arrayNode();
        pathNodeN.put("class", "plain").put("traffic", false);
        pathNodeN.set("links", (JsonNode)linksNodeN);
        pathNodeN.set("labels", (JsonNode)labelsN);
        paths.add((JsonNode)pathNodeN);
        ObjectNode pathNodeT = this.objectNode();
        ArrayNode linksNodeT = this.arrayNode();
        ArrayNode labelsT = this.arrayNode();
        pathNodeT.put("class", "secondary").put("traffic", true);
        pathNodeT.set("links", (JsonNode)linksNodeT);
        pathNodeT.set("labels", (JsonNode)labelsT);
        paths.add((JsonNode)pathNodeT);
        Map biLinks = this.consolidateLinks(this.linkService.getLinks());
        this.addEdgeLinks(biLinks);
        for (BiLink link : biLinks.values()) {
            boolean bi;
            boolean bl = bi = link.two != null;
            if (type == StatsType.FLOW) {
                link.addLoad(this.getLinkLoad(link.one));
                link.addLoad(bi ? this.getLinkLoad(link.two) : null);
            } else if (type == StatsType.PORT) {
                link.addLoad(this.portStatsService.load(link.one.src()), 4096.0, this.portStatsService.load(link.one.dst()), 4096.0);
            }
            if (link.hasTraffic) {
                linksNodeT.add(TopologyViewMessageHandlerBase.compactLinkString((Link)link.one));
                labelsT.add(type == StatsType.PORT ? this.formatBitRate(BiLink.access$000((BiLink)link)) + "ps" : this.formatBytes(link.bytes));
                continue;
            }
            linksNodeN.add(TopologyViewMessageHandlerBase.compactLinkString((Link)link.one));
            labelsN.add("");
        }
        return JsonUtils.envelope((String)"showTraffic", (long)0L, (ObjectNode)payload);
    }

    private Load getLinkLoad(Link link) {
        if (link.src().elementId() instanceof DeviceId) {
            return this.flowStatsService.load(link);
        }
        return null;
    }

    private void addEdgeLinks(Map<LinkKey, BiLink> biLinks) {
        this.hostService.getHosts().forEach(host -> {
            TopologyViewMessageHandlerBase.addLink((Map)biLinks, (Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)true));
            TopologyViewMessageHandlerBase.addLink((Map)biLinks, (Link)DefaultEdgeLink.createEdgeLink((Host)host, (boolean)false));
        });
    }

    private Map<LinkKey, BiLink> consolidateLinks(Iterable<Link> links) {
        HashMap<LinkKey, BiLink> biLinks = new HashMap<LinkKey, BiLink>();
        for (Link link : links) {
            TopologyViewMessageHandlerBase.addLink(biLinks, (Link)link);
        }
        return biLinks;
    }

    protected ObjectNode flowSummaryMessage(Set<Device> devices) {
        ObjectNode payload = this.objectNode();
        ArrayNode paths = this.arrayNode();
        payload.set("paths", (JsonNode)paths);
        for (Device device : devices) {
            Map counts = this.getFlowCounts(device.id());
            for (Link link : counts.keySet()) {
                this.addLinkFlows(link, paths, (Integer)counts.get(link));
            }
        }
        return JsonUtils.envelope((String)"showTraffic", (long)0L, (ObjectNode)payload);
    }

    private void addLinkFlows(Link link, ArrayNode paths, Integer count) {
        ObjectNode pathNode = this.objectNode();
        ArrayNode linksNode = this.arrayNode();
        ArrayNode labels = this.arrayNode();
        boolean noFlows = count == null || count == 0;
        pathNode.put("class", noFlows ? "secondary" : "primary");
        pathNode.put("traffic", false);
        pathNode.set("links", (JsonNode)linksNode.add(TopologyViewMessageHandlerBase.compactLinkString((Link)link)));
        pathNode.set("labels", (JsonNode)labels.add(noFlows ? "" : count.toString() + (count == 1 ? " flow" : " flows")));
        paths.add((JsonNode)pathNode);
    }

    protected ObjectNode trafficMessage(TrafficClass ... trafficClasses) {
        ObjectNode payload = this.objectNode();
        ArrayNode paths = this.arrayNode();
        payload.set("paths", (JsonNode)paths);
        Map biLinks = this.classifyLinkTraffic(trafficClasses);
        HashMap<String, ObjectNode> pathNodes = new HashMap<String, ObjectNode>();
        for (BiLink biLink : biLinks.values()) {
            boolean hasTraffic = biLink.hasTraffic;
            String tc = (biLink.classes() + (hasTraffic ? " animated" : "")).trim();
            ObjectNode pathNode = (ObjectNode)pathNodes.get(tc);
            if (pathNode == null) {
                pathNode = this.objectNode().put("class", tc).put("traffic", hasTraffic);
                pathNode.set("links", (JsonNode)this.arrayNode());
                pathNode.set("labels", (JsonNode)this.arrayNode());
                pathNodes.put(tc, pathNode);
                paths.add((JsonNode)pathNode);
            }
            ((ArrayNode)pathNode.path("links")).add(TopologyViewMessageHandlerBase.compactLinkString((Link)biLink.one));
            ((ArrayNode)pathNode.path("labels")).add(hasTraffic ? this.formatBytes(biLink.bytes) : "");
        }
        return JsonUtils.envelope((String)"showTraffic", (long)0L, (ObjectNode)payload);
    }

    private Map<LinkKey, BiLink> classifyLinkTraffic(TrafficClass ... trafficClasses) {
        HashMap<LinkKey, BiLink> biLinks = new HashMap<LinkKey, BiLink>();
        for (TrafficClass trafficClass : trafficClasses) {
            for (Intent intent : trafficClass.intents) {
                boolean isOptical = intent instanceof OpticalConnectivityIntent;
                List installables = this.intentService.getInstallableIntents(intent.key());
                if (installables == null) continue;
                for (Intent installable : installables) {
                    String type;
                    String string = type = isOptical ? trafficClass.type + " optical" : trafficClass.type;
                    if (installable instanceof PathIntent) {
                        this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((PathIntent)installable).path().links());
                        continue;
                    }
                    if (installable instanceof FlowRuleIntent) {
                        this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)this.linkResources(installable));
                        continue;
                    }
                    if (installable instanceof LinkCollectionIntent) {
                        this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((LinkCollectionIntent)installable).links());
                        continue;
                    }
                    if (!(installable instanceof OpticalPathIntent)) continue;
                    this.classifyLinks(type, biLinks, trafficClass.showTraffic, (Iterable)((OpticalPathIntent)installable).path().links());
                }
            }
        }
        return biLinks;
    }

    private Collection<Link> linkResources(Intent installable) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (NetworkResource r : installable.resources()) {
            if (!(r instanceof Link)) continue;
            builder.add((Object)((Link)r));
        }
        return builder.build();
    }

    private void classifyLinks(String type, Map<LinkKey, BiLink> biLinks, boolean showTraffic, Iterable<Link> links) {
        if (links != null) {
            for (Link link : links) {
                BiLink biLink = TopologyViewMessageHandlerBase.addLink(biLinks, (Link)link);
                if (showTraffic) {
                    biLink.addLoad(this.getLinkLoad(link));
                }
                biLink.addClass(type);
            }
        }
    }

    static BiLink addLink(Map<LinkKey, BiLink> biLinks, Link link) {
        LinkKey key = TopologyViewMessageHandlerBase.canonicalLinkKey((Link)link);
        BiLink biLink = biLinks.get(key);
        if (biLink != null) {
            biLink.setOther(link);
        } else {
            biLink = new BiLink(key, link);
            biLinks.put(key, biLink);
        }
        return biLink;
    }

    private String formatBytes(long bytes) {
        String unit;
        double value;
        if ((double)bytes > 1.073741824E9) {
            value = (double)bytes / 1.073741824E9;
            unit = "GB";
        } else if ((double)bytes > 1048576.0) {
            value = (double)bytes / 1048576.0;
            unit = "MB";
        } else if ((double)bytes > 1024.0) {
            value = (double)bytes / 1024.0;
            unit = "KB";
        } else {
            value = bytes;
            unit = "B";
        }
        DecimalFormat format = new DecimalFormat("#,###.##");
        return format.format(value) + " " + unit;
    }

    private String formatBitRate(long bytes) {
        String unit;
        double value;
        long bits = bytes * 8L;
        if ((double)bits > 1.073741824E9) {
            value = (double)bits / 1.073741824E9;
            unit = "Gb";
            if (value > 10.0) {
                value = 10.0;
            }
        } else if ((double)bits > 1048576.0) {
            value = (double)bits / 1048576.0;
            unit = "Mb";
        } else if ((double)bits > 1024.0) {
            value = (double)bits / 1024.0;
            unit = "Kb";
        } else {
            value = bits;
            unit = "b";
        }
        DecimalFormat format = new DecimalFormat("#,###.##");
        return format.format(value) + " " + unit;
    }

    private String format(Number number) {
        DecimalFormat format = new DecimalFormat("#,###");
        return format.format(number);
    }

    private static String compactLinkString(Link link) {
        return String.format("%s/%s-%s/%s", link.src().elementId(), link.src().port(), link.dst().elementId(), link.dst().port());
    }

    private ObjectNode json(String id, String type, Prop ... props) {
        ObjectNode result = this.objectNode().put("id", id).put("type", type);
        ObjectNode pnode = this.objectNode();
        ArrayNode porder = this.arrayNode();
        for (Prop p : props) {
            porder.add(p.key);
            pnode.put(p.key, p.value);
        }
        result.set("propOrder", (JsonNode)porder);
        result.set("props", (JsonNode)pnode);
        return result;
    }

    static LinkKey canonicalLinkKey(Link link) {
        String dn;
        String sn = link.src().elementId().toString();
        return sn.compareTo(dn = link.dst().elementId().toString()) < 0 ? LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()) : LinkKey.linkKey((ConnectPoint)link.dst(), (ConnectPoint)link.src());
    }
}

