/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.mastership.MastershipService;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.onosproject.ui.UiView;
import org.onosproject.ui.UiViewHidden;
import org.onosproject.ui.impl.AltTopoViewMessageHandler;
import org.onosproject.ui.impl.ApplicationViewMessageHandler;
import org.onosproject.ui.impl.ClusterViewMessageHandler;
import org.onosproject.ui.impl.DeviceViewMessageHandler;
import org.onosproject.ui.impl.FlowViewMessageHandler;
import org.onosproject.ui.impl.GroupViewMessageHandler;
import org.onosproject.ui.impl.HostViewMessageHandler;
import org.onosproject.ui.impl.IntentViewMessageHandler;
import org.onosproject.ui.impl.LinkViewMessageHandler;
import org.onosproject.ui.impl.PortViewMessageHandler;
import org.onosproject.ui.impl.SettingsViewMessageHandler;
import org.onosproject.ui.impl.SpriteService;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.onosproject.ui.impl.UiWebSocketServlet;
import org.onosproject.ui.impl.topo.OverlayService;
import org.onosproject.ui.impl.topo.overlay.SummaryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class UiExtensionManager
implements UiExtensionService,
SpriteService,
OverlayService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<UiExtension> extensions = Lists.newArrayList();
    private final Map<String, UiExtension> views = Maps.newHashMap();
    private final UiExtension core = this.createCoreExtension();
    private final AltTopoViewMessageHandler topoHandler = new AltTopoViewMessageHandler();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    private final Map<String, JsonNode> sprites = Maps.newHashMap();

    private UiExtension createCoreExtension() {
        ImmutableList coreViews = ImmutableList.of((Object)new UiView(UiView.Category.PLATFORM, "app", "Applications", "nav_apps"), (Object)new UiView(UiView.Category.PLATFORM, "settings", "Settings", "nav_settings"), (Object)new UiView(UiView.Category.PLATFORM, "cluster", "Cluster Nodes", "nav_cluster"), (Object)new UiView(UiView.Category.NETWORK, "topo", "Topology", "nav_topo"), (Object)new UiView(UiView.Category.NETWORK, "device", "Devices", "nav_devs"), (Object)new UiViewHidden("flow"), (Object)new UiViewHidden("port"), (Object)new UiViewHidden("group"), (Object)new UiView(UiView.Category.NETWORK, "link", "Links", "nav_links"), (Object)new UiView(UiView.Category.NETWORK, "host", "Hosts", "nav_hosts"), (Object)new UiView(UiView.Category.NETWORK, "intent", "Intents", "nav_intents"));
        UiMessageHandlerFactory messageHandlerFactory = () -> ImmutableList.of((Object)new TopologyViewMessageHandler(), (Object)new DeviceViewMessageHandler(), (Object)new LinkViewMessageHandler(), (Object)new HostViewMessageHandler(), (Object)new FlowViewMessageHandler(), (Object)new PortViewMessageHandler(), (Object)new GroupViewMessageHandler(), (Object)new IntentViewMessageHandler(), (Object)new ApplicationViewMessageHandler(), (Object)new SettingsViewMessageHandler(), (Object)new ClusterViewMessageHandler());
        return new UiExtension((List)coreViews, messageHandlerFactory, "core", UiExtensionManager.class.getClassLoader());
    }

    @Activate
    public void activate() {
        this.register(this.core);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        UiWebSocketServlet.closeAll();
        this.unregister(this.core);
        this.log.info("Stopped");
    }

    public synchronized void register(UiExtension extension) {
        if (!this.extensions.contains(extension)) {
            this.extensions.add(extension);
            for (UiView view : extension.views()) {
                this.views.put(view.id(), extension);
            }
        }
    }

    public synchronized void unregister(UiExtension extension) {
        this.extensions.remove(extension);
        extension.views().stream().map(UiView::id).collect(Collectors.toSet()).forEach(this.views::remove);
    }

    public synchronized List<UiExtension> getExtensions() {
        return ImmutableList.copyOf((Collection)this.extensions);
    }

    public synchronized UiExtension getViewExtension(String viewId) {
        return (UiExtension)this.views.get(viewId);
    }

    public Set<String> getNames() {
        return ImmutableSet.copyOf(this.sprites.keySet());
    }

    public void put(String name, JsonNode spriteData) {
        this.log.info("Registered sprite definition [{}]", (Object)name);
        this.sprites.put(name, spriteData);
    }

    public JsonNode get(String name) {
        return (JsonNode)this.sprites.get(name);
    }

    public void addSummaryGenerator(String overlayId, SummaryGenerator generator) {
        this.topoHandler.addSummaryGenerator(overlayId, generator);
    }

    public void removeSummaryGenerator(String overlayId) {
        this.topoHandler.removeSummaryGenerator(overlayId);
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }
}

