/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import java.util.HashSet;
import java.util.Set;
import org.onosproject.event.Event;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.ui.impl.topo.TopoUiEvent;
import org.onosproject.ui.impl.topo.TopoUiListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModelListenerRegistry
extends ListenerRegistry<TopoUiEvent, TopoUiListener> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<TopoUiListener> zombies = new HashSet();

    ModelListenerRegistry() {
    }

    public void process(TopoUiEvent event) {
        this.zombies.clear();
        for (TopoUiListener listener : this.listeners) {
            try {
                if (listener.isAwake()) {
                    listener.event((Event)event);
                    continue;
                }
                this.zombies.add(listener);
            }
            catch (Exception error) {
                this.reportProblem((Event)event, (Throwable)error);
            }
        }
        for (TopoUiListener z : this.zombies) {
            this.log.debug("Removing zombie model listener: {}", (Object)z);
            this.removeListener((EventListener)z);
        }
    }
}

