/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.EdgeLink;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.impl.topo.MetaDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopoMessageFactory {
    private static final ProviderId PROVIDER_ID = new ProviderId("core", "org.onosproject.core", true);
    private static final String COMPACT = "%s/%s-%s/%s";
    private static final PortNumber PORT_ZERO = PortNumber.portNumber((long)0L);
    private static final Map<Enum<?>, String> LOOKUP = new HashMap();
    private static final ObjectMapper MAPPER;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MetaDb metaDb;
    private ClusterService clusterService;
    private DeviceService deviceService;
    private LinkService linkService;
    private HostService hostService;
    private MastershipService mastershipService;

    TopoMessageFactory() {
    }

    private ObjectNode objectNode() {
        return MAPPER.createObjectNode();
    }

    private ArrayNode arrayNode() {
        return MAPPER.createArrayNode();
    }

    private String toLc(Object o) {
        return o.toString().toLowerCase();
    }

    private String messageTypeLookup(Enum<?> type, String fallback) {
        String msgType = (String)LOOKUP.get(type);
        return msgType == null ? fallback : msgType;
    }

    private String master(DeviceId deviceId) {
        NodeId master = this.mastershipService.getMasterFor(deviceId);
        return master != null ? master.toString() : "";
    }

    private ObjectNode props(Annotations annotations) {
        ObjectNode props = this.objectNode();
        if (annotations != null) {
            for (String key : annotations.keys()) {
                props.put(key, annotations.value(key));
            }
        }
        return props;
    }

    private void addGeoLocation(Annotated annotated, ObjectNode payload) {
        Annotations annot = annotated.annotations();
        if (annot == null) {
            return;
        }
        String slat = annot.value("latitude");
        String slng = annot.value("longitude");
        try {
            if (!Strings.isNullOrEmpty((String)slat) && !Strings.isNullOrEmpty((String)slng)) {
                double lat = Double.parseDouble(slat);
                double lng = Double.parseDouble(slng);
                ObjectNode loc = this.objectNode().put("type", "latlng").put("lat", lat).put("lng", lng);
                payload.set("location", (JsonNode)loc);
            }
        }
        catch (NumberFormatException e) {
            this.log.warn("Invalid geo data latitude={}; longitude={}", (Object)slat, (Object)slng);
        }
    }

    private String compactLinkString(Link link) {
        return String.format(COMPACT, link.src().elementId(), link.src().port(), link.dst().elementId(), link.dst().port());
    }

    private EdgeLink edgeLink(Host host, boolean isIngress) {
        ConnectPoint cp = new ConnectPoint((ElementId)host.id(), PORT_ZERO);
        return new DefaultEdgeLink(PROVIDER_ID, cp, host.location(), isIngress, new Annotations[0]);
    }

    private ObjectNode hostConnect(HostLocation loc) {
        return this.objectNode().put("device", loc.deviceId().toString()).put("port", loc.port().toLong());
    }

    private String firstIp(Set<IpAddress> addresses) {
        Iterator<IpAddress> it = addresses.iterator();
        return it.hasNext() ? it.next().toString() : "unknown";
    }

    private ArrayNode labels(String ... labels) {
        ArrayNode array = this.arrayNode();
        for (String label : labels) {
            array.add(label);
        }
        return array;
    }

    public void injectServices(MetaDb meta, ClusterService cs, DeviceService ds, LinkService ls, HostService hs, MastershipService ms) {
        this.metaDb = meta;
        this.clusterService = cs;
        this.deviceService = ds;
        this.linkService = ls;
        this.hostService = hs;
        this.mastershipService = ms;
    }

    public ObjectNode instanceMessage(ClusterEvent ev) {
        ControllerNode node = (ControllerNode)ev.subject();
        NodeId nid = node.id();
        String id = nid.toString();
        String ip = node.ip().toString();
        int switchCount = this.mastershipService.getDevicesOf(nid).size();
        ObjectNode payload = this.objectNode().put("id", id).put("ip", ip).put("online", this.clusterService.getState(nid) == ControllerNode.State.ACTIVE).put("uiAttached", node.equals(this.clusterService.getLocalNode())).put("switches", switchCount);
        ArrayNode labels = this.arrayNode().add(id).add(ip);
        payload.set("labels", (JsonNode)labels);
        this.metaDb.addMetaUi(id, payload);
        String msgType = this.messageTypeLookup(ev.type(), "addInstance");
        return JsonUtils.envelope((String)msgType, (ObjectNode)payload);
    }

    public ObjectNode deviceMessage(DeviceEvent ev) {
        Device device = (Device)ev.subject();
        DeviceId did = device.id();
        String id = did.toString();
        ObjectNode payload = this.objectNode().put("id", id).put("type", this.toLc((Object)device.type())).put("online", this.deviceService.isAvailable(did)).put("master", this.master(did));
        Annotations annot = device.annotations();
        String name = annot.value("name");
        String friendly = Strings.isNullOrEmpty((String)name) ? id : name;
        payload.set("labels", (JsonNode)this.labels(new String[]{"", friendly, id}));
        payload.set("props", (JsonNode)this.props(annot));
        this.addGeoLocation((Annotated)device, payload);
        this.metaDb.addMetaUi(id, payload);
        String msgType = this.messageTypeLookup(ev.type(), "updateDevice");
        return JsonUtils.envelope((String)msgType, (ObjectNode)payload);
    }

    public ObjectNode linkMessage(LinkEvent ev) {
        Link link = (Link)ev.subject();
        ObjectNode payload = this.objectNode().put("id", this.compactLinkString(link)).put("type", this.toLc((Object)link.type())).put("online", link.state() == Link.State.ACTIVE).put("linkWidth", 1.2).put("src", link.src().deviceId().toString()).put("srcPort", link.src().port().toString()).put("dst", link.dst().deviceId().toString()).put("dstPort", link.dst().port().toString());
        String msgType = this.messageTypeLookup(ev.type(), "updateLink");
        return JsonUtils.envelope((String)msgType, (ObjectNode)payload);
    }

    public ObjectNode hostMessage(HostEvent ev) {
        Host host = (Host)ev.subject();
        HostId hid = host.id();
        String id = hid.toString();
        Annotations annot = host.annotations();
        String hostType = annot.value("type");
        ObjectNode payload = this.objectNode().put("id", id).put("type", Strings.isNullOrEmpty((String)hostType) ? "endstation" : hostType).put("ingress", this.compactLinkString((Link)this.edgeLink(host, true))).put("egress", this.compactLinkString((Link)this.edgeLink(host, false)));
        payload.set("cp", (JsonNode)this.hostConnect(host.location()));
        String ipStr = this.firstIp(host.ipAddresses());
        String macStr = host.mac().toString();
        payload.set("labels", (JsonNode)this.labels(new String[]{ipStr, macStr}));
        payload.set("props", (JsonNode)this.props(annot));
        this.addGeoLocation((Annotated)host, payload);
        this.metaDb.addMetaUi(id, payload);
        String mstType = this.messageTypeLookup(ev.type(), "updateHost");
        return JsonUtils.envelope((String)mstType, (ObjectNode)payload);
    }

    static {
        LOOKUP.put(ClusterEvent.Type.INSTANCE_ADDED, "addInstance");
        LOOKUP.put(ClusterEvent.Type.INSTANCE_REMOVED, "removeInstance");
        LOOKUP.put(DeviceEvent.Type.DEVICE_ADDED, "addDevice");
        LOOKUP.put(DeviceEvent.Type.DEVICE_UPDATED, "updateDevice");
        LOOKUP.put(DeviceEvent.Type.DEVICE_REMOVED, "removeDevice");
        LOOKUP.put(LinkEvent.Type.LINK_ADDED, "addLink");
        LOOKUP.put(LinkEvent.Type.LINK_UPDATED, "updateLink");
        LOOKUP.put(LinkEvent.Type.LINK_REMOVED, "removeLink");
        LOOKUP.put(HostEvent.Type.HOST_ADDED, "addHost");
        LOOKUP.put(HostEvent.Type.HOST_UPDATED, "updateHost");
        LOOKUP.put(HostEvent.Type.HOST_REMOVED, "removeHost");
        MAPPER = new ObjectMapper();
    }
}

