/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.core.CoreService;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.impl.AltTopoViewMessageHandler;
import org.onosproject.ui.impl.topo.OverlayService;
import org.onosproject.ui.impl.topo.TopoUiEvent;
import org.onosproject.ui.impl.topo.TopoUiListener;
import org.onosproject.ui.impl.topo.TopoUiModelService;
import org.onosproject.ui.impl.topo.overlay.SummaryGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AltTopoViewMessageHandler
extends UiMessageHandler
implements OverlayService {
    private static final String TOPO_START = "topoStart";
    private static final String TOPO_HEARTBEAT = "topoHeartbeat";
    private static final String TOPO_STOP = "topoStop";
    private static final String REQ_SUMMARY = "requestSummary";
    private static final String CANCEL_SUMMARY = "cancelSummary";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ServiceDirectory directory;
    protected TopoUiModelService modelService;
    private ModelListener modelListener;
    private String version;
    private SummaryGenerator defaultSummaryGenerator;
    private SummaryGenerator currentSummaryGenerator;
    private boolean topoActive = false;
    private final Map<String, SummaryGenerator> summGenCache = Maps.newHashMap();
    private ModelEventHandler passThruHandler = event -> {
        ObjectNode message = (ObjectNode)event.subject();
        if (message != null) {
            this.sendMessages((ObjectNode)event.subject());
        }
    };
    private ModelEventHandler summaryHandler = event -> {
        ObjectNode payload = this.currentSummaryGenerator.generateSummary();
        this.sendMessages(JsonUtils.envelope((String)"showSummary", (ObjectNode)payload));
    };
    private final Map<TopoUiEvent.Type, ModelEventHandler> eventHandlerBinding = new HashMap();

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.directory = (ServiceDirectory)Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.modelService = (TopoUiModelService)directory.get(TopoUiModelService.class);
        this.defaultSummaryGenerator = new DefSummaryGenerator(this, "node", "ONOS Summary");
        this.bindEventHandlers();
        this.modelListener = new ModelListener(this, null);
        this.version = this.getVersion();
        this.currentSummaryGenerator = this.defaultSummaryGenerator;
    }

    public void destroy() {
        this.cancelAllMonitoring();
        this.stopListeningToModel();
        super.destroy();
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new TopoStart(this, null), (Object)new TopoHeartbeat(this, null), (Object)new TopoStop(this, null), (Object)new ReqSummary(this, null), (Object)new CancelSummary(this, null));
    }

    private void cancelAllMonitoring() {
    }

    private void startListeningToModel() {
        this.topoActive = true;
        this.modelService.addListener((TopoUiListener)this.modelListener);
    }

    private void stopListeningToModel() {
        this.topoActive = false;
        this.modelService.removeListener((TopoUiListener)this.modelListener);
    }

    private String getVersion() {
        String ver = ((CoreService)this.directory.get(CoreService.class)).version().toString();
        return ver.replace(".SNAPSHOT", "*").replaceFirst("~.*$", "");
    }

    public void addSummaryGenerator(String overlayId, SummaryGenerator generator) {
        this.log.info("Adding custom Summary Generator for overlay [{}]", (Object)overlayId);
        this.summGenCache.put(overlayId, generator);
    }

    public void removeSummaryGenerator(String overlayId) {
        this.summGenCache.remove(overlayId);
        this.log.info("Custom Summary Generator for overlay [{}] removed", (Object)overlayId);
    }

    private void sendMessages(Collection<ObjectNode> messages) {
        UiConnection connection;
        if (this.topoActive && (connection = this.connection()) != null) {
            messages.forEach(arg_0 -> ((UiConnection)connection).sendMessage(arg_0));
        }
    }

    private void sendMessages(ObjectNode message) {
        UiConnection connection;
        if (this.topoActive && (connection = this.connection()) != null) {
            connection.sendMessage(message);
        }
    }

    private void bindEventHandlers() {
        this.eventHandlerBinding.put(TopoUiEvent.Type.SUMMARY_UPDATE, this.summaryHandler);
    }

    static /* synthetic */ void access$600(AltTopoViewMessageHandler x0) {
        x0.startListeningToModel();
    }

    static /* synthetic */ void access$700(AltTopoViewMessageHandler x0, Collection x1) {
        x0.sendMessages(x1);
    }

    static /* synthetic */ ModelListener access$800(AltTopoViewMessageHandler x0) {
        return x0.modelListener;
    }

    static /* synthetic */ void access$900(AltTopoViewMessageHandler x0) {
        x0.stopListeningToModel();
    }

    static /* synthetic */ String access$1000(AltTopoViewMessageHandler x0) {
        return x0.version;
    }

    static /* synthetic */ Logger access$1100(AltTopoViewMessageHandler x0) {
        return x0.log;
    }

    static /* synthetic */ Map access$1200(AltTopoViewMessageHandler x0) {
        return x0.eventHandlerBinding;
    }

    static /* synthetic */ ModelEventHandler access$1300(AltTopoViewMessageHandler x0) {
        return x0.passThruHandler;
    }
}

