/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.impl.AbstractInjectionResource;

@Path(value="/")
public class MainIndexResource
extends AbstractInjectionResource {
    private static final String INDEX = "index.html";
    private static final String INJECT_CSS_START = "<!-- {INJECTED-STYLESHEETS-START} -->";
    private static final String INJECT_CSS_END = "<!-- {INJECTED-STYLESHEETS-END} -->";
    private static final String INJECT_JS_START = "<!-- {INJECTED-JAVASCRIPT-START} -->";
    private static final String INJECT_JS_END = "<!-- {INJECTED-JAVASCRIPT-END} -->";

    @GET
    @Produces(value={"text/html"})
    public Response getMainIndex() throws IOException {
        UiExtensionService service = (UiExtensionService)this.get(UiExtensionService.class);
        InputStream indexTemplate = this.getClass().getClassLoader().getResourceAsStream(INDEX);
        String index = new String(ByteStreams.toByteArray((InputStream)indexTemplate));
        int p1s = this.split(index, 0, INJECT_JS_START);
        int p1e = this.split(index, p1s, INJECT_JS_END);
        int p2s = this.split(index, p1e, INJECT_CSS_START);
        int p2e = this.split(index, p2s, INJECT_CSS_END);
        int p3s = this.split(index, p2e, null);
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(index, 0, p1s), (Object)this.includeJs(service), (Object)this.stream(index, p1e, p2s), (Object)this.includeCss(service), (Object)this.stream(index, p2e, p3s)));
        return Response.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).build();
    }

    private InputStream includeCss(UiExtensionService service) {
        ImmutableList.Builder builder = ImmutableList.builder();
        service.getExtensions().forEach(ext -> this.add(builder, ext.css()));
        return new SequenceInputStream((Enumeration<? extends InputStream>)new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)builder.build()));
    }

    private InputStream includeJs(UiExtensionService service) {
        ImmutableList.Builder builder = ImmutableList.builder();
        service.getExtensions().forEach(ext -> this.add(builder, ext.js()));
        return new SequenceInputStream((Enumeration<? extends InputStream>)new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)builder.build()));
    }

    private void add(ImmutableList.Builder<InputStream> builder, InputStream inputStream) {
        if (inputStream != null) {
            builder.add((Object)inputStream);
        }
    }
}

