/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onosproject.ui.UiExtension;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiView;
import org.onosproject.ui.impl.AbstractInjectionResource;

@Path(value="/")
public class MainNavResource
extends AbstractInjectionResource {
    private static final String NAV_HTML = "nav.html";
    private static final String INJECT_VIEW_ITEMS_START = "<!-- {INJECTED-VIEW-NAV-START} -->";
    private static final String INJECT_VIEW_ITEMS_END = "<!-- {INJECTED-VIEW-NAV-END} -->";
    private static final String HDR_FORMAT = "<div class=\"nav-hdr\">%s</div>\n";
    private static final String NAV_FORMAT = "<a ng-click=\"navCtrl.hideNav()\" href=\"#/%s\">%s %s</a>\n";
    private static final String BLANK_GLYPH = "unknown";

    @GET
    @Produces(value={"text/html"})
    public Response getNavigation() throws IOException {
        UiExtensionService service = (UiExtensionService)this.get(UiExtensionService.class);
        InputStream navTemplate = this.getClass().getClassLoader().getResourceAsStream(NAV_HTML);
        String html = new String(ByteStreams.toByteArray((InputStream)navTemplate));
        int p1s = this.split(html, 0, INJECT_VIEW_ITEMS_START);
        int p1e = this.split(html, 0, INJECT_VIEW_ITEMS_END);
        int p2s = this.split(html, p1e, null);
        AbstractInjectionResource.StreamEnumeration streams = new AbstractInjectionResource.StreamEnumeration((AbstractInjectionResource)this, (List)ImmutableList.of((Object)this.stream(html, 0, p1s), (Object)this.includeNavItems(service), (Object)this.stream(html, p1e, p2s)));
        return Response.ok((Object)new SequenceInputStream((Enumeration<? extends InputStream>)streams)).build();
    }

    private InputStream includeNavItems(UiExtensionService service) {
        List extensions = service.getExtensions();
        StringBuilder sb = new StringBuilder("\n");
        for (UiView.Category cat : UiView.Category.values()) {
            List catViews;
            if (cat == UiView.Category.HIDDEN || (catViews = this.getViewsForCat(extensions, cat)).isEmpty()) continue;
            this.addCatHeader(sb, cat);
            this.addCatItems(sb, catViews);
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private List<UiView> getViewsForCat(List<UiExtension> extensions, UiView.Category cat) {
        ArrayList<UiView> views = new ArrayList<UiView>();
        for (UiExtension extension : extensions) {
            views.addAll(extension.views().stream().filter(view -> cat.equals((Object)view.category())).collect(Collectors.toList()));
        }
        return views;
    }

    private void addCatHeader(StringBuilder sb, UiView.Category cat) {
        sb.append(String.format(HDR_FORMAT, cat.label()));
    }

    private void addCatItems(StringBuilder sb, List<UiView> catViews) {
        for (UiView view : catViews) {
            sb.append(String.format(NAV_FORMAT, view.id(), this.icon(view), view.label()));
        }
    }

    private String icon(UiView view) {
        String gid = view.iconId() == null ? BLANK_GLYPH : view.iconId();
        return "<div icon icon-id=\"" + gid + "\"></div>";
    }
}

