/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.websocket.WebSocket;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.UiMessageHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiWebSocket
implements UiConnection,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger log = LoggerFactory.getLogger(UiWebSocket.class);
    private static final long MAX_AGE_MS = 30000L;
    private static final byte PING = 9;
    private static final byte PONG = 10;
    private static final byte[] PING_DATA = new byte[]{-34, -83};
    private final ServiceDirectory directory;
    private WebSocket.Connection connection;
    private WebSocket.FrameConnection control;
    private final ObjectMapper mapper = new ObjectMapper();
    private long lastActive = System.currentTimeMillis();
    private Map<String, UiMessageHandler> handlers;

    public UiWebSocket(ServiceDirectory directory) {
        this.directory = directory;
    }

    synchronized void close() {
        this.destroyHandlers();
        if (this.connection.isOpen()) {
            this.connection.close();
        }
    }

    synchronized boolean isIdle() {
        boolean idle;
        long quietFor = System.currentTimeMillis() - this.lastActive;
        boolean bl = idle = quietFor > 30000L;
        if (idle || this.connection != null && !this.connection.isOpen()) {
            log.debug("IDLE (or closed) websocket [{} ms]", (Object)quietFor);
            return true;
        }
        if (this.connection != null) {
            try {
                this.control.sendControl((byte)9, PING_DATA, 0, PING_DATA.length);
            }
            catch (IOException e) {
                log.warn("Unable to send ping message due to: ", (Throwable)e);
            }
        }
        return false;
    }

    public void onOpen(WebSocket.Connection connection) {
        this.connection = connection;
        this.control = (WebSocket.FrameConnection)connection;
        try {
            this.createHandlers();
            this.sendInstanceData();
            log.info("GUI client connected");
        }
        catch (ServiceNotFoundException e) {
            log.warn("Unable to open GUI connection; services have been shut-down");
            this.connection.close();
            this.connection = null;
            this.control = null;
        }
    }

    public synchronized void onClose(int closeCode, String message) {
        this.destroyHandlers();
        log.info("GUI client disconnected [close-code={}, message={}]", (Object)closeCode, (Object)message);
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        this.lastActive = System.currentTimeMillis();
        return true;
    }

    public void onMessage(String data) {
        this.lastActive = System.currentTimeMillis();
        try {
            ObjectNode message = (ObjectNode)this.mapper.reader().readTree(data);
            String type = message.path("event").asText("unknown");
            UiMessageHandler handler = (UiMessageHandler)this.handlers.get(type);
            if (handler != null) {
                handler.process(message);
            } else {
                log.warn("No GUI message handler for type {}", (Object)type);
            }
        }
        catch (Exception e) {
            log.warn("Unable to parse GUI message {} due to {}", (Object)data, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    public synchronized void sendMessage(ObjectNode message) {
        try {
            if (this.connection.isOpen()) {
                this.connection.sendMessage(message.toString());
            }
        }
        catch (IOException e) {
            log.warn("Unable to send message {} to GUI due to {}", (Object)message, (Object)e);
            log.debug("Boom!!!", (Throwable)e);
        }
    }

    public synchronized void sendMessage(String type, long sid, ObjectNode payload) {
        ObjectNode message = this.mapper.createObjectNode();
        message.put("event", type);
        if (sid > 0L) {
            message.put("sid", sid);
        }
        message.set("payload", (JsonNode)payload);
        this.sendMessage(message);
    }

    private synchronized void createHandlers() {
        this.handlers = new HashMap();
        UiExtensionService service = (UiExtensionService)this.directory.get(UiExtensionService.class);
        service.getExtensions().forEach(ext -> {
            UiMessageHandlerFactory factory = ext.messageHandlerFactory();
            if (factory != null) {
                factory.newHandlers().forEach(handler -> {
                    handler.init((UiConnection)this, this.directory);
                    handler.messageTypes().forEach(type -> this.handlers.put(type, handler));
                });
            }
        });
    }

    private synchronized void destroyHandlers() {
        this.handlers.forEach((type, handler) -> handler.destroy());
        this.handlers.clear();
    }

    private void sendInstanceData() {
        ClusterService service = (ClusterService)this.directory.get(ClusterService.class);
        ArrayNode instances = this.mapper.createArrayNode();
        for (ControllerNode node : service.getNodes()) {
            ObjectNode instance = this.mapper.createObjectNode().put("id", node.id().toString()).put("ip", node.ip().toString()).put("uiAttached", node.equals(service.getLocalNode()));
            instances.add((JsonNode)instance);
        }
        ObjectNode payload = this.mapper.createObjectNode();
        payload.set("clusterNodes", (JsonNode)instances);
        this.sendMessage("bootstrap", 0L, payload);
    }
}

