/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.cluster.ClusterEvent;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.EventSink;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.impl.topo.MetaDb;
import org.onosproject.ui.impl.topo.ModelListenerRegistry;
import org.onosproject.ui.impl.topo.SummaryData;
import org.onosproject.ui.impl.topo.TopoMessageFactory;
import org.onosproject.ui.impl.topo.TopoUiEvent;
import org.onosproject.ui.impl.topo.TopoUiListener;
import org.onosproject.ui.impl.topo.TopoUiModelManager;
import org.onosproject.ui.impl.topo.TopoUiModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TopoUiModelManager
implements TopoUiModelService {
    private static final long SUMMARY_PERIOD = 15000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowRuleService flowRuleService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;
    private final ModelListenerRegistry listenerRegistry = new ModelListenerRegistry();
    private final TopoMessageFactory messageFactory = new TopoMessageFactory();
    private final MetaDb metaDb = new MetaDb();
    private final Timer timer = new Timer("topology-view");
    private TimerTask summaryTask = null;
    private boolean summaryRunning = false;
    private static final Comparator<? super ControllerNode> NODE_COMPARATOR = (o1, o2) -> o1.id().toString().compareTo(o2.id().toString());

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(TopoUiEvent.class, (EventSink)this.listenerRegistry);
        this.messageFactory.injectServices(this.metaDb, this.clusterService, this.deviceService, this.linkService, this.hostService, this.mastershipService);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(TopoUiEvent.class);
        this.log.info("Stopped");
    }

    public void addListener(TopoUiListener listener) {
        this.listenerRegistry.addListener((EventListener)listener);
    }

    public void removeListener(TopoUiListener listener) {
        this.listenerRegistry.removeListener((EventListener)listener);
    }

    public List<ObjectNode> getInitialState() {
        ArrayList<ObjectNode> results = new ArrayList<ObjectNode>();
        this.addInstances(results);
        this.addDevices(results);
        this.addLinks(results);
        this.addHosts(results);
        return results;
    }

    public synchronized void startSummaryMonitoring() {
        this.stopSummaryMonitoring();
        this.summaryTask = new /* Unavailable Anonymous Inner Class!! */;
        this.timer.schedule(this.summaryTask, 0L, 15000L);
        this.summaryRunning = true;
    }

    public synchronized void stopSummaryMonitoring() {
        if (this.summaryTask != null) {
            this.summaryTask.cancel();
            this.summaryTask = null;
        }
        this.summaryRunning = false;
    }

    public SummaryData getSummaryData() {
        return new SummaryDataImpl(this, null);
    }

    private void addInstances(List<ObjectNode> results) {
        ArrayList nodes = new ArrayList(this.clusterService.getNodes());
        Collections.sort(nodes, NODE_COMPARATOR);
        for (ControllerNode node : nodes) {
            ClusterEvent ev = new ClusterEvent(ClusterEvent.Type.INSTANCE_ADDED, node);
            results.add(this.messageFactory.instanceMessage(ev));
        }
    }

    private void addDevices(List<ObjectNode> results) {
        ArrayList<DeviceEvent> deferred = new ArrayList<DeviceEvent>();
        for (Device device : this.deviceService.getDevices()) {
            DeviceEvent ev = new DeviceEvent(DeviceEvent.Type.DEVICE_ADDED, device);
            if (device.type() == Device.Type.ROADM) {
                results.add(this.messageFactory.deviceMessage(ev));
                continue;
            }
            deferred.add(ev);
        }
        for (DeviceEvent ev : deferred) {
            results.add(this.messageFactory.deviceMessage(ev));
        }
    }

    private void addLinks(List<ObjectNode> results) {
        ArrayList<LinkEvent> deferred = new ArrayList<LinkEvent>();
        for (Link link : this.linkService.getLinks()) {
            LinkEvent ev = new LinkEvent(LinkEvent.Type.LINK_ADDED, link);
            if (link.type() == Link.Type.OPTICAL) {
                results.add(this.messageFactory.linkMessage(ev));
                continue;
            }
            deferred.add(ev);
        }
        for (LinkEvent ev : deferred) {
            results.add(this.messageFactory.linkMessage(ev));
        }
    }

    private void addHosts(List<ObjectNode> results) {
        for (Host host : this.hostService.getHosts()) {
            HostEvent ev = new HostEvent(HostEvent.Type.HOST_ADDED, host);
            results.add(this.messageFactory.hostMessage(ev));
        }
    }

    private void post(TopoUiEvent event) {
        if (event != null) {
            this.eventDispatcher.post((Event)event);
        }
    }

    static /* synthetic */ boolean access$000(TopoUiModelManager x0) {
        return x0.summaryRunning;
    }

    static /* synthetic */ void access$100(TopoUiModelManager x0, TopoUiEvent x1) {
        x0.post(x1);
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindFlowRuleService(FlowRuleService flowRuleService) {
        this.flowRuleService = flowRuleService;
    }

    protected void unbindFlowRuleService(FlowRuleService flowRuleService) {
        if (this.flowRuleService == flowRuleService) {
            this.flowRuleService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }
}

