/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.store.service.TestStorageService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.topo.UiTopoLayoutManager;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class UiTopoLayoutManagerTest {
    private UiTopoLayoutService svc;
    private UiTopoLayoutManager mgr;
    private static final UiTopoLayout L1 = new UiTopoLayout(UiTopoLayoutId.layoutId((String)"l1"), (Region)new DefaultRegion(RegionId.regionId((String)"r1"), "R1", Region.Type.CAMPUS, null), null);
    private static final UiTopoLayout L2 = new UiTopoLayout(UiTopoLayoutId.layoutId((String)"l2"), (Region)new DefaultRegion(RegionId.regionId((String)"r2"), "R2", Region.Type.CAMPUS, null), null);

    @Before
    public void setUp() {
        this.mgr = new UiTopoLayoutManager();
        this.svc = this.mgr;
        this.mgr.storageService = new TestStorageService();
        this.mgr.activate();
    }

    @After
    public void tearDown() {
        this.mgr.deactivate();
        this.mgr.storageService = null;
    }

    @Test
    public void basics() {
        Assert.assertEquals((String)"should be just default layout", (long)1L, (long)this.svc.getLayouts().size());
        this.svc.addLayout(L1);
        this.svc.addLayout(L2);
        Assert.assertEquals((String)"incorrect number of layouts", (long)3L, (long)this.svc.getLayouts().size());
        Assert.assertEquals((String)"incorrect layout", (Object)L1.id(), (Object)this.svc.getLayout(L1.id()).id());
        Assert.assertEquals((String)"incorrect layout", (Object)L2.id(), (Object)this.svc.getLayout(L2.id()).id());
        this.svc.removeLayout(L1);
        Assert.assertEquals((String)"incorrect number of layouts", (long)2L, (long)this.svc.getLayouts().size());
        Assert.assertNull((String)"layout should be gone", (Object)this.svc.getLayout(L1.id()));
        Assert.assertEquals((String)"incorrect layout", (Object)L2.id(), (Object)this.svc.getLayout(L2.id()).id());
    }
}

