/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.model;

import java.util.Collection;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.cluster.NodeId;
import org.onosproject.event.Event;
import org.onosproject.event.EventDispatcher;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.region.Region;
import org.onosproject.ui.impl.topo.model.AbstractTopoModelTest;
import org.onosproject.ui.impl.topo.model.ModelCache;
import org.onosproject.ui.impl.topo.model.UiModelEvent;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiLinkId;
import org.onosproject.ui.model.topo.UiRegion;

public class ModelCacheTest
extends AbstractTopoModelTest {
    private final TestEvDisp dispatcher = new TestEvDisp();
    private ModelCache cache;
    private static final String[] LINKS_2_7 = new String[]{"d2", "27", "d7", "72"};

    private void assertContains(String msg, Collection<?> coll, Object ... things) {
        for (Object o : things) {
            Assert.assertTrue((String)msg, (boolean)coll.contains(o));
        }
    }

    @Before
    public void setUp() {
        this.cache = new ModelCache(MOCK_SERVICES, (EventDispatcher)this.dispatcher);
    }

    @Test
    public void basic() {
        this.title("basic");
        this.print(this.cache);
        Assert.assertEquals((String)"unex # members", (long)0L, (long)this.cache.clusterMemberCount());
        Assert.assertEquals((String)"unex # regions", (long)0L, (long)this.cache.regionCount());
    }

    @Test
    public void addAndRemoveClusterMember() {
        this.title("addAndRemoveClusterMember");
        this.print(this.cache);
        Assert.assertEquals((String)"unex # members", (long)0L, (long)this.cache.clusterMemberCount());
        this.dispatcher.assertEventCount(0);
        this.cache.addOrUpdateClusterMember(CNODE_1);
        this.print(this.cache);
        Assert.assertEquals((String)"unex # members", (long)1L, (long)this.cache.clusterMemberCount());
        this.dispatcher.assertEventCount(1);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C1");
        this.cache.removeClusterMember(CNODE_1);
        this.print(this.cache);
        Assert.assertEquals((String)"unex # members", (long)0L, (long)this.cache.clusterMemberCount());
        this.dispatcher.assertEventCount(2);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_REMOVED, "C1");
    }

    @Test
    public void nonExistentClusterMember() {
        this.title("nonExistentClusterMember");
        this.cache.addOrUpdateClusterMember(CNODE_1);
        this.print(this.cache);
        Assert.assertEquals((String)"unex # members", (long)1L, (long)this.cache.clusterMemberCount());
        this.dispatcher.assertEventCount(1);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C1");
        this.cache.removeClusterMember(CNODE_2);
        Assert.assertEquals((String)"unex # members", (long)1L, (long)this.cache.clusterMemberCount());
        this.dispatcher.assertEventCount(1);
    }

    @Test
    public void createThreeNodeCluster() {
        this.title("createThreeNodeCluster");
        this.cache.addOrUpdateClusterMember(CNODE_1);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C1");
        this.cache.addOrUpdateClusterMember(CNODE_2);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C2");
        this.cache.addOrUpdateClusterMember(CNODE_3);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C3");
        this.dispatcher.assertEventCount(3);
        this.print(this.cache);
    }

    @Test
    public void addNodeThenExamineIt() {
        this.title("addNodeThenExamineIt");
        this.cache.addOrUpdateClusterMember(CNODE_1);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C1");
        UiClusterMember member = this.cache.accessClusterMember(NodeId.nodeId((String)"C1"));
        this.print(member);
        Assert.assertEquals((String)"wrong id str", (Object)"C1", (Object)member.idAsString());
        Assert.assertEquals((String)"wrong id", (Object)NodeId.nodeId((String)"C1"), (Object)member.id());
        Assert.assertEquals((String)"wrong dev count", (long)3L, (long)member.deviceCount());
        Assert.assertEquals((String)"not online", (Object)true, (Object)member.isOnline());
        Assert.assertEquals((String)"not ready", (Object)true, (Object)member.isReady());
        this.assertMasterOf(member, DEVID_1, DEVID_2, DEVID_3);
        this.assertNotMasterOf(member, DEVID_4, DEVID_6, DEVID_9);
    }

    private void assertMasterOf(UiClusterMember member, DeviceId ... ids) {
        for (DeviceId id : ids) {
            Assert.assertTrue((String)("not master of " + id), (boolean)member.masterOf(id));
        }
    }

    private void assertNotMasterOf(UiClusterMember member, DeviceId ... ids) {
        for (DeviceId id : ids) {
            Assert.assertFalse((String)("? master of " + id), (boolean)member.masterOf(id));
        }
    }

    @Test
    public void addNodeAndDevices() {
        this.title("addNodeAndDevices");
        this.cache.addOrUpdateClusterMember(CNODE_1);
        this.dispatcher.assertLast(UiModelEvent.Type.CLUSTER_MEMBER_ADDED_OR_UPDATED, "C1");
        this.cache.addOrUpdateDevice(DEV_1);
        this.dispatcher.assertLast(UiModelEvent.Type.DEVICE_ADDED_OR_UPDATED, "d1");
        this.cache.addOrUpdateDevice(DEV_2);
        this.dispatcher.assertLast(UiModelEvent.Type.DEVICE_ADDED_OR_UPDATED, "d2");
        this.cache.addOrUpdateDevice(DEV_3);
        this.dispatcher.assertLast(UiModelEvent.Type.DEVICE_ADDED_OR_UPDATED, "d3");
        this.dispatcher.assertEventCount(4);
        this.print(this.cache);
        Assert.assertEquals((String)"unex # nodes", (long)1L, (long)this.cache.clusterMemberCount());
        Assert.assertEquals((String)"unex # devices", (long)3L, (long)this.cache.deviceCount());
        this.cache.removeDevice(DEV_4);
        Assert.assertEquals((String)"unex # devices", (long)3L, (long)this.cache.deviceCount());
        this.dispatcher.assertEventCount(4);
        this.cache.removeDevice(DEV_2);
        this.dispatcher.assertLast(UiModelEvent.Type.DEVICE_REMOVED, "d2");
        this.dispatcher.assertEventCount(5);
        UiDevice dev = this.cache.accessDevice(DEVID_1);
        Assert.assertEquals((String)"wrong id", (Object)"d1", (Object)dev.idAsString());
        Assert.assertEquals((String)"wrong region", (Object)"R1", (Object)dev.regionId().toString());
        Device d = dev.backingDevice();
        Assert.assertEquals((String)"wrong serial", (Object)"ser123", (Object)d.serialNumber());
    }

    @Test
    public void addRegions() {
        this.title("addRegions");
        this.cache.addOrUpdateRegion(REGION_1);
        this.dispatcher.assertLast(UiModelEvent.Type.REGION_ADDED_OR_UPDATED, "R1");
        this.dispatcher.assertEventCount(1);
        Assert.assertEquals((String)"unex # regions", (long)1L, (long)this.cache.regionCount());
        this.cache.addOrUpdateRegion(REGION_2);
        this.dispatcher.assertLast(UiModelEvent.Type.REGION_ADDED_OR_UPDATED, "R2");
        this.dispatcher.assertEventCount(2);
        Assert.assertEquals((String)"unex # regions", (long)2L, (long)this.cache.regionCount());
        this.print(this.cache);
        this.cache.removeRegion(REGION_3);
        this.dispatcher.assertEventCount(2);
        Assert.assertEquals((String)"unex # regions", (long)2L, (long)this.cache.regionCount());
        this.cache.removeRegion(REGION_1);
        this.dispatcher.assertLast(UiModelEvent.Type.REGION_REMOVED, "R1");
        this.dispatcher.assertEventCount(3);
        Assert.assertEquals((String)"unex # regions", (long)1L, (long)this.cache.regionCount());
        this.print(this.cache);
        UiRegion region = this.cache.accessRegion(REGION_2.id());
        Assert.assertEquals((String)"wrong id", (Object)REGION_2.id(), (Object)region.id());
        Assert.assertEquals((String)"unex # device IDs", (long)3L, (long)region.deviceIds().size());
        this.assertContains("missing ID", region.deviceIds(), DEVID_4, DEVID_5, DEVID_6);
        Region r = region.backingRegion();
        this.print(r);
        Assert.assertEquals((String)"wrong region name", (Object)"Region-R2", (Object)r.name());
    }

    @Test
    public void addLinks() {
        this.title("addLinks");
        Iterator<Link> iter = ModelCacheTest.makeLinkPair(LINKS_2_7).iterator();
        Link link1 = iter.next();
        Link link2 = iter.next();
        this.print(link1);
        this.print(link2);
        UiLinkId idA2B = UiLinkId.uiLinkId((Link)link1);
        UiLinkId idB2A = UiLinkId.uiLinkId((Link)link2);
        Assert.assertEquals((String)"not same link ID", (Object)idA2B, (Object)idB2A);
        UiLinkId linkId = idA2B;
        this.cache.addOrUpdateLink(link1);
        this.dispatcher.assertLast(UiModelEvent.Type.LINK_ADDED_OR_UPDATED, linkId.toString());
        this.dispatcher.assertEventCount(1);
        Assert.assertEquals((String)"unex # links", (long)1L, (long)this.cache.linkCount());
        UiLink link = this.cache.accessLink(linkId);
        Assert.assertEquals((String)"dev A not d2", (Object)DEVID_2, (Object)link.deviceA());
        Assert.assertEquals((String)"dev B not d7", (Object)DEVID_7, (Object)link.deviceB());
        Assert.assertEquals((String)"wrong backing link A-B", (Object)link1, (Object)link.linkAtoB());
        Assert.assertEquals((String)"backing link B-A?", null, (Object)link.linkBtoA());
        this.cache.addOrUpdateLink(link2);
        this.dispatcher.assertLast(UiModelEvent.Type.LINK_ADDED_OR_UPDATED, linkId.toString());
        this.dispatcher.assertEventCount(2);
        Assert.assertEquals((String)"unex # links", (long)1L, (long)this.cache.linkCount());
        link = this.cache.accessLink(linkId);
        Assert.assertEquals((String)"dev A not d2", (Object)DEVID_2, (Object)link.deviceA());
        Assert.assertEquals((String)"dev B not d7", (Object)DEVID_7, (Object)link.deviceB());
        Assert.assertEquals((String)"wrong backing link A-B", (Object)link1, (Object)link.linkAtoB());
        Assert.assertEquals((String)"wrong backing link B-A", (Object)link2, (Object)link.linkBtoA());
        this.cache.removeLink(link1);
        this.dispatcher.assertLast(UiModelEvent.Type.LINK_ADDED_OR_UPDATED, linkId.toString());
        this.dispatcher.assertEventCount(3);
        Assert.assertEquals((String)"unex # links", (long)1L, (long)this.cache.linkCount());
        link = this.cache.accessLink(linkId);
        Assert.assertEquals((String)"dev A not d2", (Object)DEVID_2, (Object)link.deviceA());
        Assert.assertEquals((String)"dev B not d7", (Object)DEVID_7, (Object)link.deviceB());
        Assert.assertEquals((String)"backing link A-B?", null, (Object)link.linkAtoB());
        Assert.assertEquals((String)"wrong backing link B-A", (Object)link2, (Object)link.linkBtoA());
        this.cache.removeLink(link2);
        this.dispatcher.assertLast(UiModelEvent.Type.LINK_REMOVED, linkId.toString());
        this.dispatcher.assertEventCount(4);
        Assert.assertEquals((String)"unex # links", (long)0L, (long)this.cache.linkCount());
    }

    private void assertHostLinkCounts(int nHosts, int nLinks) {
        Assert.assertEquals((String)"unex # hosts", (long)nHosts, (long)this.cache.hostCount());
        Assert.assertEquals((String)"unex # links", (long)nLinks, (long)this.cache.linkCount());
    }

    private void assertLocation(HostId hid, DeviceId expDev, int expPort) {
        UiHost h = this.cache.accessHost(hid);
        Assert.assertEquals((String)"unex device", (Object)expDev, (Object)h.locationDevice());
        Assert.assertEquals((String)"unex port", (Object)PortNumber.portNumber((long)expPort), (Object)h.locationPort());
    }

    @Test
    public void addHosts() {
        this.title("addHosts");
        this.assertHostLinkCounts(0, 0);
        Host hostA = ModelCacheTest.createHost(DEV_1, 101, "a");
        Host hostB = ModelCacheTest.createHost(DEV_1, 102, "b");
        this.cache.addOrUpdateHost(hostA);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_ADDED_OR_UPDATED, hostA.id().toString());
        this.dispatcher.assertEventCount(1);
        this.assertHostLinkCounts(1, 1);
        this.assertLocation(hostA.id(), DEVID_1, 101);
        this.cache.addOrUpdateHost(hostB);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_ADDED_OR_UPDATED, hostB.id().toString());
        this.dispatcher.assertEventCount(2);
        this.assertHostLinkCounts(2, 2);
        this.assertLocation(hostB.id(), DEVID_1, 102);
        this.cache.addOrUpdateHost(hostA);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_ADDED_OR_UPDATED, hostA.id().toString());
        this.dispatcher.assertEventCount(3);
        this.assertHostLinkCounts(2, 2);
        this.assertLocation(hostA.id(), DEVID_1, 101);
        this.print(this.cache.dumpString());
        this.cache.removeHost(hostB);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_REMOVED, hostB.id().toString());
        this.dispatcher.assertEventCount(4);
        this.assertHostLinkCounts(1, 1);
        Assert.assertNull((String)"still host B?", (Object)this.cache.accessHost(hostB.id()));
        this.print(this.cache.dumpString());
        this.assertLocation(hostA.id(), DEVID_1, 101);
        Host movedHost = ModelCacheTest.createHost(DEV_1, 200, "a");
        this.print(hostA);
        this.print(movedHost);
        this.cache.moveHost(movedHost, hostA);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_MOVED, hostA.id().toString());
        this.dispatcher.assertEventCount(5);
        this.assertHostLinkCounts(1, 1);
        this.assertLocation(hostA.id(), DEVID_1, 200);
        this.print(this.cache.dumpString());
        Host movedAgain = ModelCacheTest.createHost(DEV_8, 800, "a");
        this.cache.moveHost(movedAgain, movedHost);
        this.dispatcher.assertLast(UiModelEvent.Type.HOST_MOVED, hostA.id().toString());
        this.dispatcher.assertEventCount(6);
        this.assertHostLinkCounts(1, 1);
        this.assertLocation(hostA.id(), DEVID_8, 800);
        this.print(this.cache.dumpString());
    }

    @Test
    public void load() {
        this.title("load");
        this.cache.load();
        this.print(this.cache.dumpString());
        Assert.assertEquals((String)"unex # cnodes", (long)3L, (long)this.cache.clusterMemberCount());
        Assert.assertEquals((String)"unex # regions", (long)3L, (long)this.cache.regionCount());
        Assert.assertEquals((String)"unex # devices", (long)9L, (long)this.cache.deviceCount());
        Assert.assertEquals((String)"unex # hosts", (long)18L, (long)this.cache.hostCount());
        Assert.assertEquals((String)"unex # hosts", (long)26L, (long)this.cache.linkCount());
    }

    private class TestEvDisp
    implements EventDispatcher {
        private Event<UiModelEvent.Type, UiElement> lastEvent = null;
        private int eventCount = 0;

        private TestEvDisp() {
        }

        public void post(Event event) {
            this.lastEvent = event;
            ++this.eventCount;
        }

        private void assertEventCount(int exp) {
            Assert.assertEquals((String)"unex event count", (long)exp, (long)this.eventCount);
        }

        private void assertLast(UiModelEvent.Type expEventType, String expId) {
            Assert.assertNotNull((String)"no last event", this.lastEvent);
            Assert.assertEquals((String)"unex event type", (Object)expEventType, (Object)this.lastEvent.type());
            Assert.assertEquals((String)"unex element ID", (Object)expId, (Object)((UiElement)this.lastEvent.subject()).idAsString());
        }
    }
}

