/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.ClusterServiceAdapter;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.DefaultControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.RoleInfo;
import org.onosproject.mastership.MastershipService;
import org.onosproject.mastership.MastershipServiceAdapter;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.DeviceServiceAdapter;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.host.HostServiceAdapter;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.link.LinkServiceAdapter;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.net.region.RegionListener;
import org.onosproject.net.region.RegionService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.AbstractUiImplTest;
import org.onosproject.ui.model.ServiceBundle;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

abstract class AbstractTopoModelTest
extends AbstractUiImplTest {
    protected static final String C1 = "C1";
    protected static final String C2 = "C2";
    protected static final String C3 = "C3";
    protected static final NodeId CNID_1 = NodeId.nodeId((String)"C1");
    protected static final NodeId CNID_2 = NodeId.nodeId((String)"C2");
    protected static final NodeId CNID_3 = NodeId.nodeId((String)"C3");
    protected static final ControllerNode CNODE_1 = AbstractTopoModelTest.cnode(CNID_1, "10.0.0.1");
    protected static final ControllerNode CNODE_2 = AbstractTopoModelTest.cnode(CNID_2, "10.0.0.2");
    protected static final ControllerNode CNODE_3 = AbstractTopoModelTest.cnode(CNID_3, "10.0.0.3");
    protected static final String R1 = "R1";
    protected static final String R2 = "R2";
    protected static final String R3 = "R3";
    protected static final Set<NodeId> SET_C1 = ImmutableSet.of((Object)CNID_1);
    protected static final Set<NodeId> SET_C2 = ImmutableSet.of((Object)CNID_2);
    protected static final Set<NodeId> SET_C3 = ImmutableSet.of((Object)CNID_3);
    protected static final Region REGION_1 = AbstractTopoModelTest.region("R1", Region.Type.METRO, (List<Set<NodeId>>)ImmutableList.of(SET_C1, SET_C2));
    protected static final Region REGION_2 = AbstractTopoModelTest.region("R2", Region.Type.CAMPUS, (List<Set<NodeId>>)ImmutableList.of(SET_C2, SET_C1));
    protected static final Region REGION_3 = AbstractTopoModelTest.region("R3", Region.Type.CAMPUS, (List<Set<NodeId>>)ImmutableList.of(SET_C3, SET_C1));
    protected static final Set<Region> REGION_SET = ImmutableSet.of((Object)REGION_1, (Object)REGION_2, (Object)REGION_3);
    protected static final String LROOT = "LROOT";
    protected static final String L1 = "L1";
    protected static final String L2 = "L2";
    protected static final String L3 = "L3";
    protected static final UiTopoLayout LAYOUT_ROOT = AbstractTopoModelTest.layout("LROOT", null, null);
    protected static final UiTopoLayout LAYOUT_1 = AbstractTopoModelTest.layout("L1", REGION_1, "LROOT");
    protected static final UiTopoLayout LAYOUT_2 = AbstractTopoModelTest.layout("L2", REGION_2, "LROOT");
    protected static final UiTopoLayout LAYOUT_3 = AbstractTopoModelTest.layout("L3", REGION_3, "LROOT");
    protected static final Set<UiTopoLayout> LAYOUT_SET = ImmutableSet.of((Object)LAYOUT_ROOT, (Object)LAYOUT_1, (Object)LAYOUT_2, (Object)LAYOUT_3);
    protected static final Set<UiTopoLayout> ROOT_KIDS = ImmutableSet.of((Object)LAYOUT_1, (Object)LAYOUT_2, (Object)LAYOUT_3);
    protected static final Set<UiTopoLayout> PEERS_OF_1 = ImmutableSet.of((Object)LAYOUT_2, (Object)LAYOUT_3);
    protected static final Set<UiTopoLayout> PEERS_OF_2 = ImmutableSet.of((Object)LAYOUT_1, (Object)LAYOUT_3);
    protected static final Set<UiTopoLayout> PEERS_OF_3 = ImmutableSet.of((Object)LAYOUT_1, (Object)LAYOUT_2);
    protected static final String D1 = "d1";
    protected static final String D2 = "d2";
    protected static final String D3 = "d3";
    protected static final String D4 = "d4";
    protected static final String D5 = "d5";
    protected static final String D6 = "d6";
    protected static final String D7 = "d7";
    protected static final String D8 = "d8";
    protected static final String D9 = "d9";
    protected static final String MFR = "Mfr";
    protected static final String HW = "h/w";
    protected static final String SW = "s/w";
    protected static final String SERIAL = "ser123";
    protected static final DeviceId DEVID_1 = DeviceId.deviceId((String)"d1");
    protected static final DeviceId DEVID_2 = DeviceId.deviceId((String)"d2");
    protected static final DeviceId DEVID_3 = DeviceId.deviceId((String)"d3");
    protected static final DeviceId DEVID_4 = DeviceId.deviceId((String)"d4");
    protected static final DeviceId DEVID_5 = DeviceId.deviceId((String)"d5");
    protected static final DeviceId DEVID_6 = DeviceId.deviceId((String)"d6");
    protected static final DeviceId DEVID_7 = DeviceId.deviceId((String)"d7");
    protected static final DeviceId DEVID_8 = DeviceId.deviceId((String)"d8");
    protected static final DeviceId DEVID_9 = DeviceId.deviceId((String)"d9");
    protected static final Device DEV_1 = AbstractTopoModelTest.device("d1");
    protected static final Device DEV_2 = AbstractTopoModelTest.device("d2");
    protected static final Device DEV_3 = AbstractTopoModelTest.device("d3");
    protected static final Device DEV_4 = AbstractTopoModelTest.device("d4");
    protected static final Device DEV_5 = AbstractTopoModelTest.device("d5");
    protected static final Device DEV_6 = AbstractTopoModelTest.device("d6");
    protected static final Device DEV_7 = AbstractTopoModelTest.device("d7");
    protected static final Device DEV_8 = AbstractTopoModelTest.device("d8");
    protected static final Device DEV_9 = AbstractTopoModelTest.device("d9");
    protected static final List<Device> ALL_DEVS = ImmutableList.of((Object)DEV_1, (Object)DEV_2, (Object)DEV_3, (Object)DEV_4, (Object)DEV_5, (Object)DEV_6, (Object)DEV_7, (Object)DEV_8, (Object)DEV_9);
    private static final Set<DeviceId> DEVS_TRUNK = ImmutableSet.of((Object)DEVID_1, (Object)DEVID_2, (Object)DEVID_3);
    private static final Set<DeviceId> DEVS_LEFT = ImmutableSet.of((Object)DEVID_4, (Object)DEVID_5, (Object)DEVID_6);
    private static final Set<DeviceId> DEVS_RIGHT = ImmutableSet.of((Object)DEVID_7, (Object)DEVID_8, (Object)DEVID_9);
    private static final String[][] LINK_CONNECT_DATA = new String[][]{{"d1", "12", "d2", "21"}, {"d2", "23", "d3", "32"}, {"d4", "41", "d1", "14"}, {"d5", "51", "d1", "15"}, {"d6", "61", "d1", "16"}, {"d7", "73", "d3", "37"}, {"d8", "83", "d3", "38"}, {"d9", "93", "d3", "39"}};
    private static final String HOST_MAC_PREFIX = "aa:00:00:00:00:";
    protected static final ServiceBundle MOCK_SERVICES = new ServiceBundle(){

        public UiTopoLayoutService layout() {
            return MOCK_LAYOUT;
        }

        public ClusterService cluster() {
            return MOCK_CLUSTER;
        }

        public MastershipService mastership() {
            return MOCK_MASTER;
        }

        public RegionService region() {
            return MOCK_REGION;
        }

        public DeviceService device() {
            return MOCK_DEVICE;
        }

        public LinkService link() {
            return MOCK_LINK;
        }

        public HostService host() {
            return MOCK_HOST;
        }

        public IntentService intent() {
            return null;
        }

        public FlowRuleService flow() {
            return null;
        }
    };
    private static final ClusterService MOCK_CLUSTER = new MockClusterService();
    private static final MastershipService MOCK_MASTER = new MockMasterService();
    private static final UiTopoLayoutService MOCK_LAYOUT = new MockLayoutService();
    private static final RegionService MOCK_REGION = new MockRegionService();
    private static final DeviceService MOCK_DEVICE = new MockDeviceService();
    private static final LinkService MOCK_LINK = new MockLinkService();
    private static final HostService MOCK_HOST = new MockHostService();

    AbstractTopoModelTest() {
    }

    protected static IpAddress ip(String s) {
        return IpAddress.valueOf((String)s);
    }

    protected static ControllerNode cnode(NodeId id, String ip) {
        return new DefaultControllerNode(id, AbstractTopoModelTest.ip(ip));
    }

    protected static UiTopoLayout layout(String layoutId, Region region, String parentId) {
        UiTopoLayoutId pid = parentId == null ? UiTopoLayoutId.DEFAULT_ID : UiTopoLayoutId.layoutId((String)parentId);
        return new UiTopoLayout(UiTopoLayoutId.layoutId((String)layoutId), region, pid);
    }

    protected static Region region(String id, Region.Type type, List<Set<NodeId>> masters) {
        return new DefaultRegion(RegionId.regionId((String)id), "Region-" + id, type, masters);
    }

    protected static Device device(String id) {
        return new DefaultDevice(ProviderId.NONE, DeviceId.deviceId((String)id), Device.Type.SWITCH, MFR, HW, SW, SERIAL, null, new Annotations[0]);
    }

    protected static List<Link> makeLinkPair(String[] linkPairData) {
        DeviceId devA = DeviceId.deviceId((String)linkPairData[0]);
        PortNumber portA = PortNumber.portNumber((long)Long.valueOf(linkPairData[1]));
        DeviceId devB = DeviceId.deviceId((String)linkPairData[2]);
        PortNumber portB = PortNumber.portNumber((long)Long.valueOf(linkPairData[3]));
        DefaultLink linkA = DefaultLink.builder().providerId(ProviderId.NONE).type(Link.Type.DIRECT).src(new ConnectPoint((ElementId)devA, portA)).dst(new ConnectPoint((ElementId)devB, portB)).build();
        DefaultLink linkB = DefaultLink.builder().providerId(ProviderId.NONE).type(Link.Type.DIRECT).src(new ConnectPoint((ElementId)devB, portB)).dst(new ConnectPoint((ElementId)devA, portA)).build();
        return ImmutableList.of((Object)linkA, (Object)linkB);
    }

    protected static Host createHost(Device device, int port, String hexChar) {
        DeviceId deviceId = device.id();
        String devNum = deviceId.toString().substring(1);
        MacAddress mac = MacAddress.valueOf((String)(HOST_MAC_PREFIX + devNum + hexChar));
        HostId hostId = HostId.hostId((String)String.format("%s/-1", mac));
        int ipByte = Integer.valueOf(hexChar, 16);
        if (ipByte < 10 || ipByte > 15) {
            throw new IllegalArgumentException("hexChar must be a-f");
        }
        HostLocation loc = new HostLocation(deviceId, PortNumber.portNumber((long)port), 0L);
        IpAddress ip = AbstractTopoModelTest.ip("10." + devNum + ".0." + ipByte);
        return new DefaultHost(ProviderId.NONE, hostId, mac, VlanId.NONE, loc, (Set)ImmutableSet.of((Object)ip), new Annotations[0]);
    }

    protected static List<Host> createHostPair(Device d) {
        ArrayList<Host> hosts = new ArrayList<Host>();
        hosts.add(AbstractTopoModelTest.createHost(d, 101, "a"));
        hosts.add(AbstractTopoModelTest.createHost(d, 102, "b"));
        return hosts;
    }

    private static class MockHostService
    extends HostServiceAdapter {
        private final Map<HostId, Host> hosts = new HashMap<HostId, Host>();

        MockHostService() {
            for (Device d : ALL_DEVS) {
                for (Host h : AbstractTopoModelTest.createHostPair(d)) {
                    this.hosts.put(h.id(), h);
                }
            }
        }

        public int getHostCount() {
            return this.hosts.size();
        }

        public Iterable<Host> getHosts() {
            return ImmutableSet.copyOf(this.hosts.values());
        }

        public Host getHost(HostId hostId) {
            return this.hosts.get(hostId);
        }
    }

    private static class MockLinkService
    extends LinkServiceAdapter {
        private final Set<Link> links = new HashSet<Link>();

        MockLinkService() {
            for (String[] linkPair : LINK_CONNECT_DATA) {
                this.links.addAll(AbstractTopoModelTest.makeLinkPair(linkPair));
            }
        }

        public int getLinkCount() {
            return this.links.size();
        }

        public Iterable<Link> getLinks() {
            return ImmutableSet.copyOf(this.links);
        }
    }

    private static class MockDeviceService
    extends DeviceServiceAdapter {
        private final Map<DeviceId, Device> devices = new HashMap<DeviceId, Device>();

        MockDeviceService() {
            for (Device dev : ALL_DEVS) {
                this.devices.put(dev.id(), dev);
            }
        }

        public int getDeviceCount() {
            return this.devices.size();
        }

        public Iterable<Device> getDevices() {
            return ImmutableList.copyOf(this.devices.values());
        }

        public Device getDevice(DeviceId deviceId) {
            return this.devices.get(deviceId);
        }
    }

    private static class MockRegionService
    implements RegionService {
        private final Map<RegionId, Region> lookup = new HashMap<RegionId, Region>();

        MockRegionService() {
            this.lookup.put(REGION_1.id(), REGION_1);
            this.lookup.put(REGION_2.id(), REGION_2);
            this.lookup.put(REGION_3.id(), REGION_3);
        }

        public Set<Region> getRegions() {
            return REGION_SET;
        }

        public Region getRegion(RegionId regionId) {
            return this.lookup.get(regionId);
        }

        public Region getRegionForDevice(DeviceId deviceId) {
            if (DEVS_TRUNK.contains(deviceId)) {
                return REGION_1;
            }
            if (DEVS_LEFT.contains(deviceId)) {
                return REGION_2;
            }
            if (DEVS_RIGHT.contains(deviceId)) {
                return REGION_3;
            }
            return null;
        }

        public Set<DeviceId> getRegionDevices(RegionId regionId) {
            if (REGION_1.id().equals((Object)regionId)) {
                return DEVS_TRUNK;
            }
            if (REGION_2.id().equals((Object)regionId)) {
                return DEVS_LEFT;
            }
            if (REGION_3.id().equals((Object)regionId)) {
                return DEVS_RIGHT;
            }
            return Collections.emptySet();
        }

        public void addListener(RegionListener listener) {
        }

        public void removeListener(RegionListener listener) {
        }
    }

    private static class MockLayoutService
    implements UiTopoLayoutService {
        private final Map<UiTopoLayoutId, UiTopoLayout> map = new HashMap<UiTopoLayoutId, UiTopoLayout>();
        private final Map<UiTopoLayoutId, Set<UiTopoLayout>> peers = new HashMap<UiTopoLayoutId, Set<UiTopoLayout>>();
        private final Map<RegionId, UiTopoLayout> byRegion = new HashMap<RegionId, UiTopoLayout>();

        MockLayoutService() {
            this.map.put(LAYOUT_ROOT.id(), LAYOUT_ROOT);
            this.map.put(LAYOUT_1.id(), LAYOUT_1);
            this.map.put(LAYOUT_2.id(), LAYOUT_2);
            this.map.put(LAYOUT_3.id(), LAYOUT_3);
            this.peers.put(LAYOUT_ROOT.id(), (Set<UiTopoLayout>)ImmutableSet.of());
            this.peers.put(LAYOUT_1.id(), (Set<UiTopoLayout>)ImmutableSet.of((Object)LAYOUT_2, (Object)LAYOUT_3));
            this.peers.put(LAYOUT_2.id(), (Set<UiTopoLayout>)ImmutableSet.of((Object)LAYOUT_1, (Object)LAYOUT_3));
            this.peers.put(LAYOUT_3.id(), (Set<UiTopoLayout>)ImmutableSet.of((Object)LAYOUT_1, (Object)LAYOUT_2));
            this.byRegion.put(REGION_1.id(), LAYOUT_1);
            this.byRegion.put(REGION_2.id(), LAYOUT_2);
            this.byRegion.put(REGION_3.id(), LAYOUT_3);
        }

        public UiTopoLayout getRootLayout() {
            return LAYOUT_ROOT;
        }

        public Set<UiTopoLayout> getLayouts() {
            return LAYOUT_SET;
        }

        public boolean addLayout(UiTopoLayout layout) {
            return false;
        }

        public UiTopoLayout getLayout(UiTopoLayoutId layoutId) {
            return this.map.get(layoutId);
        }

        public UiTopoLayout getLayout(RegionId regionId) {
            return this.byRegion.get(regionId);
        }

        public Set<UiTopoLayout> getPeerLayouts(UiTopoLayoutId layoutId) {
            return this.peers.get(layoutId);
        }

        public Set<UiTopoLayout> getChildren(UiTopoLayoutId layoutId) {
            return LAYOUT_ROOT.id().equals((Object)layoutId) ? ROOT_KIDS : Collections.emptySet();
        }

        public boolean removeLayout(UiTopoLayout layout) {
            return false;
        }
    }

    private static class MockMasterService
    extends MastershipServiceAdapter {
        private final Map<NodeId, Set<DeviceId>> masterOf = new HashMap<NodeId, Set<DeviceId>>();

        MockMasterService() {
            this.masterOf.put(CNODE_1.id(), DEVS_TRUNK);
            this.masterOf.put(CNODE_2.id(), DEVS_LEFT);
            this.masterOf.put(CNODE_3.id(), DEVS_RIGHT);
        }

        public NodeId getMasterFor(DeviceId deviceId) {
            if (DEVS_TRUNK.contains(deviceId)) {
                return CNID_1;
            }
            if (DEVS_LEFT.contains(deviceId)) {
                return CNID_2;
            }
            if (DEVS_RIGHT.contains(deviceId)) {
                return CNID_3;
            }
            return null;
        }

        public Set<DeviceId> getDevicesOf(NodeId nodeId) {
            return this.masterOf.get(nodeId);
        }

        public RoleInfo getNodesFor(DeviceId deviceId) {
            NodeId master = null;
            ArrayList<NodeId> backups = new ArrayList<NodeId>();
            if (DEVS_TRUNK.contains(deviceId)) {
                master = CNID_1;
                backups.add(CNID_2);
                backups.add(CNID_3);
            } else if (DEVS_LEFT.contains(deviceId)) {
                master = CNID_2;
                backups.add(CNID_1);
                backups.add(CNID_3);
            } else if (DEVS_RIGHT.contains(deviceId)) {
                master = CNID_3;
                backups.add(CNID_1);
                backups.add(CNID_2);
            }
            return new RoleInfo(master, backups);
        }
    }

    private static class MockClusterService
    extends ClusterServiceAdapter {
        private final Map<NodeId, ControllerNode> nodes = new HashMap<NodeId, ControllerNode>();
        private final Map<NodeId, ControllerNode.State> states = new HashMap<NodeId, ControllerNode.State>();

        MockClusterService() {
            this.nodes.put(CNODE_1.id(), CNODE_1);
            this.nodes.put(CNODE_2.id(), CNODE_2);
            this.nodes.put(CNODE_3.id(), CNODE_3);
            this.states.put(CNODE_1.id(), ControllerNode.State.READY);
            this.states.put(CNODE_2.id(), ControllerNode.State.ACTIVE);
            this.states.put(CNODE_3.id(), ControllerNode.State.ACTIVE);
        }

        public Set<ControllerNode> getNodes() {
            return ImmutableSet.copyOf(this.nodes.values());
        }

        public ControllerNode getNode(NodeId nodeId) {
            return this.nodes.get(nodeId);
        }

        public ControllerNode.State getState(NodeId nodeId) {
            return this.states.get(nodeId);
        }
    }
}

