/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiExtensionService;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.UiTopoMapFactory;
import org.onosproject.ui.impl.MapSelectorMessageHandler;

class MapSelectorMessageHandler
extends UiMessageHandler {
    private static final String MAP_LIST_REQ = "mapSelectorRequest";
    private static final String MAP_LIST_RESP = "mapSelectorResponse";
    private static final String ORDER = "order";
    private static final String MAPS = "maps";
    private static final String MAP_ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String FILE_PATH = "filePath";
    private static final String SCALE = "scale";

    MapSelectorMessageHandler() {
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new MapListHandler(this, null));
    }

    private ObjectNode mapsJson() {
        ObjectNode payload = this.objectNode();
        ArrayNode order = this.arrayNode();
        ObjectNode maps = this.objectNode();
        payload.set(ORDER, (JsonNode)order);
        payload.set(MAPS, (JsonNode)maps);
        UiExtensionService service = (UiExtensionService)this.get(UiExtensionService.class);
        service.getExtensions().forEach(ext -> {
            UiTopoMapFactory mapFactory = ext.topoMapFactory();
            if (mapFactory != null) {
                List topoMaps = mapFactory.newMaps();
                topoMaps.forEach(m -> {
                    maps.set(m.getId(), (JsonNode)this.objectNode().put(MAP_ID, m.getId()).put(DESCRIPTION, m.getDescription()).put(FILE_PATH, m.getFilePath()).put(SCALE, m.getScale()));
                    order.add(m.getId());
                });
            }
        });
        return payload;
    }

    static /* synthetic */ ObjectNode access$100(MapSelectorMessageHandler x0) {
        return x0.mapsJson();
    }
}

