/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.ui.UiTopoOverlay;
import org.onosproject.ui.impl.TopoOverlayCache;

public class TopoOverlayCache {
    private static final String EMPTY = "";
    private static final UiTopoOverlay NONE = new NullOverlay();
    private final Map<String, UiTopoOverlay> overlays = new HashMap();
    private UiTopoOverlay current = NONE;

    public TopoOverlayCache() {
        this.overlays.put(null, NONE);
    }

    public void add(UiTopoOverlay overlay) {
        this.overlays.put(overlay.id(), overlay);
    }

    public void destroy() {
        this.overlays.clear();
    }

    public void switchOverlay(String deact, String act) {
        UiTopoOverlay toDeactivate = this.getOverlay(deact);
        UiTopoOverlay toActivate = this.getOverlay(act);
        toDeactivate.deactivate();
        this.current = toActivate;
        this.current.activate();
    }

    private UiTopoOverlay getOverlay(String id) {
        return Strings.isNullOrEmpty((String)id) ? NONE : (UiTopoOverlay)this.overlays.get(id);
    }

    public UiTopoOverlay currentOverlay() {
        return this.current;
    }

    public int size() {
        return this.overlays.size();
    }

    public boolean isActive(String overlayId) {
        return this.currentOverlay().id().equals(overlayId);
    }
}

