/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.onlab.osgi.ServiceDirectory;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.impl.UiWebSocket;
import org.onosproject.ui.impl.topo.Topo2Jsonifier;
import org.onosproject.ui.impl.topo.Topo2ViewMessageHandler;
import org.onosproject.ui.impl.topo.UiTopoSession;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Topo2ViewMessageHandler
extends UiMessageHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String START = "topo2Start";
    private static final String NAV_REGION = "topo2navRegion";
    private static final String STOP = "topo2Stop";
    private static final String ALL_INSTANCES = "topo2AllInstances";
    private static final String CURRENT_LAYOUT = "topo2CurrentLayout";
    private static final String CURRENT_REGION = "topo2CurrentRegion";
    private static final String PEER_REGIONS = "topo2PeerRegions";
    private static final String TOPO_START_DONE = "topo2StartDone";
    private UiTopoSession topoSession;
    private Topo2Jsonifier t2json;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.topoSession = ((UiWebSocket)connection).topoSession();
        this.t2json = new Topo2Jsonifier(directory);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)new Topo2Start(this, null), (Object)new Topo2NavRegion(this, null), (Object)new Topo2Stop(this, null));
    }

    private ObjectNode mkLayoutMessage(UiTopoLayout currentLayout) {
        List crumbs = this.topoSession.breadCrumbs();
        return this.t2json.layout(currentLayout, crumbs);
    }

    private ObjectNode mkRegionMessage(UiTopoLayout currentLayout) {
        UiRegion region = this.topoSession.getRegion(currentLayout);
        Set kids = this.topoSession.getSubRegions(currentLayout);
        List links = this.topoSession.getLinks(currentLayout);
        return this.t2json.region(region, kids, links);
    }

    private ObjectNode mkPeersMessage(UiTopoLayout currentLayout) {
        Set peers = this.topoSession.getPeerNodes(currentLayout);
        ObjectNode peersPayload = this.objectNode();
        peersPayload.set("peers", (JsonNode)this.t2json.closedNodes(peers));
        return peersPayload;
    }

    static /* synthetic */ Logger access$300(Topo2ViewMessageHandler x0) {
        return x0.log;
    }

    static /* synthetic */ UiTopoSession access$400(Topo2ViewMessageHandler x0) {
        return x0.topoSession;
    }

    static /* synthetic */ Topo2Jsonifier access$500(Topo2ViewMessageHandler x0) {
        return x0.t2json;
    }

    static /* synthetic */ ObjectNode access$600(Topo2ViewMessageHandler x0, UiTopoLayout x1) {
        return x0.mkLayoutMessage(x1);
    }

    static /* synthetic */ ObjectNode access$700(Topo2ViewMessageHandler x0, UiTopoLayout x1) {
        return x0.mkRegionMessage(x1);
    }

    static /* synthetic */ ObjectNode access$800(Topo2ViewMessageHandler x0, UiTopoLayout x1) {
        return x0.mkPeersMessage(x1);
    }
}

