/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.region.RegionId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class UiTopoLayoutManager
implements UiTopoLayoutService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String ID_NULL = "Layout ID cannot be null";
    private static final String LAYOUT_NULL = "Layout cannot be null";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<UiTopoLayoutId, UiTopoLayout> layouts;
    private Map<UiTopoLayoutId, UiTopoLayout> layoutMap;

    @Activate
    public void activate() {
        KryoNamespace.Builder kryoBuilder = new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{UiTopoLayoutId.class}).register(new Class[]{UiTopoLayout.class});
        this.layouts = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withSerializer(Serializer.using((KryoNamespace)kryoBuilder.build()))).withName("onos-topo-layouts")).withRelaxedReadConsistency()).build();
        this.layoutMap = this.layouts.asJavaMap();
        this.layoutMap.computeIfAbsent(UiTopoLayoutId.DEFAULT_ID, k -> new UiTopoLayout(k, null, null));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    public UiTopoLayout getRootLayout() {
        return this.getLayout(UiTopoLayoutId.DEFAULT_ID);
    }

    public Set<UiTopoLayout> getLayouts() {
        return ImmutableSet.copyOf(this.layoutMap.values());
    }

    public boolean addLayout(UiTopoLayout layout) {
        Preconditions.checkNotNull((Object)layout, (Object)LAYOUT_NULL);
        return this.layouts.put((Object)layout.id(), (Object)layout) == null;
    }

    public UiTopoLayout getLayout(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)ID_NULL);
        return (UiTopoLayout)this.layoutMap.get(layoutId);
    }

    public UiTopoLayout getLayout(RegionId regionId) {
        if (regionId == null || regionId.equals((Object)UiRegion.NULL_ID)) {
            return this.getRootLayout();
        }
        List matchingLayouts = this.layoutMap.values().stream().filter(l -> Objects.equals(regionId, l.regionId())).collect(Collectors.toList());
        return matchingLayouts.isEmpty() ? null : (UiTopoLayout)matchingLayouts.get(0);
    }

    public Set<UiTopoLayout> getPeerLayouts(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)ID_NULL);
        UiTopoLayout layout = (UiTopoLayout)this.layoutMap.get(layoutId);
        if (layout == null || layout.isRoot()) {
            return Collections.emptySet();
        }
        UiTopoLayoutId parentId = layout.parent();
        return this.layoutMap.values().stream().filter(l -> !Objects.equals(l.id(), layoutId) && !Objects.equals(l.id(), UiTopoLayoutId.DEFAULT_ID) && Objects.equals(l.parent(), parentId)).collect(Collectors.toSet());
    }

    public Set<UiTopoLayout> getChildren(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)ID_NULL);
        return this.layoutMap.values().stream().filter(l -> !l.isRoot() && Objects.equals(l.parent(), layoutId)).collect(Collectors.toSet());
    }

    public boolean removeLayout(UiTopoLayout layout) {
        Preconditions.checkNotNull((Object)layout, (Object)LAYOUT_NULL);
        return this.layouts.remove((Object)layout.id()) != null;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

