/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.FlowObjectiveIntent;
import org.onosproject.net.intent.FlowRuleIntent;
import org.onosproject.net.intent.HostToHostIntent;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.LinkCollectionIntent;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.OpticalConnectivityIntent;
import org.onosproject.net.intent.PathIntent;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.net.link.LinkService;
import org.onosproject.ui.impl.topo.util.ServicesBundle;

public class TopoIntentFilter {
    private final IntentService intentService;
    private final DeviceService deviceService;
    private final HostService hostService;
    private final LinkService linkService;

    public TopoIntentFilter(ServicesBundle services) {
        this.intentService = services.intentService();
        this.deviceService = services.deviceService();
        this.hostService = services.hostService();
        this.linkService = services.linkService();
    }

    public List<Intent> findPathIntents(Set<Host> hosts, Set<Device> devices, Set<Link> links) {
        Iterable sourceIntents = this.intentService.getIntents();
        Set edgePoints = this.getEdgePoints(hosts);
        return this.getIntents(hosts, devices, links, edgePoints, sourceIntents);
    }

    private Set<ConnectPoint> getEdgePoints(Set<Host> hosts) {
        HashSet<ConnectPoint> edgePoints = new HashSet<ConnectPoint>();
        for (Host host : hosts) {
            edgePoints.add((ConnectPoint)host.location());
        }
        return edgePoints;
    }

    private List<Intent> getIntents(Set<Host> hosts, Set<Device> devices, Set<Link> links, Set<ConnectPoint> edgePoints, Iterable<Intent> sourceIntents) {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        if (hosts.isEmpty() && devices.isEmpty() && links.isEmpty()) {
            return intents;
        }
        HashSet<OpticalConnectivityIntent> opticalIntents = new HashSet<OpticalConnectivityIntent>();
        for (Intent intent : sourceIntents) {
            if (this.intentService.getIntentState(intent.key()) != IntentState.INSTALLED) continue;
            boolean isRelevant = false;
            if (intent instanceof HostToHostIntent) {
                isRelevant = this.isIntentRelevantToHosts((HostToHostIntent)intent, hosts) && this.isIntentRelevantToDevices(intent, devices) && this.isIntentRelevantToLinks(intent, links);
            } else if (intent instanceof PointToPointIntent) {
                isRelevant = this.isIntentRelevant((PointToPointIntent)intent, edgePoints) && this.isIntentRelevantToDevices(intent, devices) && this.isIntentRelevantToLinks(intent, links);
            } else if (intent instanceof MultiPointToSinglePointIntent) {
                isRelevant = this.isIntentRelevant((MultiPointToSinglePointIntent)intent, edgePoints) && this.isIntentRelevantToDevices(intent, devices) && this.isIntentRelevantToLinks(intent, links);
            } else if (intent instanceof OpticalConnectivityIntent) {
                opticalIntents.add((OpticalConnectivityIntent)intent);
            }
            if (!isRelevant) continue;
            intents.add(intent);
        }
        for (OpticalConnectivityIntent opticalConnectivityIntent : opticalIntents) {
            if (!this.isIntentRelevant(opticalConnectivityIntent, intents) || !this.isIntentRelevantToDevices((Intent)opticalConnectivityIntent, devices)) continue;
            intents.add((Intent)opticalConnectivityIntent);
        }
        return intents;
    }

    private boolean isIntentRelevantToHosts(HostToHostIntent intent, Iterable<Host> hosts) {
        for (Host host : hosts) {
            HostId id = host.id();
            if (id.equals((Object)intent.one()) || id.equals((Object)intent.two())) continue;
            return false;
        }
        return true;
    }

    private boolean isIntentRelevantToDevices(Intent intent, Iterable<Device> devices) {
        List installables = this.intentService.getInstallableIntents(intent.key());
        for (Device device : devices) {
            if (this.isIntentRelevantToDevice(installables, device)) continue;
            return false;
        }
        return true;
    }

    private boolean isIntentRelevantToLinks(Intent intent, Iterable<Link> links) {
        List installables = this.intentService.getInstallableIntents(intent.key());
        for (Link link : links) {
            if (this.isIntentRelevantToLink(installables, link)) continue;
            return false;
        }
        return true;
    }

    private boolean isIntentRelevantToDevice(List<Intent> installables, Device device) {
        if (installables != null) {
            for (Intent installable : installables) {
                LinkCollectionIntent linksIntent;
                if (installable instanceof PathIntent) {
                    PathIntent pathIntent = (PathIntent)installable;
                    if (!this.pathContainsDevice((Iterable)pathIntent.path().links(), device.id())) continue;
                    return true;
                }
                if (installable instanceof FlowRuleIntent) {
                    FlowRuleIntent flowRuleIntent = (FlowRuleIntent)installable;
                    if (!this.rulesContainDevice(flowRuleIntent.flowRules(), device.id())) continue;
                    return true;
                }
                if (installable instanceof FlowObjectiveIntent) {
                    FlowObjectiveIntent objectiveIntent = (FlowObjectiveIntent)installable;
                    return objectiveIntent.devices().contains(device.id());
                }
                if (!(installable instanceof LinkCollectionIntent) || !this.pathContainsDevice((Iterable)(linksIntent = (LinkCollectionIntent)installable).links(), device.id())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIntentRelevantToLink(List<Intent> installables, Link link) {
        Link reverseLink = this.linkService.getLink(link.dst(), link.src());
        if (installables != null) {
            for (Intent installable : installables) {
                if (installable instanceof PathIntent) {
                    PathIntent pathIntent = (PathIntent)installable;
                    return pathIntent.path().links().contains(link) || pathIntent.path().links().contains(reverseLink);
                }
                if (installable instanceof FlowRuleIntent) {
                    FlowRuleIntent flowRuleIntent = (FlowRuleIntent)installable;
                    return flowRuleIntent.resources().contains(link) || flowRuleIntent.resources().contains(reverseLink);
                }
                if (installable instanceof FlowObjectiveIntent) {
                    FlowObjectiveIntent objectiveIntent = (FlowObjectiveIntent)installable;
                    return objectiveIntent.resources().contains(link) || objectiveIntent.resources().contains(reverseLink);
                }
                if (!(installable instanceof LinkCollectionIntent)) continue;
                LinkCollectionIntent linksIntent = (LinkCollectionIntent)installable;
                return linksIntent.links().contains(link) || linksIntent.links().contains(reverseLink);
            }
        }
        return false;
    }

    private boolean pathContainsDevice(Iterable<Link> links, DeviceId id) {
        for (Link link : links) {
            if (!link.src().elementId().equals(id) && !link.dst().elementId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean rulesContainDevice(Collection<FlowRule> flowRules, DeviceId id) {
        for (FlowRule rule : flowRules) {
            if (!rule.deviceId().equals((Object)id)) continue;
            return true;
        }
        return false;
    }

    private boolean isIntentRelevant(PointToPointIntent intent, Iterable<ConnectPoint> edgePoints) {
        for (ConnectPoint point : edgePoints) {
            if (point.equals((Object)intent.egressPoint()) || point.equals((Object)intent.ingressPoint())) continue;
            return false;
        }
        return true;
    }

    private boolean isIntentRelevant(MultiPointToSinglePointIntent intent, Iterable<ConnectPoint> edgePoints) {
        for (ConnectPoint point : edgePoints) {
            if (point.equals((Object)intent.egressPoint()) || intent.ingressPoints().contains(point)) continue;
            return false;
        }
        return true;
    }

    private boolean isIntentRelevant(OpticalConnectivityIntent opticalIntent, Iterable<Intent> intents) {
        Link ccSrc = this.getFirstLink(opticalIntent.getSrc(), false);
        Link ccDst = this.getFirstLink(opticalIntent.getDst(), true);
        if (ccSrc == null || ccDst == null) {
            return false;
        }
        for (Intent intent : intents) {
            List installables = this.intentService.getInstallableIntents(intent.key());
            for (Intent installable : installables) {
                Link tunnel;
                List links;
                if (!(installable instanceof PathIntent) || (links = ((PathIntent)installable).path().links()).size() != 3 || !Objects.equals((tunnel = (Link)links.get(1)).src(), ccSrc.src()) || !Objects.equals(tunnel.dst(), ccDst.dst())) continue;
                return true;
            }
        }
        return false;
    }

    private Link getFirstLink(ConnectPoint point, boolean ingress) {
        for (Link link : this.linkService.getLinks(point)) {
            if (!point.equals((Object)(ingress ? link.src() : link.dst()))) continue;
            return link;
        }
        return null;
    }
}

