/*
 *  Copyright 2016-present Open Networking Laboratory
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/*
 ONOS GUI -- SVG -- Glyph Data Service
 */
(function () {
    'use strict';

    // --- ONOS logo glyph ------------------------------------

    var logos = {
            _bird: '352 224 113 112',
            bird: 'M427.7,300.4 c-6.9,0.6-13.1,5-19.2,7.1c-18.1,6.2-33.9,' +
            '9.1-56.5,4.7c24.6,17.2,36.6,13,63.7,0.1c-0.5,0.6-0.7,1.3-1.3,' +
            '1.9c1.4-0.4,2.4-1.7,3.4-2.2c-0.4,0.7-0.9,1.5-1.4,1.9c2.2-0.6,' +
            '3.7-2.3,5.9-3.9c-2.4,2.1-4.2,5-6,8c-1.5,2.5-3.1,4.8-5.1,6.9c-1,' +
            '1-1.9,1.9-2.9,2.9c-1.4,1.3-2.9,2.5-5.1,2.9c1.7,0.1,3.6-0.3,6.5' +
            '-1.9c-1.6,2.4-7.1,6.2-9.9,7.2c10.5-2.6,19.2-15.9,25.7-18c18.3' +
            '-5.9,13.8-3.4,27-14.2c1.6-1.3,3-1,5.1-0.8c1.1,0.1,2.1,0.3,3.2,' +
            '0.5c0.8,0.2,1.4,0.4,2.2,0.8l1.8,0.9c-1.9-4.5-2.3-4.1-5.9-6c-2.3' +
            '-1.3-3.3-3.8-6.2-4.9c-7.1-2.6-11.9,11.7-11.7-5c0.1-8,4.2-14.4,' +
            '6.4-22c1.1-3.8,2.3-7.6,2.4-11.5c0.1-2.3,0-4.7-0.4-7c-2-11.2-8.4' +
            '-21.5-19.7-24.8c-1-0.3-1.1-0.3-0.9,0c9.6,17.1,7.2,38.3,3.1,54.2' +
            'C429.9,285.5,426.7,293.2,427.7,300.4z',

            _cord: '0 0 110 110',
            cord: 'M92.5,62.3l-33,33,2.5,2.5c4.1,4.1,7.4,3.6,11.2-.1L95.9,75' +
            'l-4.5-4.5,4.7-4.7-3.6-3.6Z' +
            'm2.6,7L98.4,66l3.3,3.3-3.3,3.3-3.3-3.3Z' +
            'M94.5,60l4.9-4.9,4.9,4.9-4.9,4.9Z' +
            'M36.2,36.1L18.6,53.8c-7.8,7.8-5.8,17.4-2.4,22l-2.2-2.2' +
            'c-10.6-10.6-11.2-20,0-31.2L28.2,28.1L31.3,25l8,8-3.1,3.1Z' +
            'M55.5,55.4l3.6-3.6L66.9,44l-8-8l-2.5,2.5-5.2,5.2l-3.6,3.6' +
            'L33.2,61.6C22,72.7,22.5,82.2,33.2,92.8L35.4,95' +
            'c-3.4-4.5-5.4-14.1,2.4-22L55.5,55.4Z' +
            'M50.7,21.7l-8-8L35,21.2l8,8,7.6-7.6Z' +
            'M62.8,9.6L55.4,17l-8-8,7.4-7.4,8,8Z' +
            'm0.7,18.3-7.6,7.6-8-8,7.6-7.6,8,8Z' +
            'm26.1-6.6-8.1,8.1-8-8,8.1-8.1,8,8Z' +
            'M79.3,31.5l-7.4,7.4-8-8,7.4-7.4,8,8Z' +
            'M45.7,45.6L54.3,37l-8-8-8.6,8.6L23.4,51.8' +
            'C12.2,63,12.8,72.4,23.4,83l2.2,2.2c-3.4-4.5-5.4-14.1,2.4-22Z' +
            'M34.9,80.7l20.6,20.5c2,2,4.6,4.1,7.9,3.2-2.9,2.9-8.9,1.7-11.9-1.3' +
            'L35.1,86.8,35,86.6H34.9l-0.8-.8' +
            'a15,15,0,0,1,.1-1.9,14.7,14.7,0,0,1,.7-3.2Z' +
            'm-0.6,7.4a21.3,21.3,0,0,0,5.9,11.7l5.7,5.7' +
            'c3,3,9,4.1,11.9,1.3-3.3.9-5.9-1.2-7.9-3.2L34.3,88.1Z' +
            'm3.5-12.4a16.6,16.6,0,0,0-2.3,3.6L57,100.8' +
            'c3,3,9,4.1,11.9,1.3-3.3.9-5.9-1.2-7.9-3.2Z'
        },


    // --- Core glyphs ------------------------------------

    // TODO: ONOS-2566 glyphs for device types:
    //          firewall, balancer, ips, ids,
    //          controller, virtual, other

    // NOTE: when adding glyphs, please also update TopoConstants.Glyphs class.

        tableFrame = 'M6.3,5.3h8.5v14.2h-8.5z' +
            'M95.3,5.3h8.5v14.2h-8.5z' +
            'M18.5,5.3h15.6v14.2h-15.6z' +
            'M37.9,5.3h15.6v14.2h-15.6z' +
            'M57,5.3h15.6v14.2h-15.6z' +
            'M76.1,5.3h15.6v14.2h-15.6z' +
            'M6.3,23.9h97.5v80.75h-97.5z',

        rSquare = 'M10,20a10,10,0,0,1,10-10h70a10,10,0,0,1,10,10v70a10,10,' +
            '0,0,1-10,10h-70a10,10,0,0,1-10-10z',

        octagon = 'M10,35l25-25h40l25,25v40l-25,25h-40l-25-25z',

        circle = 'M10,55A45,45,0,0,1,100,55A45,45,0,0,1,10,55',

        arrowsLR = 'M58,26l12,0,0-8,18,13-18,13,0-8-12,0z' +
            'M58,60l12,0,0-8,18,13-18,13,0-8-12,0z' +
            'M52,40l-12,0,0-8-18,13,18,13,0-8,12,0z' +
            'M52,74l-12,0,0-8-18,13,18,13,0-8,12,0z',

        arrowsInHOutV = 'M20,50l12,0,0-8,18,13-18,13,0-8-12,0z' +
            'M90,50l-12,0,0-8-18,13,18,13,0-8,12,0z' +
            'M50,47l0-12-8,0,13-18,13,18-8,0,0,12z' +
            'M50,63l0,12-8,0,13,18,13-18-8,0,0-12z',

        laser = 'M47.2,68.4L31.1,84.5,25.6,79,41.7,62.9Z' +
            'M76.3,30.6A3.4,3.4,0,0,0,72.9,34a3.3,3.3,0,0,0,.3,1.3L44.7,63.7' +
            'l1.7,1.7L74.8,37a3.2,3.2,0,0,0,1.5.4A3.4,3.4,0,1,0,76.3,30.6Z' +
            'm0.9-2.9V23.8a0.8,0.8,0,0,0-.8-0.8H76.1a0.8,0.8,0,0,0-.8.8v3.9' +
            'a0.8,0.8,0,0,0,.8.8h0.3A0.8,0.8,0,0,0,77.2,27.7Z' +
            'm3.5,3.2,3.6-3.6a0.9,0.9,0,0,0,0-1.2H84.3a0.9,0.9,0,0,0-1.2,0' +
            'l-3.6,3.6a0.9,0.9,0,0,0,0,1.2h0.1A0.9,0.9,0,0,0,80.7,30.9Z' +
            'm1.8,4h3.9a0.8,0.8,0,0,0,.8-0.8V33.7a0.8,0.8,0,0,0-.8-0.8H82.6' +
            'a0.8,0.8,0,0,0-.8.8V34A0.8,0.8,0,0,0,82.6,34.8Z' +
            'm-16.3.1h3.9a0.8,0.8,0,0,0,.8-0.8V33.8a0.8,0.8,0,0,0-.8-0.8' +
            'H66.2a0.8,0.8,0,0,0-.8.8v0.3A0.8,0.8,0,0,0,66.2,34.9Z' +
            'm6.8-5.2-3.8-3.8a0.9,0.9,0,0,0-1.3,0a0.9,0.9,0,0,0,0,1.3' +
            'L71.8,31A0.9,0.9,0,0,0,73,31A0.9,0.9,0,0,0,73.1,29.7Z' +
            'M84.8,40.9L80.9,37a0.9,0.9,0,0,0-1.3,0a0.9,0.9,0,0,0,0,1.3' +
            'l3.9,3.9a0.9,0.9,0,0,0,1.3,0A0.9,0.9,0,0,0,84.8,40.9Z' +
            'm-7.6,3.2V40.2a0.8,0.8,0,0,0-.8-0.8H76.2a0.8,0.8,0,0,0-.8.8' +
            'v3.9a0.8,0.8,0,0,0,.8.8h0.3A0.8,0.8,0,0,0,77.3,44.1Z',

        fiberStar = 'M89,60V57H70.6a15,15,0,0,1-3.2,7.6l13,12.9L82.8,75v7.5' +
            'H75.2l2.2-2.2-12.8-13A14.9,14.9,0,0,1,57,70.6V89h3.1l-5.3,5.4' +
            'L49.4,89H53V70.6a13.2,13.2,0,0,1-8-3.2l-13.1,13,2.3,2.3H26.5' +
            'V75.1l2.3,2.3,13-12.8A15,15,0,0,1,38.7,57H21v3l-5.4-5.4L21,49.3' +
            'V53H38.7a13.1,13.1,0,0,1,3.2-8l-13-13.1-2.2,2.1V26.4h7.5l-2.4,2.4' +
            'L45,41.8a13.2,13.2,0,0,1,8-3.2V21H49.4l5.4-5.4L60.1,21H57V38.6' +
            'a14.9,14.9,0,0,1,7.6,3.2l12.9-13-2.4-2.3h7.5v7.6l-2.3-2.3L67.4,45' +
            'a13.1,13.1,0,0,1,3.2,8H89V49.3l5.4,5.3Z',

        glyphDataSet = {
            _viewbox: '0 0 110 110',

            uiAttached: 'M91.9,16.7H18.1A5.3,5.3,0,0,0,12.8,22V68' +
            'a5.3,5.3,0,0,0,5.3,5.3H91.9A5.3,5.3,0,0,0,97.2,68V22' +
            'A5.3,5.3,0,0,0,91.9,16.7ZM91.6,65.2H18.4V22.3H91.6V65.2Z' +
            'M71.5,87.5h3.8v5.9h-40.6v-5.9h3.8v-1.7h5.4v-9.7h22.3v9.7h5.3v1.7z',

            // Small dot
            unknown: 'M35,40a5,5,0,0,1,5-5h30a5,5,0,0,1,5,5v30a5,5,0,0,1-5,5' +
            'h-30a5,5,0,0,1-5-5z',

            // Question mark for unknown device types
            query: 'M51.4,69.9c0-0.9,0-1.6,0-2.1c0-2.7,0.4-5.1,1.2-7.1' +
            'c0.6-1.5,1.5-3,2.8-4.5c0.9-1.1,2.6-2.7,5.1-4.8c2.4-2.1,4-3.8,' +
            '4.8-5.1 c0.7-1.3,1.1-2.6,1.1-4.1c0-2.7-1.1-5.1-3.2-7.1c-2.1-2' +
            '-4.8-3.1-7.9-3.1c-3,0-5.5,0.9-7.5,2.8c-2,1.9-3.3,4.8-4,8.7l-7.2' +
            '-0.8 c0.7-5.3,2.6-9.3,5.8-12.1c3.2-2.8,7.5-4.2,12.8-4.2c5.6,0,' +
            '10.1,1.5,13.4,4.5c3.3,3,5,6.7,5,10.9c0,2.5-0.6,4.8-1.8,6.8 ' +
            's-3.5,4.6-6.9,7.6c-2.3,2-3.8,3.5-4.5,4.4c-0.7,1-1.2,2-1.6,3.3' +
            'c-0.3,1.2-0.5,3.2-0.6,6H51.4z M51,83.8v-7.9h8v7.9H51z',


            // --- ONOS cluster node ---
            node: 'M15,100a5,5,0,0,1-5-5v-65a5,5,0,0,1,5-5h80a5,5,0,0,1,5,5' +
            'v65a5,5,0,0,1-5,5zM14,22.5l11-11a10,3,0,0,1,10-2h40a10,3,0,0,1,' +
            '10,2l11,11zM16,35a5,5,0,0,1,10,0a5,5,0,0,1-10,0z',


            // --- DEVICES ---
            // See Device.DeviceType enum for the following...

            // NOTE: 'other' should map to 'unknown' (.) above

            switch: rSquare + arrowsLR,

            router: circle + arrowsInHOutV,

            roadm: octagon + arrowsLR,

            otn: rSquare + laser,

            roadm_otn: octagon + laser,

            // TODO: firewall

            // TODO: balancer

            // TODO: ips

            // TODO: ids

            // TODO: controller

            // TODO: virtual

            fiber_switch: rSquare + fiberStar,

            microwave: 'M85,71.2c-8.9,10.5-29.6,8.7-45.3-3.5C23.9,55.4,19.8,' +
            '37,28.6,26.5C29.9,38.6,71.5,69.9,85,71.2z M92.7,76.2M16.2,15 ' +
            'M69.5,100.7v-4c0-1.4-1.2-2.2-2.6-2.2H19.3c-1.4,0-2.8,0.7-2.8,2.2' +
            'v3.9c0,0.7,0.8,1,1.5,1h50.3C69,101.5,69.5,101.3,69.5,100.7z ' +
            'M77.3,7.5l0,3.7c9,0.1,16.3,7.1,16.2,15.7l3.9,0C97.5,16.3,88.5,' +
            '7.6,77.3,7.5z M77.6,14.7l0,2.5c5.3,0,9.7,4.2,9.6,9.3l2.6,0C89.9' +
            ',20,84.4,14.7,77.6,14.7z M82.3,22.2c-1.3-1.2-2.9-1.9-4.7-1.9' +
            'l0,1.2c1.4,0,2.8,0.6,3.8,1.5c1,1,1.6,2.3,1.6,3.7l1.3,0C84.3,25.1,' +
            '83.6,23.4,82.3,22.2z M38.9,69.5l-5.1,23h16.5l-2.5-17.2C44.1,73.3,' +
            '38.9,69.5,38.9,69.5zM58.1,54.1c13.7,10.1,26.5,16.8,29.2,13.7' +
            'c2.7-3.1-5.6-13-19.3-24.4 M62.9,34.2 M62,37.9C47.7,27.3,33.7,20,' +
            '31,23.1c-2.7,3.2,7,14.2,20.6,26 M73.9,25.7c-2.9,0.1-5.2,2.3-5.1,' +
            '4.8c0,0.7,0.2,1.4,0.6,2l0,0L53.8,49.7l3.3,2.5L72.7,35l-0.4-0.3' +
            'c0.6,0.2,1.3,0.3,1.9,0.3c2.9-0.1,5.2-2.3,5.1-4.9C79.3,27.6,76.8,' +
            '25.6,73.9,25.7z',

            // NOTE: 'unrecognized' should map to 'query' (?) above


            // --- HOSTS ---

            // default glyph for a host
            endstation: 'M10,15a5,5,0,0,1,5-5h65a5,5,0,0,1,5,5v80a5,5,0,0,1' +
            '-5,5h-65a5,5,0,0,1-5-5zM87.5,14l11,11a3,10,0,0,1,2,10v40a3,10,' +
            '0,0,1,-2,10l-11,11zM17,19a2,2,0,0,1,2-2h56a2,2,0,0,1,2,2v26a2,' +
            '2,0,0,1-2,2h-56a2,2,0,0,1-2-2zM20,20h54v10h-54zM20,33h54v10h' +
            '-54zM42,70a5,5,0,0,1,10,0a5,5,0,0,1-10,0z',

            bgpSpeaker: 'M10,40a45,35,0,0,1,90,0Q100,77,55,100Q10,77,10,40z' +
            'M50,29l12,0,0-8,18,13-18,13,0-8-12,0zM60,57l-12,0,0-8-18,13,' +
            '18,13,0-8,12,0z',


            // --- Miscellaneous glyphs ---------------------------------

            chain: 'M60.4,77.6c-4.9,5.2-9.6,11.3-15.3,16.3c-8.6,7.5-20.4,6.8' +
            '-28-0.8c-7.7-7.7-8.4-19.6-0.8-28.4c6.5-7.4,13.5-14.4,20.9-20.9' +
            'c7.5-6.7,19.2-6.7,26.5-0.8c3.5,2.8,4.4,6.1,2.2,8.7c-2.7,3.1' +
            '-5.5,2.5-8.5,0.3c-4.7-3.4-9.7-3.2-14,0.9C37.1,58.7,31,64.8,' +
            '25.2,71c-4.2,4.4-4.2,10.6-0.6,14.3c3.7,3.7,9.7,3.7,14.3-0.4' +
            'c2.9-2.5,5.3-5.5,8.3-8c1-0.9,3-1.1,4.4-0.9C54.8,76.3,57.9,77.1,' +
            '60.4,77.6zM49.2,32.2c5-5.2,9.7-10.9,15.2-15.7c12.8-11,31.2' +
            '-4.9,34.3,11.2C100,34.2,98.3,40.2,94,45c-6.7,7.4-13.7,14.6' +
            '-21.2,21.2C65.1,73,53.2,72.7,46,66.5c-3.2-2.8-3.9-5.8-1.6-8.4' +
            'c2.6-2.9,5.3-2.4,8.2-0.3c5.2,3.7,10,3.3,14.7-1.1c5.8-5.6,11.6' +
            '-11.3,17.2-17.2c4.6-4.8,4.9-11.1,0.9-15c-3.9-3.9-10.1-3.4-15,' +
            '1.2c-3.1,2.9-5.7,7.4-9.3,8.5C57.6,35.3,53,33,49.2,32.2z',

            crown: 'M99.5,21.6c0,3-2.3,5.4-5.1,5.4c-0.3,0-0.7,0-1-0.1c-1.8,' +
            '4-4.8,10-7.2,17.3c-3.4,10.6-0.9,26.2,2.7,27.3C90.4,72,91.3,' +
            '75,88,75H22.7c-3.3,0-2.4-3-0.9-3.5c3.6-1.1,6.1-16.7,2.7-27.3' +
            'c-2.4-7.4-5.4-13.5-7.2-17.5c-0.5,0.2-1,0.3-1.6,0.3c-2.8,0' +
            '-5.1-2.4-5.1-5.4c0-3,2.3-5.4,5.1-5.4c2.8,0,5.1,2.4,5.1,5.4c0,' +
            '1-0.2,1.9-0.7,2.7c0.7,0.8,1.4,1.6,2.4,2.6c8.8,8.9,11.9,12.7,' +
            '18.1,11.7c6.5-1,11-8.2,13.3-14.1c-2-0.8-3.3-2.7-3.3-5.1c0-3,' +
            '2.3-5.4,5.1-5.4c2.8,0,5.1,2.4,5.1,5.4c0,2.5-1.6,4.5-3.7,5.2' +
            'c2.3,5.9,6.8,13,13.2,14c6.2,1,9.3-2.7,18.1-11.7c0.7-0.7,1.4' +
            '-1.5,2-2.1c-0.6-0.9-1-2-1-3.1c0-3,2.3-5.4,5.1-5.4C97.2,16.2,' +
            '99.5,18.6,99.5,21.6zM92,87.9c0,2.2-1.7,4.1-3.8,4.1H22.4c' +
            '-2.1,0-4.4-1.9-4.4-4.1v-3.3c0-2.2,2.3-4.5,4.4-4.5h65.8c2.1,' +
            '0,3.8,2.3,3.8,4.5V87.9z',

            lock: 'M79.4,48.6h-2.7c0.2-5.7-0.2-20.4-7.9-28.8c-3.6-3.9-8.3' +
            '-5.9-13.7-5.9c-5.4,0-10.2,2-13.8,5.9c-7.8,8.4-8.3,23.2-8.1,28.8' +
            'h-2.7c-4.4,0-8,2.6-8,5.9v35.7c0,3.3,3.6,5.9,8,5.9h48.9c4.4,0,' +
            '8-2.6,8-5.9V54.5C87.5,51.3,83.9,48.6,79.4,48.6z M48.1,26.1c1.9' +
            '-2,4.1-2.9,7-2.9c2.9,0,5.1,0.9,6.9,2.9c5,5.4,5.6,17.1,5.4,22.6' +
            'h-25C42.3,43.1,43.1,31.5,48.1,26.1z',

            topo: 'M97.2,76.3H86.6l-7.7-21.9H82c1,0,1.9-0.8,1.9-1.9V35.7c' +
            '0-1-0.8-1.9-1.9-1.9H65.2c-1,0-1.9,0.8-1.9,1.9v2.6L33.4,26.1v-11' +
            'c0-1-0.8-1.9-1.9-1.9H14.7c-1,0-1.9,0.8-1.9,1.9v16.8c0,1,0.8,' +
            '1.9,1.9,1.9h16.8c1,0,1.9-0.8,1.9-1.9v-2.6l29.9,12.2v9L30.5,76.9' +
            'c-0.3-0.3-0.8-0.5-1.3-0.5H12.4c-1,0-1.9,0.8-1.9,1.9V95c0,1,0.8,' +
            '1.9,1.9,1.9h16.8c1,0,1.9-0.8,1.9-1.9v-6.9h47.4V95c0,1,0.8,1.9,' +
            '1.9,1.9h16.8c1,0,1.9-0.8,1.9-1.9V78.2C99.1,77.2,98.2,76.3,97.2,' +
            '76.3z M31.1,85.1v-4.9l32.8-26.4c0.3,0.3,0.8,0.5,1.3,0.5h10.5l' +
            '7.7,21.9h-3c-1,0-1.9,0.8-1.9,1.9v6.9H31.1z',

            refresh:
           'M99.7,53.8l-10,13.3L85,73.5,78,64,70.4,53.7h9' +
           'A28.5,28.5,0,1,0,68.3,77.6l10.6,6.9A40.7,40.7,0,1,1,91.6,53.8h8.2Z',

            garbage: 'M55.1,31.1c9.4,0,18.7.1,28.1-.1,3.2-.1,4.2,1,3.7,4.1' +
            'q-4.1,28.6-8,57.3c-0.3,2.3-1.3,3.4-3.5,3.4h-41' +
            'c-2.2,0-2.9-1.2-3.2-3.2Q27,63.5,22.7,34.4c-0.4-2.8.6-3.4,3.1-3.4' +
            'H55.1Z' +
            'M44.3,81.9c0.4-1.1-2.5-27.4-3.8-40.5a3.2,3.2,0,0,0-3.7-3.2' +
            'c-2.5.1-2.5,1.9-2.4,3.7,0.5,4.9,1,9.8,1.5,14.7,0.8,8.1,1.6,16.2,' +
            '2.4,24.2,0.2,2.2,1.1,4.1,3.6,3.4A3.6,3.6,0,0,0,44.3,81.9Z' +
            'm21.2,0a2.8,2.8,0,0,0,2.2,2.3' +
            'c2.3,0.8,3.7-.7,4-3.1,1.3-12.9,2.6-25.7,3.8-38.6,0.2-2,.3-4.1-2.6-4.4' +
            's-3.3,1.7-3.5,3.7C68.1,54.8,65.5,81.1,65.5,81.9Z' +
            'M57.9,61.3q0-9.8,0-19.6c0-2.2-.8-3.6-3.2-3.5s-2.6,1.7-2.6,3.6' +
            'q0,19.4,0,38.8c0,1.9,0,3.8,2.8,3.9s3-1.8,3-3.9Q57.9,70.9,57.9,61.3Z' +
            'M19,24.7c0.3-2,.5-5.7,1.5-8a5.1,5.1,0,0,1,3.6-2.3' +
            'c5.5-.5,17.3-0.8,17.3-0.8l4.3-3.3H62.9l5.6,3.5S84.5,14.6,87,15' +
            's2.5,0.7,3.2,1.9,0.9,7.4.9,7.4Z',

            cog: 'M100.2,46.4L87.1,44.8l-2.1-5L93.1,29a2.3,2.3,0,0,0-.2-3' +
            'l-8.7-8.8a2.4,2.4,0,0,0-3.1-.2l-11,7.9L66,23.1,63.1,9.5' +
            'A2.1,2.1,0,0,0,60.8,8H49.3A2.1,2.1,0,0,0,47,9.5L44.2,22.7l-5,2.2' +
            'L28.8,16.8a2.3,2.3,0,0,0-3.1.2l-9.2,9.2a2.4,2.4,0,0,0-.2,3.2' +
            'l8.1,10.4-1.7,4.1L9.8,46.4A2.3,2.3,0,0,0,8,48.7V61.9' +
            'a2.3,2.3,0,0,0,2,2.4L22.6,66l1.7,5.2-7.7,10a2.4,2.4,0,0,0,.2,3.2' +
            'l9.1,9a2.4,2.4,0,0,0,3.3.1l9-8.2,4.8,2.2,2.6,12.7' +
            'a2.3,2.3,0,0,0,2.4,1.9l13.9-.2a2.5,2.5,0,0,0,2.3-2.4' +
            'l0.7-11.4,5.5-2.3,9.8,8.1a2.4,2.4,0,0,0,3.2-.1L93,83.9' +
            'a2.4,2.4,0,0,0,.1-3.3L84.7,71,87,66l13.2-2.5a2.3,2.3,0,0,0,1.9-2.3' +
            'l0.2-12.5A2.4,2.4,0,0,0,100.2,46.4ZM54.4,73' +
            'A18.2,18.2,0,1,1,72.6,54.8,18.2,18.2,0,0,1,54.4,73Z',

            // --- Navigation glyphs ------------------------------------

            flowTable: tableFrame +
            'M86,63.2c0,3.3-2.7,6-6,6c-2.8,0-5.1-1.9-5.8-' +
            '4.5H63.3v5.1c0,0.9-0.7,1.5-1.5,1.5h-5.2v10.6c2.6,0.7,4.5,3,4.5,' +
            '5.8c0,3.3-2.7,6-6,6c-3.3,0-6-2.7-6-6c0-2.8,1.9-5.1,4.4-5.8V71.3' +
            'H48c-0.9,0-1.5-0.7-1.5-1.5v-5.1H36c-0.7,2.6-3,4.4-5.8,4.4c-3.3,' +
            '0-6-2.7-6-6s2.7-6,6-6c2.8,0,5.2,1.9,5.8,4.5h10.5V56c0-0.9,0.7-' +
            '1.5,1.5-1.5h5.5V43.8c-2.6-0.7-4.5-3-4.5-5.8c0-3.3,2.7-6,6-6s6,' +
            '2.7,6,6c0,2.8-1.9,5.1-4.5,5.8v10.6h5.2c0.9,0,1.5,0.7,1.5,1.5v' +
            '5.6h10.8c0.7-2.6,3-4.5,5.8-4.5C83.3,57.1,86,59.8,86,63.2z ' +
            'M55.1,42.3c2.3,0,4.3-1.9,4.3-4.3c0-2.3-1.9-4.3-4.3-4.3' +
            's-4.3,1.9-4.3,4.3C50.8,40.4,52.7,42.3,55.1,42.3z ' +
            'M34.4,63.1c0-2.3-1.9-4.3-4.3-4.3s-4.3,1.9-4.3,4.3' +
            's1.9,4.3,4.3,4.3S34.4,65.5,34.4,63.1z ' +
            'M55.1,83.5c-2.3,0-4.3,1.9-4.3,4.3s1.9,4.3,4.3,4.3' +
            's4.3-1.9,4.3-4.3S57.5,83.5,55.1,83.5z' +
            'M84.2,63.2c0-2.3-1.9-4.3-4.3-4.3s-4.3,' +
            '1.9-4.3,4.3s1.9,4.3,4.3,4.3S84.2,65.5,84.2,63.2z',

            portTable: tableFrame +
            'M85.5,37.7c0-0.7-0.4-1.3-0.9-1.3H26.2c-0.5,0-' +
            '0.9,0.6-0.9,1.3v34.6c0,0.7,0.4,1.3,0.9,1.3h11v9.6c0,1.1,0.5,2,' +
            '1.2,2h9.1c0,0.2,0,0.3,0,0.5v3c0,1.1,0.5,2,1.2,2h13.5c0.6,0,1.2-' +
            '0.9,1.2-2v-3c0-0.2,0-0.3,0-0.5h9.1c0.6,0,1.2-0.9,1.2-2v-9.6h11' +
            'c0.5,0,0.9-0.6,0.9-1.3V37.7z M30.2,40h-1v8h1V40zM75.2,40h-2.1v8' +
            'h2.1V40z M67.7,40h-2.1v8h2.1V40z M60.2,40h-2.1v8h2.1V40z M52.7,' +
            '40h-2.1v8h2.1V40z M45.2,40h-2.1v8h2.1V40zM37.7,40h-2.1v8h2.1V40' +
            'z M81.6,40h-1v8h1V40z',

            groupTable: tableFrame +
            'M45.7,52.7c0.2-5.6,2.6-10.7,6.2-14.4c-2.6-1.5-5.7-2.5-8.9-2.5' +
            'c-9.8,0-17.7,7.9-17.7,17.7c0,6.3,3.3,11.9,8.3,15' +
            'C34.8,61.5,39.4,55.6,45.7,52.7z ' +
            'M51.9,68.8c-3.1-3.1-5.2-7.2-6-11.7c-4.7,2.8-7.9,7.6-8.6,13.2' +
            'c1.8,0.6,3.6,0.9,5.6,0.9C46.2,71.2,49.3,70.3,51.9,68.8z ' +
            'M55.2,71.5c-3.5,2.4-7.7,3.7-12.2,3.7c-1.9,0-3.8-0.3-5.6-0.7' +
            'C38.5,83.2,45.9,90,54.9,90c9,0,16.4-6.7,17.5-15.4' +
            'c-1.6,0.4-3.4,0.6-5.1,0.6C62.8,75.2,58.6,73.8,55.2,71.5z ' +
            'M54.9,50.6c1.9,0,3.8,0.3,5.6,0.7c-0.5-4.1-2.5-7.9-5.4-10.6' +
            'c-2.9,2.7-4.8,6.4-5.3,10.5C51.5,50.8,53.2,50.6,54.9,50.6z ' +
            'M49.7,55.4c0.5,4.3,2.4,8.1,5.4,10.9c2.9-2.8,4.9-6.6,5.4-10.8' +
            'c-1.8-0.6-3.6-0.9-5.6-0.9C53.1,54.6,51.4,54.9,49.7,55.4z ' +
            'M89,53.5c0-12-9.7-21.7-21.7-21.7c-4.5,0-8.7,1.4-12.2,3.7' +
            'c-3.5-2.4-7.7-3.7-12.2-3.7c-12,0-21.7,9.7-21.7,21.7' +
            'c0,8.5,4.9,15.9,12,19.4C33.6,84.6,43.2,94,54.9,94' +
            'c11.7,0,21.2-9.3,21.7-20.9C84,69.7,89,62.2,89,53.5z ' +
            'M64.3,57.3c-0.8,4.4-2.9,8.4-5.9,11.5c2.6,1.5,5.7,2.5,8.9,2.5' +
            'c1.8,0,3.6-0.3,5.2-0.8C72,64.9,68.8,60.1,64.3,57.3z ' +
            'M67.3,35.8c-3.3,0-6.3,0.9-8.9,2.5c3.7,3.8,6.1,8.9,6.2,14.6' +
            'c6.1,3.1,10.6,8.9,11.7,15.8C81.5,65.6,85,60,85,53.5' +
            'C85,43.8,77.1,35.8,67.3,35.8z',

            meterTable: tableFrame +
            'M96.3,79.2c0-19.1-22.1-34.6-41.3-34.6S13.7,60.1,13.7,79.2' +
            'H39.4c0-7.2,8.4-13.1,15.7-13.1S70.6,72,70.6,79.2H96.3z' +
            'M48,65.6L36.8,53c0-.5-1.5.5-1.4,0.7l5.3,16.6z',

            // --- Topology toolbar specific glyphs ----------------------

            summary: 'M95.8,9.2H14.2c-2.8,0-5,2.2-5,5v81.5c0,2.8,2.2,5,5,' +
            '5h81.5c2.8,0,5-2.2,5-5V14.2C100.8,11.5,98.5,9.2,95.8,9.2z ' +
            'M16.7,22.2c0-1.1,0.9-2,2-2h20.1c1.1,0,2,0.9,2,2v20.1c0,1.1-0.9,' +
            '2-2,2H18.7c-1.1,0-2-0.9-2-2V22.2z M93,87c0,1.1-0.9,2-2,2H18.9' +
            'c-1.1,0-2-0.9-2-2v-7c0-1.1,0.9-2,2-2H91c1.1,0,2,0.9,2,2V87z ' +
            'M93,65c0,1.1-0.9,2-2,2H18.9c-1.1,0-2-0.9-2-2v-7c0-1.1,0.9-2,' +
            '2-2H91c1.1,0,2,0.9,2,2V65z',

            details: 'M95.8,9.2H14.2c-2.8,0-5,2.2-5,5v81.5c0,2.8,2.2,5,5,' +
            '5h81.5c2.8,0,5-2.2,5-5V14.2C100.8,11.5,98.5,9.2,95.8,9.2z M16.9,' +
            '22.2c0-1.1,0.9-2,2-2H91c1.1,0,2,0.9,2,2v7c0,1.1-0.9,2-2,2H18.9c' +
            '-1.1,0-2-0.9-2-2V22.2z M93,87.8c0,1.1-0.9,2-2,2H18.9c-1.1,' +
            '0-2-0.9-2-2v-7c0-1.1,0.9-2,2-2H91c1.1,0,2,0.9,2,2V87.8z M93,68.2' +
            'c0,1.1-0.9,2-2,2H18.9c-1.1,0-2-0.9-2-2v-7c0-1.1,0.9-2,2-2H91' +
            'c1.1,0,2,0.9,2,2V68.2z M93,48.8c0,1.1-0.9,2-2,2H19c-1.1,0-2-' +
            '0.9-2-2v-7c0-1.1,0.9-2,2-2H91c1.1,0,2,0.9,2,2V48.8z',

            ports: 'M98,9.2H79.6c-1.1,0-2.1,0.9-2.1,2.1v17.6l-5.4,5.4c-1.7' +
            '-1.1-3.8-1.8-6-1.8c-6,0-10.9,4.9-10.9,10.9c0,2.2,0.7,4.3,1.8,6' +
            'l-7.5,7.5c-1.8-1.2-3.9-1.9-6.2-1.9c-6,0-10.9,4.9-10.9,10.9c0,' +
            '2.3,0.7,4.4,1.9,6.2l-6.2,6.2H11.3c-1.1,0-2.1,0.9-2.1,2.1v18.4' +
            'c0,1.1,0.9,2.1,2.1,2.1h18.4c1.1,0,2.1-0.9,2.1-2.1v-16l7-6.9' +
            'c1.4,0.7,3,1.1,4.7,1.1c6,0,10.9-4.9,10.9-10.9c0-1.7-0.4-3.3-' +
            '1.1-4.7l8-8c1.5,0.7,3.1,1.1,4.8,1.1c6,0,10.9-4.9,10.9-10.9c0' +
            '-1.7-0.4-3.4-1.1-4.8l6.9-6.9H98c1.1,0,2.1-0.9,2.1-2.1V11.3' +
            'C100.1,10.2,99.2,9.2,98,9.2z M43.4,72c-3.3,0-6-2.7-6-6s2.7-6,' +
            '6-6s6,2.7,6,6S46.7,72,43.4,72z M66.1,49.5c-3.3,0-6-2.7-6-6' +
            'c0-3.3,2.7-6,6-6s6,2.7,6,6C72.2,46.8,69.5,49.5,66.1,49.5z',

            map: 'M95.8,9.2H14.2c-2.8,0-5,2.2-5,5v66c0.3-1.4,0.7-2.8,' +
            '1.1-4.1l1.6,0.5c-0.9,2.4-1.6,4.8-2.2,7.3l-0.5-0.1v12c0,2.8,2.2,' +
            '5,5,5h81.5c2.8,0,5-2.2,5-5V14.2C100.8,11.5,98.5,9.2,95.8,9.2z ' +
            'M16.5,67.5c-0.4,0.5-0.7,1-1,1.5c-0.3,0.5-0.6,1-0.9,1.6l-1.9-0.9' +
            'c0.3-0.6,0.6-1.2,0.9-1.8c0.3-0.6,0.6-1.2,1-1.7c0.7-1.1,1.5-2.2,' +
            '2.5-3.2l1.8,1.8C18,65.6,17.2,66.5,16.5,67.5z M29.7,64.1' +
            'c-0.4-0.4-0.8-0.8-1.2-1.1c-0.1-0.1-0.2-0.1-0.2-0.1c0,0-0.1,' +
            '0-0.1-0.1l-0.1,0l0,0l-0.1,0c-0.3-0.1-0.5-0.2-0.8-0.2c-0.5-0.1' +
            '-1.1-0.2-1.6-0.3c-0.6,0-1.1,0-1.6,0l-0.4-2.8c0.7-0.1,1.5-0.2,2.2' +
            '-0.1c0.7,0,1.4,0.1,2.2,0.3c0.4,0.1,0.7,0.2,1,0.3l0.1,0l0,0l0.1,' +
            '0l0.1,0c0.1,0,0.1,0,0.3,0.1c0.3,0.1,0.5,0.2,0.7,0.4c0.7,0.5,' +
            '1.2,0.9,1.7,1.4L29.7,64.1z M39.4,74.7c-1.8-1.8-3.6-3.8-5.3-5.7' +
            'l2.6-2.4c0.9,0.9,1.8,1.8,2.7,2.7c0.9,0.9,1.8,1.7,2.7,2.6L39.4,' +
            '74.7z M50.8,84.2c-1.1-0.7-2.2-1.5-3.3-2.3c-0.5-0.4-1.1-0.8-1.6' +
            '-1.2c-0.5-0.4-1-0.8-1.5-1.2l2.7-3.4c0.5,0.4,1,0.8,1.5,1.1c0.5,' +
            '0.3,1,0.7,1.5,1c1,0.7,2.1,1.3,3.1,1.9L50.8,84.2z M61.3,' +
            '88.7c-0.7-0.1-1.4-0.3-2.1-0.5c-0.7-0.2-1.4-0.5-2-0.7l1.8' +
            '-4.8c0.6,0.2,1.1,0.4,1.6,0.5c0.5,0.2,1.1,0.3,1.6,0.4c1,0.2,2.1,' +
            '0.2,3,0.1l0.7,5.1C64.3,89.1,62.7,88.9,61.3,88.7z M75.1,80.4c' +
            '-0.2,0.7-0.5,1.4-0.9,2c-0.2,0.3-0.3,0.7-0.5,1l-0.3,0.5l-0.3,' +
            '0.4l-3.9-2.8l0.3-0.4l0.2-0.3c0.1-0.2,0.3-0.4,0.4-0.7c0.3-0.5,' +
            '0.5-0.9,0.7-1.5c0.4-1,0.8-2.1,1.1-3.3l4.2,0.9C75.9,77.7,75.6,' +
            '79,75.1,80.4z M73,69.2l0.2-1.9l0.1-1.9c0.1-1.2,0.1-2.5,0.1-' +
            '3.8l2.5-0.2c0.2,1.3,0.4,2.6,0.5,3.9l0.1,2l0.1,2L73,69.2z ' +
            'M73,51l0.5-0.1c0.4,1.3,0.8,2.6,1.1,3.9L73.2,55C73.1,53.7,73.1,' +
            '52.3,73,51z M91.9,20.4c-0.7,1.4-3.6,3.6-4.2,3.9c-1.5,0.8-5,' +
            '2.8-10.1,7.7c3,2.9,5.8,5.4,7.3,6.4c2.6,1.8,3.4,4.3,3.6,6.1c0.1,' +
            '1.1-0.1,2.5-0.4,3c-0.5,0.9-1.6,2-3,1.4c-2-0.8-11.5-9.6-13-11c' +
            '-3.5,3.9-7.4,8.9-11.7,15.1c0,0-3.1,3.4-5.2,0.9C52.9,51.5,61,' +
            '39.3,61,39.3s2.2-3.1,5.6-7c-2.9-3-5.9-6.3-6.6-7.3c0,0-3.7-5-1.3' +
            '-6.6c3.2-2.1,6.3,0.8,6.3,0.8s3.1,3.3,7,7.2c4.7-4.7,10.1-9.2,' +
            '14.7-10c0,0,3.3-1,5.2,1.7C92.5,18.8,92.4,19.6,91.9,20.4z',

            cycleLabels: 'M72.5,33.9c0,0.6-0.2,1-0.5,1H40c-0.3,0-0.5-0.4' +
            '-0.5-1V20.7c0-0.6,0.2-1,0.5-1h32c0.3,0,0.5,0.4,0.5,1V33.9z ' +
            'M41.2,61.8c0-0.6-0.2-1-0.5-1h-32c-0.3,0-0.5,0.4-0.5,1V75c0,0.6,' +
            '0.2,1,0.5,1h32c0.3,0,0.5-0.4,0.5-1V61.8z M101.8,61.8c0-0.6-0.2' +
            '-1-0.5-1h-32c-0.3,0-0.5,0.4-0.5,1V75c0,0.6,0.2,1,0.5,1h32c0.3,' +
            '0,0.5-0.4,0.5-1V61.8z M17.2,52.9c0-0.1-0.3-7.1,4.6-13.6l-2.4-1.8' +
            'c-5.4,7.3-5.2,15.2-5.1,15.5L17.2,52.9z M12.7,36.8l7.4,2.5l1.5,' +
            '7.6L29.5,31L12.7,36.8z M94.2,42.3c-2.1-8.9-8.3-13.7-8.6-13.9l' +
            '-1.8,2.4c0.1,0,5.6,4.3,7.5,12.2L94.2,42.3z M99,37.8l-6.6,4.1l' +
            '-6.8-3.7l7.1,16.2L99,37.8z M69,90.2l-1.2-2.8c-0.1,0-6.6,2.8' +
            '-14.3,0.6l-0.8,2.9c2.5,0.7,4.9,1,7,1C65,91.8,68.7,90.2,69,90.2z ' +
            'M54.3,97.3L54,89.5l6.6-4.1l-17.6-1.7L54.3,97.3z',

            oblique: 'M80.9,30.2h4.3l15-16.9H24.8l-15,16.9h19v48.5h-4l-15,' +
            '16.9h75.3l15-16.9H80.9V30.2z M78.6,78.7H56.1V30.2h22.5V78.7z' +
            'M79.7,17.4c2.4,0,4.3,1.9,4.3,4.3c0,2.4-1.9,4.3-4.3,4.3s-4.3' +
            '-1.9-4.3-4.3C75.4,19.3,77.4,17.4,79.7,17.4z M55,17.4c2.4,0,' +
            '4.3,1.9,4.3,4.3c0,2.4-1.9,4.3-4.3,4.3s-4.3-1.9-4.3-4.3C50.7,' +
            '19.3,52.6,17.4,55,17.4z M26.1,21.7c0-2.4,1.9-4.3,4.3-4.3c2.4,' +
            '0,4.3,1.9,4.3,4.3c0,2.4-1.9,4.3-4.3,4.3C28,26,26.1,24.1,26.1,' +
            '21.7z M31.1,30.2h22.6v48.5H31.1V30.2z M30.3,91.4c-2.4,0-4.3' +
            '-1.9-4.3-4.3c0-2.4,1.9-4.3,4.3-4.3c2.4,0,4.3,1.9,4.3,4.3C34.6,' +
            '89.5,32.7,91.4,30.3,91.4z M54.9,91.4c-2.4,0-4.3-1.9-4.3-4.3c0' +
            '-2.4,1.9-4.3,4.3-4.3c2.4,0,4.3,1.9,4.3,4.3C59.2,89.5,57.3,' +
            '91.4,54.9,91.4z M84,87.1c0,2.4-1.9,4.3-4.3,4.3c-2.4,0-4.3-1.9' +
            '-4.3-4.3c0-2.4,1.9-4.3,4.3-4.3C82.1,82.8,84,84.7,84,87.1z',

            filters: 'M24.8,13.3L9.8,40.5h75.3l15.0-27.2H24.8z M72.8,32.1l-' +
            '9.7-8.9l-19.3,8.9l-6.0-7.4L24.1,30.9l-1.2-2.7l15.7-7.1l6.0,7.4' +
            'l19.0-8.8l9.7,8.8l11.5-5.6l1.3,2.7L72.8,32.1zM24.3,68.3L9.3,' +
            '95.5h75.3l15.0-27.2H24.3z M84.3,85.9L70.7,79.8l-6.0,7.4l-19.3' +
            '-8.9l-9.7,8.9l-13.3-6.5l1.3-2.7l11.5,5.6l9.7-8.8l19.0,8.8l6.0' +
            '-7.4l15.7,7.1L84.3,85.9z M15.3,57h-6v-4h6V57zM88.1,57H76.0v-4h' +
            '12.1V57z M69.9,57H57.8v-4h12.1V57z M51.7,57H39.6v-4H51.7V57z ' +
            'M33.5,57H21.4v-4h12.1V57zM100.2,57h-6v-4h6V57z',

            resetZoom: 'M86,79.8L61.7,54.3c1.8-2.9,2.8-6.3,2.9-10c0.3-11.2' +
            '-8.6-20.5-19.8-20.8C33.7,23.2,24.3,32,24.1,43.2c-0.3,11.2,8.6,' +
            '20.5,19.8,20.8c4,0.1,8.9-0.8,11.9-3.6l23.7,25c1.5,1.6,4,2.3,' +
            '5.3,1l1.6-1.6C87.7,83.7,87.5,81.4,86,79.8z M31.4,43.4c0.2-7.1,' +
            '6.1-12.8,13.2-12.6C51.8,31,57.5,37,57.3,44.1c-0.2,7.1-6.1,12.8' +
            '-13.2,12.6C36.9,56.5,31.3,50.6,31.4,43.4zM22.6,104H6V86.4c0' +
            '-1.7,1.4-3.1,3.1-3.1s3.1,1.4,3.1,3.1v11.4h10.4c1.7,0,3.1,1.4,' +
            '3.1,3.1S24.3,104,22.6,104z M25.7,9.1c0,1.7-1.4,3.1-3.1,3.1' +
            'H12.2v11.4c0,1.7-1.4,3.1-3.1,3.1S6,25.3,6,23.6V6h16.6C24.3,6,' +
            '25.7,7.4,25.7,9.1z M84.3,100.9c0-1.7,1.4-3.1,3.1-3.1h10.4V86.4' +
            'c0-1.7,1.4-3.1,3.1-3.1s3.1,1.4,3.1,3.1V104H87.4C85.7,104,84.3,' +
            '102.6,84.3,100.9z M87.4,6H104v17.6c0,1.7-1.4,3.1-3.1,3.1s-3.1' +
            '-1.4-3.1-3.1V12.2H87.4c-1.7,0-3.1-1.4-3.1-3.1S85.7,6,87.4,6z',

            relatedIntents: 'M99.9,43.7v22.6c0,1.9-1.5,3.4-3.4,3.4H73.9c' +
            '-1.9,0-3.4-1.5-3.4-3.4V43.7c0-1.9,1.5-3.4,3.4-3.4h22.6C98.4,' +
            '40.3,99.9,41.8,99.9,43.7z M48.4,46.3l6.2,6.7h-4.6L38.5,38v9.7' +
            'l4.7,5.3H10.1V57h33.2l-4.8,5.3v9.5L49.8,57h5.1v0l-6.5,7v11.5' +
            'L64.1,55L48.4,34.4V46.3z',

            nextIntent: 'M88.1,55.7L34.6,13.1c0,0-1.6-0.5-2.1-0.2c-1.9,1.2' +
            '-6.5,13.8-3.1,17.2c7,6.9,30.6,24.5,32.4,25.9c-1.8,1.4-25.4,19' +
            '-32.4,25.9c-3.4,3.4,1.2,16,3.1,17.2c0.6,0.4,2.1-0.2,2.1-0.2' +
            's53.1-42.4,53.5-42.7C88.5,56,88.1,55.7,88.1,55.7z',

            prevIntent: 'M22.5,55.6L76,12.9c0,0,1.6-0.5,2.2-0.2c1.9,1.2,' +
            '6.5,13.8,3.1,17.2c-7,6.9-30.6,24.5-32.4,25.9c1.8,1.4,25.4,19,' +
            '32.4,25.9c3.4,3.4-1.2,16-3.1,17.2c-0.6,0.4-2.2-0.2-2.2-0.2' +
            'S22.9,56.3,22.5,56C22.2,55.8,22.5,55.6,22.5,55.6z',

            intentTraffic: 'M14.7,71.5h-6v-33h6V71.5z M88.5,38.5H76.9v33' +
            'h11.7V38.5z M70.1,38.5H58.4v33h11.7V38.5z M51.6,38.5H39.9v33' +
            'h11.7V38.5z M33.1,38.5H21.5v33h11.7V38.5z M101.3,38.5h-6v33h6' +
            'V38.5z',

            allTraffic: 'M15.7,64.5h-7v-19h7V64.5z M78.6,45.5H62.9v19h15.7' +
            'V45.5z M47.1,45.5H31.4v19h15.7V45.5z M101.3,45.5h-7v19h7V45.5z' +
            'M14.7,14.1h-6v19h6V14.1z M88.5,14.1H76.9v19h11.7V14.1z M70.1,' +
            '14.1H58.4v19h11.7V14.1z M51.6,14.1H39.9v19h11.7V14.1z M33.1,14.1' +
            'H21.5v19h11.7V14.1z M101.3,14.1h-6v19h6V14.1z M14.7,76.9h-6v19' +
            'h6V76.9z M88.5,76.9H76.9v19h11.7V76.9z M70.1,76.9H58.4v19h11.7' +
            'V76.9z M51.6,76.9H39.9v19h11.7V76.9z M33.1,76.9H21.5v19h11.7' +
            'V76.9z M101.3,76.9h-6v19h6V76.9z',

            flows: 'M93.8,46.1c-4.3,0-8,3-9,7H67.9v-8.8c0-1.3-1.1-2.4-2.4' +
            '-2.4h-8.1V25.3c4-1,7-4.7,7-9.1c0-5.2-4.2-9.4-9.4-9.4c-5.2,0' +
            '-9.4,4.2-9.4,9.4c0,4.3,3,8,7,9v16.5H44c-1.3,0-2.4,1.1-2.4,2.4' +
            'v8.8H25.3c-1-4.1-4.7-7.1-9.1-7.1c-5.2,0-9.4,4.2-9.4,9.4s4.2,' +
            '9.4,9.4,9.4c4.3,0,8-2.9,9-6.9h16.4v7.9c0,1.3,1.1,2.4,2.4,2.4' +
            'h8.6v16.6c-4,1.1-6.9,4.7-6.9,9c0,5.2,4.2,9.4,9.4,9.4c5.2,0,' +
            '9.4-4.2,9.4-9.4c0-4.4-3-8-7.1-9.1V68.2h8.1c1.3,0,2.4-1.1,2.4' +
            '-2.4v-7.9h16.8c1.1,4,4.7,7,9,7c5.2,0,9.4-4.2,9.4-9.4S99,46.1,' +
            '93.8,46.1z M48.7,16.3c0-3.5,2.9-6.4,6.4-6.4c3.5,0,6.4,2.9,6.4,' +
            '6.4s-2.9,6.4-6.4,6.4C51.5,22.6,48.7,19.8,48.7,16.3zM16.2,61.7c' +
            '-3.5,0-6.4-2.9-6.4-6.4c0-3.5,2.9-6.4,6.4-6.4s6.4,2.9,6.4,6.4' +
            'C22.6,58.9,19.7,61.7,16.2,61.7z M61.4,93.7c0,3.5-2.9,6.4-6.4,' +
            '6.4c-3.5,0-6.4-2.9-6.4-6.4c0-3.5,2.9-6.4,6.4-6.4C58.6,87.4,' +
            '61.4,90.2,61.4,93.7z M93.8,61.8c-3.5,0-6.4-2.9-6.4-6.4c0-3.5,' +
            '2.9-6.4,6.4-6.4s6.4,2.9,6.4,6.4C100.1,58.9,97.3,61.8,93.8,61.8z',

            eqMaster: 'M100.1,46.9l-10.8-25h0.2c0.5,0,0.8-0.5,0.8-1.1v-3.2' +
            'c0-0.6-0.4-1.1-0.8-1.1H59.2v-5.1c0-0.5-0.8-1-1.7-1h-5.1c-0.9,0' +
            '-1.7,0.4-1.7,1v5.1l-30.2,0c-0.5,0-0.8,0.5-0.8,1.1v3.2c0,0.6,' +
            '0.4,1.1,0.8,1.1h0.1l-10.8,25C9,47.3,8.4,48,8.4,48.8v1.6l0,0h0' +
            'v6.4c0,1.3,1.4,2.3,3.2,2.3h21.7c1.8,0,3.2-1,3.2-2.3v-8c0-0.9' +
            '-0.7-1.6-1.7-2L22.9,21.9h27.9v59.6l-29,15.9c0,1.2,1.8,2.2,4.1,' +
            '2.2h58.3c2.3,0,4.1-1,4.1-2.2l-29-15.9V21.9h27.8L75.2,46.8c-1,' +
            '0.4-1.7,1.1-1.7,2v8c0,1.3,1.4,2.3,3.2,2.3h21.7c1.8,0,3.2-1,3.2' +
            '-2.3v-8C101.6,48,101,47.3,100.1,46.9z M22,23.7l10.8,22.8H12.1' +
            'L22,23.7z M97.9,46.5H77.2L88,23.7L97.9,46.5z',

            xClose: 'M20,8l35,35,35-35,12,12-35,35,35,35-12,12-35-35-35,35' +
            '-12-12,35-35-35-35,12-12Z'
        },

        badgeDataSet = {
            _viewbox: '0 0 10 10',

            checkMark: 'M8.6,3.4L4.4,7.7L1.4,4.7L2.5,3.6L4.4,5.5L7.5,2.3L8.6,3.4Z',

            xMark: 'M7.8,6.7L6.7,7.8,5,6.1,3.3,7.8,2.2,6.7,3.9,5,2.2,3.3,3.3,' +
            '2.2,5,3.9,6.7,2.2,7.8,3.3,6.1,5Z',

            triangleUp: 'M0.5,6.2c0,0,3.8-3.8,4.2-4.2C5,1.7,5.3,2,5.3,2l4.3,' +
            '4.3c0,0,0.4,0.4-0.1,0.4c-1.7,0-8.2,0-8.8,0C0,6.6,0.5,6.2,0.5,6.2z',

            triangleDown: 'M9.5,4.2c0,0-3.8,3.8-4.2,4.2c-0.3,0.3-0.5,0-0.5,' +
            '0L0.5,4.2c0,0-0.4-0.4,0.1-0.4c1.7,0,8.2,0,8.8,0C10,3.8,9.5,4.2,' +
            '9.5,4.2z',

            plus: 'M4,2h2v2h2v2h-2v2h-2v-2h-2v-2h2z',

            minus: 'M2,4h6v2h-6z',

            play: 'M3,1.5l3.5,3.5l-3.5,3.5z',

            stop: 'M2.5,2.5h5v5h-5z'
        },

        spriteData = {
            _cloud: '0 0 110 110',
            cloud: 'M37.6,79.5c-6.9,8.7-20.4,8.6-22.2-2.7' +
            'M16.3,41.2c-0.8-13.9,19.4-19.2,23.5-7.8' +
            'M38.9,30.9c5.1-9.4,15.1-8.5,16.9-1.3' +
            'M54.4,32.9c4-12.9,14.8-9.6,18.6-3.8' +
            'M95.8,58.5c10-4.1,11.7-17.8-0.9-19.8' +
            'M18.1,76.4C5.6,80.3,3.8,66,13.8,61.5' +
            'M16.2,62.4C2.1,58.4,3.5,36,16.8,36.6' +
            'M93.6,74.7c10.2-2,10.7-14,5.8-18.3' +
            'M71.1,79.3c11.2,7.6,24.6,6.4,22.1-11.7' +
            'M36.4,76.8c3.4,13.3,35.4,11.6,36.1-1.4' +
            'M70.4,31c11.8-10.4,26.2-5.2,24.7,10.1'
        },


        // --- Mojo Re-Design ---------------------------------------

        m_octagon = 'M33.5,91.9a1.8,1.8,0,0,1-1.3-.5L8.7,68a1.8,1.8,0,0,' +
            '1-.5-1.3V33.5a1.8,1.8,0,0,1,.5-1.3L32,8.7a1.8,1.8,0,0,1,1.3-.5' +
            'H66.5a1.8,1.8,0,0,1,1.3.5L91.3,32a1.8,1.8,0,0,1,.5,1.3V66.5' +
            'a1.8,1.8,0,0,1-.5,1.3L68,91.3a1.8,1.8,0,0,1-1.3.5H33.5Z' +
            'm-21.7-26L34.3,88.2H65.9L88.2,65.7V34.1L65.7,11.8H34.1' +
            'L11.8,34.3V65.9Z',

        m_switch_arrows = 'M60,42.1l-0.9-.3a1.8,1.8,0,0,1-.9-1.6V33.8' +
            'a1.8,1.8,0,0,1,3.7,0v3.3l13-7.1L61.9,23v3.3' +
            'A1.8,1.8,0,0,1,60,28.2h-7v3.7h1.7a1.8,1.8,0,0,1,0,3.7H51.2' +
            'a1.8,1.8,0,0,1-1.8-1.8V26.4a1.8,1.8,0,0,1,1.8-1.8h7V20' +
            'a1.8,1.8,0,0,1,2.7-1.6l18.7,10a1.8,1.8,0,0,1,0,3.2L60.9,41.8Z' +
            'M60,69.2l-0.9-.3a1.8,1.8,0,0,1-.9-1.6V60.9a1.8,1.8,0,0,1,3.7,0' +
            'v3.3l13-7.1-13-6.9v3.3A1.8,1.8,0,0,1,60,55.3h-7V59h1.7' +
            'a1.8,1.8,0,0,1,0,3.7H51.2a1.8,1.8,0,0,1-1.8-1.8V53.5' +
            'a1.8,1.8,0,0,1,1.8-1.8h7V47.1a1.8,1.8,0,0,1,2.7-1.6l18.7,10' +
            'a1.8,1.8,0,0,1,0,3.2L60.9,69ZM40,54.8l-0.9-.2L20.4,44.2' +
            'a1.8,1.8,0,0,1,0-3.2L39.1,31a1.8,1.8,0,0,1,2.7,1.6v4.5h7' +
            'A1.8,1.8,0,0,1,50.6,39v7.4a1.8,1.8,0,0,1-1.8,1.8H45.2' +
            'a1.8,1.8,0,0,1,0-3.7h1.7V40.9H40A1.8,1.8,0,0,1,38.1,39' +
            'V35.7l-13,6.9,13,7.1V46.4a1.8,1.8,0,0,1,3.7,0v6.5' +
            'a1.8,1.8,0,0,1-.9,1.6ZM40,81.9l-0.9-.2L20.4,71.4' +
            'a1.8,1.8,0,0,1,0-3.2l18.7-10a1.8,1.8,0,0,1,2.7,1.6v4.5h7' +
            'a1.8,1.8,0,0,1,1.8,1.8v7.4a1.8,1.8,0,0,1-1.8,1.8H45.2' +
            'a1.8,1.8,0,0,1,0-3.7h1.7V68H40a1.8,1.8,0,0,1-1.8-1.8V62.9' +
            'l-13,6.9,13,7.1V73.6a1.8,1.8,0,0,1,3.7,0V80a1.8,1.8,0,0,1-.9,1.6Z',

        m_diamond = 'M50,87a16.1,16.1,0,0,1-11.5-4.7L17.7,61.5a16.3,16.3,0,0,' +
            '1,0-22.9L38.5,17.7a16.3,16.3,0,0,1,22.9,0L82.3,38.5' +
            'a16.3,16.3,0,0,1,0,22.9L61.5,82.3A16.1,16.1,0,0,1,50,87Z' +
            'm0-70.3a12.4,12.4,0,0,0-8.9,3.7L20.3,41.1a12.6,12.6,0,0,0,0,' +
            '17.7L41.1,79.7a12.6,12.6,0,0,0,17.7,0L79.7,58.9a12.6,12.6,0,0,' +
            '0,0-17.7L58.9,20.3A12.4,12.4,0,0,0,50,16.7Z',

        m_trafficArrows = 'M41,66.7l-0.9-.2-16.8-9a1.8,1.8,0,0,1,0-3.2' +
            'L40.1,45a1.8,1.8,0,0,1,2.7,1.6v5.8a1.8,1.8,0,0,1-3.7,0V49.7' +
            'L28,55.8l11.1,5.9V59.1A1.8,1.8,0,0,1,41,57.2H47v-3H45.7' +
            'a1.8,1.8,0,0,1,0-3.7h3.2a1.8,1.8,0,0,1,1.8,1.8v6.7' +
            'a1.8,1.8,0,0,1-1.8,1.8H42.8v3.9a1.8,1.8,0,0,1-.9,1.6ZM59,55.3' +
            'l-1-.3a1.8,1.8,0,0,1-.9-1.6V49.5H51.1a1.8,1.8,0,0,1-1.8-1.8' +
            'V41a1.8,1.8,0,0,1,1.8-1.8h3.2a1.8,1.8,0,0,1,0,3.7H53v3H59' +
            'a1.8,1.8,0,0,1,1.8,1.8v2.7L72,44.4,60.9,38.3V41' +
            'a1.8,1.8,0,0,1-3.7,0V35.2a1.8,1.8,0,0,1,2.7-1.6l16.8,9.3' +
            'a1.8,1.8,0,0,1,0,3.2L59.9,55Z',

        m_intentArrows = 'M55.9,77.8a1.9,1.9,0,0,1-1.6-1L45,60a1.9,1.9,0,0,' +
            '1,1.6-2.7h5.8a1.9,1.9,0,0,1,0,3.7H49.7L55.8,72l5.9-11.1H59.1' +
            'a1.9,1.9,0,0,1-1.9-1.9V53h-3v1.3a1.9,1.9,0,0,1-3.7,0V51.1' +
            'a1.9,1.9,0,0,1,1.9-1.9h6.7A1.9,1.9,0,0,1,61,51.1v6.1h3.9' +
            'a1.9,1.9,0,0,1,1.6,2.7l-9,16.9a1.9,1.9,0,0,1-1.6,1h0Z' +
            'M47.7,50.7H41a1.9,1.9,0,0,1-1.9-1.9V45.7a1.9,1.9,0,0,1,3.7,0' +
            'V47h3V40.9a1.9,1.9,0,0,1,1.9-1.9h2.7L44.4,28,38.3,39.1H41' +
            'a1.9,1.9,0,0,1,0,3.7H35.1A1.9,1.9,0,0,1,33.5,40l9.3-16.9' +
            'a1.9,1.9,0,0,1,1.6-1h0a1.9,1.9,0,0,1,1.6,1l9,16.9a1.9,1.9,0,0,' +
            '1-1.6,2.7H49.5v6.1A1.9,1.9,0,0,1,47.7,50.7Z',


        mojoDataSet = {
            _viewbox: '0 0 100 100',

            m_cloud: 'M62,48.8H61.5a1.8,1.8,0,0,1-1.3-2.3,11,11,0,0,' +
            '0-21.1-6.1,1.8,1.8,0,1,1-3.5-1,14.7,14.7,0,0,1,28.2,8.1' +
            'A1.8,1.8,0,0,1,62,48.8ZM70.6,71.2H28.3' +
            'A14.7,14.7,0,1,1,38.4,45.2,1.8,1.8,0,1,1,36,48' +
            'a11,11,0,1,0-7.5,19.4H71.8A11,11,0,0,0,71,45.5' +
            'a10.9,10.9,0,0,0-3.2.5,1.8,1.8,0,1,1-1.1-3.5,14.7,14.7,0,0,1,19,14' +
            'A14.8,14.8,0,0,1,72.2,71.1H70.6Z',

            m_map: 'M50,17.6A32.4,32.4,0,1,0,82.4,50,32.4,32.4,0,0,0,50,17.6Z' +
            'm0,61.1A28.7,28.7,0,1,1,78.7,50,28.7,28.7,0,0,1,50,78.7Z' +
            'M75.9,48.8a1.8,1.8,0,0,1-1.8,1.8H65' +
            'a38.3,38.3,0,0,1-8.4,22.9,1.8,1.8,0,0,1-1.4.7,1.8,1.8,0,0,' +
            '1-1.2-.4,1.8,1.8,0,0,1-.3-2.6,34.6,34.6,0,0,0,7.5-20.5H39.2' +
            'a34.5,34.5,0,0,0,7.6,20.7,1.8,1.8,0,0,1-1.4,3,1.8,1.8,0,0,' +
            '1-1.4-.7,38.2,38.2,0,0,1-8.5-23H26.2a1.8,1.8,0,1,1,0-3.7' +
            'h9.4a38.1,38.1,0,0,1,8.4-21.6,1.8,1.8,0,0,1,2.9,2.3,34.4,34.4,0,0,' +
            '0-7.6,19.3h22a34.3,34.3,0,0,0-8-19.7,1.8,1.8,0,1,1,2.8-2.4,38,38,' +
            '0,0,1,8.8,22.1h9.1A1.8,1.8,0,0,1,75.9,48.8Z',

            m_selectMap: 'M51.36,8.74A32.45,32.45,0,0,0,19,41.15' +
            'a32.12,32.12,0,0,0,9.22,22.62L17,72.07a1.84,1.84,0,0,0,1,3.32' +
            'L35.52,76h0l10,14.42a1.84,1.84,0,0,0,1.52.79,2.05,2.05,0,0,' +
            '0,.49-0.06,1.84,1.84,0,0,0,1.35-1.66l2.68-39.19' +
            'a1.73,1.73,0,0,0-.06-0.6,0.85,0.85,0,0,0-.09-0.24,1.7,1.7,0,0,' +
            '0-.81-0.9l-0.18-.1a1.69,1.69,0,0,0-.94-0.16H49.33l-0.16,0' +
            'a1,1,0,0,0-.31.12,1.52,1.52,0,0,0-.33.18L42.73,53' +
            'a34.6,34.6,0,0,1-2.22-11.21H62.68a34.55,34.55,0,0,1-7.55,20.54' +
            'A1.85,1.85,0,1,0,58,64.63a38.26,38.26,0,0,0,8.37-22.86h9.08' +
            'a1.85,1.85,0,0,0,0-3.7H66.3a38.06,38.06,0,0,0-8.83-22.14,' +
            '1.85,1.85,0,1,0-2.82,2.38,34.37,34.37,0,0,1,8,19.76h-22' +
            'a34.38,34.38,0,0,1,7.58-19.3,1.85,1.85,0,1,0-2.87-2.33,' +
            '38.11,38.11,0,0,0-8.41,21.63H27.53a1.85,1.85,0,0,0,0,3.7' +
            'h9.28a38.43,38.43,0,0,0,2.85,13.48l-8.5,6.31a28.71,28.71,0,1,' +
            '1,23.21,8.16,1.85,1.85,0,0,0,.19,3.68h0.19A32.41,32.41,0,0,' +
            '0,51.36,8.74Zm-4,49.75L45.57,84l-6.85-9.87,2.64-4.92,0.56-1,2.8-5' +
            'C45.61,61.58,46.49,60,47.31,58.49ZM44,56.63' +
            'c-0.81,1.5-1.69,3.11-2.56,4.73l-3.3,6.11-0.19.35' +
            'C37,69.4,36.19,70.93,35.4,72.34l-12-.44Z',

            thatsNoMoon: 'M50,83.4A33.2,33.2,0,1,1,83.2,50.2,33.2,33.2,0,0,' +
            '1,50,83.4ZM79.3,50.1A29.3,29.3,0,1,0,50.1,79.4,29.3,29.3,0,0,0,' +
            '79.3,50.1ZM65.4,46.9h9.1A1.9,1.9,0,0,1,76.4,48a1.9,1.9,0,0,' +
            '1-.3,2.1,2.1,2.1,0,0,1-1.8.7H65.4c-0.1.6-.1,1.2-0.2,1.8' +
            'A38.5,38.5,0,0,1,57,73.9a2.1,2.1,0,0,1-2.2.9,2,2,0,0,' +
            '1-1.4-1.6,2.3,2.3,0,0,1,.6-1.7,33.6,33.6,0,0,0,4.9-8.5,34.6,34.6,' +
            '0,0,0,2.5-11c0-.3,0-0.7,0-1.1H38.9c0.2,1.3.3,2.6,0.5,3.9' +
            'a34.2,34.2,0,0,0,7.3,17,2,2,0,1,1-3,2.4A37.1,37.1,0,0,1,39.1,67' +
            'a40.8,40.8,0,0,1-4-15.5V50.8H25.8a2,2,0,0,1-2.2-1.9,1.9,1.9,0,0,' +
            '1,2.1-2H35l0.3-1.8-0.8-.2a7.5,7.5,0,0,1-5.5-8.5,12.4,12.4,0,0,' +
            '1,10-10.3,15.5,15.5,0,0,1,3.4,0,0.6,0.6,0,0,0,.7-0.3l0.8-1.1' +
            'a1.9,1.9,0,0,1,2.5-.4,1.8,1.8,0,0,1,.7,2.4,13.6,13.6,0,0,' +
            '1-.8,1.4,7.7,7.7,0,0,1,2.1,6.3A11,11,0,0,1,46,40.2a12.6,12.6,0,0,' +
            '1-6.3,4.5,0.5,0.5,0,0,0-.5.6c0,0.5-.1,1-0.1,1.6H61.5l-0.7-4' +
            'A33.6,33.6,0,0,0,53.5,27c-0.8-1-.9-1.7-0.4-2.5a1.7,1.7,0,0,' +
            '1,2.4-.7,3.6,3.6,0,0,1,1.1.9,37,37,0,0,1,8,17.1' +
            'c0.3,1.5.4,3,.7,4.4v0.7Zm-28.8-4A10.1,10.1,0,0,0,46,34.1' +
            'a5.3,5.3,0,0,0-6-5.8A10.2,10.2,0,0,0,31.3,36' +
            'C30.4,39.9,32.8,42.9,36.6,42.9ZM34.9,35.1a4,4,0,0,' +
            '1,2.7-3.2,2.7,2.7,0,0,1,3.8,2.6,4.4,4.4,0,0,1-2.5,4' +
            'C36.8,39.5,34.7,38,34.9,35.1Zm2,0.7c0,0.7.3,1,.9,0.9' +
            'a2.3,2.3,0,0,0,1.5-2.3,0.7,0.7,0,0,0-1.1-.6' +
            'A2.2,2.2,0,0,0,36.9,35.8Z',

            m_ports: 'M83.2,20L80,16.8a4.8,4.8,0,0,0-6.8,0l-1.4,1.4' +
            'a4.8,4.8,0,0,0-1.4,3.4l-4.5,5.9a3.8,3.8,0,0,0,.4,5l1.2,1.2' +
            'a3.8,3.8,0,0,0,5,.4l5.4-3.9,0.5-.6h0a4.8,4.8,0,0,0,3.4-1.4' +
            'l1.4-1.4A4.8,4.8,0,0,0,83.2,20ZM70.3,31.1H70.1l-1.2-1.2' +
            'a0.2,0.2,0,0,1,0-.2l3.3-4.4,2.6,2.6Zm10.3-6.9-1.4,1.4' +
            'a1.1,1.1,0,0,1-1.6,0l-3.2-3.2a1.1,1.1,0,0,1,0-1.6l1.4-1.4' +
            'a1.1,1.1,0,0,1,1.6,0l3.2,3.2A1.1,1.1,0,0,1,80.6,24.2Z' +
            'M33.7,67.5l-1.2-1.2a3.8,3.8,0,0,0-5-.4l-5.9,4.5' +
            'a4.8,4.8,0,0,0-3.4,1.4l-1.4,1.4a4.8,4.8,0,0,0,0,6.8L20,83.2' +
            'a4.8,4.8,0,0,0,6.8,0l1.4-1.4a4.8,4.8,0,0,0,1.4-3.5l4.5-5.9' +
            'A3.8,3.8,0,0,0,33.7,67.5ZM25.6,79.3l-1.4,1.4' +
            'a1.2,1.2,0,0,1-1.6,0l-3.2-3.2a1.1,1.1,0,0,1,0-1.6l1.4-1.4' +
            'a1.1,1.1,0,0,1,.8-0.3,1.1,1.1,0,0,1,.8.3l3.2,3.2' +
            'A1.1,1.1,0,0,1,25.6,79.3Zm5.6-9-3.3,4.4-2.5-2.5,4.3-3.3h0.2' +
            'l1.2,1.2A0.2,0.2,0,0,1,31.1,70.3ZM65.4,61.9a6.2,6.2,0,0,1-8.8,0' +
            'L37.2,42.5A2.5,2.5,0,1,0,33.7,46l7,7a6.2,6.2,0,0,1,.4,8.3h0' +
            'l-0.2.2-0.2.2-3.6,3.6a1.8,1.8,0,0,1-2.6-2.6l3.6-3.6h0.1' +
            'a2.5,2.5,0,0,0-.1-3.4l-7-7a6.2,6.2,0,0,1,8.8-8.8L59.3,59.3' +
            'a2.5,2.5,0,0,0,3.5-3.5l-6.2-6.2a6.2,6.2,0,0,1,0-8.8l6.1-6.1' +
            'a1.8,1.8,0,0,1,2.6,2.6l-6.1,6.1a2.5,2.5,0,0,0,0,3.5l6.2,6.2' +
            'A6.2,6.2,0,0,1,65.4,61.9Z',

            m_switch: m_switch_arrows,

            m_roadm: m_switch_arrows + m_octagon,

            m_uiAttached: 'M73.6,61.3H26.4a4.9,4.9,0,0,1-4.9-4.9V27.7' +
            'a4.9,4.9,0,0,1,4.9-4.9H73.6a4.9,4.9,0,0,1,4.9,4.9V56.5' +
            'A4.9,4.9,0,0,1,73.6,61.3ZM26.4,26.5a1.2,1.2,0,0,0-1.2,1.2' +
            'V56.5a1.2,1.2,0,0,0,1.2,1.2H73.6a1.2,1.2,0,0,0,1.2-1.2V27.7' +
            'a1.2,1.2,0,0,0-1.2-1.2H26.4ZM63.5,75.3a1.8,1.8,0,0,1-1.8,1.8' +
            'H38.4a1.8,1.8,0,0,1,0-3.7h9.8V65.7a1.8,1.8,0,0,1,3.7,0v7.8' +
            'h9.8A1.8,1.8,0,0,1,63.5,75.3Z',

            m_summary: 'M73.9,79.9H26.1A4.9,4.9,0,0,1,21.2,75V25' +
            'a4.9,4.9,0,0,1,4.9-4.9H73.9A4.9,4.9,0,0,1,78.8,25V75' +
            'A4.9,4.9,0,0,1,73.9,79.9Zm-47.8-56A1.2,1.2,0,0,0,24.9,25V75' +
            'a1.2,1.2,0,0,0,1.2,1.2H73.9A1.2,1.2,0,0,0,75.1,75V25' +
            'a1.2,1.2,0,0,0-1.2-1.2H26.1ZM42.4,46.7h-8a4.9,4.9,0,0,1-4.9-4.9' +
            'v-8A4.9,4.9,0,0,1,34.4,29h8a4.9,4.9,0,0,1,4.9,4.9v8' +
            'A4.9,4.9,0,0,1,42.4,46.7Zm-8-14.1a1.2,1.2,0,0,0-1.2,1.2v8' +
            'A1.2,1.2,0,0,0,34.4,43h8a1.2,1.2,0,0,0,1.2-1.2v-8' +
            'a1.2,1.2,0,0,0-1.2-1.2h-8ZM68.7,57.3H31.3a1.8,1.8,0,0,1,0-3.7' +
            'H68.7A1.8,1.8,0,0,1,68.7,57.3ZM68.7,66.5H31.3a1.8,1.8,0,0,1,0-3.7' +
            'H68.7A1.8,1.8,0,0,1,68.7,66.5Z',

            m_details: 'M68.7,33.2H31.3a1.8,1.8,0,0,1,0-3.7H68.7' +
            'A1.8,1.8,0,1,1,68.7,33.2ZM73.9,17.5H26.1a4.9,4.9,0,0,0-4.9,4.9' +
            'V72.4a4.9,4.9,0,0,0,4.9,4.9h8.2l-4.1,6.6a1.9,1.9,0,0,0,.6,2.5' +
            'l1,0.3a1.8,1.8,0,0,0,1.6-.9L46.1,64.9a15.1,15.1,0,0,' +
            '0,4,.5,15.6,15.6,0,0,0,3.7-.4A15.9,15.9,0,0,0,57,63.9H68.7' +
            'a1.8,1.8,0,0,0,0-3.7H61.9a16.6,16.6,0,0,0,1.6-2.2,15.5,15.5,0,0,' +
            '0,2.2-9.4h2.9a1.8,1.8,0,0,0,0-3.7H65a15.7,15.7,0,0,0-29.8,0' +
            'H31.3a1.8,1.8,0,1,0,0,3.7h3.2a15.7,15.7,0,0,0,.4,4.9,15.5,15.5,' +
            '0,0,0,3.5,6.7H31.3a1.8,1.8,0,1,0,0,3.7H42.4l-6,9.8H26.1' +
            'a1.2,1.2,0,0,1-1.2-1.2V22.4a1.2,1.2,0,0,1,1.2-1.2H73.9' +
            'a1.2,1.2,0,0,1,1.2,1.2V72.4a1.2,1.2,0,0,1-1.2,1.2H44.5' +
            'a1.8,1.8,0,0,0,0,3.7H73.9a4.9,4.9,0,0,0,4.9-4.9V22.4' +
            'A4.9,4.9,0,0,0,73.9,17.5ZM38.5,52.6A12,12,0,0,1,50.2,37.8,12,12,' +
            '0,0,1,61.8,47a10.7,10.7,0,0,1,.3,1.6,12,12,0,0,1-5.9,11.6,12,12,' +
            '0,0,1-12,0L43.9,60A12,12,0,0,1,38.5,52.6Z',

            m_oblique: 'M82.1,30.5a1.8,1.8,0,0,0-1.7-1.1H30.2' +
            'a1.8,1.8,0,0,0-1.4.7L18.2,42.8a1.8,1.8,0,0,0,1.4,3H40.9V62.2' +
            'a1.8,1.8,0,1,0,3.7,0V45.8H55.4V62.2a1.9,1.9,0,1,0,3.7,0V45.8' +
            'H69.8a1.9,1.9,0,0,0,1.4-.7L81.8,32.5A1.8,1.8,0,0,0,82.1,30.5Z' +
            'M69,42.2H23.5l7.5-9H76.5ZM69.8,70.5H19.6a1.8,1.8,0,0,1-1.4-3' +
            'L28.7,54.8a1.8,1.8,0,0,1,1.4-.7h7a1.8,1.8,0,0,1,0,3.7H31l-7.5,9' +
            'H69l7.5-9H62.4a1.8,1.8,0,0,1,0-3.7H80.4a1.8,1.8,0,0,1,1.4,3' +
            'L71.3,69.9A1.8,1.8,0,0,1,69.8,70.5ZM52.3,57.8H47.6' +
            'a1.8,1.8,0,0,1,0-3.7h4.8A1.8,1.8,0,0,1,52.3,57.8Z',

            m_filters: 'M69.9,45.8H19.5a1.9,1.9,0,0,1-1.4-3L28.7,30' +
            'a1.8,1.8,0,0,1,1.4-.7H80.5a1.8,1.8,0,0,1,1.4,3L71.3,45.1' +
            'A1.8,1.8,0,0,1,69.9,45.8ZM23.5,42.1H69l7.5-9H31ZM69.9,58.2' +
            'H19.5a1.8,1.8,0,0,1-1.4-3l6.1-7.3a1.8,1.8,0,0,1,2.8,2.4l-3.6,4.3' +
            'H69l7.6-9.1a1.8,1.8,0,0,1,.5-3.6h3.4a1.8,1.8,0,0,1,1.4,3' +
            'L71.3,57.5A1.8,1.8,0,0,1,69.9,58.2ZM69.9,70.7H19.5' +
            'a1.9,1.9,0,0,1-1.4-3l5.6-6.7a1.8,1.8,0,0,1,2.8,2.4L23.5,67H69' +
            'l7.5-9H76.3a1.8,1.8,0,0,1,0-3.7h4.1a1.9,1.9,0,0,1,1.4,3L71.3,70' +
            'A1.8,1.8,0,0,1,69.9,70.7Z',

            m_cycleLabels: 'M78.5,74.7a34.2,34.2,0,0,1-47.7,6.8l-0.3-.3' +
            'L30.4,81V80.8a1.8,1.8,0,0,1,.8-2.5l0.7-.3-5.2-3.4v6.2l0.7-.3' +
            'a1.8,1.8,0,1,1,1.7,3.3l-3.4,1.8-0.9.2-1-.3a1.9,1.9,0,0,1-.9-1.6' +
            'V71.1a1.8,1.8,0,0,1,2.8-1.5l10.7,7a1.9,1.9,0,0,1,.8,1.6,1.9,1.9,' +
            '0,0,1-1,1.5l-0.7.4a30.5,30.5,0,0,0,40.1-7.7A1.8,1.8,0,0,' +
            '1,78.5,74.7ZM30.8,25.7L29.5,38.4a1.8,1.8,0,0,1-1.1,1.5l-0.8.2' +
            'a1.9,1.9,0,0,1-1.1-.3l-1.7-1.2a30.1,30.1,0,0,0-2.7,6,1.9,1.9,0,0,' +
            '1-1.8,1.3H19.9a1.8,1.8,0,0,1-1.2-2.3A33.9,33.9,0,0,1,22.8,35' +
            'a1.8,1.8,0,0,1,1.6-.8,1.9,1.9,0,0,1,1.2.3L26.2,35l0.7-6.2-5.5,2.8' +
            'L21.9,32a1.8,1.8,0,1,1-2.1,3l-3.1-2.2a1.8,1.8,0,0,1,.2-3.2' +
            'l11.3-5.8A1.8,1.8,0,0,1,30.8,25.7ZM85.2,30.8L84.7,43.4' +
            'a1.8,1.8,0,0,1-1,1.6l-0.8.2a1.8,1.8,0,0,1-1.1-.4L71.4,37.4' +
            'a1.8,1.8,0,0,1,.3-3.2l1.9-.9a30.5,30.5,0,0,0-3.9-5.3,1.8,1.8,0,0,' +
            '1,2.7-2.5,34.3,34.3,0,0,1,5.3,7.7,2,2,0,0,1-.9,2.6' +
            'l-0.7.3,5.1,3.6,0.3-6.2-0.7.3a1.8,1.8,0,0,1-1.6-3.3L82.6,29' +
            'a1.8,1.8,0,0,1,1.8.1A1.9,1.9,0,0,1,85.2,30.8ZM62.4,32.2H40.2' +
            'a4.9,4.9,0,0,1-4.9-4.9V16.6a4.9,4.9,0,0,1,4.9-4.9H62.4' +
            'a4.9,4.9,0,0,1,4.9,4.9V27.3A4.9,4.9,0,0,1,62.4,32.2ZM40.2,15.4' +
            'A1.2,1.2,0,0,0,39,16.6V27.3a1.2,1.2,0,0,0,1.2,1.2H62.4' +
            'a1.2,1.2,0,0,0,1.2-1.2V16.6a1.2,1.2,0,0,0-1.2-1.2H40.2Z' +
            'M88.4,68.1H66.2a4.9,4.9,0,0,1-4.9-4.9V52.6a4.9,4.9,0,0,1,4.9-4.9' +
            'H88.4a4.9,4.9,0,0,1,4.9,4.9V63.2A4.9,4.9,0,0,1,88.4,68.1Z' +
            'M66.2,51.4A1.2,1.2,0,0,0,65,52.6V63.2a1.2,1.2,0,0,0,1.2,1.2H88.4' +
            'a1.2,1.2,0,0,0,1.2-1.2V52.6a1.2,1.2,0,0,0-1.2-1.2H66.2Z' +
            'M33.8,68.1H11.6a4.9,4.9,0,0,1-4.9-4.9V52.6a4.9,4.9,0,0,1,4.9-4.9' +
            'H33.8a4.9,4.9,0,0,1,4.9,4.9V63.2A4.9,4.9,0,0,1,33.8,68.1Z' +
            'M11.6,51.4a1.2,1.2,0,0,0-1.2,1.2V63.2a1.2,1.2,0,0,0,1.2,1.2' +
            'H33.8A1.2,1.2,0,0,0,35,63.2V52.6a1.2,1.2,0,0,0-1.2-1.2H11.6Z',

            m_prev: 'M59.8,72l-0.9-.2L21.8,51.3a1.8,1.8,0,0,1,0-3.2L58.9,28.2' +
            'a1.8,1.8,0,0,1,2.7,1.6V40.7H77.3a1.8,1.8,0,0,1,1.8,1.8V57.3' +
            'a1.8,1.8,0,0,1-1.8,1.8h-7a1.8,1.8,0,1,1,0-3.7h5.2v-11H59.8' +
            'A1.8,1.8,0,0,1,58,42.6V33L26.6,49.7,58,67V57.3' +
            'a1.8,1.8,0,0,1,3.7,0V70.1a1.8,1.8,0,0,1-.9,1.6Z',

            m_next: 'M40.2,72l-0.9-.3a1.8,1.8,0,0,1-.9-1.6V57.3' +
            'a1.8,1.8,0,0,1,3.7,0V67L73.5,49.7,42,32.9v9.6' +
            'a1.8,1.8,0,0,1-1.8,1.8H24.5v11h5.2a1.8,1.8,0,1,1,0,3.7h-7' +
            'a1.8,1.8,0,0,1-1.8-1.8V42.6a1.8,1.8,0,0,1,1.8-1.8H38.3V29.9' +
            'a1.8,1.8,0,0,1,2.7-1.6L78.2,48.1a1.8,1.8,0,0,1,0,3.2L41.1,71.8Z',

            m_flows: 'M50.1,26.2a7.4,7.4,0,1,1,7.4-7.4A7.4,7.4,0,0,1,50.1,26.2Z' +
            'm0-11.2a3.8,3.8,0,1,0,3.8,3.8A3.8,3.8,0,0,0,50.1,15Z' +
            'M50.1,88.6a7.4,7.4,0,1,1,7.4-7.4A7.4,7.4,0,0,1,50.1,88.6Z' +
            'm0-11.2a3.8,3.8,0,1,0,3.8,3.8A3.8,3.8,0,0,0,50.1,77.4Z' +
            'M72,50.1a1.8,1.8,0,0,1-1.8,1.8H58.1V55a3,3,0,0,1-3,3H51.9V70.2' +
            'a1.8,1.8,0,0,1-3.6,0V58.1h-3a3,3,0,0,1-3-3V51.9H29.8' +
            'a1.8,1.8,0,1,1,0-3.6H42.3v-3a3,3,0,0,1,3-3h3a1.7,1.7,0,0,1,0-.3' +
            'V29.8a1.8,1.8,0,0,1,3.6,0V41.9a1.7,1.7,0,0,1,0,.3h3.2' +
            'a3,3,0,0,1,3,3v3H70.2A1.8,1.8,0,0,1,72,50.1ZM18.8,57.5' +
            'a7.4,7.4,0,1,1,7.4-7.4A7.4,7.4,0,0,1,18.8,57.5Zm0-11.2' +
            'a3.8,3.8,0,1,0,3.8,3.8A3.8,3.8,0,0,0,18.8,46.3ZM81.2,57.5' +
            'a7.4,7.4,0,1,1,7.4-7.4A7.4,7.4,0,0,1,81.2,57.5Zm0-11.2' +
            'A3.8,3.8,0,1,0,85,50.1,3.8,3.8,0,0,0,81.2,46.3Z',

            m_allTraffic: m_diamond + m_trafficArrows,

            m_intentTraffic: m_diamond + m_intentArrows,

            m_xMark: 'M76.8,73.7a2.2,2.2,0,0,1-3.1,3.1L50,53.1,26.3,76.7' +
            'a2.2,2.2,0,1,1-3.1-3.1L46.9,50,23.2,26.3a2.2,2.2,0,0,1,3.1-3.1' +
            'L50,46.9,73.7,23.2a2.2,2.2,0,1,1,3.1,3.1L53.1,50Z',

            m_resetZoom: 'M73.9,76.8H64.2a1.8,1.8,0,1,1,0-3.7h9.7' +
            'a1.2,1.2,0,0,0,1.2-1.2V62.6a1.8,1.8,0,0,1,3.7,0v9.3' +
            'A4.9,4.9,0,0,1,73.9,76.8ZM77,33.3a1.8,1.8,0,0,1-1.8-1.8V22' +
            'a1.2,1.2,0,0,0-1.2-1.2H64.2a1.8,1.8,0,1,1,0-3.7h9.7' +
            'A4.9,4.9,0,0,1,78.8,22v9.5A1.8,1.8,0,0,1,77,33.3ZM23,33.6' +
            'a1.8,1.8,0,0,1-1.8-1.8V22a4.9,4.9,0,0,1,4.9-4.9h9.8' +
            'a1.8,1.8,0,0,1,0,3.7H26.1A1.2,1.2,0,0,0,24.9,22v9.7' +
            'A1.8,1.8,0,0,1,23,33.6ZM65.3,42.3A15.7,15.7,0,1,0,42.6,59.8' +
            'L34.4,73.1H26.1a1.2,1.2,0,0,1-1.2-1.2V62.1a1.9,1.9,0,0,0-3.7,0' +
            'v9.8a4.9,4.9,0,0,0,4.9,4.9h6.1l-2,3.3' +
            'a1.8,1.8,0,0,0,.6,2.5,1.8,1.8,0,0,0,1,.3,1.8,1.8,0,0,0,1.6-.9' +
            'L46,61.2a15.7,15.7,0,0,0,7.7.1A15.7,15.7,0,0,0,65.3,42.3Z' +
            'm-5,9.9A12,12,0,1,1,50.1,34a12,12,0,0,1,11.7,9.2' +
            'A11.9,11.9,0,0,1,60.3,52.3Z',

            m_eqMaster: 'M63,79.9H37.4a1.8,1.8,0,0,1-1.2-3.2L48.8,65.1' +
            'a1.8,1.8,0,0,1,2.5,0L64.2,76.7A1.8,1.8,0,0,1,63,79.9Z' +
            'M42.1,76.2H58.2l-8.1-7.3ZM19.7,65.8a1.8,1.8,0,0,1-.3-3.7' +
            'l61-11.3a1.8,1.8,0,1,1,.7,3.6L20,65.8H19.7ZM34.2,53.5' +
            'A16.7,16.7,0,1,1,50.9,36.8,16.7,16.7,0,0,1,34.2,53.5Zm0-29.7' +
            'a13,13,0,1,0,13,13A13,13,0,0,0,34.2,23.8ZM70.7,45.7' +
            'a8.6,8.6,0,1,1,8.6-8.6A8.6,8.6,0,0,1,70.7,45.7Zm0-13.6' +
            'a4.9,4.9,0,1,0,4.9,4.9A4.9,4.9,0,0,0,70.7,32.2Z',

            m_unknown: 'M63.2,20.6H36.8A16.2,16.2,0,0,0,20.6,36.8V63.2' +
            'A16.2,16.2,0,0,0,36.8,79.4H63.2A16.2,16.2,0,0,0,79.4,63.2V36.8' +
            'A16.2,16.2,0,0,0,63.2,20.6ZM75.7,63.2A12.5,12.5,0,0,1,63.2,75.7' +
            'H36.8A12.5,12.5,0,0,1,24.3,63.2V36.8A12.5,12.5,0,0,1,36.8,24.3' +
            'H63.2A12.5,12.5,0,0,1,75.7,36.8V63.2ZM67.3,64.7' +
            'a1.8,1.8,0,0,1-2.6,2.6L50,52.6,35.3,67.3a1.8,1.8,0,0,1-2.6-2.6' +
            'L47.4,50,32.7,35.3a1.8,1.8,0,0,1,2.6-2.6L50,47.4,64.7,32.7' +
            'a1.8,1.8,0,0,1,2.6,2.6L52.6,50Z',

            m_firewall: 'M53.4,37.9h-31A4.9,4.9,0,0,1,17.5,33V23.4' +
            'a4.9,4.9,0,0,1,4.9-4.9h31a4.9,4.9,0,0,1,4.9,4.9V33' +
            'A4.9,4.9,0,0,1,53.4,37.9Zm-31-15.7a1.2,1.2,0,0,0-1.2,1.2V33' +
            'a1.2,1.2,0,0,0,1.2,1.2h31A1.2,1.2,0,0,0,54.6,33V23.4' +
            'a1.2,1.2,0,0,0-1.2-1.2h-31ZM77.6,37.9H66.2A4.9,4.9,0,0,1,61.3,33' +
            'V23.4a4.9,4.9,0,0,1,4.9-4.9H77.6a4.9,4.9,0,0,1,4.9,4.9V33' +
            'A4.9,4.9,0,0,1,77.6,37.9ZM66.2,22.2A1.2,1.2,0,0,0,65,23.4V33' +
            'a1.2,1.2,0,0,0,1.2,1.2H77.6A1.2,1.2,0,0,0,78.8,33V23.4' +
            'a1.2,1.2,0,0,0-1.2-1.2H66.2ZM42.4,81.5h-20a4.9,4.9,0,0,1-4.9-4.9' +
            'V67a4.9,4.9,0,0,1,4.9-4.9h20A4.9,4.9,0,0,1,47.3,67v9.6' +
            'A4.9,4.9,0,0,1,42.4,81.5Zm-20-15.7A1.2,1.2,0,0,0,21.2,67v9.6' +
            'a1.2,1.2,0,0,0,1.2,1.2h20a1.2,1.2,0,0,0,1.2-1.2V67' +
            'a1.2,1.2,0,0,0-1.2-1.2h-20ZM77.6,81.5H55.1a4.9,4.9,0,0,1-4.9-4.9' +
            'V67a4.9,4.9,0,0,1,4.9-4.9H77.6A4.9,4.9,0,0,1,82.5,67v9.6' +
            'A4.9,4.9,0,0,1,77.6,81.5ZM55.1,65.8A1.2,1.2,0,0,0,53.9,67v9.6' +
            'a1.2,1.2,0,0,0,1.2,1.2H77.6a1.2,1.2,0,0,0,1.2-1.2V67' +
            'a1.2,1.2,0,0,0-1.2-1.2H55.1ZM77.6,59.7H42.8a4.9,4.9,0,0,1-4.9-4.9' +
            'V45.2a4.9,4.9,0,0,1,4.9-4.9H77.6a4.9,4.9,0,0,1,4.9,4.9v9.6' +
            'A4.9,4.9,0,0,1,77.6,59.7ZM42.8,44a1.2,1.2,0,0,0-1.2,1.2v9.6' +
            'A1.2,1.2,0,0,0,42.8,56H77.6a1.2,1.2,0,0,0,1.2-1.2V45.2' +
            'A1.2,1.2,0,0,0,77.6,44H42.8ZM30,59.7H22.4a4.9,4.9,0,0,1-4.9-4.9' +
            'V45.2a4.9,4.9,0,0,1,4.9-4.9H30a4.9,4.9,0,0,1,4.9,4.9v9.6' +
            'A4.9,4.9,0,0,1,30,59.7ZM22.4,44a1.2,1.2,0,0,0-1.2,1.2v9.6' +
            'A1.2,1.2,0,0,0,22.4,56H30a1.2,1.2,0,0,0,1.2-1.2V45.2' +
            'A1.2,1.2,0,0,0,30,44H22.4Z',

            m_controller: 'M73.9,20.1H26.1A4.9,4.9,0,0,0,21.2,25V75' +
            'a4.9,4.9,0,0,0,4.9,4.9H73.9A4.9,4.9,0,0,0,78.8,75V25' +
            'A4.9,4.9,0,0,0,73.9,20.1ZM75.1,75a1.2,1.2,0,0,1-1.2,1.2H26.1' +
            'A1.2,1.2,0,0,1,24.9,75V25a1.2,1.2,0,0,1,1.2-1.2H73.9' +
            'A1.2,1.2,0,0,1,75.1,25V75ZM70.5,63a1.8,1.8,0,0,1-1.9,1.8H38.3' +
            'v2.4a1.8,1.8,0,0,1-3.7,0V64.9H31.3a1.8,1.8,0,1,1,0-3.7h3.3V58.3' +
            'a1.8,1.8,0,0,1,3.7,0v2.9H68.7A1.9,1.9,0,0,1,70.5,63ZM70.5,36.6' +
            'a1.9,1.9,0,0,1-1.9,1.9H44.5v2.3a1.8,1.8,0,0,1-3.7,0V38.5H31.3' +
            'a1.8,1.8,0,1,1,0-3.7h9.5v-3a1.8,1.8,0,0,1,3.7,0v3H68.7' +
            'A1.8,1.8,0,0,1,70.5,36.6ZM70.5,49.8a1.9,1.9,0,0,1-1.9,1.8H60.9' +
            'v2.1a1.8,1.8,0,1,1-3.7,0V51.7H31.3a1.8,1.8,0,1,1,0-3.7H57.2' +
            'V44.8a1.8,1.8,0,1,1,3.7,0V48h7.8A1.9,1.9,0,0,1,70.5,49.8Z',

            m_virtual: 'M56.6,53.5l-0.9-.3a1.8,1.8,0,0,1-.9-1.6V45.8' +
            'a1.8,1.8,0,1,1,3.7,0v2.7l11.1-6.1L58.4,36.5v2.7' +
            'A1.8,1.8,0,0,1,56.6,41H50.5v3h1.3a1.8,1.8,0,0,1,0,3.7H48.6' +
            'a1.8,1.8,0,0,1-1.8-1.8V39.2a1.8,1.8,0,0,1,1.8-1.8h6.1V33.4' +
            'a1.8,1.8,0,0,1,2.7-1.6l16.8,9a1.8,1.8,0,0,1,0,3.2L57.5,53.3Z' +
            'M56.6,77.9l-0.9-.3a1.8,1.8,0,0,1-.9-1.6V70.2a1.8,1.8,0,1,1,3.7,0' +
            'v2.7l11.1-6.1L58.4,60.9v2.7a1.8,1.8,0,0,1-1.8,1.8H50.5v3h1.3' +
            'a1.8,1.8,0,0,1,0,3.7H48.6a1.8,1.8,0,0,1-1.8-1.8V63.6' +
            'a1.8,1.8,0,0,1,1.8-1.8h6.1V57.8a1.8,1.8,0,0,1,2.7-1.6l16.8,9' +
            'a1.8,1.8,0,0,1,0,3.2L57.5,77.7ZM38.5,64.9l-0.9-.2L20.8,55.4' +
            'a1.8,1.8,0,0,1,0-3.2l16.8-9a1.8,1.8,0,0,1,2.7,1.6v3.9h6.1' +
            'a1.8,1.8,0,0,1,1.8,1.8v6.7a1.8,1.8,0,0,1-1.8,1.8H43.2' +
            'a1.8,1.8,0,1,1,0-3.7h1.3v-3H38.5a1.8,1.8,0,0,1-1.8-1.8V47.9' +
            'L25.6,53.8l11.1,6.1V57.2a1.8,1.8,0,0,1,3.7,0v5.8' +
            'a1.8,1.8,0,0,1-.9,1.6ZM38.5,89.3l-0.9-.2L20.8,79.8' +
            'a1.8,1.8,0,0,1,0-3.2l16.8-9a1.8,1.8,0,0,1,2.7,1.6v3.9h6.1' +
            'A1.8,1.8,0,0,1,48.3,75v6.7a1.8,1.8,0,0,1-1.8,1.8H43.2' +
            'a1.8,1.8,0,1,1,0-3.7h1.3v-3H38.5A1.8,1.8,0,0,1,36.6,75V72.3' +
            'L25.6,78.2l11.1,6.1V81.6a1.8,1.8,0,1,1,3.7,0v5.8' +
            'a1.8,1.8,0,0,1-.9,1.6ZM60.8,29.1H60.3A1.8,1.8,0,0,1,59,26.8' +
            'a9.7,9.7,0,0,0-18.7-5.4,1.8,1.8,0,1,1-3.5-1,13.4,13.4,0,0,' +
            '1,25.8,7.4A1.8,1.8,0,0,1,60.8,29.1ZM77.4,45.7a1.8,1.8,0,0,' +
            '1-1.3-3.1,9.7,9.7,0,0,0-9.9-16A1.8,1.8,0,1,1,65,23.1,13.4,13.4,' +
            '0,0,1,78.7,45.1,1.8,1.8,0,0,1,77.4,45.7ZM22.7,45.8a1.8,1.8,0,0,' +
            '1-1.3-.6A13.4,13.4,0,0,1,39.6,25.6a1.8,1.8,0,1,1-2.4,2.8' +
            'A9.7,9.7,0,0,0,24,42.6,1.8,1.8,0,0,1,22.7,45.8Z',

            m_olt: 'M31.7,28.6h-6a1.8,1.8,0,1,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,31.7,28.6ZM45,28.6h-6a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,1,' +
            '1,45,28.6ZM31.7,38.3h-6a1.8,1.8,0,1,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,31.7,38.3ZM45,38.3h-6a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,1,' +
            '1,45,38.3ZM31.7,48.1h-6a1.8,1.8,0,1,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,31.7,48.1ZM45,48.1h-6a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,1,' +
            '1,45,48.1ZM63.7,51.1h-6a1.8,1.8,0,1,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,63.7,51.1ZM77,51.1H71a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,77,51.1ZM63.7,60.9h-6a1.8,1.8,0,1,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,63.7,60.9ZM77,60.9H71a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,0,' +
            '1,77,60.9ZM45,57.9h-6a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,1,1,' +
            '45,57.9ZM45,67.6h-6a1.8,1.8,0,0,1,0-3.7h6A1.8,1.8,0,1,1,45,67.6Z' +
            'M82.3,37.9H52.6V18a1.8,1.8,0,0,0-1.8-1.8H19.2A1.8,1.8,0,0,' +
            '0,17.3,18V50.1a1.8,1.8,0,0,0,3.7,0V19.8H48.9V80.2H27.2V75.4' +
            'c4-1.2,6.5-3.3,7.3-6.3,2-7.2-6.8-16.2-7.8-17.2a1.9,1.9,0,0,' +
            '0-2.6,0c-1,1-9.9,10-7.9,17.2,0.8,3,3.3,5.1,7.3,6.3v4.7H21V77.9' +
            'a1.8,1.8,0,0,0-3.7,0V82a1.8,1.8,0,0,0,1.9,1.8H82.3A1.8,1.8,0,0,' +
            '0,84.1,82V39.7A1.8,1.8,0,0,0,82.3,37.9ZM25.4,62.5a1.9,1.9,0,0,' +
            '0-1.9,1.8v7.2c-2.1-.8-3.4-1.9-3.8-3.4-1-3.7,3-9.2,5.6-12.2,2.6,' +
            '3,6.6,8.5,5.6,12.2-0.4,1.5-1.7,2.6-3.8,3.4V64.4A1.8,1.8,0,0,' +
            '0,25.4,62.5ZM71.5,80.2H63.3V70h8.2V80.2Zm8.9,0H75.2V68.1' +
            'a1.8,1.8,0,0,0-1.8-1.8H61.5a1.8,1.8,0,0,0-1.8,1.8V80.2H52.6' +
            'V41.6H80.4V80.2Z',

            m_onu: 'M79.2,52.2a1.7,1.7,0,0,1-2.3,0l-5.8-5.8V77a1.7,1.7,0,0,' +
            '1-1.7,1.7H30.6A1.7,1.7,0,0,1,28.9,77V52.1a1.7,1.7,0,1,1,3.3,0' +
            'V75.3H67.8V43.8a1.7,1.7,0,0,1,.1-0.7L50.1,25.4l-26.9,27' +
            'a1.7,1.7,0,0,1-1.2.5A1.7,1.7,0,0,1,20.8,50L48.9,21.8' +
            'a1.7,1.7,0,0,1,2.4,0l28,28A1.7,1.7,0,0,1,79.2,52.2ZM57.1,61.6' +
            'H42.9a1.7,1.7,0,0,1-1.7-1.7V45.6A1.7,1.7,0,0,1,42.9,44H57.1' +
            'a1.7,1.7,0,0,1,1.7,1.7V59.9A1.7,1.7,0,0,1,57.1,61.6ZM44.5,58.2' +
            'H55.5V47.3H44.5V58.2Z',

            m_other: 'M78.9,64.9H21.1A4.9,4.9,0,0,1,16.2,60V24.3a4.9,4.9,0,0,' +
            '1,4.9-4.9H78.9a4.9,4.9,0,0,1,4.9,4.9V60A4.9,4.9,0,0,1,78.9,64.9Z' +
            'M21.1,23.1a1.2,1.2,0,0,0-1.2,1.2V60a1.2,1.2,0,0,0,1.2,1.2H78.9' +
            'A1.2,1.2,0,0,0,80.1,60V24.3a1.2,1.2,0,0,0-1.2-1.2H21.1Z' +
            'M65.8,78.8a1.9,1.9,0,0,1-1.8,1.8H36.1a1.9,1.9,0,1,1,0-3.7H48.2' +
            'V70.4a1.8,1.8,0,1,1,3.7,0v6.5H63.9A1.9,1.9,0,0,1,65.8,78.8Z' +
            'M47.2,49.3V48.1c-0.3-2.3.5-4.9,2.7-7.5s3-4,3-5.9-1.4-3.7-4.1-3.7' +
            'a7.7,7.7,0,0,0-4.4,1.3l-1-2.7A11.3,11.3,0,0,1,49.5,28' +
            'c5,0,7.2,3.1,7.2,6.3s-1.6,5-3.7,7.5-2.6,4.1-2.5,6.3v1.1H47.2Z' +
            'm-1,6a2.5,2.5,0,0,1,2.6-2.7A2.7,2.7,0,1,1,46.3,55.3Z',

            // TODO: replace with MOJO official design
            m_endstation: 'M75,52H25a1.8,1.8,0,0,1-1.8-1.8V37.3' +
            'A1.8,1.8,0,0,1,25,35.5H75a1.8,1.8,0,0,1,1.8,1.8V50.2' +
            'A1.8,1.8,0,0,1,75,52ZM26.9,48.3H73.1V39.1H26.9v9.2ZM35.5,45.7' +
            'H30.7a1.8,1.8,0,0,1,0-3.7h4.8A1.8,1.8,0,1,1,35.5,45.7Z' +
            'M72.1,62.7a1.8,1.8,0,0,1-1.8,1.8H29.8a1.8,1.8,0,1,1,0-3.7H48.2' +
            'V56a1.8,1.8,0,1,1,3.7,0v4.8H70.2A1.9,1.9,0,0,1,72.1,62.7Z',

            // TODO: replace with (updated) MOJO official design
            m_relatedIntents: 'M31.1,65.3H21.4a3,3,0,0,1-3-3V52.5' +
            'a3,3,0,0,1,3-3h9.7a3,3,0,0,1,3,3v9.8A3,3,0,0,1,31.1,65.3Z' +
            'M78.3,38.8H68.6a3,3,0,0,1-3-3V26a3,3,0,0,1,3-3h9.7' +
            'a3,3,0,0,1,3,3v9.8A3,3,0,0,1,78.3,38.8ZM40.9,35H31' +
            'A3,3,0,0,1,28,32V22.2a3,3,0,0,1,3.1-3h9.9a3,3,0,0,1,3.1,3V32' +
            'A3,3,0,0,1,40.9,35ZM58.9,80.6H49a3.1,3.1,0,0,1-3.1-3V67.8' +
            'a3.1,3.1,0,0,1,3.1-3h9.9a3.1,3.1,0,0,1,3.1,3v9.8' +
            'A3.1,3.1,0,0,1,58.9,80.6ZM37.5,58.5a1.9,1.9,0,0,1-1.2-3.3' +
            'L61.2,34.3a1.9,1.9,0,0,1,2.4,2.8L38.6,58A1.8,1.8,0,0,1,37.5,58.5Z' +
            'M42.5,75.2H41.9L27.6,70a1.9,1.9,0,0,1,1.2-3.5l14.3,5' +
            'A1.9,1.9,0,0,1,42.5,75.2ZM64.8,73.8H64.2A1.9,1.9,0,0,1,63,71.5' +
            'l8.7-29.7a1.9,1.9,0,0,1,3.6,1L66.5,72.5A1.9,1.9,0,0,1,64.8,73.8Z' +
            'M27.4,47.9a1.9,1.9,0,0,1-1.5-3l5.8-7.7a1.9,1.9,0,0,1,2.9,2.2' +
            'l-5.8,7.7A1.8,1.8,0,0,1,27.4,47.9ZM62.6,32H62.3L46.6,28.7' +
            'a1.9,1.9,0,0,1,.7-3.6L63,28.3A1.9,1.9,0,0,1,62.6,32Z'

        };


    // ----------------------------------------------------------------------
    // === API functions ===

    function registerCoreGlyphs(gsApi) {
        gsApi.registerGlyphs(logos);
        gsApi.registerGlyphSet(glyphDataSet);
        gsApi.registerGlyphSet(badgeDataSet);
        gsApi.registerGlyphs(spriteData);
        gsApi.registerGlyphSet(mojoDataSet);
    }

    // ----------------------------------------------------------------------

    angular.module('onosSvg')
    .factory('GlyphDataService',
        [function () {
            return {
                registerCoreGlyphs: registerCoreGlyphs
            };
        }]
    );

}());
