/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.ui.impl.AbstractUiImplTest;
import org.onosproject.ui.impl.topo.Topo2Jsonifier;
import org.onosproject.ui.model.topo.UiNode;

public class Topo2JsonifierTest
extends AbstractUiImplTest {
    private static final List<String> ALL_TAGS = ImmutableList.of((Object)"opt", (Object)"pkt", (Object)"def");
    private static final List<String> PKT_DEF_TAGS = ImmutableList.of((Object)"pkt", (Object)"def");
    private static final List<String> DEF_TAG_ONLY = ImmutableList.of((Object)"def");
    private static final MockNode NODE_A = new MockNode("A-O", "opt");
    private static final MockNode NODE_B = new MockNode("B-P", "pkt");
    private static final MockNode NODE_C = new MockNode("C-O", "opt");
    private static final MockNode NODE_D = new MockNode("D-D", "def");
    private static final MockNode NODE_E = new MockNode("E-P", "pkt");
    private static final MockNode NODE_F = new MockNode("F-r", "random");
    private static final Set<MockNode> NODES = ImmutableSet.of((Object)((Object)NODE_A), (Object)((Object)NODE_B), (Object)((Object)NODE_C), (Object)((Object)NODE_D), (Object)((Object)NODE_E), (Object)((Object)NODE_F), (Object[])new MockNode[0]);
    private Topo2Jsonifier t2 = new Topo2Jsonifier();
    private static final String K1 = "K1";
    private static final String K2 = "K2";
    private static final String K3 = "K3";
    private static final String K4 = "K4";
    private static final String V1 = "V1";
    private static final String V2 = "V2";
    private static final String V3 = "V3";
    private static final Annotations ANNOTS = new Annotations(){

        public Set<String> keys() {
            return ImmutableSet.of((Object)Topo2JsonifierTest.K1, (Object)Topo2JsonifierTest.K2, (Object)Topo2JsonifierTest.K3);
        }

        public String value(String key) {
            switch (key) {
                case "K1": {
                    return Topo2JsonifierTest.V1;
                }
                case "K2": {
                    return Topo2JsonifierTest.V2;
                }
                case "K3": {
                    return Topo2JsonifierTest.V3;
                }
            }
            return null;
        }
    };
    private static final Annotated THING = () -> ANNOTS;

    @Test
    public void threeLayers() {
        this.print("threeLayers()");
        List result = this.t2.splitByLayer(ALL_TAGS, NODES);
        this.print(result);
        Assert.assertEquals((String)"wrong split size", (long)3L, (long)result.size());
        Set opt = (Set)result.get(0);
        Set pkt = (Set)result.get(1);
        Set def = (Set)result.get(2);
        Assert.assertEquals((String)"opt bad size", (long)2L, (long)opt.size());
        Assert.assertEquals((String)"missing node A", (Object)true, (Object)opt.contains((Object)NODE_A));
        Assert.assertEquals((String)"missing node C", (Object)true, (Object)opt.contains((Object)NODE_C));
        Assert.assertEquals((String)"pkt bad size", (long)2L, (long)pkt.size());
        Assert.assertEquals((String)"missing node B", (Object)true, (Object)pkt.contains((Object)NODE_B));
        Assert.assertEquals((String)"missing node E", (Object)true, (Object)pkt.contains((Object)NODE_E));
        Assert.assertEquals((String)"def bad size", (long)2L, (long)def.size());
        Assert.assertEquals((String)"missing node D", (Object)true, (Object)def.contains((Object)NODE_D));
        Assert.assertEquals((String)"missing node F", (Object)true, (Object)def.contains((Object)NODE_F));
    }

    @Test
    public void twoLayers() {
        this.print("twoLayers()");
        List result = this.t2.splitByLayer(PKT_DEF_TAGS, NODES);
        this.print(result);
        Assert.assertEquals((String)"wrong split size", (long)2L, (long)result.size());
        Set pkt = (Set)result.get(0);
        Set def = (Set)result.get(1);
        Assert.assertEquals((String)"pkt bad size", (long)2L, (long)pkt.size());
        Assert.assertEquals((String)"missing node B", (Object)true, (Object)pkt.contains((Object)NODE_B));
        Assert.assertEquals((String)"missing node E", (Object)true, (Object)pkt.contains((Object)NODE_E));
        Assert.assertEquals((String)"def bad size", (long)4L, (long)def.size());
        Assert.assertEquals((String)"missing node D", (Object)true, (Object)def.contains((Object)NODE_D));
        Assert.assertEquals((String)"missing node F", (Object)true, (Object)def.contains((Object)NODE_F));
        Assert.assertEquals((String)"missing node A", (Object)true, (Object)def.contains((Object)NODE_A));
        Assert.assertEquals((String)"missing node C", (Object)true, (Object)def.contains((Object)NODE_C));
    }

    @Test
    public void oneLayer() {
        this.print("oneLayer()");
        List result = this.t2.splitByLayer(DEF_TAG_ONLY, NODES);
        this.print(result);
        Assert.assertEquals((String)"wrong split size", (long)1L, (long)result.size());
        Set def = (Set)result.get(0);
        Assert.assertEquals((String)"def bad size", (long)6L, (long)def.size());
        Assert.assertEquals((String)"missing node D", (Object)true, (Object)def.contains((Object)NODE_D));
        Assert.assertEquals((String)"missing node F", (Object)true, (Object)def.contains((Object)NODE_F));
        Assert.assertEquals((String)"missing node A", (Object)true, (Object)def.contains((Object)NODE_A));
        Assert.assertEquals((String)"missing node C", (Object)true, (Object)def.contains((Object)NODE_C));
        Assert.assertEquals((String)"missing node B", (Object)true, (Object)def.contains((Object)NODE_B));
        Assert.assertEquals((String)"missing node E", (Object)true, (Object)def.contains((Object)NODE_E));
    }

    private void verifyValues(List<String> vals, String ... exp) {
        this.print(vals);
        if (exp.length == 0) {
            Assert.assertNull((String)"huh?", vals);
        } else {
            Assert.assertEquals((String)"wrong list len", (long)exp.length, (long)vals.size());
            for (int i = 0; i < exp.length; ++i) {
                Assert.assertEquals((String)("wrong value " + i), (Object)exp[i], (Object)vals.get(i));
            }
        }
    }

    @Test
    public void annotValues() {
        this.print("annotValues()");
        this.verifyValues(this.t2.getAnnotValues(THING, new String[]{K1}), V1);
        this.verifyValues(this.t2.getAnnotValues(THING, new String[]{K3, K1}), V3, V1);
        this.verifyValues(this.t2.getAnnotValues(THING, new String[]{K1, K2, K3}), V1, V2, V3);
        this.verifyValues(this.t2.getAnnotValues(THING, new String[]{K1, K4}), new String[0]);
    }

    private static class MockNode
    extends UiNode {
        private final String id;

        MockNode(String id, String layer) {
            this.id = id;
            this.setLayer(layer);
        }

        public String idAsString() {
            return this.id;
        }

        public String toString() {
            return this.id;
        }
    }
}

