/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.config.NetworkConfigRegistryAdapter;
import org.onosproject.net.region.DefaultRegion;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.topo.UiTopoLayoutManager;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;

public class UiTopoLayoutManagerTest {
    private static final Region R1 = UiTopoLayoutManagerTest.region("r1", "R1", Region.Type.CAMPUS);
    private static final Region R2 = UiTopoLayoutManagerTest.region("r2", "R2", Region.Type.CAMPUS);
    private static final UiTopoLayout L1 = UiTopoLayoutManagerTest.layout("l1", R1, null);
    private static final UiTopoLayout L2 = UiTopoLayoutManagerTest.layout("l2", R2, null);
    private UiTopoLayoutService svc;
    private UiTopoLayoutManager mgr;

    private static Region region(String id, String name, Region.Type type) {
        return new DefaultRegion(RegionId.regionId((String)id), name, type, null);
    }

    private static UiTopoLayout layout(String id, Region region, String parentId) {
        UiTopoLayoutId parent = parentId == null ? null : UiTopoLayoutId.layoutId((String)parentId);
        UiTopoLayout layout = new UiTopoLayout(UiTopoLayoutId.layoutId((String)id));
        return layout;
    }

    @Before
    public void setUp() {
        this.mgr = new UiTopoLayoutManager();
        this.svc = this.mgr;
        this.mgr.cfgService = new MockConfigService();
        this.mgr.activate();
    }

    @After
    public void tearDown() {
        this.mgr.deactivate();
        this.mgr.cfgService = null;
    }

    @Test
    public void basics() {
        Assert.assertEquals((String)"should be just default layout", (long)1L, (long)this.svc.getLayouts().size());
        this.svc.addLayout(L1);
        this.svc.addLayout(L2);
        Assert.assertEquals((String)"incorrect number of layouts", (long)3L, (long)this.svc.getLayouts().size());
        Assert.assertEquals((String)"incorrect layout", (Object)L1.id(), (Object)this.svc.getLayout(L1.id()).id());
        Assert.assertEquals((String)"incorrect layout", (Object)L2.id(), (Object)this.svc.getLayout(L2.id()).id());
        this.svc.removeLayout(L1);
        Assert.assertEquals((String)"incorrect number of layouts", (long)2L, (long)this.svc.getLayouts().size());
        Assert.assertNull((String)"layout should be gone", (Object)this.svc.getLayout(L1.id()));
        Assert.assertEquals((String)"incorrect layout", (Object)L2.id(), (Object)this.svc.getLayout(L2.id()).id());
    }

    private static class MockConfigService
    extends NetworkConfigRegistryAdapter {
        private MockConfigService() {
        }
    }
}

