/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.onlab.rest.BaseResource;
import org.onosproject.app.ApplicationAdminService;
import org.onosproject.core.Application;
import org.onosproject.core.ApplicationId;

@Path(value="applications")
public class ApplicationResource
extends BaseResource {
    static String lastInstalledAppName = null;

    @Path(value="upload")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Response upload(@QueryParam(value="activate") @DefaultValue(value="false") String activate, @FormDataParam(value="file") InputStream stream) throws IOException {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        Application app = service.install(stream);
        lastInstalledAppName = app.id().name();
        if (Objects.equals(activate, "true")) {
            service.activate(app.id());
        }
        return Response.ok().build();
    }

    @Path(value="{name}/icon")
    @GET
    @Produces(value={"image/png"})
    public Response getIcon(@PathParam(value="name") String name) throws IOException {
        ApplicationAdminService service = (ApplicationAdminService)this.get(ApplicationAdminService.class);
        ApplicationId appId = service.getId(name);
        Application app = service.getApplication(appId);
        return Response.ok((Object)app.icon()).build();
    }
}

