/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.rest.BaseResource;
import org.onosproject.ui.impl.SpriteService;
import org.onosproject.ui.impl.TopologyViewMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="topology")
public class TopologyResource
extends BaseResource {
    private static final Logger log = LoggerFactory.getLogger(TopologyResource.class);
    private final ObjectMapper mapper = new ObjectMapper();

    @Path(value="geoloc")
    @GET
    @Produces(value={"application/json"})
    public Response getGeoLocations() {
        ObjectNode rootNode = this.mapper.createObjectNode();
        ArrayNode devices = this.mapper.createArrayNode();
        ArrayNode hosts = this.mapper.createArrayNode();
        Map metaUi = TopologyViewMessageHandler.getMetaUi();
        for (String id : metaUi.keySet()) {
            ObjectNode memento = (ObjectNode)metaUi.get(id);
            if (id.length() > 17 && id.charAt(17) == '/') {
                this.addGeoData(hosts, "id", id, memento);
                continue;
            }
            this.addGeoData(devices, "uri", id, memento);
        }
        rootNode.set("devices", (JsonNode)devices);
        rootNode.set("hosts", (JsonNode)hosts);
        return Response.ok((Object)rootNode.toString()).build();
    }

    private void addGeoData(ArrayNode array, String idField, String id, ObjectNode memento) {
        ObjectNode node = this.mapper.createObjectNode().put(idField, id);
        ObjectNode annot = this.mapper.createObjectNode();
        node.set("annotations", (JsonNode)annot);
        try {
            annot.put("latitude", memento.get("lat").asDouble()).put("longitude", memento.get("lng").asDouble());
            array.add((JsonNode)node);
        }
        catch (Exception e) {
            log.debug("Skipping geo entry");
        }
    }

    @Path(value="sprites")
    @POST
    @Consumes(value={"application/json"})
    public Response setSprites(InputStream stream) throws IOException {
        JsonNode root = this.mapper.readTree(stream);
        String name = root.path("defn_name").asText("sprites");
        ((SpriteService)this.get(SpriteService.class)).put(name, root);
        return Response.ok().build();
    }
}

