/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.event.EventListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.topo.UiTopoLayoutManager;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.onosproject.ui.model.topo.UiTopoLayoutId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(immediate=true)
@Service
public class UiTopoLayoutManager
implements UiTopoLayoutService {
    private static final String ID_NULL = "Layout ID cannot be null";
    private static final String LAYOUT_NULL = "Layout cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final InternalConfigListener cfgListener = new InternalConfigListener(this, null);
    private final Map<UiTopoLayoutId, UiTopoLayout> layoutMap = new HashMap();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry cfgService;

    @Activate
    public void activate() {
        this.layoutMap.computeIfAbsent(UiTopoLayoutId.DEFAULT_ID, UiTopoLayout::new);
        this.cfgService.addListener((EventListener)this.cfgListener);
        InternalConfigListener.access$100((InternalConfigListener)this.cfgListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cfgService.removeListener((EventListener)this.cfgListener);
        this.log.info("Stopped");
    }

    public UiTopoLayout getRootLayout() {
        return this.getLayout(UiTopoLayoutId.DEFAULT_ID);
    }

    public Set<UiTopoLayout> getLayouts() {
        return ImmutableSet.copyOf(this.layoutMap.values());
    }

    public boolean addLayout(UiTopoLayout layout) {
        Preconditions.checkNotNull((Object)layout, (Object)"Layout cannot be null");
        return this.layoutMap.put(layout.id(), layout) == null;
    }

    public UiTopoLayout getLayout(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)"Layout ID cannot be null");
        return (UiTopoLayout)this.layoutMap.get(layoutId);
    }

    public UiTopoLayout getLayout(RegionId regionId) {
        if (regionId == null || regionId.equals((Object)UiRegion.NULL_ID)) {
            return this.getRootLayout();
        }
        List matchingLayouts = this.layoutMap.values().stream().filter(l -> Objects.equals(regionId, l.regionId())).collect(Collectors.toList());
        return matchingLayouts.isEmpty() ? null : (UiTopoLayout)matchingLayouts.get(0);
    }

    public Set<UiTopoLayout> getPeerLayouts(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)"Layout ID cannot be null");
        UiTopoLayout layout = (UiTopoLayout)this.layoutMap.get(layoutId);
        if (layout == null || layout.isRoot()) {
            return Collections.emptySet();
        }
        UiTopoLayoutId parentId = layout.parent();
        return this.layoutMap.values().stream().filter(l -> !Objects.equals(l.id(), layoutId) && !Objects.equals(l.id(), UiTopoLayoutId.DEFAULT_ID) && Objects.equals(l.parent(), parentId)).collect(Collectors.toSet());
    }

    public Set<UiTopoLayout> getChildren(UiTopoLayoutId layoutId) {
        Preconditions.checkNotNull((Object)layoutId, (Object)"Layout ID cannot be null");
        return this.layoutMap.values().stream().filter(l -> !l.isRoot() && Objects.equals(l.parent(), layoutId)).collect(Collectors.toSet());
    }

    public boolean removeLayout(UiTopoLayout layout) {
        Preconditions.checkNotNull((Object)layout, (Object)"Layout cannot be null");
        return this.layoutMap.remove(layout.id()) != null;
    }

    static /* synthetic */ Logger access$200(UiTopoLayoutManager x0) {
        return x0.log;
    }

    static /* synthetic */ Map access$300(UiTopoLayoutManager x0) {
        return x0.layoutMap;
    }

    protected void bindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        this.cfgService = networkConfigRegistry;
    }

    protected void unbindCfgService(NetworkConfigRegistry networkConfigRegistry) {
        if (this.cfgService == networkConfigRegistry) {
            this.cfgService = null;
        }
    }
}

