/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.UiTopoLayoutService;
import org.onosproject.ui.impl.UiWebSocket;
import org.onosproject.ui.impl.topo.model.UiModelEvent;
import org.onosproject.ui.impl.topo.model.UiModelListener;
import org.onosproject.ui.impl.topo.model.UiSharedTopologyModel;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiTopoSession
implements UiModelListener {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UiWebSocket webSocket;
    private final String username;
    final UiSharedTopologyModel sharedModel;
    private boolean registered = false;
    private UiTopoLayoutService layoutService;
    private UiTopoLayout currentLayout;
    private boolean messagesEnabled;

    public UiTopoSession(UiWebSocket webSocket, UiSharedTopologyModel model, UiTopoLayoutService layoutService) {
        this.webSocket = webSocket;
        this.username = webSocket.userName();
        this.sharedModel = model;
        this.layoutService = layoutService;
    }

    UiTopoSession() {
        this.webSocket = null;
        this.username = null;
        this.sharedModel = null;
    }

    public void init() {
        if (!this.registered) {
            this.log.debug("{} : Registering with shared model", (Object)this);
            this.sharedModel.register(this);
            this.currentLayout = this.layoutService.getRootLayout();
            this.registered = true;
        } else {
            this.log.warn("already registered");
        }
    }

    public void destroy() {
        if (this.registered) {
            this.log.debug("{} : Unregistering from shared model", (Object)this);
            this.sharedModel.unregister(this);
            this.registered = false;
        } else {
            this.log.warn("already unregistered");
        }
    }

    public String toString() {
        return String.format("{UiTopoSession for user <%s>}", this.username);
    }

    public void event(UiModelEvent event) {
        this.log.debug("Event received: {}", (Object)event);
    }

    public UiTopoLayout currentLayout() {
        return this.currentLayout;
    }

    public List<UiTopoLayout> breadCrumbs() {
        UiTopoLayout current = this.currentLayout;
        ArrayList<UiTopoLayout> crumbs = new ArrayList<UiTopoLayout>();
        crumbs.add(current);
        while (!current.isRoot()) {
            current = this.layoutService.getLayout(current.parent());
            crumbs.add(current);
        }
        return crumbs;
    }

    public void setCurrentLayout(UiTopoLayout topoLayout) {
        this.currentLayout = topoLayout;
    }

    public void enableEvent(boolean enabled) {
        this.messagesEnabled = enabled;
    }

    public List<UiClusterMember> getAllInstances() {
        return this.sharedModel.getClusterMembers();
    }

    public UiRegion getRegion(UiTopoLayout layout) {
        RegionId rid = layout.regionId();
        return rid == null ? this.sharedModel.getNullRegion() : this.sharedModel.getRegion(rid);
    }

    public Set<UiNode> getPeerNodes(UiTopoLayout layout) {
        HashSet<UiNode> peers = new HashSet<UiNode>();
        Set peerLayouts = this.layoutService.getPeerLayouts(layout.id());
        peerLayouts.forEach(l -> {
            RegionId peerRegion = l.regionId();
            peers.add((UiNode)this.sharedModel.getRegion(peerRegion));
        });
        if (!layout.isRoot()) {
            UiTopoLayout parentLayout = this.layoutService.getLayout(layout.parent());
            this.getRegion(parentLayout).devices().forEach(peers::add);
        }
        return peers;
    }

    public Set<UiRegion> getSubRegions(UiTopoLayout layout) {
        Set kidLayouts = this.layoutService.getChildren(layout.id());
        HashSet<UiRegion> kids = new HashSet<UiRegion>();
        kidLayouts.forEach(l -> kids.add(this.sharedModel.getRegion(l.regionId())));
        return kids;
    }

    public List<UiSynthLink> getLinks(UiTopoLayout layout) {
        return this.sharedModel.getSynthLinks(layout.regionId());
    }

    public void refreshModel() {
        this.sharedModel.refresh();
    }

    public void navToRegion(String regionId) {
        RegionId r = RegionId.regionId((String)regionId);
        UiTopoLayout layout = this.layoutService.getLayout(r);
        this.setCurrentLayout(layout);
    }
}

