/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo.util;

import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.statistic.Load;
import org.onosproject.ui.impl.topo.util.TrafficLink;
import org.onosproject.ui.topo.BiLink;
import org.onosproject.ui.topo.LinkHighlight;
import org.onosproject.ui.topo.TopoUtils;

public class TrafficLink
extends BiLink {
    private static final String EMPTY = "";
    private static final String QUE = "?";
    private long bytes = 0L;
    private long rate = 0L;
    private long flows = 0L;
    private LinkHighlight.Flavor taggedFlavor = LinkHighlight.Flavor.NO_HIGHLIGHT;
    private boolean hasTraffic = false;
    private boolean isOptical = false;
    private boolean antMarch = false;

    public TrafficLink(LinkKey key, Link link) {
        super(key, link);
    }

    public TrafficLink optical(boolean b) {
        this.isOptical = b;
        return this;
    }

    public TrafficLink antMarch(boolean b) {
        this.antMarch = b;
        return this;
    }

    public TrafficLink tagFlavor(LinkHighlight.Flavor flavor) {
        this.taggedFlavor = flavor;
        return this;
    }

    public void addLoad(Load load) {
        this.addLoad(load, 0.0);
    }

    public void addLoad(Load load, double threshold) {
        if (load != null) {
            this.hasTraffic = this.hasTraffic || (double)load.rate() > threshold;
            this.bytes += load.latest();
            this.rate += load.rate();
        }
    }

    public void addFlows(int count) {
        this.flows += (long)count;
    }

    public LinkHighlight highlight(Enum<?> type) {
        StatsType statsType = (StatsType)type;
        switch (1.$SwitchMap$org$onosproject$ui$impl$topo$util$TrafficLink$StatsType[statsType.ordinal()]) {
            case 1: {
                return this.highlightForFlowCount(statsType);
            }
            case 2: 
            case 3: {
                return this.highlightForStats(statsType);
            }
            case 4: {
                return this.highlightForTagging(statsType);
            }
        }
        throw new IllegalStateException("unexpected case: " + statsType);
    }

    private LinkHighlight highlightForStats(StatsType type) {
        return new LinkHighlight(this.linkId(), LinkHighlight.Flavor.SECONDARY_HIGHLIGHT).setLabel(this.generateLabel(type));
    }

    private LinkHighlight highlightForFlowCount(StatsType type) {
        LinkHighlight.Flavor flavor = this.flows > 0L ? LinkHighlight.Flavor.PRIMARY_HIGHLIGHT : LinkHighlight.Flavor.SECONDARY_HIGHLIGHT;
        return new LinkHighlight(this.linkId(), flavor).setLabel(this.generateLabel(type));
    }

    private LinkHighlight highlightForTagging(StatsType type) {
        LinkHighlight hlite = new LinkHighlight(this.linkId(), this.taggedFlavor).setLabel(this.generateLabel(type));
        if (this.isOptical) {
            hlite.addMod(LinkHighlight.MOD_OPTICAL);
        }
        if (this.antMarch) {
            hlite.addMod(LinkHighlight.MOD_ANIMATED);
        }
        return hlite;
    }

    private String generateLabel(StatsType type) {
        switch (1.$SwitchMap$org$onosproject$ui$impl$topo$util$TrafficLink$StatsType[type.ordinal()]) {
            case 1: {
                return TopoUtils.formatFlows((long)this.flows);
            }
            case 2: {
                return TopoUtils.formatBytes((long)this.bytes);
            }
            case 3: {
                return TopoUtils.formatBitRate((long)this.rate);
            }
            case 4: {
                return this.hasTraffic ? TopoUtils.formatBytes((long)this.bytes) : EMPTY;
            }
        }
        return QUE;
    }

    public boolean hasTraffic() {
        return this.hasTraffic;
    }
}

