/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.impl.topo;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.incubator.net.PortStatisticsService;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.Device;
import org.onosproject.net.Host;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.FlowRuleService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.region.Region;
import org.onosproject.net.statistic.StatisticService;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.ui.JsonUtils;
import org.onosproject.ui.model.topo.UiClusterMember;
import org.onosproject.ui.model.topo.UiDevice;
import org.onosproject.ui.model.topo.UiHost;
import org.onosproject.ui.model.topo.UiLink;
import org.onosproject.ui.model.topo.UiNode;
import org.onosproject.ui.model.topo.UiRegion;
import org.onosproject.ui.model.topo.UiSynthLink;
import org.onosproject.ui.model.topo.UiTopoLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Topo2Jsonifier {
    private static final String E_DEF_NOT_LAST = "UiNode.LAYER_DEFAULT not last in layer list";
    private static final String E_UNKNOWN_UI_NODE = "Unknown subclass of UiNode: ";
    private static final String REGION = "region";
    private static final String DEVICE = "device";
    private static final String HOST = "host";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ObjectMapper mapper = new ObjectMapper();
    private ServiceDirectory directory;
    private ClusterService clusterService;
    private DeviceService deviceService;
    private LinkService linkService;
    private HostService hostService;
    private MastershipService mastershipService;
    private IntentService intentService;
    private FlowRuleService flowService;
    private StatisticService flowStatsService;
    private PortStatisticsService portStatsService;
    private TopologyService topologyService;
    private TunnelService tunnelService;
    private static Map<String, ObjectNode> metaUi = new ConcurrentHashMap();

    Topo2Jsonifier(ServiceDirectory directory) {
        this.directory = (ServiceDirectory)Preconditions.checkNotNull((Object)directory, (Object)"Directory cannot be null");
        this.clusterService = (ClusterService)directory.get(ClusterService.class);
        this.deviceService = (DeviceService)directory.get(DeviceService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.hostService = (HostService)directory.get(HostService.class);
        this.mastershipService = (MastershipService)directory.get(MastershipService.class);
        this.intentService = (IntentService)directory.get(IntentService.class);
        this.flowService = (FlowRuleService)directory.get(FlowRuleService.class);
        this.flowStatsService = (StatisticService)directory.get(StatisticService.class);
        this.portStatsService = (PortStatisticsService)directory.get(PortStatisticsService.class);
        this.topologyService = (TopologyService)directory.get(TopologyService.class);
        this.tunnelService = (TunnelService)directory.get(TunnelService.class);
    }

    Topo2Jsonifier() {
    }

    private ObjectNode objectNode() {
        return this.mapper.createObjectNode();
    }

    private ArrayNode arrayNode() {
        return this.mapper.createArrayNode();
    }

    private String nullIsEmpty(Object o) {
        return o == null ? "" : o.toString();
    }

    ObjectNode instances(List<UiClusterMember> instances) {
        NodeId local = this.clusterService.getLocalNode().id();
        ObjectNode payload = this.objectNode();
        ArrayNode members = this.arrayNode();
        payload.set("members", (JsonNode)members);
        for (UiClusterMember member : instances) {
            members.add((JsonNode)this.json(member, member.id().equals((Object)local)));
        }
        return payload;
    }

    private ObjectNode json(UiClusterMember member, boolean isUiAttached) {
        return this.objectNode().put("id", member.id().toString()).put("ip", member.ip().toString()).put("online", member.isOnline()).put("ready", member.isReady()).put("uiAttached", isUiAttached).put("switches", member.deviceCount());
    }

    ObjectNode layout(UiTopoLayout layout, List<UiTopoLayout> crumbs) {
        ObjectNode result = this.objectNode().put("id", layout.id().toString()).put("parent", this.nullIsEmpty((Object)layout.parent())).put(REGION, this.nullIsEmpty((Object)layout.regionId())).put("regionName", UiRegion.safeName((Region)layout.region()));
        this.addCrumbs(result, crumbs);
        return result;
    }

    private void addCrumbs(ObjectNode result, List<UiTopoLayout> crumbs) {
        ArrayNode trail = this.arrayNode();
        crumbs.forEach(c -> {
            ObjectNode n = this.objectNode().put("id", c.regionId().toString()).put("name", UiRegion.safeName((Region)c.region()));
            trail.add((JsonNode)n);
        });
        result.set("crumbs", (JsonNode)trail);
    }

    ObjectNode region(UiRegion region, Set<UiRegion> subRegions, List<UiSynthLink> links) {
        ObjectNode payload = this.objectNode();
        if (region == null) {
            payload.put("note", "no-region");
            return payload;
        }
        payload.put("id", region.idAsString());
        payload.set("subregions", (JsonNode)this.jsonSubRegions(subRegions));
        payload.set("links", this.jsonLinks(links));
        List layerTags = region.layerOrder();
        List splitDevices = this.splitByLayer(layerTags, region.devices());
        List splitHosts = this.splitByLayer(layerTags, region.hosts());
        payload.set("devices", (JsonNode)this.jsonGrouped(splitDevices));
        payload.set("hosts", (JsonNode)this.jsonGrouped(splitHosts));
        payload.set("layerOrder", (JsonNode)this.jsonStrings(layerTags));
        return payload;
    }

    private ArrayNode jsonSubRegions(Set<UiRegion> subregions) {
        ArrayNode kids = this.arrayNode();
        subregions.forEach(s -> kids.add((JsonNode)this.jsonClosedRegion(s)));
        return kids;
    }

    private JsonNode jsonLinks(List<UiSynthLink> links) {
        ArrayNode synthLinks = this.arrayNode();
        links.forEach(l -> synthLinks.add((JsonNode)this.json(l)));
        return synthLinks;
    }

    private ArrayNode jsonStrings(List<String> strings) {
        ArrayNode array = this.arrayNode();
        strings.forEach(arg_0 -> ((ArrayNode)array).add(arg_0));
        return array;
    }

    private ArrayNode jsonGrouped(List<Set<UiNode>> groupedNodes) {
        ArrayNode result = this.arrayNode();
        groupedNodes.forEach(g -> {
            ArrayNode subset = this.arrayNode();
            g.forEach(n -> subset.add((JsonNode)this.json(n)));
            result.add((JsonNode)subset);
        });
        return result;
    }

    private ObjectNode json(UiNode node) {
        if (node instanceof UiRegion) {
            return this.jsonClosedRegion((UiRegion)node);
        }
        if (node instanceof UiDevice) {
            return this.json((UiDevice)node);
        }
        if (node instanceof UiHost) {
            return this.json((UiHost)node);
        }
        throw new IllegalStateException(E_UNKNOWN_UI_NODE + node.getClass());
    }

    private ObjectNode json(UiDevice device) {
        ObjectNode node = this.objectNode().put("id", device.idAsString()).put("nodeType", DEVICE).put("type", device.type()).put("online", this.deviceService.isAvailable(device.id())).put("master", this.nullIsEmpty((Object)device.master())).put("layer", device.layer());
        Device d = device.backingDevice();
        this.addProps(node, d);
        this.addGeoLocation(node, (Annotated)d);
        this.addMetaUi(node, device.idAsString());
        return node;
    }

    private void addProps(ObjectNode node, Device dev) {
        Annotations annot = dev.annotations();
        ObjectNode props = this.objectNode();
        if (annot != null) {
            annot.keys().forEach(k -> props.put(k, annot.value(k)));
        }
        node.set("props", (JsonNode)props);
    }

    private void addMetaUi(ObjectNode node, String metaInstanceId) {
        ObjectNode meta = (ObjectNode)metaUi.get(metaInstanceId);
        if (meta != null) {
            node.set("metaUi", (JsonNode)meta);
        }
    }

    private void addGeoLocation(ObjectNode node, Annotated a) {
        List lngLat = this.getAnnotValues(a, new String[]{"longitude", "latitude"});
        if (lngLat != null) {
            try {
                double lng = Double.parseDouble((String)lngLat.get(0));
                double lat = Double.parseDouble((String)lngLat.get(1));
                ObjectNode loc = this.objectNode().put("type", "lnglat").put("lng", lng).put("lat", lat);
                node.set("location", (JsonNode)loc);
            }
            catch (NumberFormatException e) {
                this.log.warn("Invalid geo data: longitude={}, latitude={}", lngLat.get(0), lngLat.get(1));
            }
        } else {
            this.log.debug("No geo lng/lat for {}", (Object)a);
        }
    }

    private void addIps(ObjectNode node, Host h) {
        Set ips = h.ipAddresses();
        ArrayNode a = this.arrayNode();
        for (IpAddress ip : ips) {
            a.add(ip.toString());
        }
        node.set("ips", (JsonNode)a);
    }

    List<String> getAnnotValues(Annotated a, String ... annotKeys) {
        ArrayList<String> result = new ArrayList<String>(annotKeys.length);
        for (String k : annotKeys) {
            String v = a.annotations().value(k);
            if (v == null) {
                return null;
            }
            result.add(v);
        }
        return result;
    }

    private ObjectNode props(Annotations annotations) {
        ObjectNode p = this.objectNode();
        if (annotations != null) {
            annotations.keys().forEach(k -> p.put(k, annotations.value(k)));
        }
        return p;
    }

    private ObjectNode json(UiHost host) {
        ObjectNode node = this.objectNode().put("id", host.idAsString()).put("nodeType", HOST).put("layer", host.layer());
        Host h = host.backingHost();
        this.addIps(node, h);
        this.addGeoLocation(node, (Annotated)h);
        this.addMetaUi(node, host.idAsString());
        return node;
    }

    private ObjectNode json(UiSynthLink sLink) {
        UiLink uLink = sLink.link();
        ObjectNode data = this.objectNode().put("id", uLink.idAsString()).put("epA", uLink.endPointA()).put("epB", uLink.endPointB()).put("type", uLink.type());
        String pA = uLink.endPortA();
        String pB = uLink.endPortB();
        if (pA != null) {
            data.put("portA", pA);
        }
        if (pB != null) {
            data.put("portB", pB);
        }
        return data;
    }

    private ObjectNode jsonClosedRegion(UiRegion region) {
        ObjectNode node = this.objectNode().put("id", region.idAsString()).put("name", region.name()).put("nodeType", REGION).put("nDevs", region.deviceCount()).put("nHosts", region.hostCount());
        this.addMetaUi(node, region.idAsString());
        return node;
    }

    public ArrayNode closedNodes(Set<UiNode> nodes) {
        ArrayNode array = this.arrayNode();
        for (UiNode node : nodes) {
            if (node instanceof UiRegion) {
                array.add((JsonNode)this.jsonClosedRegion((UiRegion)node));
                continue;
            }
            if (node instanceof UiDevice) {
                array.add((JsonNode)this.json((UiDevice)node));
                continue;
            }
            this.log.warn("Unexpected node instance: {}", node.getClass());
        }
        return array;
    }

    public ArrayNode closedRegions(Set<UiRegion> regions) {
        ArrayNode array = this.arrayNode();
        for (UiRegion r : regions) {
            array.add((JsonNode)this.jsonClosedRegion(r));
        }
        return array;
    }

    public ArrayNode devices(Set<UiDevice> devices) {
        ArrayNode array = this.arrayNode();
        for (UiDevice device : devices) {
            array.add((JsonNode)this.json(device));
        }
        return array;
    }

    public ArrayNode hosts(Set<UiHost> hosts) {
        ArrayNode array = this.arrayNode();
        for (UiHost host : hosts) {
            array.add((JsonNode)this.json(host));
        }
        return array;
    }

    List<Set<UiNode>> splitByLayer(List<String> layerTags, Set<? extends UiNode> nodes) {
        int nLayers = layerTags.size();
        if (!layerTags.get(nLayers - 1).equals("def")) {
            throw new IllegalArgumentException(E_DEF_NOT_LAST);
        }
        ArrayList<Set<UiNode>> splitList = new ArrayList<Set<UiNode>>(layerTags.size());
        HashMap byLayer = new HashMap(layerTags.size());
        for (String string : layerTags) {
            HashSet set = new HashSet();
            byLayer.put(string, set);
            splitList.add(set);
        }
        for (UiNode uiNode : nodes) {
            String which = uiNode.layer();
            if (!layerTags.contains(which)) {
                which = "def";
            }
            ((Set)byLayer.get(which)).add(uiNode);
        }
        return splitList;
    }

    void updateMeta(ObjectNode payload) {
        String id = JsonUtils.string((ObjectNode)payload, (String)"id");
        metaUi.put(id, JsonUtils.node((ObjectNode)payload, (String)"memento"));
        this.log.debug("Storing metadata for {}", (Object)id);
    }
}

